

#include "HIH_5030.h"
#include "mbed.h"


Serial pc(USBTX, USBRX);
 
AnalogIn ain_UseA(p15);
AnalogIn ain_UseB(p16);
AnalogIn ain_UseC(p17);
AnalogIn ain_UseD(p18);
AnalogIn ain_UseE(p19);
DigitalOut myled(LED1);


/*

Constructor
dataPin: the IO pin connected to the sensor's data pin (pin 15)
supplyVoltage: the voltage supplying the humidity sensor (pins 1,3 - for the HIH5030 3.3 V typical)
referenceVoltage: motor controller's reference voltage (3.3V for the LPC1768)
*/

HIH4010::HIH4010(float dataPin, float supplyVoltage, float referenceVoltage){

pin = dataPin;
vSupply = supplyVoltage;
vRef = referenceVoltage;

/*
Relative Humidity is calculated using the following equations taken from the datasheet:
(1) Vout = (VSupply)(0.00636(sensorRH) + 0.1515)
(2) sensorRH = (Vout - zeroOffset) / slope

Solving (1) for sensorRH: 
sensorRH = (Vout - (0.1515)VSupply) / (0.00636)VSupply

Equate result with (2):
zeroOffset = (0.1515)VSupply
slope = (0.00636)VSupply
*/ 

slope = 0.00636 * vSupply;
zeroOffset = 0.1515 * vSupply; 

}


/*
Convert sensor reading into relative humidity using equation (2)
*/ 

float HIH4010::getSensorRH() {
return ((vout() - zeroOffset) / slope);

}

/*
Get temperature-compensated relative humity. From data sheet: 
trueRH = sensorRH / (1.0546 - 0.00216T)
*/

float HIH4010::getTrueRH(float temperature) { 
return getSensorRH() / (1.0546 - (0.00216 * temperature)); 

}

/*
Get sensor output voltage.
Assumes 12-bit (2^16 = 4096) A/D resolution.
*/

float HIH4010::vout() {
return (float)(ain_UseA.read_u16()) * 3.3 / 65536;

}

 
int main()
{
    float ad[5];
    float supplyvoltage = 3.3;
    float referencevoltage = 3.3;
    float vdiv = (3.3 / 65536); //3.3 is the reference voltage (AnalogIn measures from 0V to 3.3V) and 65536 is the highest number that can be represented by a 16 bit unsigned
    while( 1 ){
        ad[0] = (float)ain_UseA.read_u16() * vdiv;  //16-bit unsigned short representing the current input voltage, normalised to a 16-bit value 
        ad[1] = (float)ain_UseB.read_u16() * vdiv;
        ad[2] = (float)ain_UseC.read_u16() * vdiv;
        ad[3] = (float)ain_UseD.read_u16() * vdiv;
        ad[4] = (float)ain_UseE.read_u16() * vdiv;
        //pc.printf("%5.3f,%5.3f,%5.3f,%5.3f,%5.3f\r\n ", ad[0],ad[1],ad[2],ad[3],ad[4]);
        HIH4010 humidity(ad[0], supplyvoltage, referencevoltage);
        pc.printf("%5.3f\r\nHumidity: ", humidity.getSensorRH());
    myled = 1;
    wait(2.0);
    myled = 0;
    wait(2.0);
    }
}
