#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "mpr121.h"

Mutex lcd_mutex;

uLCD_4DGL uLCD(p9, p10, p12); // uLCD-144-G2 screen, (serial tx, serial rx, reset pin)
int currentShipX;
float x;
AnalogOut DACout(p18);
wave_player waver(&DACout);


//8 missiles 
int missile0 [1][2]; // 1 row 2 col
int missile1 [1][2];
int missile2 [1][2];
int missile3 [1][2];

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p28, p27);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

void fallInterrupt();
void gameover();
void moveShip(void const *args);
void moveMissile0(void const *args);
//void sd_sound(void const *args);
int getRandNum();

void moveShip(void const *args){
        
    currentShipX = 64;
    lcd_mutex.lock();
    uLCD.media_init();
    uLCD.set_sector_address(0x0040, 0x4083);
    uLCD.display_image(currentShipX, 112);
    lcd_mutex.unlock();
    
    while(1) {
        
        lcd_mutex.lock();
        uLCD.filled_rectangle(currentShipX - 16, 112 , currentShipX , 128 ,WHITE);
        uLCD.filled_rectangle(currentShipX + 16, 112 ,currentShipX + 32 , 128 ,WHITE);
        uLCD.media_init();
        uLCD.set_sector_address(0x0040, 0x4083);
        uLCD.display_image(currentShipX, 112);
        uLCD.filled_rectangle(currentShipX - 16, 112 , currentShipX , 128 ,WHITE);
        uLCD.filled_rectangle(currentShipX + 16, 112 ,currentShipX + 32 , 128 ,WHITE);
        lcd_mutex.unlock();
        
    }
    
        
}

//Move Missile 0
void moveMissile0(void const *args) {
        Thread::wait(1000);
        
        missile0[0][0] = getRandNum(); //x coordinate
        missile0[0][1] = 0;  //y coordinate
        
        //draw Missile
        lcd_mutex.lock();
        uLCD.media_init();
        uLCD.set_sector_address(0x0040, 0x4081);
        uLCD.display_image(missile0[0][0], missile0[0][1]);
        lcd_mutex.unlock();

        while(1) {
             
             lcd_mutex.lock();
             uLCD.filled_rectangle(missile0[0][0], missile0[0][1] ,missile0[0][0]+16 , missile0[0][1]+16 ,WHITE);
             uLCD.media_init();
             uLCD.set_sector_address(0x0040, 0x4081);
             //Reset missile
             if (missile0[0][1] == 112) {
                missile0[0][1] = -16;
                missile0[0][0] = getRandNum();    
             }
             uLCD.display_image(missile0[0][0], missile0[0][1]+16);//Move missile down
             lcd_mutex.unlock();
             missile0[0][1] = missile0[0][1]+16;//Update new y value
             
        }

}

//Move Missile 1
void moveMissile1(void const *args) {
        Thread::wait(2000);
        
        missile1[0][0] = getRandNum(); //x coordinate
        missile1[0][1] = 0;  //y coordinate
        
        //draw Missile
        lcd_mutex.lock();
        uLCD.media_init();
        uLCD.set_sector_address(0x0040, 0x4081);
        uLCD.display_image(missile1[0][0], missile1[0][1]);
        lcd_mutex.unlock();

        while(1) {
             
             lcd_mutex.lock();
             uLCD.filled_rectangle(missile1[0][0], missile1[0][1] ,missile1[0][0]+16 , missile1[0][1]+16 ,WHITE);
             uLCD.media_init();
             uLCD.set_sector_address(0x0040, 0x4081);
             //Reset missile
             if (missile1[0][1] == 112) {
                missile1[0][1] = -16;
                missile1[0][0] = getRandNum();    
             }
             uLCD.display_image(missile1[0][0], missile1[0][1]+16);//Move missile down
             lcd_mutex.unlock();
             missile1[0][1] = missile1[0][1]+16;//Update new y value
             
        }

}

//Move Missile 2
void moveMissile2(void const *args) {
        Thread::wait(3000);
        
        missile2[0][0] = getRandNum(); //x coordinate
        missile2[0][1] = 0;  //y coordinate
        
        //draw Missile
        lcd_mutex.lock();
        uLCD.media_init();
        uLCD.set_sector_address(0x0040, 0x4081);
        uLCD.display_image(missile2[0][0], missile2[0][1]);
        lcd_mutex.unlock();

        while(1) {
             
             lcd_mutex.lock();
             uLCD.filled_rectangle(missile2[0][0], missile2[0][1] ,missile2[0][0]+16 , missile2[0][1]+16 ,WHITE);
             uLCD.media_init();
             uLCD.set_sector_address(0x0040, 0x4081);
             //Reset missile
             if (missile2[0][1] == 112) {
                missile2[0][1] = -16;
                missile2[0][0] = getRandNum();    
             }
             uLCD.display_image(missile2[0][0], missile2[0][1]+16);//Move missile down
             lcd_mutex.unlock();
             missile2[0][1] = missile2[0][1]+16;//Update new y value
             
        }

}

//Move Missile 3
void moveMissile3(void const *args) {
        Thread::wait(4000);
        
        missile3[0][0] = getRandNum(); //x coordinate
        missile3[0][1] = 0;  //y coordinate
        
        //draw Missile
        lcd_mutex.lock();
        uLCD.media_init();
        uLCD.set_sector_address(0x0040, 0x4081);
        uLCD.display_image(missile3[0][0], missile3[0][1]);
        lcd_mutex.unlock();

        while(1) {
             
             lcd_mutex.lock();
             uLCD.filled_rectangle(missile3[0][0], missile3[0][1] ,missile3[0][0]+16 , missile3[0][1]+16 ,WHITE);
             uLCD.media_init();
             uLCD.set_sector_address(0x0040, 0x4081);
             //Reset missile
             if (missile3[0][1] == 112) {
                missile3[0][1] = -16;
                missile3[0][0] = getRandNum();    
             }
             uLCD.display_image(missile3[0][0], missile3[0][1]+16);//Move missile down
             lcd_mutex.unlock();
             missile3[0][1] = missile3[0][1]+16;//Update new y value
             
        }

}


// Key hit/release interrupt routine
void fallInterrupt() {
  int key_code=0;
  int i=0;
  int value=mpr121.read(0x00);
  value +=mpr121.read(0x01)<<8;
  // LED demo mod
  i=0;
  // puts key number out to LEDs for demo
  for (i=0; i<12; i++) {
  if (((value>>i)&0x01)==1) key_code=i+1;
  }
  
  if (key_code == 0x4 && currentShipX != 16) {
        currentShipX = currentShipX - 16;
   }
  if (key_code == 0x3 && currentShipX != 96) {
        currentShipX = currentShipX + 16;
   }      
}

inline float random_number()
{
    return (rand()/(float(RAND_MAX)));
}

int getRandNum() {
        
    x = random_number();
    x = x * 6;
    x = x+1;
    
    return (((int)x) * 16);
    
}


void gameover() {
    
    uLCD.background_color(WHITE);
    uLCD.cls();
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);
    
    uLCD.media_init();
    uLCD.set_sector_address(0x0040, 0x4089);
    uLCD.display_video(0, 0);
    
    uLCD.background_color(WHITE);
    uLCD.cls();
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);
    
    uLCD.printf("Gameover");
    FILE *wave_file;
    wave_file=fopen("/sd/gameover.wav","r");
    waver.play(wave_file);
    fclose(wave_file);    
}

int main() {
    
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    
    uLCD.baudrate(3000000);
        
    uLCD.background_color(WHITE);
    uLCD.cls();
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);
    
    Thread thread0(moveShip);
    Thread thread1(moveMissile0);
    Thread thread2(moveMissile1);
    Thread thread3(moveMissile2);
    Thread thread4(moveMissile3);    
    bool keepGoing = true;

      
    while(1) {
        
        if (((currentShipX == missile0[0][0] && missile0[0][1] == 112)|| 
            (currentShipX == missile1[0][0] && missile1[0][1]== 112) ||
            (currentShipX == missile2[0][0] && missile2[0][1]== 112) || 
            (currentShipX == missile3[0][0] && missile3[0][1]== 112)) && 
            keepGoing) {
                keepGoing = false;
                thread0.terminate();
                thread1.terminate();
                thread2.terminate();
                thread3.terminate();
                thread4.terminate();
                gameover();
        }

    }
}