
#include "mbed.h"
#include "TmpLM74.h"


TmpLM74::TmpLM74(PinName mosi, PinName miso, PinName sclk, PinName csLM74):
        SPI(mosi, miso, sclk), _csLM74(csLM74) {

       _csLM74 = 1;

        format(8,3);            // initialize SPI peripheral
        frequency(1000000);     // initialize SPI peripheral

        startLM74();
    }
    
float TmpLM74::readTemp(void){

    float realTemp;
    int16_t tempRegister;
    
    _csLM74 = 0;
    
    tempRegister = ((uint16_t) write(0xFF)) << 8;
    tempRegister |= write(0xFF);
    
    _csLM74 = 1;
    
//    tempRegister = (((uint16_t) 0xE4) << 8) | 0x84; // -55.0 C
//    tempRegister = (((uint16_t) 0xFB) << 8) | 0x04; // -10.0 C
//    tempRegister = 0x8000;                          // power down
    
//    pc.printf("TempRegister = 0x%x\n", tempRegister);     debugging ONLY
    
    if ((tempRegister & 0x0004) == 0) {             // temp reading NOT ready or LM74 in power down
        if((tempRegister & 0xFFFC) == 0x8000) {     // Manufacturer's Device ID Register (power down) ?
            startLM74();
        }
        tempRegister = INVALID_LM74_TEMP;
    } else {
        tempRegister >>= 3;
    }
    realTemp = ((float) tempRegister) * 0.0625;
    
    return realTemp;
}
//      ******************************************************************

void TmpLM74::startLM74(void){

    _csLM74 = 0;
    
    uint8_t dummy = write(0x00);
    dummy = write(0x00);
    dummy = write(0x00);
    dummy = write(0x00);            // this byte sets LM74 to continuous conversion
    
    _csLM74 = 1;
}
//      ******************************************************************

void TmpLM74::shutLM74down(void){

    _csLM74 = 0;
    
    uint8_t dummy = write(0xFF);
    dummy = write(0xFF);
    dummy = write(0xFF);        // these 2 bytes set LM74 to power down
    dummy = write(0xFF);        // these 2 bytes set LM74 to power down
    
    _csLM74 = 1;
}
//      ******************************************************************
