// Hello World! for the TextLCD

#include "mbed.h"
#include "TextLCD.h"
#include "TmpLM74.h"

DigitalOut myled(LED1);

//TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD20x4);    // rs, e, d4-d7
//TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2);    // rs, e, d4-d7
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD20x2);    // rs, e, d4-d7
Serial pc(USBTX, USBRX); // tx, rx

TmpLM74 Temp74(p5, p6, p7, p8);         //  LM74 connected on:  mosi, miso, sclk, csLM74

void showTemp74(void);

int main() {

    lcd.cls();
    
    wait(2);
    lcd.locate(0,0);
//  lcd.printf("Hello World12345678!");
    lcd.printf("Hello World!");
    
    
    pc.printf("HELLO!,  testing LM74 temperature sensor ...\n\r");
    wait(2);
    
    lcd.locate(0,0);        //   locate(column,row)
    lcd.printf("test LM74 tmp sensor");
    lcd.locate(0,1);
    lcd.printf("LM74temp = 110.8 *C ");
    
    wait(1);
    
    while(1) {

        myled = !myled;
        showTemp74();
        wait(2);
/*
        myled = !myled;
        showTemp74();
        Temp74.shutLM74down();
        wait(1);
*/
    }
}
//      ******************************************************************
//      ******************************************************************

void showTemp74(void){

    float TempC = Temp74.readTemp();
    lcd.locate(11,1);
    lcd.printf("         ");
    lcd.locate(11,1);
    
    pc.printf("Temperature = ");
    if(TempC > MAX_LM74_TEMP) {
        pc.printf(" ? *C\n", TempC);
        lcd.printf(" ? *C", TempC);
    } else {
        pc.printf("%3.1f *C\n", TempC);
        lcd.printf("%3.1f *C", TempC);
    }
}
//      ******************************************************************
