/*  DRIVE SUSBSYSTEM
;****************************************************************************************
;   Filename: "/DRIVE ECU/main.cpp"                                                     *
;   https://mbed.org/compiler/                                                          *
;                                                                                       *
;      Networked Processors Autonomous Guided Vehicle (AGV)                             *
;                                                                                       *
;      Presented by:                                                                    *
;           Aniebiet Micheal Ezekiel                                                    *
;                                                                                       *
;   Date            :   2013/09/21                                                      *
;   MSc. Control and Instrumentation                                                    *
;                       Dissertation                                                    *
;                                                                                       *
;                                                                                       *
;****************************************************************************************
;                                                                                       *
;   Abstract:                                                                           *
;                                                                                       *
;****************************************************************************************
*/

#include "mbed.h"

CAN can1(p30, p29);   // Configure a serial port, pins 30 and 29 as rd and td respectively
Serial pc(USBTX, USBRX);

PwmOut PWM1(p21); //Forward Left DC Motors
PwmOut PWM2(p22); //Backward Left DC Motors
PwmOut ServoB(p23);         //Frontleft servo
PwmOut ServoF(p24);         //BackRight servo
PwmOut PWM3(p25); //Forward Right DC Motors
PwmOut PWM4(p26); //Backward Right DC Motors

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

CANMessage msg;

Ticker timeupps; //define Ticker for light
Ticker timeuppps; //define Ticker for obstacles

//CAN SEND ID

// 0x0a: drive send to Diagnostics
// 0x0b: drive send to Camera
// 0x0c: obstacles send to Drive
// 0x0d: diagnostics send to Camera
// 0x0e: camera send to Diagnostics
// 0x0f: temprature/humidity send Climatic condition to diagnostics
// 0x1f: temprature/humidity send Temperature value to diagnostics
// 0x2f: temprature/humidity send Humidity value to diagnostics

//CAN messages
char diag_msg1 = 1;  //AGV moves front message: AGV explores: No obstacles message
char diag_msg2 = 2;  //AGV moves fast front message
char diag_msg3 = 3;  //AGV turns right message
char diag_msg4 = 4;  //AGV turns left message
char diag_msg5 = 5;  //AGV starts message
char diag_msg6 = 6;  //AGV stops message
char diag_msg7 = 7;  //AGV Increases speed; temperature adverse
char diag_msg8 = 8;  //AGV normal speed; temperature normal

//call functions
void TempS(void);   //Temperature call function
void ObstS(void);   //Obstacle call function

// Drive functions
void front(void);
void fast_front(void);
void back(void);
void front_left(void);
void left(void);
void front_right(void);
void right(void);
void stop(void);

int main()
{
    CANMessage msg;
    printf("read...\n");
    printf("send...\n");
 
   if(can1.write(CANMessage(0x0a, &diag_msg5,1))) {
        pc.printf("Message sent: %d\n", diag_msg5);
        myled3=!myled3;
    }
 
    timeupps.attach(&ObstS, 0.02);

    PWM1.period(0.010); //set PWM period to 10 ms (motor)
    PWM2.period(0.010); //set PWM period to 10 ms(motor)
    PWM3.period(0.010); //set PWM period to 10 ms(motor)
    PWM4.period(0.010); //set PWM period to 10 ms(motor)
    ServoF.period_ms(20);      //set PWM1 period to 20 ms(servo)
    ServoB.period_ms(20);    //set PWM2 period to 20 ms(servo)

    ServoF.pulsewidth_us(1400);         //update PWM pulse with to 90*
    ServoB.pulsewidth_us(1400);         //update PWM pulse with to 90*

    while(1) {
    }
}

//Obstcales function starts
void ObstS()
{
    if(can1.read(msg)) {
        pc.printf(" - Message received: %d\n", msg.data[0]);
        pc.printf("\n Message id :%d", msg.id);
        if (msg.id==0x0c) {
            myled1=!myled1;
            if (msg.data[0]==1) {
                //stop(); //AGV stops to take Picture
                //wait (5);
                front_right();    //obstacles left; AGV moves right
            }
            if (msg.data[0]==2) {
                //stop(); //AGV stops to take Picture
                //wait (5);
                front_right();    // obstacles centre; AGV moves right
            }
            if (msg.data[0]==3) {
                //stop(); //AGV stops to take Picture
                //wait (5);
                front_left(); // obstacles right; AGV moves left
            }
            if (msg.data[0]==4) {
                ServoF.pulsewidth_us(1400);
                PWM1=0.75;
                PWM2=0;
                PWM3=0.75;
                PWM4=0;

                if(can1.write(CANMessage(0x0a, &diag_msg1,1))) {
                    pc.printf("Message sent: %d\n", diag_msg1);
                    myled3=!myled3;
                }
                //  front();   // no obstacles; AGV move straight and seeks for enviromental condition
                //   timeuppps.attach(TempS, 1);
            } else {
                myled1=0;
            }
            //  wait(0.1); // delete if possible
        }
    }
}
//Obstacle Function ends

//Temperature Function Starts
void TempS ()
{
    if(can1.read(msg)) {
        pc.printf(" - Message received: %d\n", msg.data[0]);
        pc.printf("\n Message id :%d", msg.id);
        if (msg.id==0x0f) {
            myled2=!myled2;
            if (msg.data[0]==4) {
                fast_front();    // Adverse environmental condition
                //optional send below; may delete
                if(can1.write(CANMessage(0x0a, &diag_msg7,1))) {
                    pc.printf("Message sent: %d\n", diag_msg7);
                    myled3=!myled3;
                }
            }

            if (msg.data[0]==3) {
                front();    // Normal operation, favourable condition
                //optional send below; may delete
                if(can1.write(CANMessage(0x0a, &diag_msg8,1))) {
                    pc.printf("Message sent: %d\n", diag_msg8);
                    myled3=!myled3;
                }
            } else {
                myled2=0;
            }
            wait(0.1); // delete if possible
        }
    }
}
//Temperature Function ends

//Maneuvering Codes Begin
void front()
{
    ServoF.pulsewidth_us(1400);
    PWM1=0.75;
    PWM2=0;
    PWM3=0.75;
    PWM4=0;

    if(can1.write(CANMessage(0x0a, &diag_msg1,1))) {
        pc.printf("Message sent: %d\n", diag_msg1);
        myled3=!myled3;
    }
}

void fast_front()
{
    ServoF.pulsewidth_us(1400);
    PWM1=1;
    PWM2=0;
    PWM3=1;
    PWM4=0;

    if(can1.write(CANMessage(0x0a, &diag_msg2,1))) {
        pc.printf("Message sent: %d\n", diag_msg2);
        myled3=!myled3;
    }
}

void back()
{
    ServoF.pulsewidth_us(1400);
    PWM1=0;
    PWM2=0.75;
    PWM3=0;
    PWM4=1;
}

void front_right()
{
    ServoF.pulsewidth_us(1650);
    PWM1=0.75;
    PWM2=0;
    PWM3=1;
    PWM4=0;
    if(can1.write(CANMessage(0x0a, &diag_msg3,1))) {
        pc.printf("Message sent: %d\n", diag_msg3);
        myled3=!myled3;
    }
}

void right()
{
    ServoF.pulsewidth_us(1900);
    PWM1=0.75;
    PWM2=0;
    PWM3=0.75;
    PWM4=0;

    if(can1.write(CANMessage(0x0a, &diag_msg3,1))) {
        pc.printf("Message sent: %d\n", diag_msg3);
        myled3=!myled3;
    }
}

void front_left()
{
    ServoF.pulsewidth_us(1150);
    PWM1=0.75;
    PWM2=0;
    PWM3=0.5;
    PWM4=0;
    if(can1.write(CANMessage(0x0a, &diag_msg4,1))) {
        pc.printf("Message sent: %d\n", diag_msg4);
        myled3=!myled3;
    }
}

void left()
{
    ServoF.pulsewidth_us(900);
    PWM1=0.75;
    PWM2=0;
    PWM3=0.5;
    PWM4=0;

    if(can1.write(CANMessage(0x0a, &diag_msg4,1))) {
        pc.printf("Message sent: %d\n", diag_msg4);
        myled3=!myled3;
    }
}

void stop()
{
    ServoF.pulsewidth_us(1400);
    PWM1=0;
    PWM2=0;
    PWM3=0;
    PWM4=0;

    if(can1.write(CANMessage(0x0a, &diag_msg6,1))) {
        pc.printf("Message sent: %d\n", diag_msg6);
        myled3=!myled3;
    }
}
//Maneuvering codes end.