#include "mbed.h"
#include "LIS331.h"
#include "ITG3200.h"
#include "HMC5843.h"
//#include "SDHCFileSystem.h"

// Define binary expansions if needed
//#define Ob(x)  ((unsigned)Ob_(0 ## x ## uL))
//#define Ob_(x) (x & 1 | x >> 2 & 2 | x >> 4 & 4 | x >> 6 & 8 |        \
//  x >> 8 & 16 | x >> 10 & 32 | x >> 12 & 64 | x >> 14 & 128)



//SDFileSystem sd(p5, p6, p7, p8, "sd");
Serial pc(USBTX, USBRX);
LIS331 accel(p9, p10);
ITG3200 gyro(p9, p10);
HMC5843 compass(p9, p10);
Timer t;
DigitalOut success_led(LED4);
DigitalOut progress_led(LED3);
DigitalOut error_led(LED1);

int readings[3];

int main() {
    success_led = 0;
    error_led = 0;
    pc.printf("Now starting LIS331/ITG-3200 acceptance test...\n\r");
    
    // Set Highest Gyro Bandwidth
    gyro.setLpBandwidth(LPFBW_256HZ);
    
    // Set 8g range on accel
    accel.setFullScaleRange8g();
    
    //Continuous mode, , 10Hz measurement rate.
    // HMC5843_CONTINUOUS, HMC5843_10HZ_NORMAL HMC5843_1_0GA
    compass.setDefault();
    
    //FILE *fp = fopen("/sd/data.txt", "w");
    //if(fp == NULL) {
    //    error_led = 1;  // crap something went wrong
    //    error("Could not open file for write\n");
    //}
    //success_led = 1;    // file is open for writing!
    
        
    pc.printf("Accel Address:%x\n\r",accel.getWhoAmI());
    pc.printf("Gyro Address:%x\n\r",gyro.getWhoAmI());
    pc.printf("Temp(C):%f\n\r",gyro.getTemperature());
    
    wait(0.9);




    t.start();  // Start our timer
    while (1) {
        progress_led = 1;
        //Arbitrary wait for printf clarity.
        wait(0.3);
        compass.readData(readings);
    
        
        pc.printf("\n\r%f,", t.read());     // get current time in seconds
        pc.printf("%f,%f,%f,", (float)accel.getAccelX(), (float)accel.getAccelY(), (float)accel.getAccelZ());
        pc.printf("%f,%f,%f", (float)gyro.getGyroX() / 14.375, (float)gyro.getGyroY() / 14.375, (float)gyro.getGyroZ() / 14.375);

        // uncomment next line to enable output of mag values
        //pc.printf(",%i,%i,%i", (int16_t)readings[0],(int16_t)readings[1],(int16_t)readings[2]);
        
        progress_led = 0;
        if (t.read() > 240) {    // quit after 240 seconds, change it to however long you want to record for
            break;  // LED3 will remain off when done writing to card
        }
    }
    
wait(0.5);
    
// fclose(fp);     // Need to add Physical_Switch --> DigitalIn --> Int --> fclose()
}