#pragma once

const int stride = 2;
const int kernel_count = 8;
const int kernel_size = 4;
const int image_size = 28;

const int convImageSize = (image_size - kernel_size) / stride + 1;
float image[28][28] = {-0.5f};
float activated[kernel_count * convImageSize * convImageSize] = { 0.0f };
const float kernels[kernel_count][kernel_size][kernel_size] = {{{-1.01081, -1.78989, -0.552032, 1.01814}, {-1.63849, -1.25246, 0.295075, 1.0604}, {-1.52022, -0.923819, 1.93481, 1.40607}, {-1.60144, -0.307462, 1.81143, 1.06675}}, {{-0.758482, 0.179353, 0.438091, 0.367944}, {-0.383311, 0.997245, 1.28515, 0.919137}, {-0.649462, 0.399981, 0.699305, 0.745563}, {-0.023449, 0.902529, 1.82247, 0.610457}}, {{-0.0400643, -0.118862, 0.659298, 0.976635}, {-0.226508, 0.245497, 0.595656, 1.6868}, {1.33748, 1.07026, 1.36612, 0.528341}, {1.17569, 0.719557, -0.768594, -0.439}}, {{0.323669, 0.904749, 1.70538, 1.1731}, {-1.58033, 0.00831194, 1.95718, 1.42617}, {-1.78664, -1.12022, 0.550419, 0.939726}, {-1.37935, -1.80033, 0.106619, 1.10187}}, {{1.27226, 1.15556, -0.11242, -0.923521}, {0.669006, 1.2414, 1.63359, -0.0424935}, {-0.728033, -0.386935, 1.05247, 1.08513}, {-0.636308, -1.11437, -0.328895, 1.98443}}, {{1.01658, 1.63552, 1.59175, 1.51986}, {0.410274, 1.2305, 1.4274, 0.672727}, {-1.3512, -1.87873, -1.13042, -0.833957}, {-1.60595, -1.88525, -2.12884, -1.08705}}, {{-1.08925, 0.0556109, 0.683938, 0.572581}, {-1.50219, -2.19516, -1.56723, -1.35482}, {-0.0304434, -0.237657, -1.18816, -1.50116}, {0.900746, 0.863792, 0.465329, 0.549435}}, {{0.48392, -0.722259, -1.18896, -0.184937}, {-0.534505, -1.10443, -0.795713, 0.242404}, {-0.209939, -1.36473, -0.552264, -0.0779372}, {0.0327447, -1.45355, -0.736824, 0.0419642}}};
const float bias_kernels[kernel_count] = {-1.01233, -0.0700131, 0.962957, 0.0925588, -0.124831, -1.26567, -1.75514, -1.812};
const float weights[10][kernel_count * convImageSize * convImageSize] = {{-0.0880301, -0.0895173, 0.0326247, -0.0954243, -0.0706094, -0.197569, -0.190647, -0.0510268, -0.0634136, 0.0343635, -0.0612173, -0.0357321, -0.0888078, 0.00274312, -0.179104, -0.105156, -0.125222, -0.152552, -0.019913, -0.0480107, -0.119933, 0.151983, -0.112398, 0.15126, 0.0717639, 0.0318152, -0.0379883, -0.105153, 0.0470134, -0.0659087, -0.226077, -0.261309, -0.354764, -0.106009, -0.0918134, 0.00711855, -0.0622499, -0.180229, -0.0551929, -0.105504, 0.129304, 0.113618, -0.0265121, 0.059004, -0.113745, -0.245277, -0.353424, -0.0474547, -0.238919, -0.267232, -0.0162922, -0.0994659, 0.107188, -0.0448482, 0.115377, 0.0707563, 0.107032, 0.010465, 0.0918553, -0.023413, -0.26445, -0.241023, -0.0648256, -0.131896, -0.0772425, 0.193136, 0.18892, 0.250279, 0.475136, 0.392732, 0.130077, -0.0240522, 0.162016, -0.167537, 0.0112186, 0.130401, -0.0239529, -0.104149, 0.107759, 0.119467, 0.302819, 0.139469, 0.37688, 0.318595, 0.0485245, 0.0319553, -0.0275184, 0.103667, 0.239424, 0.0669661, -0.0906927, 0.0644847, 0.078104, 0.249969, 0.0825707, 0.350452, 0.356651, 0.435177, 0.385607, 0.273081, -0.0292045, 0.0692566, 0.093111, 0.0757151, 0.193929, 0.0615489, 0.107564, 0.214534, 0.279647, 0.307759, 0.0237831, 0.12204, 0.440855, 0.387791, 0.335104, 0.185637, -0.0362231, 0.198247, -0.100815, 0.240317, 0.031038, -0.0113532, 0.0738543, -0.0775011, -0.0414485, -0.110346, 0.221959, 0.00173701, 0.0357979, 0.0522751, 0.0585414, 0.0856181, -0.0369662, 0.00924457, -0.0939024, -0.605829, -0.594885, -0.134031, -0.271091, -0.162035, -0.178787, -0.0266706, -0.0227672, -0.0826577, -0.0859999, -0.054356, -0.0826533, -0.168256, -0.543097, -0.532891, -0.636337, -0.564848, -0.0284221, -0.284325, 0.0535846, 0.00258309, 0.0647762, -0.0248129, -0.0187048, -0.132165, 0.0417267, -0.176021, -0.307208, -0.195336, -0.282522, 0.0156896, 0.00803887, 0.0738937, -0.0353483, 0.0503392, 0.00558091, 0.0215063, -0.0670891, 0.0345492, 0.0393835, -0.153461, 0.0421406, -0.00283262, -0.0566651, 0.0796117, -0.0106915, 0.0236025, 0.0768186, -0.0871476, -0.0846315, 0.113425, -0.00841843, 0.0299293, 0.0243379, 0.0104405, -0.115985, 0.0454874, -0.0496322, -0.0782945, -0.097681, 0.0255641, -0.121559, -0.0160126, 0.150223, 0.00432856, 0.0419346, -0.159173, -0.22137, -0.0263807, 0.185581, 0.0351817, -0.0376313, -0.0907903, 0.0833825, -0.0298356, 0.0563388, 0.0251853, 0.0601954, 0.00263916, 0.299215, 0.180232, 0.0380156, 0.013895, -0.0423387, -0.0587106, -0.0392732, -0.0669579, -0.00723183, 0.072229, -0.000147798, 0.045982, 0.00697435, -0.0414751, 0.194608, 0.0392319, 0.207347, -0.280712, 0.0419778, 0.0116477, -0.0155613, 0.069184, -0.0664594, 0.0688649, 0.0666261, 0.142773, -0.0337975, 0.0902413, 0.0222376, -0.170232, -0.0480799, 0.117026, -0.0080011, 0.00628468, 0.132747, 0.133589, 0.00419905, 0.172591, 0.0831194, 0.121724, -0.157956, 0.0872049, 0.273115, -0.00451355, 0.138403, -0.001909, 0.0782893, 0.102948, 0.125502, -0.048753, -0.0491371, -0.00290104, -0.116622, -0.174725, -0.137412, 0.101782, 0.215761, 0.0925724, -0.0304438, -0.0365993, 0.231041, -0.0427384, -0.146733, 0.24016, 0.00316034, -0.0666074, 0.0863638, -0.0600428, -0.127969, 0.0629003, 0.0186775, -0.0837726, -0.0667311, -0.016561, 0.139806, 0.189126, -0.014916, -0.028491, -0.00864946, -0.243257, 0.237241, -0.104275, 0.138834, -0.0283153, -0.040038, -0.098311, 0.0204082, 0.163696, 0.0370858, -0.0803087, 0.0569577, 0.0631121, -0.0728008, 0.0367854, -0.0362732, 0.160424, -0.0292521, 0.0688269, 0.0236125, 0.0844305, 0.0474519, 0.0824764, -0.0551746, -0.15932, 0.267686, -0.186538, 0.120011, -0.107304, -0.0308844, 0.0724232, 0.0478285, 0.093048, 0.075885, -0.0941983, 0.0641903, -0.00276886, 0.0704139, -0.142248, -0.0571418, 0.0607485, 0.0119145, 0.0238726, 0.0900317, 0.0518507, -0.0179011, 0.0628269, 0.0775548, -0.064912, 0.0647923, 0.0639426, 0.0140574, -0.107106, 0.0762311, 0.0521553, 0.0782156, 0.0898741, -0.0194166, 0.0567256, 0.0096424, -0.0351393, -0.0131963, -0.0511917, 0.00771584, -0.0648678, -0.0210714, -0.0763773, -0.0939572, 0.0326063, 0.0252282, 0.0920967, 0.0829962, -0.13268, 0.0553039, 0.14652, 0.279182, 0.142441, 0.0200846, 0.0524927, -0.117675, -0.075826, 0.184346, 0.0579672, 0.0864766, -0.0989487, 0.0215059, 0.182415, 0.151103, 0.0415874, -0.0250827, 0.366042, -0.117487, -0.273831, -0.230071, -0.0848323, 0.00606538, 0.0223427, -0.067015, 0.00122724, 0.254339, 0.143904, 0.0559882, 0.162935, -0.0233507, 0.310234, -0.199058, -0.162882, -0.0393288, -0.248462, -0.0884425, 0.0956204, 0.0728128, 0.130104, 0.180941, -0.216298, -0.261913, -0.0243646, -0.0938965, -0.333373, -0.267905, -0.206052, -0.0726583, -0.0922049, 0.0393366, 0.0456249, -0.0427244, 0.0331262, 0.111953, -0.0305619, -0.16484, -0.0479283, 0.0365227, -0.096913, 0.0281339, 0.0404092, 0.0573211, -0.0661647, 0.0480404, -0.145186, 0.0722382, 0.168975, -0.123488, -0.224111, 0.0805722, -0.108956, -0.0762097, 0.0394771, 0.273366, -0.0651466, 0.0577189, 0.137891, -0.0168823, -0.0396518, -0.24396, -0.263543, -0.0154864, -0.154968, 0.0114416, 0.0631717, -0.117929, 0.129496, -0.0089868, -0.0406307, 0.0875422, 0.0125618, -0.0279158, -0.306835, -0.470807, -0.0807379, -0.0464291, -0.135494, 0.0893852, 0.148148, 0.263649, 0.117013, 0.00917385, 0.00731348, 0.150979, -0.0273764, -0.203416, -0.223486, 0.224594, 0.0135125, 0.405505, 0.309721, 0.207189, 0.17877, -0.0650774, -0.0187941, 0.00715713, -0.174802, -0.132872, -0.0172856, -0.113369, 0.0754449, 0.396685, 0.446636, 0.165005, 0.0427143, -0.0972808, -0.0516197, 0.0952168, 0.0790522, -0.0220618, -0.09834, -0.138498, 0.0896121, -0.0391243, -0.162298, -0.00614132, -0.0609789, -0.0292895, 0.000454433, -0.0431209, 0.0263045, 0.0415624, 0.0634031, -0.0645333, -0.00898741, -0.0192691, 0.0300279, -0.0245311, 0.0376647, 0.0919748, -0.0153646, 0.00234855, -0.00842873, -0.0701019, -0.0471941, 0.0497757, -0.141119, -0.20916, -0.182287, -0.0627434, 0.00214268, -0.0778161, -0.111997, -0.0456338, 0.0283209, 0.0843814, -0.101692, -0.140111, -0.0113262, -0.0322531, -0.172833, -0.120857, 0.0883572, 0.0182361, -0.0803858, 0.141108, 0.057726, 0.0870638, -0.0217756, -0.0300593, -0.0396803, 0.0398435, 6.36377e-05, 0.120122, -0.143865, -0.00665309, 0.0305816, 0.371831, 0.480353, 0.415941, 0.0375265, 0.081826, -0.0270152, 0.183837, -0.255966, -0.104759, -0.0588743, -0.0963775, 0.105925, 0.28482, 0.318788, 0.582224, 0.435664, 0.266086, -0.0143226, -0.0274911, 0.157379, 0.0585168, -0.0632317, -0.164798, 0.062176, 0.134427, 0.339009, 0.614471, 0.350406, 0.310387, 0.260127, -0.134682, 0.0780097, 0.183723, -0.0722043, 0.0539564, -0.134532, 0.0346445, -0.257304, 0.310952, 0.259912, -0.0741953, 0.307256, 0.357446, 0.0725685, 0.0621499, 0.219827, 0.112775, 0.229227, -0.177301, -0.0324811, -0.0401627, -0.0108367, 0.0156585, -0.136219, 0.0768969, 0.318356, 0.0410881, -0.0396383, 0.110974, -0.0107871, -0.0520768, 0.00567218, -0.0244004, -0.0687956, -0.286157, -0.312953, -0.173843, -0.29582, 0.0540886, -0.0733244, 0.181491, 0.172129, 0.107223, 0.148437, 0.179546, -0.0512892, -0.739856, -0.503896, -0.259427, -0.443417, -0.150723, -0.125612, -0.0930336, -0.0504676, 0.112272, 0.190727, 0.306018, 0.0507496, 0.118172, -0.156678, -0.374385, -0.491964, -0.556055, -0.115476, -0.146047, -0.0835346, 0.00308097, 0.0224558, 0.0313757, 0.0135362, 0.00729297, -0.283567, -0.102533, -0.44796, -0.393998, -0.417805, -0.149431, -0.114301, -0.0406124, 0.0308006, -0.00200591, -0.0674675, -0.122065, 0.0927157, -0.262304, 0.228224, -0.172611, 0.138401, -0.0637639, -0.187008, -0.0400558, 0.030946, 0.0281975, -0.0336623, 0.0102522, 0.00699354, -0.030724, -0.00436268, 0.0201393, 0.0405277, 0.0276634, 0.023813, 0.00117545, 0.0941433, -0.0132018, 0.0446413, -0.060869, 0.0538291, 0.0271612, -0.0669782, -0.0058294, 0.155266, -0.0360265, 0.0217991, 0.0616634, -0.0760512, 0.0775917, -0.0157103, -0.0377931, -0.101507, -0.0311042, 0.0629822, 0.193768, 0.0307776, 0.17272, 0.164263, 0.145806, 0.330668, -0.0438742, 0.0945503, -0.0564886, 0.0635989, -0.0684577, -0.0012468, -0.165928, -0.0839038, 0.0376707, 0.21389, 0.0796825, 0.396994, 0.221807, 0.224975, 0.0528869, 0.0805401, 0.0116302, 0.0124217, -0.15287, 0.0987813, 0.174687, -0.14535, 0.29981, 0.15493, 0.0587906, 0.0124724, 0.0474577, 0.0538528, 0.048761, 0.0883405, -0.0666632, -0.12055, -0.162831, -0.144101, 0.000147276, 0.0934736, 0.197698, 0.052917, 0.1209, 0.20843, 0.121443, 0.0276164, 0.0225276, -0.00856487, -0.0464289, 0.0246642, 0.0255413, 0.073003, 0.0572079, -0.21896, 0.150482, 0.0229243, 0.00750775, 0.0632644, 0.0809804, -0.0915456, 0.0790739, -0.0570848, -0.0369426, -0.265446, -0.182455, -0.0834812, 0.295222, -0.068974, 0.0640291, -0.0194107, 0.0476685, -0.0751774, -0.0498703, -0.0117526, 0.0527443, -0.211254, -0.0553554, 0.0375604, 0.0974936, -0.0646644, -0.0814214, -0.0670273, -0.0609121, -0.0936058, -0.0337715, -0.0798195, 0.154141, -0.0529968, 0.0479738, 0.126828, 0.0978755, 0.152794, -0.213207, -0.029426, -0.204113, -0.0859268, -0.00277161, -0.0430049, 0.0196403, -0.00614161, 0.0998916, 0.0202378, 0.0883797, -0.13065, 0.0190243, 0.00511273, 0.0794168, -0.011712, -0.107451, -0.00548771, -0.0848756, -0.0740406, 0.0331057, -0.0573138, 0.256868, 0.144393, 0.0462251, 0.0690326, 0.224603, 0.211109, 0.0245986, 0.0723515, -0.00527672, 0.0675019, -0.011057, 0.0871692, -0.0742092, -0.0317616, 0.162617, 0.146776, 0.0214564, 0.156974, 0.128558, -0.0652139, 0.0122902, -0.0621273, 0.0582797, 0.0725104, 0.0154579, -0.0969275, -0.0859576, -0.068161, -0.0467695, -0.067956, -0.0956513, -0.0335777, 0.0722051, -0.0841934, -0.0574511, -0.0694466, 0.0127393, -0.0875586, -0.0758118, -0.089762, -0.191718, 0.0321403, 0.00849394, 0.0126467, -0.0842803, -0.00175452, 0.0574397, -0.0390365, 0.0401061, 0.0698304, 0.00287027, 0.0218372, -0.176453, -0.136445, -0.262832, -0.00932303, -0.110454, 0.00978311, 0.169363, -0.10634, -0.0486641, -0.0684401, -0.0609631, 0.0171225, -0.193788, -0.0366697, -0.0891619, -0.0133669, 0.243954, -0.22672, -0.0132254, -0.160162, 0.0376334, 0.0632355, -0.00600631, -0.0471702, -0.0900296, -0.191111, 0.0132327, -0.260407, -0.173174, -0.206566, -0.205447, -0.0681701, -0.34837, -0.332674, -0.107936, -0.0128948, -0.0709438, -0.167517, -0.320921, 0.128076, -0.101374, -0.294943, -0.0922148, -0.582347, -0.275779, -0.23542, -0.267441, -0.136327, -0.25832, -0.0174542, -0.0129106, -0.605107, -0.314261, -0.297156, -0.38328, -0.198906, -0.205889, -0.0995703, 0.0915238, -0.192381, -0.165414, 0.0230667, 0.0643115, -0.210227, -0.188351, -0.639945, -0.410624, -0.278225, -0.197166, -0.506043, -0.437446, -0.00757191, 0.0221141, -0.179747, -0.124332, -0.130149, 0.190183, -0.0743646, -0.240007, -0.197011, -0.0736296, -0.186047, -0.0998427, 0.047054, -0.021621, 0.247169, 0.275328, -0.0280548, 0.0530886, -0.127182, -0.361404, -0.295223, 0.00627053, 0.111188, 0.277743, 0.179925, 0.135611, 0.00369898, -0.0579268, 0.0200383, -0.0778348, -0.0316097, 0.0497649, -0.221225, -0.213929, -0.15898, 0.12822, 0.0238495, 0.25973, 0.453522, 0.123826, 0.0965507, -0.0230743, 0.116349, 0.00335136, -0.0150785, -0.0638102, -0.104982, -0.111397, 0.126478, 0.292286, 0.441315, 0.108844, 0.0349156, -0.047433, -0.0283249, -0.015953, -0.0871894, -0.0417323, -0.135141, -0.1497, 0.0253606, 0.0735632, 0.284919, 0.196296, 0.195917, -0.0201848, -0.150523, -0.101334, 0.0337314, -0.0405154, -0.0677793, 0.0498976, 0.107039, 0.159155, 0.118884, 0.348537, 0.34372, 0.157444, 0.0307619, 0.0148198, 0.0882606, 0.0486442, 0.0325363, -0.0320042, 0.0639756, 0.105474, -0.0500338, -0.0394686, -0.0534767, -0.00751042, 0.16785, 0.257332, 0.182549, 0.0577375, -0.0938174, -0.0346818, -0.00652081, 0.0690576, 0.0664837, 0.0978844, 0.0712201, 0.11537, 0.128904, -0.0522279, -0.0547574, -0.0288967, 0.0279898, 0.110192, 0.0657558, -0.00550009, 0.108736, -0.00898272, 0.0605422, -0.176061, -0.0227161, -0.0666288, -0.0911166, -0.0476576, 0.0916057, -0.123322, 0.0764964, 0.0913896, -0.0248466, -0.00842084, 0.190008, 0.203146, 0.295608, 0.0653956, 0.186315, -0.264726, -0.299767, -0.215158, -0.200521, -0.0365393, -0.0550463, -0.0121031, -0.305097, -0.289511, -0.157477, -0.0186328, -0.12506, -0.382922, -0.284255, -0.447844, -0.37697, -0.524695, -0.236136, -0.122439, -0.232449, -0.186247, -0.438855, -0.343487, -0.149587, 0.0684634, 0.181608, 0.0553985, -0.13134, -0.37812, -0.171855, -0.0544055, -0.00637969, -0.179616, -0.19112, -0.508866, -0.246303, -0.213266, -0.0811566, 0.298941, 0.119594, -0.0644298, -0.297729, -0.096069, -0.108982, 0.0261355, -0.0952055, -0.344682, -0.271594, -0.257131, -0.135439, 0.073244, 0.015647, 0.192455, -0.110034, -0.19518, -0.0885976, -0.0263974, -0.155273, -0.142862, -0.359742, -0.232441, -0.326281, 0.0081573, -0.146085, 0.244035, -0.0440575, 0.12156, 0.0101322, 0.143577, -0.102137, 0.0834291, -0.224901, -0.0430755, -0.0875646, 0.134898, -0.0484756, 0.00742001, 0.182432, 0.23343, 0.340533, 0.0260023, 0.177293, 0.0970075, 0.0574161, 0.226776, 0.0395423, 0.22381, 0.0653373, -0.145919, 0.128963, 0.144135, 0.250756, 0.189495, 0.0503398, 0.0582154, 0.0105188, 0.0762584, 0.103237, 0.044032, 0.0515068, 0.0972861, 0.173924, -0.0707825, 0.082257, 0.284531, 0.102652, 0.185428, 0.0835597, -0.0152919, 0.0429396, -0.0926669, -0.0235344, 0.0692901, 0.104661, 0.0397765, -0.0352737, 0.0621227, -0.0566409, 0.202771, 0.031189, 0.0267064, 0.0449707, -0.0657851, 0.0362694, 0.109023, 0.0894803, 0.0914387, 0.137715, -0.000346398, 0.158057, 0.0384582, -0.0694991, 0.136664, -0.128301, -0.0237999, 0.000780088, -0.00854054, 0.0399766, 0.0669425, 0.282596, 0.218073, 0.0758976, 0.0914259, -0.128811, 0.11259, -0.14774, 0.0465511, 0.045441, -0.0211225, -0.0567379, 0.103154, 0.123226, -0.0123635, -0.0498994, 0.152012, -0.0112117, 0.0116634, -0.374575, -0.0899851, -0.231824, 0.137841, 0.0359684, 0.0949709, 0.011869, -0.0295969, 0.0508899, -0.0525852, -0.0241712, -0.201311, -0.335099, -0.408904, -0.0436225, -0.170507, -0.0316551, 0.0313179, -0.0886239, -0.0241041, -0.175762, -0.0838098, -0.00647876, 0.100196, 0.2352, -0.100221, -0.272445, -0.140829, -0.141621, -0.00920207, -0.0990395, -0.153526, -0.0640876, 0.0640938, -0.0634689, 0.0589942, 0.119983, 0.286411, 0.0614872, -0.0786622, -0.0658326, -0.0486188, -0.114869, -0.0398588, -0.049958, -0.324739, -0.209171, -0.192435, -0.076887, 0.281753, 0.10403, -0.217045, 0.105179, -0.166291, 0.086926, -0.298843, 0.0481457, -0.177266, -0.119634, -0.00830892, -0.0660968, -0.0837352, 0.411629, 0.319127, -0.165448, 0.178484, -0.00736375, 0.167736, -0.11218, -0.0744754, 0.0698134, -0.0623732, 0.306631, -0.117065, 0.1283, 0.411966, 0.209657, 0.153543, 0.116413, 0.261925, 0.0751479, 0.024056, -0.0523044, -0.077564, 0.139787, 0.0651629, 0.0316075, -0.285568, 0.128665, 0.0805954, 0.212258, 0.0111446, 0.0733461, 0.149898, -0.035471, 0.0247687, -0.0662128, 0.152462, 0.103621, 0.13545, 0.0731816, -0.0926208, 0.0502649, 0.266718, 0.0416916, 0.306805, 0.0461252, -0.0798961, 0.0605162, -0.00376602, 0.125673, -0.0237875, 0.0638393, 0.114082, 0.0157813, 0.0862957, 0.0752128, 0.0730544, 0.0845439, 0.148275, -0.0326629}, {-0.00702459, -0.058447, -0.0121729, -0.0257262, 0.130602, -0.0523586, 0.0354359, -0.0255493, 0.164408, 0.161718, -0.0258615, 0.0360731, 0.0672791, 0.0357683, 0.0630375, -0.0271739, -0.0256037, 0.106655, 0.297772, 0.0990212, 0.447643, 0.0838438, 0.183688, -0.0600471, -0.023036, 0.0453551, -0.105527, 0.0623061, -0.145557, -0.0394248, 0.114205, 0.278914, 0.26596, 0.299138, 0.268069, 0.243119, 0.0218518, -0.117867, -0.0763784, -0.101515, 0.0939556, -0.0946, -0.173784, -0.473599, 0.0340898, 0.276772, 0.184246, 0.275881, 0.590879, 0.0886518, -0.00379701, -0.00529346, -0.0413067, -0.109518, -0.0963928, -0.405161, -0.168166, -0.177018, 0.0458206, 0.444233, 0.117689, 0.259473, 0.14364, 0.0257415, 0.0418018, 0.00564578, -0.0977604, -0.0920365, -0.0422207, 0.0666847, -0.0237667, -0.124535, 0.0992866, 0.0784602, 0.210973, -0.0511799, -0.0221726, -0.0396506, -0.0162194, -0.163473, -0.0222073, -0.188447, 0.254366, 0.205841, 0.214292, 0.166018, 0.0485112, 0.179802, -0.0890206, -0.137797, 0.0363855, -0.0710247, -0.140415, 0.105067, -0.231432, -0.114846, 0.193985, 0.0113453, 0.0360258, -0.0154562, 0.0344679, 0.127941, -0.11214, -0.0283878, -0.0942188, -0.0530683, -0.224048, 0.00795625, -0.0676725, 0.101772, 0.135203, -0.0705275, -0.314285, -0.120347, -0.269323, -0.143305, 0.0632592, -0.0344139, 0.133718, -0.0467912, -0.0744797, 0.1236, 0.264775, 0.151975, 0.295217, -0.292248, -0.187332, -0.00593283, -0.0135951, 0.0382206, -0.0326779, 0.281252, 0.170091, 0.142037, 0.185564, -0.0362257, 0.271916, 0.0742108, -0.271606, -0.119977, 0.0246642, -0.0141083, 0.0664953, -0.0411785, -0.00776262, 0.0574699, 0.144466, 0.221739, 0.16581, -0.135842, 0.0239339, -0.131843, 0.0347154, -0.0259365, -0.0376212, 0.0776085, 0.0433189, 0.0313564, 0.119372, 0.109505, -0.049866, -0.0927765, 0.0771023, -0.0517309, 0.00901332, 0.0785602, -0.0546896, -0.0467151, -0.0459417, 0.0550655, -0.0435909, -0.0500366, -0.0620741, -0.0810854, 0.0160083, 0.10851, 0.0470279, 0.0458663, 0.014982, -0.0877862, 0.0354212, 0.083329, 0.0662735, 0.0322006, 0.00712829, 0.0450622, 0.0536595, 0.0927751, 0.0719136, 0.222033, 0.037963, 0.0436652, -0.038848, 0.0770174, 0.0165615, -0.0466129, 0.0124708, 0.0862152, -0.131913, 0.167599, 0.0963397, 0.264954, 0.303644, 0.179361, 0.047087, -0.062296, -0.0654947, 0.0561547, -0.0437224, -0.0304546, 0.0512951, 0.0430667, 0.219205, 0.173325, 0.168514, 0.28761, 0.223503, 0.151031, -0.0490211, -0.0507612, -0.0945413, 0.0933159, 0.0651028, -0.18831, 0.0445113, 0.040234, 0.127561, 0.3661, 0.128688, 0.223125, -0.00877764, 0.0109834, 0.053794, -0.100768, -0.0122597, -0.0669745, 0.0205295, -0.174389, 0.0763009, 0.243709, 0.220097, -0.0168909, 0.0810666, -0.00697345, -0.0177427, -0.0673825, -0.0156577, 0.00404417, -0.106633, -0.215582, -0.0443366, 0.017073, 0.321759, -0.136011, 0.383039, 0.0454465, -0.133504, -0.00619418, -0.103042, -0.109789, 0.0803534, -0.0243146, -0.17155, 0.00939593, 0.081839, 0.286346, 0.216775, 0.0771118, -0.0278763, 0.0522671, -0.107503, -0.00851161, 0.0751955, -0.00792349, -0.111185, 0.0977397, 0.125471, -0.0701879, 0.469953, 0.00847229, 0.0325932, -0.0532413, -0.0596679, -0.142677, -0.107299, -0.0337442, 0.0238391, -0.0769508, -0.171283, 0.257565, 0.180923, -0.0172916, 0.237852, 0.116453, -0.134592, -0.11773, 0.0309971, -0.0443424, -0.0435569, -0.0140549, -0.0658643, -0.143785, -0.056622, 0.0645473, 0.0760647, 0.0976383, -0.0267947, -0.000971882, -0.108828, 0.02319, 0.0953394, -0.0516403, 0.00568719, -0.039341, 0.00932017, 0.252394, 0.22553, 0.17289, -0.0373219, 0.108891, 0.0229282, 0.0125832, -0.0219927, 0.0337572, 0.0422864, -0.0428115, -0.0569328, 0.0196323, 0.00157229, 0.0344439, 0.0526964, -0.0444532, -0.075744, 0.0848342, 0.0170481, 0.0778719, -0.014987, -0.0632058, -0.0894443, 0.0624155, 0.0856662, -0.0732445, -0.136658, 0.0673435, 0.017858, 0.100221, 0.0960153, 0.0668718, 0.0900801, -0.0774985, -0.0185612, 0.00633391, 0.0287135, -0.0739497, -0.0659295, -0.2663, -0.050401, 0.24946, -0.0388312, 0.0440653, 0.225903, -0.0332278, -0.0343746, 0.0627093, 0.0696641, 0.0936442, -0.0161866, -0.0897262, 0.115022, 0.28559, 0.231445, 0.0152692, 0.0228929, 0.051899, 0.112866, 0.0733813, 0.0329645, 0.0462749, 0.0363391, -0.0400369, 0.0622671, 0.102975, 0.284199, 0.0326561, -0.0713291, -0.0461172, 0.320341, 0.108549, -0.110611, -0.087234, 0.0648189, -0.103196, -0.198714, 0.0743822, 0.214773, 0.446191, 0.395678, 0.35039, 0.0358397, 0.0810533, 0.0451282, 0.0930354, -0.0867865, 0.0722748, -0.0796255, -0.0259666, -0.177993, 0.217122, 0.394403, -0.0513133, 0.109676, 0.210411, 0.00695671, -0.0642613, 0.056057, -0.00247071, -0.0705967, 0.0364482, -0.124054, -0.0163081, 0.149479, 0.303706, 0.203352, 0.223662, -0.0219679, -0.0273671, -0.077112, 0.0396797, -0.0862476, 0.0631469, 0.0326179, -0.248569, 0.132262, -0.141383, 0.277121, 0.100527, -0.219121, -0.0645279, -0.147739, -0.160227, -0.0369344, 0.0105697, -0.0685977, -0.0863923, -0.112422, 0.0837657, 0.144221, 0.263711, -0.122744, -0.228843, -0.165013, -0.288567, -0.191576, -0.131035, -0.0726858, 0.0899053, -0.0844995, 0.00941819, -0.0769007, 0.0848474, 0.121146, 0.131971, 0.321097, -0.146161, -0.308745, -0.177697, -0.0673039, -0.0672173, 0.0258101, -0.10743, -0.0218641, 0.0139391, 0.0185868, 0.253601, -0.033846, -0.0915021, 0.0907876, -0.154377, -0.197479, 0.133928, -0.0263445, 0.0605713, 0.0382439, -0.0735832, 0.106228, -0.0233855, 0.0692391, 0.0194188, -0.0727327, 0.00534144, -0.0273725, -0.0609397, -0.0316545, 0.0619469, -0.0427655, 0.0965548, -0.0198029, 0.0691919, 0.0314562, -0.03212, -0.128304, 0.0416065, 0.0286904, 0.0736354, 0.0420932, -0.0245081, 0.0208582, -0.00438694, 0.0125621, -0.0967048, -0.0349567, 0.0222446, 0.0620563, -0.0416832, -0.0560345, -0.0488093, -0.046591, -0.0849182, -0.028578, -0.0617607, 0.015857, -0.105682, -0.020596, 0.174922, 0.168397, 0.212152, -0.0218784, -0.234765, -0.0690721, -0.0560993, 0.0384293, 0.0680897, 0.0965425, 0.031371, -0.0574202, -0.04883, 0.234639, 0.411264, 0.0195173, 0.0746134, -0.227384, -0.135994, -0.111663, 0.0126958, 0.0712756, 0.0865657, -0.0204522, -0.0912236, 0.119129, -0.136489, 0.245554, 0.260912, -0.0719409, -0.171356, -0.090628, -0.168809, -0.118151, -0.104856, -0.106586, 0.0476838, -0.209707, -0.083667, -0.0936297, -0.132745, -0.150222, 0.164579, 0.154057, -0.0367717, -0.285074, -0.159607, -0.0600974, -0.0624926, -0.0694756, -0.0182273, -0.149495, -0.0973353, -0.026217, -0.106873, 0.00539805, -0.0226399, 0.1579, -0.0939667, -0.0267447, 0.0224033, -0.109272, 0.0312991, -0.154438, -0.202325, -0.133943, -0.292018, -0.0748218, 0.123829, -0.0835809, -0.255972, 0.0552853, -0.136795, -0.171215, 0.0672182, -0.143302, -0.0685396, -0.215192, -0.242155, -0.302469, -0.315648, 0.0572447, -0.0314756, -0.330888, -0.079922, -0.0209552, -0.159087, -0.034737, -0.102958, -0.0124586, -0.225459, -0.207383, 0.00350845, -0.0403786, 0.213128, 0.0802851, -0.107132, -0.109922, -0.0618314, 0.0238935, -0.0240912, -0.0930492, -0.143292, -0.111085, -0.0727386, -0.099432, 0.0836836, 0.255094, 0.365244, 0.10282, -0.175116, -0.116373, -0.0413436, -0.0479474, -0.0384425, 0.0153176, -0.25331, 0.039049, 0.0456646, 0.397875, 0.508721, 0.175859, 0.29146, 0.357241, 0.255258, 0.0520934, -0.020336, -0.0283475, -0.11648, 0.154979, 0.262105, 0.337548, 0.341029, 0.205998, 0.360719, 0.228653, 0.121153, 0.00802931, 0.177738, -0.0404599, -0.0474805, 0.065858, -0.0708563, 0.188693, -0.0212235, -0.136843, 0.180555, 0.158283, 0.0329165, -0.0384247, -0.131814, 0.0341383, 0.049965, -0.0327002, -0.0423128, -0.0763681, -0.0704836, 0.0292476, 0.019177, -0.0211737, -0.0398379, -0.0210927, -0.0511448, 0.0252428, -0.063757, -0.0900069, -0.0259375, -0.0532751, -0.0745918, 0.0247183, -0.126796, -0.0280421, -0.139344, -0.156285, -0.31062, -0.0287161, 0.0762655, -0.000558461, -0.0441943, 0.0637937, 0.0282772, -0.0204397, -0.0551885, 0.0448843, 0.170635, -0.222469, -0.21415, 0.0884467, -0.0711975, -0.110167, -0.0357196, 0.0195991, 0.035271, 0.0679737, 0.0633026, 0.0385893, 0.278039, 0.103481, 0.00225193, -0.17086, -0.325871, -0.361059, -0.0115359, -0.00956529, 0.0576741, 0.0419163, -0.0736209, -0.000915928, 0.150538, 0.266165, 0.0852721, -0.0841461, 0.0415393, -0.21851, -0.153538, -0.0299373, -0.12321, 0.0537123, 0.0798999, 0.0437877, -0.0288261, -0.14282, 0.00356459, 0.162678, -0.0872001, -0.0460209, -0.0116586, 0.104068, 0.0566735, 0.0873093, 0.0626067, 0.0188983, -0.0813646, -0.055096, 0.0499736, -0.0745112, 0.0140997, -0.00197604, -0.0377961, -0.1467, -0.0319743, -0.105405, -0.0290939, 0.0653894, -0.046496, 0.0759609, -0.110162, 0.0158906, -0.0570199, -0.0133466, -0.186246, -0.170879, 0.16022, -0.156426, 0.0407, 0.0310086, 0.092742, -0.0916742, -0.0458789, -0.0214923, -0.0869718, -0.127175, -0.12604, 0.0250666, -0.276913, 0.207709, -0.0631619, 0.0357782, 0.0541124, 0.0538096, 0.0198002, -0.121256, -0.0788934, -0.105109, -0.0547895, 0.022206, -0.147273, -0.0059612, 0.124481, -0.0360968, 0.0134637, -0.00172665, -0.0277788, -0.0145755, 0.0651347, -0.161168, -0.129869, -0.113892, 0.0226946, -0.141661, -0.058258, 0.113547, 0.0330183, 0.0891138, 0.156999, -0.000153101, -0.00140703, -0.110985, -0.122915, -0.0474574, -0.0267118, 0.0644293, 0.148005, 0.176103, -0.115215, 0.124478, 0.11978, -0.056425, 0.112844, 0.0721606, 0.0948388, 0.0220239, 0.0556093, 0.121912, 0.024402, 0.0431777, -0.0448922, 0.141124, 0.00738489, 0.0523154, 0.0914237, 0.0699975, 0.0981084, -0.0635597, 0.0782137, 0.0545169, -0.0809091, 0.103227, 0.0739628, 0.0388863, -0.0920227, -0.0617646, -0.00457072, 0.0160474, 0.050013, 0.00556324, -0.0913692, -0.0706972, -0.0100335, 0.113338, -0.120244, -0.0628176, 0.142603, -0.207987, -0.0799833, -0.0303055, 0.0118477, -0.0789454, -0.0303617, -0.0723803, -0.0406052, 0.0622, -0.255796, -0.308604, -0.236243, -0.126251, -0.606543, 0.000356258, -0.0395039, -0.0832512, -0.0860064, -0.0167398, -0.0454309, -0.0952267, -0.013232, 0.0209327, -0.520825, -0.141986, -0.252181, -0.567352, -0.339114, -0.239937, -0.167066, -0.0866553, -0.0252548, -0.0709342, 0.173421, 0.0711275, 0.167259, -0.070576, -0.238961, -0.24175, -0.443423, -0.237468, -0.0976167, -0.237714, -0.0180945, -0.122204, -0.106699, -0.14917, 0.255677, 0.277894, -0.362985, -0.335917, -0.140675, -0.385025, -0.399045, -0.0167659, 0.0523072, 0.0527804, 0.0173417, -0.0375416, 0.0331869, 0.171772, -0.144915, -0.375012, -0.282117, -0.381826, -0.382096, -0.123201, -0.151235, -0.0347478, 0.0732926, -0.00359525, 0.0054996, 0.130096, 0.179781, -0.053768, -0.121615, -0.340773, -0.5856, -0.248388, -0.0883108, -0.107143, -0.0169141, -0.00943099, 0.00499284, -0.150763, 0.00642814, 0.211084, -0.0581636, -0.35813, -0.250809, -0.194704, 0.0978864, 0.185328, 0.255895, -0.0278768, -0.122126, 0.0111242, 0.169268, 0.368517, 0.287674, 0.205093, -0.293572, -0.127062, -0.0937571, 0.0539672, 0.385386, 0.0962984, -0.193383, -0.0912871, 0.00861359, 0.138093, 0.110744, 0.0834931, -0.0805932, -0.169219, -0.132029, 0.0173145, 0.350816, 0.0965351, 0.267127, 0.0769768, -0.0550881, 0.0137776, -0.00741153, 0.323907, 0.0604786, -0.0795616, -0.38056, -0.196133, -0.168028, 0.0752082, 0.214416, -0.0720034, 0.0782771, 0.252229, 4.20911e-05, -0.0688061, -0.0589477, 0.161175, -0.0942418, -0.252899, -0.0751455, -0.239136, 0.132486, -0.0227854, -0.0414525, 0.0233925, -0.0850304, -0.171646, -0.194669, -0.179854, -0.0577163, -0.14001, -0.271306, -0.336944, -0.284118, -0.0175351, -0.129013, -0.157354, -0.118009, -0.152891, -0.0377927, -0.0298285, -0.0300689, -0.16653, -0.102468, -0.529069, -0.285209, 0.0404512, -0.234236, -0.262964, -0.129612, -0.084783, -0.0804091, -0.0120678, -0.079484, -0.118224, 0.111665, -0.179897, 0.156233, 0.0316428, -0.208459, 4.20992e-05, -0.0441582, 0.0467154, 0.0231124, -0.0539324, 0.00624299, -0.0404948, 0.0677832, 0.110599, 0.356738, 0.116612, 0.234072, 0.0515224, 0.112012, -0.0742885, -0.174824, -0.134485, -0.0536345, -0.165096, -0.0138383, -0.249164, 0.142831, 0.159648, 0.329205, 0.107387, 0.136014, 0.28153, 0.357821, 0.247429, 0.0904179, 0.0222589, -0.186977, -0.0420143, 0.118454, 0.25526, 0.376862, 0.109657, 0.04133, -0.000626678, 0.283527, 0.0467148, 0.0189025, 0.0845401, 0.0432016, -0.0314034, -0.0534887, -0.003725, 0.0353068, 0.105213, -0.108302, 0.0211698, -0.0409747, 0.0818021, -0.0724143, -0.0871423, -0.0408578, 0.0113805, -0.160927, -0.115873, 0.0303647, 0.0272153, 0.076933, 0.404615, 0.239963, 0.232759, 0.135345, 0.366107, 0.207549, 0.10151, -0.0388073, -0.16601, 0.0753097, 0.149916, 0.224011, 0.478547, 0.334717, 0.220759, 0.192492, 0.206984, 0.287557, 0.0752432, 0.0215012, -0.00362224, -0.159873, -0.0536412, -0.219516, 0.292261, 0.379008, 0.47494, 0.67958, 0.296452, 0.364948, 0.141855, 0.178736, 0.0306832, 0.0188598, 0.00333821, -0.190189, -0.150729, -0.0963925, -0.120128, 0.0858641, 0.271885, 0.374012, 0.150283, 0.144138, -0.147441, -0.202748, -0.073843, -0.0476117, -0.0818589, -0.18247, -0.105768, 0.0107697, 0.314266, 0.225287, 0.106448, -0.12486, -0.0420451, -0.247511, -0.048811, -0.154031, -0.0207778, -0.185234, -0.112214, -0.24887, -0.015154, 0.23648, 0.0714986, -0.197269, 0.0602694, -0.0628226, -0.0404376, 0.00471769, -0.0346622, -0.182529, -0.152884, -0.187104, -0.152081, -0.267562, 0.0904827, -0.266668, 0.0358783, -0.335505, -0.271258, -0.134571, -0.227919, -0.118752, -0.103702, -0.194384, -0.190904, 0.0115087, -0.129815, -0.0761374, 0.101752, -0.116148, 0.117331, -0.0074943, -0.0836397, -0.160725, -0.0980603, -0.167434, -0.0921838, -0.209876, 0.164711, 0.257215, 0.242747, 0.513679, 0.502162, 0.0596318, -0.0545005, -0.0443505, -0.056017, -0.0407992, -0.115289, -0.108679, 0.0389499, 0.00382882, 0.133233, 0.334692, 0.459712, 0.571414, 0.467678, 0.367807, 0.0916529, 0.116849, -0.0733459, -0.201792, -0.0383005, -0.0486753, 0.189303, 0.0554778, 0.164861, 0.580334, 0.605451, 0.427329, 0.489506, 0.0526652, 0.104749, -0.0720525, -0.23943, -0.000248784, 0.138206, -0.119206, 0.112765, 0.291484, 0.457957, 0.466056, 0.0420793, 0.21089, -0.0279577, 0.0591935, -0.0212651, -0.0553663, -0.145679, -0.0400187, 0.213919, -0.00809955, 0.525364, 0.284826, 0.431918, 0.117946, 0.164017, 0.0629572, 0.0999678, -0.0856371, -0.218778, -0.0798792, -0.00471552, 0.0665236, 0.156505, 0.345763, 0.511954, 0.66257, 0.296366, 0.152494, 0.038229, -0.0751795, -0.0733935, -0.038747, -0.038232, 0.0431538, 0.0972826, 0.16229, 0.48137, 0.689846, 0.663077, 0.395465, -0.0251885, -0.0868393, -0.13889, 0.0621522, -0.0406753, -0.100849, -0.0885286, -0.109398, 0.238373, 0.562438, 0.584282, 0.632043, 0.410573, -0.0723168, -0.173417, -0.236853, -0.154115, -0.230421, -0.134494, -0.109339, -0.186146, -0.0956948, 0.441633, 0.415668, 0.361638, 0.19444, -0.148197, -0.293683, -0.0938535, -0.354452, -0.115083, -0.104099, -0.163257, -0.241746, 0.181769, 0.194722, 0.186372, 0.150402, 0.131861, -0.0705287, -0.102784, -0.228094, -0.237828, -0.05178, -0.132652, 0.000286174, -0.22208, -0.0541312, -0.178532, 0.0134302, -0.108912, -0.112387, -0.164981, -0.0574093, -0.125414, -0.155953}, {0.0336497, 0.0628364, -0.159989, 0.124968, -0.0124233, 0.154493, 0.218542, 0.0636737, -0.218067, 0.10996, 0.024284, 0.0830209, 0.063121, -0.0289522, 0.0200162, 0.0221247, -0.192709, -0.151271, -0.131435, -0.283521, -0.334333, -0.111033, -0.248439, -0.100429, 0.0195712, -0.0929567, 0.107964, -0.16543, -0.101505, -0.0312138, -0.1468, 0.0427333, -0.0758744, -0.07818, -0.22349, -0.304446, -0.236837, -0.153797, -0.035687, -0.122839, -0.154765, -0.0456246, -0.158808, -0.167003, -0.0161434, -0.00708462, 0.0531184, -0.161979, -0.319186, 0.0203045, -0.207358, -0.0105394, -0.149835, -0.0372228, -0.130025, -0.149441, -0.154794, -0.173106, -0.200389, 0.0673077, 0.190166, 0.142061, -0.00363927, 0.196252, 0.0629713, -0.202596, -0.240576, -0.0661727, -0.166283, -0.37199, -0.189773, 0.0526824, 0.237016, 0.219597, 0.0750114, 0.347497, 0.128648, -0.0550282, 0.00936112, -0.0553804, 0.0957801, -0.157084, -0.252165, -0.207294, -0.121346, -0.177904, 0.12441, 0.315757, 0.087311, 0.151817, -0.0624872, 0.11396, -0.00609284, 0.0433807, 0.0302145, 0.0294522, 0.0861496, 0.0113055, 0.0659442, -0.0526996, -0.109349, -0.0304837, 0.163314, 0.0754936, 0.0588611, 0.0412393, 0.206393, 0.0138917, 0.236308, 0.352242, 0.162219, 0.18811, 0.0846681, 0.130605, -0.308737, -0.0668663, 0.00166773, 0.276798, 0.261862, 0.233639, 0.175382, 0.0204604, 0.00035638, 0.0458109, 0.131397, -0.453016, -0.18427, -0.480333, -0.173048, 0.0542488, 0.148486, 0.0816948, 0.0436442, -0.107152, -0.251221, -0.254181, -0.55188, -0.254015, -0.368925, -0.354702, -0.360321, -0.133891, -0.0405888, -0.1067, -0.206021, 0.00420468, -0.0699763, -0.0954517, -0.0284186, -0.169764, -0.490491, -0.19906, -0.371699, 0.0699963, -0.162439, 0.0586564, -0.0884353, 0.0603646, -0.163139, -0.0566192, -0.258434, -0.029921, -0.00732751, -0.250485, -0.585245, -0.144798, -0.0712964, -0.0723439, 0.0698345, -0.0431591, -0.0950354, 0.0996768, 0.102208, 0.0640625, 0.169377, 0.0118272, 0.0395094, -0.0903232, -0.0972936, -0.0138321, 0.0119714, -0.0442785, 0.0765135, -0.0588028, -0.0724175, -0.0108687, -0.0386579, 0.0994493, -0.035135, 0.165659, -0.0108364, -0.0466707, -0.0175531, 0.0128287, 0.0246026, 0.0526353, 0.0197332, 0.0343004, 0.138152, -0.211969, 0.172117, -0.0577784, 0.0611547, -0.00962933, -0.0351922, 0.165708, -0.0774736, -0.0878035, 0.0122879, -0.0465175, -0.0918594, 0.184309, 0.200914, -0.0277838, 0.140194, 0.0722141, -0.13989, 0.105752, -0.047192, -0.209033, 0.0416744, 0.00307157, -0.133638, -0.104604, 0.129892, 0.147405, -0.0451892, 0.0773442, -0.0143414, 0.113793, -0.244643, 0.0626269, -0.143563, 0.0450999, -0.0354262, -0.0805759, -0.266334, -0.106709, 0.106644, -0.0860784, 0.0166084, 0.0924227, 0.0892456, 0.146042, -0.0137073, -0.252897, 0.00718775, 0.0209045, -0.0834586, 0.0117653, -0.0105448, 0.109051, 0.0203099, -0.283679, -0.106011, -0.122427, -0.24651, -0.289015, -0.181312, 0.0756497, -0.00978445, 0.0543285, -0.0381672, -0.098424, 0.133095, 0.214066, -0.0765176, -0.134091, 0.123951, -0.0840772, -0.0164149, -0.187113, -0.00274835, 0.0313468, -0.0556869, -0.17876, 0.277246, 0.0399317, -0.0922422, -0.13674, -0.164085, 0.167267, -0.160173, -0.00977187, -0.152133, -0.0643781, 0.0325901, -0.12401, 0.117, 0.0211802, 0.170131, 0.0344678, -0.195018, -0.179466, -0.0110588, -0.085406, -0.366765, -0.206577, -0.0691835, -0.0169095, 0.18749, 0.119549, 0.0676127, 0.145472, 0.121698, 0.00854047, 0.105226, 0.0137261, -0.218039, -0.0920445, 0.0241342, -0.0328916, -0.0275013, -0.11018, 0.117549, -0.0818326, 0.0915111, 0.0477046, 0.0850514, 0.0721294, 0.0398092, -0.00403433, -0.0604406, -0.0728453, 0.0344969, 0.012509, 0.0269332, -0.0434034, 0.0275677, -0.0347258, -0.0642851, -0.0492687, 0.16661, -0.0342076, 0.0052916, 0.0691427, 0.0221601, -0.0651883, -0.0263047, -0.0347297, -0.0127598, -0.0804512, 0.0560507, -0.0484844, -0.0132246, -0.00734312, 0.0503842, 0.0836968, 0.0507489, -0.0778939, -0.0480792, -0.0478398, -0.0576768, -0.127869, -0.244341, 0.077086, -0.053259, 0.0280685, -0.0974551, -0.116435, 0.0269322, 0.0354407, 0.0636507, 0.0802418, 0.00336441, 0.124218, 0.0240491, 0.235152, 0.15816, -0.0236792, 0.0865216, -0.148757, -0.273421, 0.0330478, -0.136631, -0.013637, 0.0528145, 0.0840484, -0.00485302, -0.0655008, 0.14002, 0.256987, -0.0211889, -0.0437068, 0.0105807, -0.0880027, -0.13785, 0.0282501, -0.135, -0.102961, 0.0312406, -0.140519, 0.0890269, 0.0922981, 0.261216, 0.247608, -0.0431501, -0.257575, -0.141984, -0.0253615, -0.128421, -0.309181, 0.0154279, 2.37393e-07, -0.0397631, -0.260203, 0.16282, 0.0199563, 0.104249, 0.21827, -0.024739, -0.174094, -0.0980448, -0.280363, -0.354556, -0.0834154, -0.043446, -0.206877, 0.105346, 0.25518, 0.64968, 0.215604, 0.157867, -0.100135, 0.128644, 0.112598, -0.155275, -0.0157667, 0.0805958, 0.132771, 0.0930808, 0.0798541, 0.329201, 0.429485, 0.35378, 0.218851, 0.137157, 0.0175303, -0.0683692, 0.0233534, 0.0233191, -0.0695336, 0.0735599, 0.100995, 0.0855171, -0.0508126, 0.0212889, 0.117974, 0.0348428, 0.0159852, -0.1376, -0.0961276, -0.146877, -0.272977, -0.047277, -0.00768014, 0.124393, -0.0409135, 0.0203817, 0.00511289, 0.0177658, 0.205144, -0.201772, -0.385956, -0.2275, -0.248261, -0.0544916, 0.0230773, 0.0120082, 0.0999853, 0.115509, -0.11673, 0.212571, 0.231312, 0.101414, -0.251159, -0.20991, -0.194374, -0.358151, -0.199565, 0.0488922, 0.0979226, -0.131494, 0.0682959, 0.249727, 0.280425, 0.251071, 0.101494, 0.300305, 0.0299886, -0.185696, 0.0378348, 0.00345568, -0.0299085, -0.00639722, -0.0394014, -0.107834, 0.0835315, 0.0183732, 0.0932722, 0.049661, 0.288785, 0.169145, -0.273284, -0.0260839, 0.0424461, -0.0756989, 0.055759, 0.0236737, -0.0755353, 0.134933, 0.0934281, -0.0188294, 0.0556515, -0.0227957, -0.066684, -0.0371256, 0.0913666, -0.0384613, -0.023472, -0.0700986, -0.000816489, -0.100564, -0.0250501, 0.245105, -0.0342832, 0.0660831, 0.146285, 0.0688633, -0.0862429, 0.0472284, 0.00373978, 0.0166033, -0.076136, -0.114372, -0.0177073, -0.0946102, 0.0353156, -0.256187, 0.259187, 0.328659, 0.352941, 0.457902, 0.152924, 0.0496545, -0.0252315, 0.00947196, 0.0253246, -0.367861, -0.0556091, -0.125693, 0.0380663, 0.278205, 0.336294, 0.397326, 0.441606, 0.31144, -0.0792783, 0.0153179, -0.139939, -0.176553, -0.328292, -0.412138, 0.173742, 0.0778977, 0.08556, 0.181978, 0.205415, 0.237494, 0.152398, -0.0459643, 0.0509696, -0.0965216, -0.00771041, -0.409328, -0.321114, -0.149609, 0.130556, 0.00716645, 0.040044, -0.0353524, -0.0912114, -0.0211592, -0.202099, 0.0802577, -0.251209, -0.164503, -0.0714475, -0.399804, -0.196105, -0.216165, -0.0270898, -0.17016, -0.249721, -0.0894166, -0.364671, -0.447283, 0.00720547, 0.131306, 0.00303266, -0.198601, -0.273998, -0.316462, -0.352501, 0.0391692, 0.0295182, 0.0235006, -0.226899, -0.27363, -0.102413, 0.0246015, 0.0709174, -0.149908, 0.121348, 0.186188, -0.148732, -0.254531, -0.149613, -0.116336, 0.408025, -0.0103408, -0.11102, -0.187137, -0.0294599, 0.109702, -0.0721368, 0.0766283, -7.1994e-05, 0.125626, -0.202729, -0.130513, -0.105495, -0.0847219, -0.0188412, 0.205718, -0.159862, 0.127091, 0.193806, 0.100404, 0.0448275, 0.127844, -0.301903, -0.295951, -0.0103928, -0.115564, 0.273683, 0.14886, 0.216952, 0.0375733, 0.0652802, 0.00461368, -0.0737257, 0.191991, -0.141836, -0.00987758, 0.0186696, 0.00623792, 0.0993214, -0.00712646, -0.00988571, 0.238756, 0.261482, 0.104477, 0.0376749, -0.0243598, 0.145739, -0.0673815, 0.0482172, -0.0644102, 0.164843, 0.524404, -0.137126, -0.103195, 0.0138479, -0.0887442, 0.00674006, 0.0815893, -0.0975328, 0.0611146, 0.0989203, -0.0184261, 0.0233233, 0.0721967, -0.0105831, 0.0715228, -0.0834637, -0.0326984, -0.00453002, 0.052684, 0.0540491, 0.0515142, -0.0400748, 0.0146285, 0.257428, 0.152005, 0.0945296, 0.145732, 0.104116, -0.00341217, -0.0991162, -0.0104054, -0.0139376, -0.0488658, 0.0211711, -0.0268857, 0.0207558, 0.0521981, 0.165481, 0.228848, 0.282216, 0.22677, 0.136115, 0.172491, -0.00322238, -0.0602123, -0.0305293, -0.0658158, -0.103469, 0.0504782, 0.0258768, 0.21011, -0.0343732, 0.160537, 0.121312, -0.134903, 0.0384095, -0.0351132, -0.0267445, 0.0659342, 0.0536516, -0.074926, -0.0973025, 0.245436, -0.117254, -0.0383613, 0.187025, 0.133074, 0.267089, 0.132643, -0.0181345, -0.010972, -0.0129337, -0.0673885, -0.138546, 0.00204044, -0.059115, 0.028666, -0.0376548, 0.185693, -0.208015, -0.132251, -0.266213, -0.0972315, -0.0923771, 0.0826018, -0.128484, -0.0511693, -0.0890697, 0.109623, 0.136427, 0.0328401, -0.0538764, -0.303473, -0.0419337, -0.0285674, -0.136288, -0.0457004, 0.105344, -0.032985, -0.0285057, -0.266693, -0.234727, 0.0487363, 0.0150696, -0.196482, -0.13186, -0.00962083, -0.165974, -0.111522, 0.0428839, -0.0512645, -0.113925, 0.0747764, -0.166983, -0.178751, -0.00261371, 0.0316508, 0.273862, 0.266962, -0.140985, 0.0230089, -0.132576, -0.091754, -0.101219, 0.0651221, 0.216615, -0.0743247, -0.18374, -0.0345791, 0.0867871, 0.155387, 0.113196, -0.0375957, 0.0320325, -0.0763806, 0.114016, -0.0962102, -0.0671738, -0.209592, -0.172597, -0.142302, -0.107238, 0.0335264, 0.0614143, 0.222253, 0.289105, 0.123136, 0.0349662, -0.0430035, -0.0925624, 0.042728, 0.0398131, 0.101003, -0.00388068, 0.262123, 0.177944, 0.348331, 0.239817, 0.0815197, 0.0158556, 0.0254485, 0.0833503, -0.00491135, 0.0936639, -0.040374, 0.0796062, 0.00380489, 0.138821, 0.162829, 0.0550471, 0.248603, 0.0938793, -0.0579236, 0.0463687, -0.0538243, 0.0682055, -0.0735639, 0.00508718, 0.062806, -0.016856, 0.0188537, -0.0740535, 0.0167222, 0.0273371, -0.0983582, 0.00318665, 0.0376057, -0.0513904, 0.080598, 0.0440208, 0.0527025, 0.297377, 0.0980912, 0.0748727, -0.125916, 0.087259, 0.192514, -0.0398544, 0.0146612, 0.0249551, -0.0628858, -0.0544564, -0.153121, 0.333162, 0.272984, 0.173825, 0.339662, -0.0135631, -0.0239157, 0.0727568, -0.206825, -0.371482, -0.0845851, 0.00523281, 0.113231, 0.118098, 0.231499, 0.265517, 0.20594, 0.134665, 0.135115, 0.0565231, 0.0808498, -0.266235, -0.418153, -0.11967, -0.0491531, -0.0595837, 0.0228588, 0.368983, 0.469995, 0.0419033, 0.341741, 0.178224, -0.0202411, -0.0850733, -0.41525, -0.203991, -0.13216, -0.236151, -0.150657, 0.0284804, 0.662658, 0.494939, 0.33181, 0.212805, 0.392055, 0.364319, -0.0127602, -0.264094, 0.183607, -0.150221, -0.150565, 0.0430914, 0.226917, 0.268893, 0.489767, 0.376168, 0.46732, 0.058996, 0.0873352, 0.0358327, -0.0582966, 0.174501, 0.297314, -0.0560504, -0.0289306, -0.0668816, 0.213368, 0.0320848, 0.193071, 0.0678388, 0.160868, 0.0151255, 0.057739, 0.321845, 0.325429, 0.57608, 0.0984768, 0.103365, 0.127623, 0.024411, -0.336827, -0.180585, 0.208837, -0.0605322, -0.0972151, -0.0513191, 0.418454, 0.209316, 0.409507, 0.0610691, 0.166133, 0.20225, -0.214767, -0.279892, -0.17744, -0.0964909, 0.18587, -0.0515981, 0.304343, 0.355488, 0.464261, -0.0714658, 0.119591, 0.00842856, 0.1988, -0.298607, -0.235213, -0.177418, 0.0953298, 0.0574942, 0.194626, 0.246545, 0.474569, 0.368235, 0.151361, 0.0923048, 0.0795939, 0.0812404, -0.286157, -0.152803, -0.225286, 0.154992, 0.0410247, 0.508436, 0.0796492, 0.407473, 0.288351, 0.332766, 0.0371247, -0.0470605, -0.321281, -0.128941, -0.293553, -0.069302, 0.109694, -0.0025683, 0.122956, 0.219111, 0.201838, 0.150086, 0.0699755, -0.0857324, -0.0673375, -0.0665945, -0.0175044, -0.128451, -0.230746, 0.00230403, -0.126071, -0.0589847, 0.0588848, -0.0721256, -0.109819, -0.130964, 0.0610207, -0.11154, 0.0139108, -0.222938, -0.0867699, -0.0714782, 0.0240811, 0.273675, 0.132032, -0.124398, 0.0239765, -0.132354, -0.000263984, -0.0857043, 0.018074, 0.0495777, 0.110127, 0.140402, 0.198443, 0.0430933, 0.0655492, 0.218594, -0.00963537, -0.0409427, -0.11055, 0.0653833, 0.128376, -0.0875986, 0.0449618, 0.0939926, 0.115341, 0.190064, 0.18299, 0.0836148, 0.0517837, 0.10409, -0.0724337, -0.243861, 0.112054, -0.110348, -0.023285, -0.0718478, -0.0310464, 0.00233851, 0.257069, 0.28825, 0.199204, -0.266077, -0.0890295, -0.238461, -0.0628794, -0.0258148, 0.229255, 0.0596291, 0.0496628, 0.409591, 0.432629, 0.214062, 0.28851, 0.327885, -0.115382, 0.179422, -0.201354, 0.0795004, 0.0439507, -0.0162662, 0.0210622, -0.0922357, 0.279885, 0.148944, -0.24589, 0.20797, 0.0994098, -0.0781396, -0.0709654, -0.0987059, 0.111026, 0.0777243, -0.0499945, -0.007852, 0.0170534, 0.0923256, -0.180045, -0.158136, -0.0780599, -0.385832, 0.222399, 0.0120258, 0.120351, 0.0275852, 0.213013, 0.120185, 0.0947178, -0.100835, -0.162371, -0.296132, -0.423536, -0.286155, -0.283183, -0.109315, 0.307717, 0.221462, -0.16544, -0.110278, 0.0861133, -0.125065, -0.0165525, -0.2642, -0.41015, -0.199479, -0.423583, -0.128762, -0.158383, 0.102973, 0.367694, -0.053462, -0.059146, 0.055592, -0.0864154, -0.101939, -0.0780256, -0.138113, 0.0558819, 0.0168015, -0.21912, -0.0757523, -0.0918985, 0.0326446, 0.15495, 0.0951747, 0.0164272, 0.0867383, -0.0244046, 0.056149, 0.0761787, 0.0458837, 0.114641, 0.0585409, -0.0606165, 0.181238, 0.379406, 0.015917, -0.186035, -0.0757194, -0.0537804, 0.0557095, 0.204388, 0.0887945, 0.250373, 0.0123309, 0.0342142, 0.337673, 0.128716, 0.0286668, -0.0603905, -0.121926, -0.0810539, -0.0440237, 0.0909827, 0.0150195, -0.0247827, -0.150354, -0.243154, -0.079587, -0.144971, 0.00996014, 0.151553, 0.00919187, -0.0167793, 0.0733841, -0.0937835, -0.0967682, 0.0895406, -0.236221, -0.0488331, -0.143297, 0.142897, -0.0404562, -0.112282, -0.0304156, 0.170889, 0.0251432, 0.103463, -0.113717, -0.130613, -0.105048, 0.0271162, -0.0660328, -0.00464237, 0.0653317, 0.222428, 0.113299, -0.0557984, 0.106906, 0.136185, 0.08678, 0.0220276, 0.0733394, 0.13424, 0.0368463, -0.11472, -0.218498, -0.153178, 0.221956, 0.143855, 0.13958, 0.0423236, -0.0551446, 0.344166, 0.0619341, 0.0674115, 0.142143, 0.356753, 0.273022, 0.325591, 0.19671, 0.201658, 0.362099, 0.186906, -0.0658864, -0.0793072, 0.217332, 0.0306654, 0.271904, 0.121038, 0.369871, 0.374248, 0.191361, 0.588051, 0.724756, 0.0847975, 0.228259, -0.0361474, -0.126734, 0.152036, -0.0112611, 0.125411, 0.120165, -0.130825, -0.133437, -0.0148925, 0.105007, 0.1636, 0.366996, 0.332851, -0.102947, -0.261012, 0.0372095, -0.128058, -0.0440388, -0.00739984, -0.0728438, -0.276342, -0.386008, 0.0565766, 0.175713, 0.32678, 0.142125, -0.175928, -0.278331, 0.0212663, -0.0415473, -0.249859, 0.106329, -0.122529, -0.156593, -0.305257, -0.158003, -0.323593, 0.0767158, 0.0204447, -0.0917905, -0.167186, -0.129267, -0.175647, -0.17127, -0.152325, -0.00695833, 0.039581, 0.0216899, 0.143213, -0.364111, -0.31703, -0.174012, -0.440058, -0.0926934, -0.263481, 0.0467143, -0.0228324, 0.151882, -0.0207243, 0.118307, 0.106661, 0.330091, -0.184883, -0.284969, -0.24988, -0.20351, -0.227016, -0.0732733, -0.00227877, 0.10572, -0.048459, 0.245116, 0.0196556, 0.186154, -0.0168652, 0.173976, -0.364337, -0.36306, -0.035961, -0.156905, -0.0168599, -0.0541139, 0.14222, 0.0332474, 0.256997, 0.173708, 0.132137, 0.0907509, 0.104413, -0.0982699, -0.0829539, -0.0791396, -0.0141567, -0.0226955}, {0.0316419, 0.131443, 0.129569, -0.139035, 0.0405001, 0.0510878, 0.158011, -0.168659, -0.123035, -0.121938, -0.0167455, 0.00183656, -0.0143232, 0.0355959, -0.0269307, -0.135048, -0.0184369, -0.0312948, -0.100069, -0.153433, -0.108792, -0.177411, -0.211418, -0.135217, -0.0572011, -0.0407764, 0.0192642, -0.0796288, -0.040453, -0.308435, -0.358416, -0.245218, -0.295283, -0.289944, -0.301973, -0.24256, -0.22495, -0.0367076, -0.0166386, 0.0609174, -0.167708, -0.113908, 0.035884, -0.374146, -0.558479, -0.342859, -0.200314, 0.0309636, -0.0631599, -0.375593, -0.0735043, 0.0127251, 0.00521723, -0.114137, -0.200015, 0.121124, -0.121722, -0.0343311, -0.163518, -0.336069, 0.0819959, 0.0102193, 0.0976731, 0.106579, 0.0972071, -0.209207, -0.0641357, 0.166817, -0.116665, -0.117621, -0.151537, -0.284468, 0.00376505, 0.0452481, 0.0107684, -0.0883489, 0.0618258, -0.0618428, -0.157793, -0.030838, -0.000119182, -0.0100086, -0.0145494, 0.138189, 0.14429, 0.0580098, -0.11267, -0.12796, -0.140355, 0.0298566, 0.0293115, -0.128246, -0.212335, -0.272392, -0.130019, -0.0804356, -0.0589751, -0.152851, -0.225407, -0.29549, -0.341402, -0.516621, -0.0627191, -0.00311619, 0.0533021, -0.128672, -0.11616, -0.332027, -0.205061, -0.304681, -0.158742, -0.170094, -0.0293806, -0.115188, 0.00881578, 0.0969209, 0.0931174, -0.0121211, -0.450129, -0.371069, -0.163692, -0.0971318, -0.168125, -0.0145726, 0.0189288, 0.176152, 0.36275, 0.344312, 0.00633828, -0.0882435, 0.0547617, -0.192102, -0.299329, -0.123909, -0.45584, -0.0800429, -0.0119984, 0.0446711, 0.230525, 0.383337, 0.0964535, -0.110887, 0.00167197, 0.0691229, 0.110643, -0.167631, -0.289476, -0.163394, 0.0345019, 0.33367, 0.379049, 0.244562, -0.0348725, -0.138895, -0.00710875, 0.00384208, -0.00864009, -0.0520744, -0.0025769, -0.0408371, -0.050762, -0.067309, 0.133598, 0.0411518, 0.373627, -0.00799751, 0.024368, 0.00562853, 0.0716095, -0.0795981, 0.0891666, 0.0137994, 0.034307, -0.000547222, 0.0291626, 0.0542401, 0.00314925, 0.0728372, -0.0453684, -0.0147475, -0.0637587, -0.0863228, 0.021059, -0.0440469, -0.0933978, 0.089224, -0.0358018, -0.209811, 0.140417, -0.0338444, 0.0388114, 0.260723, -0.0159633, -0.00151844, 0.0176085, -0.0013864, -0.035801, -0.200708, -0.0588573, -0.0560101, -0.184704, -0.0990992, 0.0655683, 0.0109393, -0.00337412, 0.0593525, -0.0775977, 0.0755167, 0.0185413, -0.0489241, -0.151565, -0.189676, 0.0388488, 0.0217611, -0.0963401, -0.163086, 0.177695, -0.00213536, 0.0423283, 0.0868938, -0.0162882, -0.130983, -0.201524, -0.231125, -0.0783744, -0.0962427, -0.0110745, -0.303407, -0.179213, -0.0734786, 0.178616, 0.06664, -0.0101747, -0.00660074, 0.0219382, -0.225668, -0.184362, 0.0400032, 0.10612, -0.171839, -0.00737643, 0.163222, -0.0444404, -0.173832, 0.08151, 0.0246444, 0.0874393, -0.0148212, 0.0076065, -0.201935, -0.187619, -0.265001, -0.0837415, 0.0662346, -0.0272983, 0.0353695, 0.0646269, -0.0358657, -0.0651444, 0.0111598, 0.00369277, 0.113424, 0.00904421, -0.0560669, 0.0819955, 0.0718822, -0.168919, -0.0480404, 0.172386, -0.032578, 0.0113634, -0.00105259, -0.0821091, -0.0159084, 0.0787097, 0.121531, -0.293194, -0.217872, -0.0121692, 0.0832001, -0.0814741, 0.163141, 0.0469608, 0.127796, 0.219387, -0.0846841, -0.00290873, 0.105001, -0.169244, 0.0792843, 0.103347, 0.167202, 0.168429, 0.262044, -0.163518, 0.0957943, -0.0125443, -0.0577909, -0.0617562, 0.0118045, -0.0450163, -0.202417, -0.025437, 0.0376388, 0.0798831, 0.325786, 0.0918715, -0.0968561, -0.0179891, 0.190908, 0.0373984, 0.0904465, -0.0140664, 0.0803299, 0.00436659, -0.110504, -0.295639, -0.10884, 0.101107, 0.0320025, 0.00273515, -0.129239, -0.114631, -0.004363, -0.062655, 0.0364128, -0.0779062, -0.0465028, -0.0243728, 0.0671691, 0.0361211, -0.0805097, 0.114226, 0.101648, -0.0730321, 0.0195562, 0.0461149, -0.0654207, -0.0902501, 0.0767492, -0.0424429, 0.103801, -0.043948, 0.0354614, -0.129557, 0.0698524, 0.0591553, -0.027794, -0.0192534, -0.00208295, 0.0343474, -0.025141, -0.0118335, 0.0608897, 0.012358, -0.192245, -0.252065, -0.346839, 0.201128, 0.132794, 0.0851982, 0.136372, -0.00126047, -0.0461812, -0.0933538, -0.0933679, -0.0625615, -0.0635276, 0.0275149, -0.17011, -0.170074, 0.0502899, 0.150314, 0.106613, 0.076687, 0.0555915, -0.0940723, 0.0241614, -0.135071, -0.0693292, 0.125646, 0.0730248, 0.102776, 0.162588, 0.139743, 0.112193, 0.0800043, -0.017285, 0.0134992, -0.0416245, 0.0451269, -0.206067, 0.0265104, 0.198089, 0.384602, 0.479714, 0.273297, 0.182296, 0.0869987, 0.251264, 0.453924, 0.186231, 0.0341436, 0.0570646, 0.0661256, -0.18588, -0.0254963, -0.0804276, 0.344983, 0.362624, 0.294704, 0.209516, 0.0843803, 0.336207, -0.170428, -0.0774132, -0.0107972, -0.294732, -0.382009, -0.667384, -0.312944, 0.193133, 0.209533, -0.00249141, -0.00519866, 0.133021, -0.0310124, -0.0804405, -0.00959519, 0.0299014, 0.0198915, -0.196704, -0.348542, -0.150376, -0.145625, -0.190114, -0.161927, -0.266346, -0.114902, -0.0633945, -0.17088, -0.0235027, 0.0121864, -0.0577568, -0.432956, -0.0472448, -0.202544, -0.0654936, 0.0454984, -0.247417, -0.164327, -0.106381, 0.00981608, 0.119709, 0.0687091, -0.00346094, -0.005688, -0.0106873, 0.0305957, 0.00222636, 0.225618, -0.00832305, -0.0335011, -0.0659671, 0.209697, 0.260951, 0.240242, -0.0580461, -0.0462669, -0.079693, -0.0263044, -0.0628087, -0.149741, 0.0251516, -0.0107842, 0.00844236, 0.0673135, 0.169, 0.234471, 0.147346, -0.00778235, -0.0596731, 0.00860603, -0.0796472, -0.156783, -0.0462048, 0.145769, 0.40103, 0.5622, 0.240192, -0.00568145, -0.0132672, -0.0339725, 0.0125868, 0.0982025, -0.0365471, -0.0114511, 0.0821004, 0.132201, 0.168268, 0.29124, 0.222477, 0.241451, 0.138608, -0.0692681, -0.0460646, 0.0992124, -0.0626811, -0.0224351, -0.0146385, -0.0934967, -0.0873606, 0.0162205, 0.100702, -0.0475895, 0.0338264, -0.0517859, -0.0341555, 0.0441194, 0.0313164, 0.105629, 0.0282753, 0.00164546, -0.133055, 0.232704, 0.0409826, 0.290483, 0.182089, 0.0834474, -0.0174026, -0.0495296, -0.0170034, -0.0837253, 0.0418725, -0.0906015, -0.282273, -0.251789, -0.280399, 0.201657, 0.164327, 0.46126, 0.451138, 0.258866, -0.0166472, 0.0813324, 0.0135332, -0.0133071, -0.0356379, -0.149579, -0.156577, -0.0269035, -0.0502516, 0.0854708, 0.426112, 0.121682, 0.207633, 0.337085, 0.254519, 0.088379, -0.145372, -0.0365342, -0.0712134, -0.562949, -0.159146, -0.0451507, -0.196763, -0.167656, -0.235623, -0.247364, -0.165399, -0.0919937, -0.0394599, -0.0966567, -0.100954, -0.515111, -0.261436, -0.289575, -0.664194, -0.41632, -0.427556, -0.405601, -0.368276, -0.435362, -0.246298, -0.0731921, -0.152688, -0.0931231, -0.208144, -0.0538301, -0.173063, -0.385697, -0.352821, -0.105262, 0.035863, 0.121991, -0.101236, -0.113153, -0.0549107, -0.0468086, -0.0766588, 0.387738, 0.145159, 0.150482, 0.140767, 0.0117205, 0.136792, 0.128625, 0.272055, 0.0177442, -0.0658998, -0.000707869, 0.0471457, 0.102507, 0.29935, 0.185324, -0.015703, 0.188745, 0.257379, 0.127135, 0.0565289, 0.0595272, 0.453549, 0.260275, 0.0750885, -0.0871874, 0.105565, 0.349849, 0.16155, -0.341523, -0.26555, -0.212525, -0.298958, -0.198996, 0.097786, -0.226846, -0.185865, -0.0588341, 0.0646201, 0.0364061, -0.126329, -0.0523739, -0.036693, -0.338935, -0.472318, -0.200635, -0.148721, -0.0899674, -0.212402, 0.0469716, -0.0370761, 0.139909, 0.0311567, -0.0480867, -0.0456874, -0.176115, -0.363941, -0.386179, -0.270302, -0.394901, -0.116029, -0.20684, -0.0390319, 0.0831996, -0.0222135, 0.0641516, 0.0645527, -0.0137039, -0.00343309, -0.144114, -0.381583, 0.000263857, 0.0101394, 0.0943726, -0.088121, 0.0297, -0.041052, 0.0717156, -0.0905923, -0.00111701, -0.0587728, -0.133684, -0.104809, -0.0724099, 0.0148638, 0.062436, 0.0472275, -0.0742667, -0.0932167, -0.0844994, -0.0644037, 0.0187371, -0.0161646, -0.123895, 0.136736, 0.107367, 0.196063, 0.131488, 0.265828, 0.115686, 0.0377519, 0.0788096, -0.0514031, 0.0403928, 0.0485736, -0.0861858, -0.0836928, 0.289496, -0.00806366, 0.131755, -0.000302359, 0.215578, 0.0279786, 0.235997, -0.0548953, -0.0481807, -0.0663151, -0.0362805, -0.116338, -0.00795884, 0.12593, 0.0364204, -0.120836, -0.0100403, 0.032763, 0.347331, 0.175683, 0.196055, -0.0504139, -0.040234, -0.104197, -0.0609932, -0.165384, 0.083742, -0.0586808, -0.153787, 0.0186933, -0.119503, -0.142926, 0.121548, 0.0181577, -0.0771177, 0.0760398, -0.0365568, -0.194486, -0.202373, -0.186211, -0.146444, -0.142287, 0.184408, 0.134396, 0.0222684, -0.0937258, 0.0207916, -0.069686, 0.0271191, 0.0284792, -0.139681, -0.176891, -0.0272117, 0.0336481, 0.305202, 0.170499, 0.136985, 0.327962, 0.0299734, 0.0223188, 0.0634137, 0.100691, 0.0244945, 0.212632, 0.0633046, 0.216066, -0.040499, 0.160831, 0.362996, 0.0926128, 0.103762, -0.136986, 0.229556, -0.0662179, -0.0817383, 0.0965261, 0.412509, 0.315017, 0.110907, 0.0592203, 0.153494, 0.169331, -0.0254134, 0.0913169, -0.0380226, 0.102957, 0.0163866, 0.0883431, 0.0186941, 0.0573021, -0.00440925, 0.125555, 0.462297, 0.324377, 0.0846324, 0.246922, -0.0416275, 0.111849, -0.0859098, -0.0879542, 0.00713733, 0.0806971, 0.0595421, 0.214932, 0.15034, 0.174556, 0.0763714, 0.0364719, -0.285744, -0.191976, -0.12193, -0.162212, -0.00244006, 0.0613462, 0.123686, 0.0260295, -0.105369, -0.098404, 0.0202969, -0.159122, -0.128758, -0.153781, -0.117854, -0.114642, 0.00780215, 0.00529247, -0.0953187, -0.051305, 0.020287, 0.140838, 0.0481806, 0.0238753, -0.0899579, -0.156003, -0.118977, -0.14257, -0.0906569, 0.0118009, 0.0707367, -0.0404192, -0.106421, 0.0826242, -0.0116736, -0.1188, -0.0375934, -0.109245, 0.0703458, 0.0771768, -0.0944966, 0.0111072, 0.0783783, 0.0855781, -0.0363361, 0.067838, 0.115673, 0.0313173, 0.278297, 0.282785, 0.0573883, 0.0372664, -0.218534, -0.200802, -0.0293513, -0.112714, 0.0104038, 0.0260152, 0.138589, 0.334598, 0.400361, 0.367873, 0.312948, 0.138356, -0.324981, -0.0561557, -0.368332, -0.228835, -0.0772758, -0.102468, 0.0132038, 0.0833838, 0.357325, 0.093278, 0.472617, 0.361095, 0.171405, 0.122307, -0.0775861, -0.0924708, 0.0110531, -0.228594, -0.0832309, 0.0621804, 0.120155, 0.382277, 0.357781, 0.450886, 0.345068, 0.168624, 0.212724, 0.076283, 0.0709085, -0.130216, -0.259667, 0.0511368, -0.149769, 0.203792, 0.384231, 0.360604, 0.256305, 0.453732, 0.396833, 0.326461, 0.424323, -0.0316878, 0.0371149, -0.0610128, -0.0857994, -0.0296558, 0.119529, 0.472629, 0.217404, 0.0187894, 0.484831, 0.2358, 0.296779, -0.0843579, -0.148372, 0.0915674, -0.151934, -0.157089, -0.00426236, -0.148221, -0.0652353, 0.333074, 0.172845, 0.270524, 0.129697, 0.132256, 0.084754, -0.273631, -0.163175, -0.277418, -0.0284762, 0.147125, -0.0129209, -0.0380627, 0.329204, 0.0974336, 0.295964, 0.206419, 0.187148, -0.0549611, -0.199074, -0.40549, -0.321228, -0.0352529, 0.0227135, 0.120507, 0.0100943, 0.167291, 0.243274, 0.500734, 0.48899, 0.484349, -0.0610809, -0.107442, -0.294701, -0.207415, 0.00515318, 0.0640177, -0.000609287, 0.447856, 0.0773714, 0.275568, 0.356643, 0.448083, 0.181117, 0.036131, -0.206269, -0.197019, -0.038545, -0.0483965, 0.109421, 0.132531, 0.206782, 0.267277, 0.136763, 0.49082, 0.274264, 0.265698, 0.248745, -0.385769, 0.0449504, -0.0960184, -0.0510499, -0.0419935, 0.165348, 0.296586, 0.298769, 0.0705974, 0.206708, 0.0905167, 0.0423558, -0.0854521, -0.124442, -0.0877871, -0.100215, 0.00357182, -0.0217669, 0.0477318, -0.0815528, -0.0527528, 0.0373031, 0.103056, -0.0209273, -0.0302289, 0.00424109, 0.0852237, 0.00975817, -0.0182969, 0.00562312, -0.00621262, -0.0262771, -0.0771384, 0.0701447, -0.135639, 0.0776139, 0.0603984, 0.285216, 0.0383, 0.0160854, -0.169432, -0.107214, 0.077899, -0.158917, -0.213261, 0.0192446, 0.145403, 0.324003, -0.140548, 0.136047, -0.109697, 0.228487, -0.152742, -0.05175, 0.0072778, 0.109756, -0.0344653, 0.0405959, -0.007241, 0.101033, 0.179037, -0.254332, -0.306361, -0.16129, 0.0506755, -0.0314751, 0.336062, 0.0111159, -0.231066, -0.0911667, 0.0236371, 0.236761, 0.166552, 0.0544272, 0.175085, -0.188027, -0.107986, -0.0437359, 0.212402, -0.101284, -0.0552412, 0.0191948, 0.0823041, 0.0592209, 0.196417, 0.180951, -0.042802, -0.0306536, 0.0492586, 0.162353, 0.283818, 0.167858, 0.0823981, -0.267846, 0.00688628, 0.0924989, 0.0469467, 0.0871215, 0.336192, 0.189929, 0.300638, -0.311005, -0.0606967, -0.0193365, 0.193842, -0.183206, 0.171425, 0.199698, -0.0533483, -0.0229309, 0.372358, 0.342569, 0.52746, 0.359221, 0.154376, -0.34982, 0.0380465, -0.112028, 0.233852, 0.0624729, 0.269889, -0.0982556, -0.00931152, 0.382758, 0.225841, 0.0458642, 0.174378, 0.190871, 0.11679, -0.338721, -0.0653531, 0.157428, -0.478635, -0.0364671, -0.0259534, -0.168318, 0.0248581, 0.379678, 0.0941117, 0.348123, -0.0850824, 0.0787499, -0.125679, -0.0948141, -0.18272, -0.166555, -0.113158, 0.108224, -0.120739, -0.098457, 0.191493, 0.153535, 0.333682, -0.043528, -0.093457, -0.0645108, 0.0275629, 0.0850028, -0.0464718, 0.0866822, -0.0112814, -0.17202, -0.036608, -0.174447, 0.0128587, -0.063541, -0.106014, -0.168548, -0.0427944, -0.203014, -0.103134, 0.126874, 0.0388357, -0.0910417, -0.0133606, 0.000798057, 0.03432, -0.0177573, 0.0430275, -0.346415, -0.290851, -0.173523, -0.0099738, -0.145237, 0.0831045, -0.0776992, 0.055913, -0.0264375, -0.113245, 0.0315806, -0.0900919, -0.158671, -0.0115973, 0.0950845, -0.000661938, -0.0813942, 0.0583591, 0.00726389, -0.0119999, -0.0230585, 0.0480938, 0.0388016, 0.00806918, -0.31381, -0.251115, -0.206101, -0.093747, -0.011488, 0.232718, 0.184348, 0.0527013, 0.0520628, -0.0173683, -0.0362706, -0.0656048, -0.0559222, -0.251523, -0.389721, -0.203145, -0.0734374, 0.197815, 0.149462, 0.170369, 0.110938, 0.0502708, 0.0814224, 0.0251259, 0.10156, 0.0561992, -0.241338, -0.536145, -0.503875, -0.357114, 0.114805, 0.112194, 0.0594673, 0.182431, 0.0714274, 0.00353141, -0.105543, 0.0906476, 0.0803618, 0.0530218, -0.033242, -0.570351, -0.337483, -0.111273, -0.272965, 0.352976, 0.229404, 0.193744, 0.172225, 0.0386849, 0.180517, 0.196279, -0.0347557, 0.109126, -0.280586, -0.271819, -0.160209, -0.0102528, 0.164318, 0.176347, 0.236053, 0.00577883, 0.00731626, 0.18624, 0.0123237, 0.423542, 0.238717, -0.255933, -0.588565, -0.177175, -0.156838, 0.208552, 0.357667, 0.0709769, -0.0498926, 0.122809, 0.0627368, 0.407898, 0.410255, 0.0832591, -0.371825, -0.153944, -0.124786, -0.107129, -0.171614, -0.250984, -0.0200599, -0.0179576, -0.100991, 0.0698954, 0.0792984, 0.296005, 0.207394, -0.0027656, -0.196109, 0.0149377, -0.148652, -0.0482962, 0.204915, -0.111614, 0.0302483, -0.106427, 0.149138, -0.0390042, 0.263511, 0.187995, -0.372747, -0.139357, 0.0841224, -0.0361544, -0.00316509, -0.11617, 0.0915523, 0.0162218, -0.170403, -0.176995, 0.0283359, -0.205769, 0.0174497, -0.0994407, -0.196362, -0.0977706, 0.116095, 0.14335, -0.0986265, 0.160396, -0.00796158, -0.138046, -0.195732, -0.282427, -0.475937, -0.350311, 0.183193, -0.0909088, 0.00376687, -0.146998, 0.0328592, 0.163755, -0.0320882, 0.0485632, -0.00479822, -0.0439841, -0.176245, -0.176699, -0.327005, -0.252521, -0.159909, -0.163905, -0.0567971, 0.0377828, 0.0649315, -0.065456}, {-0.0434438, -0.0391887, -0.212261, -0.179657, 0.198346, -0.145975, -0.111673, -0.122784, -0.0167971, -0.00275804, 0.0386521, 5.16636e-05, 0.0240861, 0.0468099, 0.186981, -0.0528585, 0.0138933, 0.0184311, -0.124107, 0.304293, 0.546405, 0.105736, 0.310925, 0.0513204, -0.126753, -0.0204929, -0.00480281, 0.111979, -0.115972, 0.188293, 0.427218, 0.436168, 0.465782, 0.684409, 0.639071, 0.499263, 0.497085, 0.228488, -0.156796, 0.0941431, 0.0245424, 0.235798, 0.307874, 0.394245, 0.299046, 0.477586, 0.637269, 0.607443, 0.684004, 0.577153, 0.245272, 0.062534, 0.0476832, -0.0128579, 0.202229, 0.371801, 0.323953, 0.300518, 0.394171, 0.429388, 0.449861, 0.692717, 0.287397, 0.0147479, -0.0380514, -0.124523, 0.180365, -0.16782, 0.134816, 0.14562, 0.294526, 0.390821, 0.249097, 0.119868, 0.2324, 0.278696, -0.0648055, 0.0952847, 0.112022, -0.356365, -0.415635, 0.0915667, 0.0279523, -0.416101, -0.266255, -0.0277848, 0.123455, 0.188715, 0.284098, 0.021943, -0.0656256, -0.114983, -0.0489918, -0.0463793, -0.0836475, -0.279999, -0.400923, -0.284882, 0.133431, -0.0788964, 0.427475, -0.0158913, -0.0645637, 0.0658897, -0.0977623, 0.0367782, 0.0991481, 0.141955, 0.132764, -0.121554, -0.130157, -0.00743946, 0.203811, -0.244866, -0.0787886, 0.0423601, -0.106852, 0.0185959, 0.0372457, 0.264226, 0.0911752, -0.0519623, -0.0891386, 0.256811, 0.218619, -0.13319, -0.0224931, -0.0722428, 0.0252095, -0.102719, 0.040431, -0.104939, 0.144342, 0.304705, 0.431513, 0.49146, 0.378164, 0.35281, 0.121643, 0.331184, -0.0163507, -0.0231538, 0.080781, -0.0439746, 0.341801, -0.0651303, 0.0873902, 0.143559, 0.154136, 0.354746, 0.384887, 0.168166, 0.0692603, 0.101001, -0.0776173, -0.0107389, 0.0339998, 0.0776093, 0.0418576, 0.0829452, 0.229525, 0.153391, 0.0234512, 0.00398464, -0.0229151, -0.197127, -0.0773107, -0.0672432, 0.067446, 0.0797917, 0.0588999, 0.0442324, -0.0253548, -0.0553742, -0.0216189, -0.114275, -0.170349, -0.0239687, -0.0763012, 0.0717111, 0.045293, 0.087523, 0.0411629, 0.123474, 0.0438057, -0.046173, -0.150382, -0.0337063, 0.010059, -0.151892, 0.0390122, -0.0684744, -0.0206328, -0.043605, -0.0723886, 0.0414584, 0.11851, -0.0878103, 0.112154, -0.0556984, 0.0434991, -0.0383352, -0.0263641, 0.0749794, -0.132272, -0.0639924, -0.0509624, 0.0742199, 0.10447, -0.0708314, -0.139245, 0.0756711, -0.0471557, 0.0114636, 0.0167556, 0.119674, -0.188121, -0.110604, -0.257255, 0.131179, -0.00504561, -0.0617074, 0.138775, 0.259539, 0.0279799, -0.0431112, 0.0871388, -0.354181, -0.106325, -0.075296, -0.126258, 0.320944, -0.0264523, 0.012464, 0.0364438, 0.112769, 0.122934, 0.303214, -0.0598383, -0.213609, -0.207215, 0.112731, -0.00810223, 0.0937451, -0.1264, -0.0596965, -0.0258107, -0.00950684, 0.0694486, 0.266014, 0.270686, -0.0470073, -0.150523, 0.0764005, 0.183359, 0.316892, 0.103259, -0.014644, -0.0111558, 0.0341698, -0.004205, 0.0196824, 0.033242, 0.00467806, 0.0701085, -0.219185, 0.0310715, 0.0634801, 0.378836, -0.15479, -0.29541, -0.0386817, 0.017469, -0.0332976, -0.0682818, -0.0313235, 0.233617, -0.00554766, 0.0565795, 0.0885671, 0.0244643, 0.328275, -0.105458, 0.0409314, -0.0944202, -0.0915657, -0.0742418, 0.0829172, 0.000601868, 0.0801852, 0.229375, 0.153172, 0.0648707, 0.0020292, -0.0985465, -0.0694505, -0.0745276, -0.112258, 0.0480745, -0.0346993, -0.00857266, -0.128348, 0.086775, 0.241752, -0.0197343, -0.0493865, 0.0238569, -0.0422921, -0.107707, -0.0949259, -0.118125, 0.062908, 0.0784471, 0.0955916, 0.0238329, 0.0323293, 0.0383248, 0.0454575, 0.0158757, 0.0146542, -0.00896502, -0.067706, -0.0603298, 0.0454803, 0.0759051, 0.0995378, 0.0116115, 0.0155703, -0.0492995, 0.0604196, 0.0464248, 0.0663015, -0.171542, -0.102315, -0.099997, -0.0971018, 0.00683966, -0.0960296, 0.0981143, -0.0582356, -0.0142274, 0.0264777, -0.0434788, -0.136022, -0.0406038, -0.0121691, -0.0297892, 0.0545599, -0.0779341, 0.0679512, 0.0751802, -0.065411, 0.0677196, 0.0826227, -0.125013, -0.204181, -0.138182, -0.0581561, -0.0294671, -0.123502, 0.102127, 0.0380914, 0.0635404, 0.0560779, -0.0405627, -0.11045, -0.0682754, -0.0267819, -0.526587, -0.192799, -0.328268, -0.126082, -0.126788, -0.00232031, -0.0354149, -0.0953052, 0.0132104, -0.017546, -0.00736467, 0.0348029, -0.0600129, -0.155709, -0.173965, -0.0880154, -0.0184333, -0.0856844, -0.114456, -0.0777173, -0.165174, -0.0209241, -0.0543829, 0.111943, -0.0637679, -0.434893, -0.366258, -0.294229, -0.13414, -0.286024, -0.0997443, -0.069902, -0.0739571, 0.201847, 0.00326122, -0.0336923, 0.0254807, 0.135025, 0.393406, 0.227581, -0.0733467, 0.0545726, -0.203893, -0.302935, -0.279075, -0.228344, -0.0962204, 0.0808186, -0.0721155, -0.0402622, 0.429057, 0.195915, -0.0965771, -0.171594, -0.0890894, 0.116767, 0.114256, -0.093178, 0.045727, -0.0406593, 0.0920759, -0.0926315, 0.074313, 0.0366126, -0.028898, -0.0932396, -0.136795, 0.0600904, 0.13816, 0.181547, -0.263594, 0.0423624, 0.00503926, 0.01062, 0.00889648, 0.0227233, 0.191214, 0.0848655, 0.211847, 0.0462998, -0.0844613, -0.0635146, -0.00308228, 0.153441, -0.0223862, -0.0999928, -0.00201183, -0.0728852, -0.0865508, 0.118667, 0.248302, 0.0368134, -0.0440319, 0.219916, 0.0554216, -0.0133035, -0.00947625, 0.0975087, -0.183561, 0.00317492, -0.0481184, -0.046627, -0.118528, -0.050808, 0.130583, -0.322413, -0.175199, 0.0677089, -0.483793, -0.42531, -0.249656, -0.114926, -0.0483033, -0.0920568, 0.0422694, 0.130436, -0.141319, -0.147272, -0.200236, -0.391339, -0.294135, -0.53143, -0.195487, -0.0779284, -0.0964763, -0.0932542, -0.0287782, 0.0883348, -0.0531848, -0.0335671, 0.0476063, 0.00804149, 0.0839981, -0.210553, -0.24488, -0.00738434, -0.0529936, 0.0944711, 0.0955375, -0.0358579, 0.0432739, -0.122268, -0.0438195, 0.0186107, -0.195386, -0.139212, 0.0311881, 0.0439967, -0.0831828, -0.0966231, 0.00940131, -0.012347, 0.0678376, 0.0196898, -0.0824706, -0.197127, 0.216718, 0.122937, 0.0952335, -0.137659, -0.134601, 0.0471544, 0.00111767, -0.088575, 0.00456027, -0.0145784, 0.172267, -0.0400752, 0.218445, 0.212543, 0.425385, 0.110145, -0.468571, -0.210014, 0.0569757, 0.0155335, -0.00257375, -0.0230198, 0.015278, 0.203434, 0.254585, 0.410561, 0.20582, 0.0623526, -0.0393407, -0.0795797, -0.0884379, -0.379444, -0.246961, -0.0396123, 0.0846829, 0.0924302, 0.00977528, 0.198737, 0.14618, -0.0828239, 0.0992129, 0.317941, 0.0559534, 0.0741507, -0.257636, -0.100786, -0.00641797, -0.0210679, -0.0672603, 0.229066, 0.350966, -0.273954, -0.065108, 0.102607, -0.389039, -0.237482, -0.178995, -0.0248619, -0.0129201, -0.107764, 0.0675711, 0.0124765, -0.0761827, 0.048242, -0.202197, -0.0242933, 0.294219, 0.425575, -0.353518, -0.331445, 0.0633633, -0.167333, 0.0902642, 0.08569, 0.0522087, 0.294763, -0.00707255, -0.129727, 0.0851262, 0.2824, -0.0180027, -0.10334, -0.174358, 0.0126473, -0.155329, 0.00436266, 0.0411163, -0.129119, -0.187594, -0.0926677, 0.0383571, 0.101202, 0.0967122, -0.188997, -0.214444, -0.0526322, -0.145616, -0.114471, 0.133596, 0.115977, -0.150307, -0.0977134, -0.0928466, -0.137389, 0.0057754, 0.287435, 0.14823, 0.0664121, 0.405957, -0.0203171, -0.0708227, 0.000848092, -0.0021874, 0.061431, -0.119809, -0.0581666, 0.00971414, 0.0032509, 0.150817, 0.420219, 0.228044, 0.608, 0.520947, 0.421849, 0.0649546, -0.00535085, -0.0482658, 0.0470129, -0.0255944, -0.121784, 0.073879, 0.0330891, -0.0305345, 0.273899, 0.277544, 0.237463, 0.27146, -0.0868252, -0.0193919, 0.0573196, 0.173643, -0.0572039, -0.0157039, -0.0266416, -0.214397, -0.167023, -0.190871, -0.0573273, -0.137508, -0.0679135, -0.0261642, 0.0624411, -0.0292682, -0.0450134, 0.00341691, 0.0881527, 0.0559636, 0.0656579, 0.00340496, -0.102654, 0.0590616, -0.0476038, -0.105663, 0.0541345, 0.0485954, -0.00117612, -0.029737, 0.0305106, 0.0992404, 0.088632, 0.00400935, -0.0550936, -0.0394822, -0.13657, -0.0898946, -0.0234796, 0.0501509, 0.0596011, -0.0169494, 0.10822, -0.0808773, 0.178513, -0.261044, -0.126742, -0.299268, -0.515174, -0.244364, -0.0529875, -0.202549, -0.0648262, 0.0396167, 0.00690624, 0.0258018, 0.0848955, 0.0640904, 0.123563, -0.184222, 0.0608948, 0.0241586, -0.439988, -0.0895271, -0.36531, -0.0796071, 0.0786903, -0.0246987, 0.177156, -0.114869, 0.0241541, 0.0556008, -0.300952, -0.0714323, -0.0776656, -0.116179, 0.0189649, -0.0611423, 0.0393543, 0.0657585, 0.0353916, 0.180725, 0.30176, 0.00954305, 0.180377, -0.0168958, -0.00692341, 0.0720543, 0.0573174, -0.0615175, -0.0356741, -0.137685, -0.0972498, 0.0506197, 0.0651912, 0.0488649, -0.220649, -0.21542, 0.120005, -0.0483726, -0.14852, -0.165321, -0.145314, -0.0442087, 0.0456156, -0.0571454, 0.0179564, 0.0832712, 0.285893, 0.0966089, -0.0352409, 0.0890885, 0.0338464, -0.0349472, -0.0995329, -0.0957499, -0.0623784, -0.015868, 0.0509876, -0.0245917, -0.0323599, -0.197277, -0.0157446, 0.0366975, -0.196501, -0.106173, -0.0468353, -0.265687, -0.102073, 0.0885796, -0.130818, 0.0563792, -0.0601577, 0.0640385, -0.0725437, -0.0698001, 0.234246, -0.0588568, -0.162877, 0.0131255, -0.0533174, 0.105146, 0.0747178, 0.0737377, 0.0471907, 0.0624766, 0.0756427, 0.0340548, -0.131379, -0.133502, 0.185105, -0.137797, -0.139068, 0.244105, -0.00218296, 0.10254, -0.0581786, -0.0632651, 0.0397154, 0.0829545, 0.0503816, -0.0508296, -0.205584, -0.12765, -0.0258752, -0.202421, 0.0474135, -0.0548386, -0.0937566, 0.023165, -0.0171093, 0.0057199, -0.0811279, 0.0196991, 0.0711202, 0.0310072, -0.0145897, -0.00683946, -0.0232493, -0.169656, -0.00976438, 0.077692, 0.0980789, -0.0922247, -0.00873994, 0.0928318, -0.080985, -0.00846219, -0.0812292, 0.0862416, -0.0480753, 0.0362201, -0.0781522, -0.201758, -0.0772797, 0.0729705, 0.0556446, -0.100142, 0.00100122, 0.0130455, -0.0571101, -0.0676646, -0.124173, -0.164312, -0.282287, -0.0205929, -0.0985092, 0.0780392, 0.0513208, 0.0373256, -0.0255793, -0.0647842, 0.013439, 0.00462377, -0.374303, -0.401266, -0.335921, -0.186066, -0.568065, -0.224892, -0.019626, -0.107551, 0.0868818, 0.0686354, 0.107672, -0.0720875, -0.173932, -0.457543, -0.393599, -0.587579, -0.520461, -0.64546, -0.351237, -0.110211, 0.193158, -0.0324775, 0.0138862, -0.0385862, -0.0478377, -0.0368877, -0.215636, -0.381994, -0.405019, -0.517508, -0.580473, -0.246268, -0.0394259, -0.139619, 0.328351, 0.176892, 0.168475, -0.110111, 0.182981, -0.176399, -0.224514, -0.130105, -0.311717, -0.218448, -0.0783923, -0.322744, -0.141261, 0.123449, -0.0678681, -0.0793497, -0.07165, 0.261354, 0.0546452, -0.115324, -0.132635, -0.12888, 0.244823, 0.0316376, -0.00941851, 0.135311, -0.0421357, 0.0811086, -0.14151, -0.0159459, 0.23645, 0.139212, 0.080587, 0.272857, -0.134406, 0.107961, 0.0162734, 0.125758, 0.056715, -0.0559769, 0.0788212, -0.0575377, 0.114031, 0.187165, 0.254592, 0.0387711, 0.105286, 0.109547, -9.63134e-05, 0.261296, 0.0192522, 0.150447, 0.241006, 0.0396789, 0.202134, 0.239943, 0.350874, 0.0545643, -0.219008, -0.0470089, -0.155292, -0.0344271, -0.044958, 0.241884, 0.269506, -0.0525183, -0.090182, 0.0311363, 0.00485846, 0.132104, -0.0562115, -0.487196, -0.465611, -0.299216, -0.186642, 0.00123323, -0.129035, 0.0623404, -0.0673296, 0.0853394, -0.0673884, -0.0854185, -0.0391016, -0.146468, -0.0347868, -0.578664, -0.181449, -0.250095, -0.238959, 0.220307, -0.063203, -0.106377, -0.0563222, 0.24005, 0.179024, 0.055686, -0.0490317, -0.284576, -0.123853, -0.116268, 0.0202002, 0.127746, 0.160385, -0.0995981, -0.048674, 0.00744419, -0.00426319, 0.237091, 0.197316, 0.10456, 0.138436, 0.209664, 0.200982, 0.105942, 0.191004, 0.168013, 0.0228833, 0.0900302, 0.10754, 0.0213, 0.107111, 0.218892, 0.136721, -0.101975, -0.253216, -0.102756, -0.0999061, -0.0954112, 0.00192108, 0.0465724, 0.122451, 0.0391311, -0.103263, -0.17594, -0.077307, -0.212694, 0.0876618, -0.41112, -0.252254, -0.0199364, -0.0975665, -0.170677, -0.215768, -0.1642, -0.0113189, -0.11019, -0.0270809, -0.25805, -0.295503, -0.253534, -0.154898, -0.425589, -0.437011, -0.0765104, -0.261927, -0.0968683, -0.140644, -0.121461, 0.181642, 0.0344359, -0.351643, -0.433877, -0.443567, -0.308012, -0.208632, -0.381944, 0.0154462, 0.0559695, -0.0198122, -0.0917006, -0.0287035, -0.0311084, 0.0457719, -0.133459, -0.31865, 0.0072629, 0.156633, -0.0642855, -0.477906, -0.177225, -0.154466, 0.144824, 0.128122, 0.0265912, 0.155058, -0.168963, -0.3705, 0.119964, 0.138473, 0.362195, 0.210998, -0.303221, -0.30877, 0.250676, 0.216685, 0.134068, 0.0633963, -0.138845, 0.186999, 0.142975, -0.162808, -0.0452749, -0.00456445, 0.23983, -0.129019, -0.0464047, 0.01797, -0.201406, 0.0232018, 0.0309206, 0.144807, 0.121058, 0.0199029, 0.211725, 0.11548, 0.0171355, -0.000774121, 0.197526, -0.0607101, -0.0683949, 0.0789877, 0.0735163, 0.0952682, 0.0866788, 0.0497773, 0.159657, 0.165012, -0.0703551, -0.0524731, -0.189562, 0.246818, 0.178154, 0.0484795, 0.00488442, -0.015424, -0.0775233, 0.0288963, 0.0667558, -0.117648, -0.277817, -0.34356, -0.260582, -0.172711, -0.0930937, 0.188039, 0.240337, 0.0187814, 0.121217, 0.00446599, 0.101025, 0.0858148, -0.0586673, -0.0686768, -0.0694699, -0.0636092, -0.240347, -0.111715, 0.0418888, -0.165819, -0.0653323, 0.0839431, -0.0777802, -0.00749545, -0.132741, 0.0120999, 0.0439914, 0.149211, 0.176032, 0.300975, 0.0210287, 0.142968, 0.0511757, 0.0649738, -0.0109677, -0.0271291, -0.00225885, -0.0539463, 0.0509307, 0.175867, 0.00752189, 0.179734, 0.146705, 0.0978223, 0.160088, -0.0937538, -0.0636141, 0.00468398, -0.0503823, 0.00555325, -0.0183192, -0.0227565, 0.534011, 0.198173, 0.248108, 0.303762, 0.279884, 0.265794, -0.163028, 0.0126946, -0.0257509, 0.0526002, -0.0952612, 0.111186, -0.276894, 0.233027, 0.188495, 0.262667, 0.345059, 0.402785, 0.0949184, -0.0168033, -0.171758, -0.0251244, -0.156457, -0.0398848, 0.00188203, 0.120375, 0.29401, -0.0332755, 0.379134, 0.32363, 0.147967, 0.246649, -0.0486718, -0.375119, -0.079396, 0.0366231, 0.0642392, -0.154014, -0.129004, -0.129195, -0.160435, 0.00110197, -0.031096, 0.227116, 0.0668842, 0.230915, 0.2506, -0.0253535, 0.0313424, -0.134705, -0.0261459, -0.39523, -0.127888, -0.310556, -0.397369, 0.114822, -0.08368, 0.0474707, 0.104502, 0.195066, 0.107883, -0.0583854, -0.0872566, 0.243982, 0.000877021, -0.484414, -0.118346, -0.0678914, 0.111406, -0.428114, -0.240837, -0.198748, 0.0779047, 0.103698, -0.0914015, 0.162388, 0.0135621, -0.189017, -0.291623, 0.0758784, -0.193819, -0.320225, -0.0934764, -0.243378, -0.20127, -0.0359243, 0.010523, 0.0432477, 0.0618668, -0.115986, -0.00289025, -0.116661, -0.00727942, -0.258538, -0.254335, 0.0340948, -0.200295, -0.197398, 0.044778, 0.0525133, 0.0109825, -0.0708362, 0.101304, 0.0178073, -0.0283773, -0.0605212, 0.109252, -0.234564, -0.115649, -0.17595, -0.103202, 0.0438813, 0.114344, -0.0295888, 0.0146532, -0.0251516, 0.079445, 0.0173626, -0.0301346, 0.139707, -0.121407, -0.0152204, 0.0915336, -0.13322, 0.0826084, 0.0508506, -0.00139999, -0.0779433, -0.0670896, 0.0218339, 0.0201931, 0.258512, -0.0691058, 0.208952, 0.0285013, 0.291236, -0.216998, 0.00880313, 0.100964, 0.0573098, -0.180834, -0.117287, 0.0716075, -0.0198303, 0.32198, 0.219963, 0.0631564, 0.272726, 0.1576, 0.126609, 0.123701, -0.0064746}, {-0.0396693, 0.0711738, -0.0731143, 0.005453, -0.00225787, 0.164415, 0.131543, 0.166476, 0.0525006, -0.312825, -0.0869828, -0.0665103, 0.0892116, 0.0484726, 0.0828941, -0.207648, -0.0375537, -0.239755, -0.431816, -0.279179, 0.102081, 0.0461071, -0.169832, 0.244506, 0.0286419, -0.0183621, 0.016706, 0.231197, -0.121635, 0.0622522, 0.0571476, -0.0437117, 0.0903535, 0.035611, 0.0599086, -0.105511, -0.0403565, -0.1309, 0.0526735, -0.114864, -0.0638641, 0.121982, -0.164568, -0.239306, 0.0952478, -0.0936038, -0.274451, -0.364761, -0.211562, -0.021316, -0.0290058, -0.0375728, -0.169956, -0.0862223, -0.159712, -0.00840926, -0.201638, -0.123498, -0.14119, -0.487714, -0.344301, -0.408652, -0.305255, -0.0280669, -0.11404, -0.0863037, 0.038124, -0.245961, -0.18465, -0.172184, -0.00806352, -0.166274, -0.215904, -0.579895, -0.623449, -0.600703, -0.444038, -0.0539963, -0.0850653, 0.00745009, -0.229316, -0.259602, -0.141365, 0.000364663, -0.0605015, -0.137343, -0.293568, -0.313723, -0.179109, -0.149112, -0.0480045, -0.0507719, 0.00368216, -0.284501, -0.177096, -0.111218, -0.146178, 0.0643246, 0.0793312, -0.136017, -0.506592, 0.0498398, -0.0623254, 0.0135366, 0.00512085, -0.0240988, -0.307321, -0.539524, -0.181968, -0.157105, 0.0241876, 0.0918425, -0.0156877, -0.363814, -0.0682211, -0.124407, 0.0200242, -0.0453829, 0.0832768, -0.00228724, -0.143148, -0.296137, -0.173108, -0.251859, -0.177818, -0.0197778, -0.0283776, 0.137932, 0.0243844, 0.04961, 0.196165, -0.0264526, 0.0637615, -0.0713413, -0.0409814, 0.00399401, 0.128598, 0.191129, 0.339318, -0.160572, 0.27519, 0.00385605, 0.0330902, -0.0139628, 0.055696, -0.0465599, -0.218938, -0.439991, -0.340293, -0.0507254, -0.103927, 0.165162, -0.0183474, 0.0519455, 0.12185, -0.0551192, 0.112689, 0.07435, -0.0340824, -0.0975647, -0.0709872, -0.188678, -0.118891, -0.0455404, -0.0444459, 0.0330142, -0.000291888, 0.112108, 0.0831126, -0.0572883, -0.0945895, -0.0817662, -0.00534918, 0.0394251, -0.078296, -0.100237, 0.177252, 0.0249147, -0.109016, 0.0609784, -0.0446018, -0.0452996, -0.062228, -0.061274, 0.0616045, -0.0329117, -0.0131364, 0.0868233, -0.0140942, -0.0244779, 0.00745344, -0.131368, 0.00172998, 0.0338407, -0.078423, -0.0633124, 0.0944694, -0.0573137, 0.175785, -0.137927, 0.194217, -0.011221, -0.176634, 0.00421311, -0.201332, 0.0216741, 0.0997187, -0.0289841, -0.0874701, 0.00467049, 0.0632028, 0.0867316, -0.111258, 0.431406, -0.0868722, -0.193449, -0.115601, -0.489375, 0.0295448, -0.0123153, 0.10194, -0.069055, 0.0264584, 0.207487, 0.0240477, -0.0278961, -0.177645, 0.155305, 0.20809, -0.0566797, -0.529217, -0.0784351, 0.0506239, 0.0560164, -0.0900838, 0.0290344, 0.0296435, 0.013659, 0.241757, 0.117482, 0.0538482, 0.131078, 0.0857896, -0.067387, -0.103022, -0.0922218, -0.0940155, 0.0809511, 0.0869735, -0.0599303, 0.143452, -0.0368254, 0.310333, -0.0963503, -0.111175, 0.0239385, 0.021106, -0.0349284, -0.114923, -0.0694784, -0.123741, -0.078564, -0.0150978, -0.2681, 0.0804484, -0.0451245, 0.0887547, 0.0895188, 0.00861231, 0.0135338, -0.0961397, 0.0448303, 0.0319057, -0.00739214, 0.0517623, -0.0103374, 0.0584722, -0.00980406, -0.133313, -0.0430013, 0.201354, 0.215885, 0.123578, 0.0965609, 0.0100801, -0.0660422, 0.00533956, 0.0581159, 0.105405, -0.00821205, -0.0497238, 0.127077, -0.0409366, 0.0327143, 0.145876, 0.135667, 0.145458, 0.0265349, 0.0900778, -0.0108937, 0.090539, -0.109655, 0.0262743, 0.00739514, -0.00973724, -0.0881306, 0.0783214, -0.195757, 0.14134, -0.0538407, 0.134214, -0.0638427, 0.0285246, -0.0284153, 0.0536798, -0.0908947, -0.198888, -0.404383, 0.100333, 0.0709725, 0.248969, -0.0193627, 0.221763, 0.0525296, -0.026509, 0.0640337, 0.0276385, -0.00160321, -0.0925879, -0.0376294, -0.107977, 0.0470593, -0.118483, 0.0036945, 0.0193809, 0.103553, -0.0478473, -0.000805021, 0.0932896, -0.0781246, -0.0998658, -0.0984202, -0.0801456, 0.0551492, 0.0148282, -0.063687, -0.0132759, 0.013786, 0.0684073, -0.00534084, -0.0268111, 0.0459908, 0.036071, -0.0682275, 0.0369775, 0.140115, 0.316468, 0.253656, 0.267322, 0.10955, -0.217933, -0.00784225, 0.0193641, -0.0187264, 0.0973033, 0.0690173, -0.048184, 0.0676645, -0.188884, 0.2431, -0.068326, 0.136472, 0.0950415, -0.188233, 0.0698901, 0.015752, 0.011582, 0.0746128, -0.0833063, 0.00885752, 0.210206, -0.278126, 0.0273155, -0.109535, 0.208046, 0.210937, -0.0882559, -0.0891037, 0.0884245, 0.0759147, -0.00411114, -0.187663, -0.0221099, -0.30876, -0.0743545, -0.277056, -0.281905, -0.17657, 0.14596, -0.0596832, 0.0277572, 0.184924, 0.0817217, -0.114754, 0.0786487, 0.0763543, 0.0188557, 0.0201258, -0.186084, 0.00438781, 0.0457002, 0.22548, -0.124309, 0.0653073, 0.315274, 0.15774, 0.0874602, 0.069578, -0.08955, 0.160509, 0.0225722, 0.160051, -0.102183, -0.129473, -0.261419, -0.487019, -0.33252, -0.268993, -0.0928823, -0.103843, -0.0648701, -0.0690287, -0.0355282, -0.217222, -0.0262935, -0.0185214, 0.0999003, -0.213811, 0.0272762, -0.145029, -0.0462697, 0.0360137, 0.0444559, 0.046943, 0.121639, 0.121877, 0.260579, 0.0409351, 0.258753, -0.128305, -0.123459, -0.0105428, 0.157573, 0.0912422, 0.00197088, 0.0646345, 0.181476, -0.0638662, 0.289345, 0.110597, 0.0212661, 0.153409, 0.0717412, 0.0187339, 0.144471, -0.0897548, 0.0627908, -0.0422576, -0.08552, -0.00408039, 0.0695737, 0.15353, 0.0982632, 0.237087, 0.22369, 0.187015, 0.170257, 0.167579, 0.0504083, -0.0203087, -0.0950477, 0.00941006, 0.00690963, 0.0608099, -0.0478552, -0.303806, 0.141564, 0.194706, 0.1104, 0.137983, 0.172466, 0.0724779, 0.040153, 0.0654365, -0.0488073, -0.0792311, 0.0150201, -0.0664217, -0.0400355, 0.0709453, 0.256446, 0.128846, 0.175414, -0.142408, -0.0606679, 0.0405045, -0.0966273, 0.0161093, 0.0577889, 0.0785687, 0.0748012, -0.13762, -0.0848228, 0.0535333, 0.0061512, -0.0280193, -0.0191488, 0.0134757, -0.0704851, 0.0884064, 0.0744245, -0.0565738, -0.169084, 0.128789, -0.238718, -0.244846, 0.121823, 0.0175645, 0.07388, 0.0510298, 0.0744406, -0.0388374, 0.0520777, -0.116364, 0.113595, 0.0183437, 0.0702092, 0.235991, 0.142118, -0.164677, -0.228211, -0.550684, -0.563602, -0.182613, -0.141707, -0.0416243, 0.0464013, 0.0756121, 0.196708, 0.128525, 0.300788, 0.249826, 0.101537, -0.133962, -0.695271, -0.492726, -0.680788, -0.240936, 0.0410509, -0.122806, 0.000722387, 0.0309795, 0.541858, 0.295229, 0.0695918, -0.0839678, -0.0901863, -0.0875987, -0.401178, -0.529414, -0.478988, -0.0322416, -0.154379, 0.0564307, 0.247337, 0.318191, 0.391759, 0.105448, 0.176004, 0.294513, 0.157301, 0.0835973, 0.195038, 0.28265, 0.0375367, 0.0034508, -0.0532461, 0.031808, 0.0524617, 0.34967, 0.0306468, 0.0511461, 0.109929, 0.481096, 0.51149, 0.193751, 0.29049, 0.254654, -0.262849, 0.0906038, -0.149956, 0.373408, 0.235946, 0.165205, 0.257801, 0.190127, 0.175788, 0.513997, 0.268274, 0.0939815, 0.00420276, 0.0356191, -0.0974406, 0.00971404, 0.0736701, 0.0611529, -0.0215664, -0.109938, 0.100326, 0.171343, 0.223369, 0.0527651, -0.0249098, -0.0195553, 0.0564615, -0.0623602, -0.0698967, 0.139332, 0.102362, -0.199601, 0.179779, 0.154689, -0.181233, 0.0467835, -0.0575113, -0.00301775, -0.0669147, 0.0518047, -0.0315149, 0.0522835, 0.00430967, 0.0562067, -0.196558, -0.293062, -0.498728, -0.350181, -0.332831, -0.14919, 0.180271, 0.0428194, -0.110022, 0.0575916, -0.323945, -0.073418, -0.400228, -0.166131, -0.211543, -0.201259, -0.422579, -0.18475, -0.163411, -0.034669, 0.0499246, -0.088701, -0.0481142, 0.143936, -0.0258707, -0.0191281, 0.148108, -0.244602, -0.205604, 0.0783866, -0.232529, 0.114037, 0.000541007, 0.0448908, -0.033107, 0.0469719, -0.0268537, -0.0545218, -0.0839138, -0.0953317, -0.00992769, -0.0922542, -0.00868461, -0.0719841, 0.0127276, 0.0552429, 0.0533495, 0.0874437, 0.0598495, -0.0978495, -0.0674338, -0.040335, -0.202715, 0.006969, -0.119186, -0.138584, 0.0656398, 0.0159393, 0.0420674, -0.067743, -0.00510024, 0.0567351, -0.00435935, 0.0675029, -0.23399, -0.0752463, -0.176453, 0.0219457, -0.123077, -0.222159, -0.00259814, -0.0202452, 0.0690139, 0.0400252, -0.0755257, 0.256815, 0.00488119, -0.0650682, -0.0913057, -0.303928, -0.210178, -0.124445, -0.0209669, -0.247008, -0.324673, 0.0376876, -0.0789259, 0.0265441, 0.102439, 0.000756625, -0.115764, 0.179099, -0.0137798, 0.00890438, 0.103178, 0.0574421, -0.262633, -0.0461652, 0.0609108, -0.0739991, -0.0872638, -0.00130299, 0.0719961, -0.084584, -0.0290445, -0.13326, -0.0109124, 0.120872, -0.0350917, 0.128622, 0.203187, 0.0562595, -0.093247, -0.0543823, 0.0333827, 0.0604051, -0.125266, 0.0347396, -0.281168, 0.120358, 0.205979, 0.253006, 0.145039, -0.0801399, -0.0463658, -0.00708227, -0.0651061, -0.0187159, 0.0960942, 0.138479, 0.0938551, -0.0749987, 0.0564098, 0.288541, 0.0816995, 0.0431629, -0.0399536, -0.092379, -0.106276, 0.156528, 0.0250987, 0.139336, 0.290776, 0.158195, -0.0372359, 0.144856, 0.112149, 0.121336, 0.0873543, 0.0342792, 0.0824246, 0.0495243, -0.112893, 0.16018, 0.107997, 0.124976, -0.0372383, 0.060633, -0.0552213, -0.239764, -0.00776867, 0.0713466, 0.088548, 0.0459404, 0.0745599, 0.0408549, -0.0516141, -0.125638, 0.17974, -0.196853, 0.0750775, 0.25396, -0.0819898, 0.0355992, -0.122079, 0.0792394, 0.0110372, 0.0206606, 0.00911817, 0.0348293, -0.160754, -0.0637403, -0.0248012, -0.085871, -0.048554, -0.115788, 0.0341803, -0.0667868, -0.183567, -0.0272959, 0.0833018, -0.0481849, 0.066354, -0.0358563, 0.0525273, -0.0298225, 0.0507445, -0.000703761, 0.0454283, -0.0818142, 0.0886871, -0.0380234, -0.0786076, -0.0802309, 0.0596629, -0.106594, -0.0406392, 0.0444032, -0.0193575, 0.0262485, -0.051588, -0.0167528, 0.0216986, 0.0874819, -0.0691632, -0.047809, -0.0907651, -0.0112793, 0.0140968, 0.0245926, -0.21761, -0.213315, 0.00268195, 0.0222714, 0.320121, 0.210728, -0.0203632, -0.148816, -0.0115154, 0.00123929, -0.145267, -0.350113, -0.495705, -0.240827, 0.237362, 0.383762, 0.311469, 0.295076, 0.554806, 0.705217, 0.0293011, 0.0152585, -0.0943906, -0.208626, -0.491732, -0.333487, -0.0243813, 0.105182, 0.095449, 0.418838, 0.581728, 0.784208, 0.48927, 0.418391, 0.203457, 0.0292838, -0.228407, -0.460481, -0.490814, 0.286439, -0.0561125, 0.0682951, 0.375701, 0.497294, 1.00066, 0.507334, 0.56052, 0.0612709, -0.0771131, 0.00331949, -0.238865, -0.316438, 0.0884057, 0.0739505, 0.109655, 0.14025, 0.193706, 0.674747, 0.391634, 0.599659, 0.354344, 0.0189538, -0.0830973, 0.247843, 0.269709, 0.199513, 0.247968, 0.0703264, -0.117007, -0.0180562, 0.16218, 0.253806, 0.452271, 0.28238, -0.00527865, -0.00381668, 0.246119, 0.246103, 0.1461, 0.192517, 0.0628842, 0.239863, 0.0968661, -0.0615464, 0.0641658, -0.0460072, -0.203255, 0.0247246, -0.061441, 0.206365, 0.4459, 0.314656, 0.310579, 0.290533, 0.0105897, 0.272503, -0.148648, -0.332754, -0.475378, 0.0316066, -0.123291, -0.0594178, 0.228287, 0.244053, 0.218292, 0.293157, 0.202101, 0.0554777, 0.19402, -0.17062, -0.410283, -0.10165, 0.0364412, 0.0445917, -0.0549318, -0.0081811, 0.0690577, 0.360007, 0.274002, 0.0969812, 0.0742913, 0.0386043, -0.155302, -0.441618, -0.0570104, -0.00770094, -0.026128, -0.112574, -0.139838, 0.00648668, 0.461481, 0.229897, 0.177928, -0.257346, 0.200578, -0.171448, 0.0710506, -0.117715, 0.103594, -0.0281698, -0.0681658, 0.0597966, -0.0059291, 0.339489, 0.255365, -0.0266795, 0.105784, 0.0492191, 0.0231031, 0.344425, 0.0123755, -0.0692542, 0.0104368, 0.0215592, -0.0301563, -0.145063, -0.0474336, -0.020267, -0.182474, -0.178823, -0.249512, -0.110936, -0.0243776, -0.00955137, -0.0806107, -0.11017, 0.0233896, 0.0563973, -0.152934, 0.125878, 0.307454, -0.00444427, -0.0172857, 0.0568529, 0.0218493, 0.111177, -0.0290839, -0.0222676, -0.0344353, -0.0967757, -0.138886, -0.153592, -0.00151088, 0.44362, 0.169297, 0.30472, -0.236123, 0.176141, 0.110627, -0.301614, -0.0831379, -0.00986461, 0.0297056, -0.13133, -0.123233, 0.0025189, 0.136957, 0.197086, 0.442491, 0.298183, 0.210345, -0.0505622, 0.167389, 0.0433718, -0.0730824, -0.0385843, -0.0688808, -0.262299, -0.313877, -0.140982, 0.12053, 0.433241, 0.621311, 0.22788, 0.207053, 0.0515351, -0.290245, -0.105781, -0.115287, -0.0635562, 0.0384441, -0.378157, -0.0125791, -0.0484378, 0.740633, 0.531676, 0.430756, 0.43737, 0.288225, -0.230186, -0.0898891, -0.0721855, 0.229348, 0.236286, 0.295468, 0.132372, 0.156082, 0.177672, 0.303402, 0.110362, 0.367426, 0.166748, 0.222495, 0.0661246, 0.102494, -0.0157598, 0.431168, 0.401867, -0.0266392, 0.0846725, 0.315373, 0.197833, -0.0583711, 0.0295389, 0.0854731, 0.13073, -0.0183226, -0.14002, 0.0362661, 0.438808, 0.218463, 0.170079, 0.187537, 0.344416, 0.138062, 0.114825, 0.0955924, -0.0204539, -0.138266, -0.0401255, 0.0302437, 0.128974, 0.0656032, 0.336545, 0.0209277, 0.228691, 0.0833615, -0.114993, -0.0973371, -0.0181626, -0.235088, -0.22204, -0.0944716, 0.114535, -0.111529, 0.0184098, 0.174191, 0.117885, -0.159395, -0.286341, -0.232644, -0.393175, -0.144859, -0.0667103, -0.156289, -0.0316584, -0.200936, -0.0324472, -0.00535438, -0.00756476, -0.00493973, -0.017683, -0.11478, -0.198104, -0.23095, 0.00902136, -0.0960036, -0.0117292, 0.031661, -0.0267768, -0.00884032, 0.0236519, 0.105519, -0.290452, -0.193445, -0.138519, -0.129956, -0.242395, -0.0773168, -0.0287696, -0.0316515, 0.025353, -0.0872151, -0.0669104, 0.0744072, 0.0434692, 0.0145017, -0.06297, -0.000538305, 0.050535, 0.0873912, 0.135879, 0.0278357, -0.0853056, -0.129835, 0.00427915, 0.0679873, -0.0667342, 0.0875434, -0.0333467, -0.156313, -0.239842, -0.00175178, -0.114164, -0.190967, -0.278253, -0.103381, 0.0386839, -0.144031, 0.133032, 0.209524, 0.138272, -0.0659473, 0.065161, -0.178521, -0.047867, -0.0437852, -0.237255, 0.0852737, -0.160245, -0.0554913, 0.10655, 0.0862358, 0.215273, 0.0446054, 0.568779, 0.385807, -0.039807, -0.228709, -0.0758416, -0.41263, -0.346204, -0.354132, -0.071182, 0.00456032, 0.0154237, -0.0874778, -0.0984499, 0.0785465, 0.176556, 0.183746, -0.0982003, -0.254062, -0.0850513, -0.168632, -0.471077, 0.085612, 0.0760874, 0.076124, 0.0471484, 0.144277, 0.15096, 0.109724, 0.0638783, -0.0494765, 0.111781, 0.151974, 0.140272, -0.0420595, 0.081999, 0.12137, 0.160391, -0.0585413, 0.251515, 0.0853686, 0.0951831, 0.189671, 0.456891, 0.118946, 0.00812465, 0.17849, 0.0180597, 0.0949144, -0.130723, 0.164136, 0.163002, 0.0223559, 0.263816, -0.0600606, 0.143669, 0.307209, 0.240183, 0.00514359, 0.147597, -0.0397254, 0.0414511, 0.0488221, -0.179655, 0.0481434, 0.311156, 0.213789, 0.272426, 0.283879, 0.110762, 0.159401, -0.0594422, -0.0418242, -0.246515, 0.0371666, 0.0356757, -0.166895, -0.159916, 0.19109, 0.235093, -0.221094, 0.0382528, 0.0450673, -0.0795469, -0.111005, -0.111761, -0.0770526, -0.0782959, 0.0246661, -0.0288695, -0.0226619, 0.061182, -0.136668, -0.0502166, -0.151274, -0.167336, 0.0302634, -0.0743574, 0.0164605, -0.0431627, -0.0337055, -0.0277882, -0.00119592, -0.164186, -0.172505, -0.340481, -0.432969, -0.343718, -0.0712886, 0.227696, -0.181507, 0.0613586, -0.0305857, 0.0173642, -0.0202493, -0.112226, 0.00800059, -0.0211448, -0.420408, -0.216416, -0.135613, -0.0557508, -0.156401, -0.0147643, 0.012011, -0.0915876}, {0.0650128, 0.0590195, 0.142531, 0.372171, 0.00486308, 0.239411, 0.21334, 0.254316, 0.238273, 0.200059, 0.086595, 0.0185397, 0.0166616, -0.0405625, 0.188998, 0.251305, 0.182293, 0.290102, 0.512605, 0.460614, 0.232885, 0.105851, 0.422853, -0.061386, 0.117191, -0.0282228, 0.0399359, 0.307027, 0.0696319, 0.318096, 0.309947, 0.691795, 0.707905, 0.289245, 0.27937, 0.100726, 0.0171405, -0.0650168, -0.0128549, 0.0557087, 0.212969, 0.120714, 0.270728, 0.38938, 0.201063, 0.487339, 0.251445, 0.0461278, 0.13388, -0.0918521, -0.0685587, -0.0667383, 0.0584611, 0.0963905, 0.188663, 0.190524, 0.270223, 0.28587, 0.233916, 0.198354, 0.220457, -0.0975013, -0.1054, -0.107773, 0.0564696, -0.00828864, 0.126696, 0.048591, 0.286667, 0.217405, 0.0655338, 0.402845, 0.17478, -0.108547, -0.181806, -0.0694537, 0.0745453, 0.110159, 0.0572111, 0.205016, 0.355738, 0.19929, 0.264627, 0.29582, 0.0830108, -0.0502409, -0.243357, -0.20346, -0.0365154, 0.0232529, -0.0862717, 0.0240249, 0.218009, 0.00972183, 0.245094, 0.300642, 0.312241, -0.0828048, -0.020658, 0.0713571, -0.237814, -0.0558762, -0.0986706, 0.0551698, 0.00290652, -0.119052, 0.00894526, 0.0511376, -0.0458981, 0.0953142, -0.109154, -0.105491, -0.138778, -0.138948, -0.102126, -0.0701535, -0.0510082, -0.0595878, -0.245296, -0.00191298, 0.0586586, -0.0476538, -0.118661, -0.193426, -0.0811165, -0.181756, -0.265798, -0.100841, -0.0257396, 0.093614, -0.0309204, -0.087935, 0.117637, -0.0455529, -0.238488, -0.370661, -0.480242, -0.548803, -0.268907, 0.0604466, -0.21109, -0.0622345, -0.00977506, -0.0907595, 0.026816, 0.0682462, 0.059432, -0.309744, -0.191278, -0.395509, -0.218164, -0.169718, -0.139768, -0.0163184, -0.00191839, 0.0456564, 0.0242229, -0.0439103, 0.0064938, 0.000130222, -0.0661834, 0.0674199, -0.119313, -0.110592, -0.0569831, -0.0655313, 0.0982619, 0.0733079, 0.0905693, -0.0392489, 0.0679145, 0.0972181, 0.0236605, 0.057813, -0.143402, 0.0734741, 0.00561609, 0.0784533, 0.012598, 0.0161146, 0.0186564, 0.0453482, 0.0656708, 0.0412323, 0.024824, 0.0130023, 0.167952, 0.0260321, -0.0316525, 0.081898, -0.00403796, -0.0173178, 0.0316182, -0.0541462, -0.0239193, -0.0651672, 0.0644185, 0.0627181, 0.0417925, 0.239535, -0.228463, 0.21922, -0.0276319, 0.0311139, -0.127376, 0.106456, 0.169383, -0.0509772, 0.000683219, 0.0612886, 0.0826111, 0.170383, 0.104895, -0.170489, -0.0750889, -0.165851, -0.120635, 0.0724256, 0.0124411, -0.00903474, 0.0326956, -0.00366266, -0.014016, 0.0811302, 0.24136, -0.00766549, 0.181617, 0.0384568, -0.0392666, -0.0226064, 0.0486937, -0.0687043, -0.114546, 0.0150918, 0.059582, 0.0250413, 0.0315346, 0.09147, 0.236751, -0.0368887, -0.188937, -0.289399, -0.0330195, -0.113503, -0.0383471, 0.0873872, 0.0783474, 0.0263825, 0.0396836, -0.136779, -0.160173, 0.217188, 0.295764, 0.0791442, -0.2679, -0.088202, 0.106671, -0.106376, 0.04701, 0.0574129, -0.0525224, 0.0185374, 0.053204, 0.0999035, 0.0708801, -0.0704652, -0.166657, -0.0884949, 0.00710285, -0.0636037, 0.004849, -0.0192947, -0.00881454, -0.0973583, 0.0950351, 0.115164, 0.066715, -0.0767679, 0.142256, 0.0280871, -0.393406, -0.292442, -0.0724498, -0.234426, 0.133459, 0.0641656, 0.00561853, 0.0687139, -0.000790774, -0.185118, -0.211675, -0.14615, 0.138309, -0.127505, 0.0799918, -0.108917, -0.0393708, -0.057904, -0.0120455, -0.0677644, -0.0353775, -0.0435358, -0.230774, 0.109376, -0.0351457, -0.0777825, 0.200396, -0.0320164, 0.14921, 0.060701, -0.104534, -0.0232055, 0.034893, 0.0708923, 0.0499066, 0.0427502, -0.00757105, -0.116385, -0.1305, -0.136506, 0.0837633, 0.0318559, 0.000763574, -0.00792599, -0.0514444, -0.00443363, 0.0987558, -0.0645849, -0.0730076, -0.036317, 0.0235792, 0.0577465, 0.0151614, -0.104607, 0.00705602, -0.0677378, 0.0197214, 0.0323267, -0.029549, 0.0256787, -0.0112053, 0.106134, 0.0776039, 0.00643071, 0.0625442, 0.184053, -0.0785253, -0.0178956, -0.0285938, 0.0870018, 0.0800202, -0.00890128, 0.0942568, 0.0874702, 0.163679, 0.184537, 0.0163348, 0.204811, -0.000293772, 0.185645, 0.0455959, 0.0737328, -0.068872, -0.0746383, 0.0617588, -0.0132936, -0.00575319, 0.156663, -0.0844299, -0.162091, 0.176494, -0.0373439, 0.0963344, 0.093707, 0.0884802, 0.140704, 0.0523449, 0.0360999, -0.01031, -0.18476, -0.0175854, 0.0807537, -0.439095, -0.103322, 0.082158, 0.00555245, -0.0502806, 0.0655053, 0.095047, 0.117926, -0.0150955, -0.0409116, -0.0319299, 0.132777, -7.24481e-05, -0.210838, -0.161187, -0.00130591, 0.00263237, 0.114757, -0.0284119, -0.0597456, -0.120716, 0.0595246, 0.0176448, 0.0403155, -0.0453032, -0.0717911, 0.0338724, 0.00580893, 0.0518505, 0.0665365, 0.101159, -0.0151442, -0.073883, 0.0188071, -0.052153, 0.0783869, -0.0366558, 0.0428987, 0.25373, -0.14752, -0.294503, -0.0948311, 0.0463775, -0.12959, -0.102806, 0.0855952, 0.00427608, -0.0645393, 0.126736, 0.0735009, -0.168348, -0.0364387, -0.182917, -0.236835, 0.0315085, 0.0340492, -0.0306468, 0.144635, 0.0430495, 0.100434, -0.000596279, -0.0638342, 0.0569496, -0.0744794, -0.22926, 0.110961, -0.164853, 0.227115, -0.191437, -0.209899, 0.0444528, 0.105447, 0.142766, -0.0219699, -0.0597475, -0.0880767, -0.316405, -0.37572, -0.329281, -0.154211, 0.0592067, 0.0807269, -0.108194, -0.113482, 0.041027, 0.0340708, 0.0153186, 0.0696725, -0.0837538, -0.319602, -0.188883, -0.119914, -0.242386, 0.050717, -0.0466513, 0.333125, 0.0478769, -0.159871, 0.00679891, 0.0498303, 0.0945537, -0.0368421, 0.00215403, 0.0273426, -0.162607, 0.199552, 0.171031, 0.122661, 0.214558, -0.0703181, 0.055469, 0.0310503, 0.0841018, 0.0906644, -0.0566962, -0.0219841, -0.119595, 0.0869778, 0.00639085, 0.0590053, 0.0212096, 0.0327176, 0.0573179, -0.100209, 0.0644866, 0.00629802, 0.070046, 0.0155665, 0.0126712, 0.0855247, 0.0919104, 0.0953497, 0.0576263, 0.0199417, 0.131545, 0.100819, -0.0052774, 0.0490116, 0.0322845, 0.0664795, 0.159353, 0.412149, 0.12905, -0.00378458, -0.304402, -0.00622258, 0.162746, 0.00786571, 0.0055664, 0.0433722, 0.0907747, 0.0167899, 0.140346, 0.190591, 0.0809134, 0.193578, -0.197491, -0.463089, -0.151927, -0.109511, -0.380054, -0.0624188, 0.0835558, 0.0375261, 0.0751282, 0.0465931, 0.103976, 0.117505, -0.10419, -0.0677938, -0.259715, -0.380855, -0.224005, -0.103826, 0.104417, -0.0928247, -0.0635223, 0.0361882, 0.116662, 0.0750769, 0.119711, -0.0281597, -0.426304, -0.434379, -0.681666, -0.0850162, -0.129935, -0.104035, -0.042636, 0.055707, 0.123299, 0.119137, 0.207549, 0.280185, -0.321747, -0.458852, -0.2301, -0.0862125, -0.0132015, 0.155539, 0.0824654, 0.0171213, 0.0796674, -0.0788496, 0.23751, 0.130945, -0.08907, -0.131757, -0.10885, -0.0798935, 0.0302491, 0.103226, 0.378745, 0.317051, 0.286008, 0.056754, 0.0416412, 0.220166, 0.0279574, 0.0147192, 0.12137, -0.0203275, 0.0168358, -0.163779, 0.018139, -0.0889889, -0.101319, -0.0303057, -0.024569, 0.0975872, -0.0152843, 0.21546, 0.124123, -0.071458, 0.234431, 0.195254, 0.0980091, -0.196895, -0.00772511, -0.198087, -0.0740562, 0.0643278, 0.036416, -0.0557698, 0.0279666, 0.243814, 0.342543, 0.316286, -0.156932, -0.315641, -0.028864, -0.10987, -0.241807, -0.0177619, 0.114338, -0.0859272, -0.156727, 0.147878, 0.145905, 0.211712, -0.0507135, -0.113054, 0.116875, -0.219816, -0.168283, -0.00225372, -0.0582498, -0.0554767, -7.64921e-05, -0.00761047, -0.10801, -0.0131639, 0.102432, 0.0427942, -0.0145927, -0.449687, -0.162335, -0.0939886, -0.108696, -0.0437753, -0.0862825, -0.0782862, 0.0224051, -0.0421429, -0.0825129, 0.0823876, 0.0143325, -0.0449446, 0.224939, 0.00706916, 0.0633506, -0.0188824, 0.0199735, 0.0886419, 0.0453444, -0.0692054, 0.0512474, -0.0666372, -0.0543662, -0.0351438, 0.0474849, 0.0209473, -0.00903352, 0.00522269, -0.0859103, -0.060437, -0.0527824, 0.00677101, -0.0872317, 0.0540462, -0.0278612, -0.0472941, -0.137403, -0.316169, -0.0514388, -0.00433439, -0.109784, 0.0408743, 0.00788985, 0.0424431, 0.0920136, -0.0224893, -0.0694371, -0.158399, -0.132164, -0.29783, -0.156815, -0.095565, -0.126021, -0.273149, -0.152649, 0.0807524, -0.0291895, -0.0627102, -0.0909332, -0.113605, 0.0318115, -0.10081, -0.414774, -0.354978, -0.27997, -0.0733566, 0.0649098, 0.157489, 0.100873, 0.066087, 0.0451393, 0.00816468, -0.134776, -0.0932575, -0.292505, 0.0837332, -0.428549, -0.32971, -0.0764964, 0.139224, -0.0677593, -0.0605332, 0.0602202, 0.0782567, 0.128797, 0.0509674, -0.105899, 0.022847, -0.303801, 0.0528799, 0.186907, 0.269571, 0.16907, 0.218552, -0.00792055, 0.020259, 0.0564123, 0.0536691, 0.056892, -0.147324, 0.154564, -0.289035, -0.032141, 0.190031, -0.104244, 0.108838, -0.134152, 0.0543938, -0.0334529, 0.00193169, 0.0629144, 0.0119875, 0.0213967, -0.0285746, -0.11526, 0.0358788, 0.109457, 0.232061, 0.0823079, 0.125247, 0.0126533, 0.0977255, -0.0564258, -0.0768406, -0.0329403, -0.0985611, 0.0667082, 0.0137871, 0.121924, 0.0819019, 0.0256654, 0.119222, -0.0461412, 0.00226319, -0.015782, -0.016337, 0.0572995, 0.144777, 0.166616, -0.0110366, 0.0559518, 0.233446, 0.0846377, 0.047642, 0.0932968, -0.0869395, 0.000729787, 0.0225909, -0.067245, -0.0244277, -0.0358365, 0.108683, 0.243595, 0.211274, 0.0179617, 0.00481722, -0.0191069, -0.115825, 0.201915, 0.0380225, -0.00277005, -0.0864808, -0.0948751, 0.0490724, 0.117158, 0.129127, 0.162037, 0.144222, 0.208254, 0.00321777, 0.0398533, -0.0767163, -0.00242631, -0.0123936, -0.042749, -0.0277439, -0.0514439, -0.0708257, -0.0372331, 0.0863863, -0.072683, 0.028042, -0.0258763, -0.0930262, -0.0194043, -0.0645809, -0.0598816, 0.0133039, 0.0850564, 0.0635939, -0.0556762, -0.0675354, 0.0564423, -0.000491021, -0.0223791, 0.106248, 0.229468, 0.0605449, 0.0270152, -0.0597438, -0.0459476, -0.0195795, 0.151216, 0.010379, -0.457985, -0.322376, -0.251038, 0.0160029, -0.114504, 0.0909066, 0.0991202, 0.0890969, 0.0782281, 0.0884825, -0.062011, -0.0599094, -0.223085, -0.447558, -0.332102, -0.306093, -0.000334351, 0.18835, 0.0836948, 0.28475, 0.132102, 0.0547339, 0.0209013, -0.0758282, 0.0283436, -0.327317, -0.187287, -0.344412, -0.153325, 0.018671, 0.397955, 0.359409, 0.122247, 0.0919759, 0.126845, 0.00661348, -0.114082, -0.197204, -0.418169, -0.453437, -0.348395, -0.148323, 0.167285, 0.458635, 0.45064, 0.353786, 0.026035, 0.0120887, -0.090905, -0.15234, -0.392196, -0.646614, -0.311733, -0.213143, 0.0116371, 0.203751, 0.252259, 0.411187, 0.196489, -0.226223, -0.217718, -0.0306726, -0.0207187, -0.199553, -0.495737, -0.689702, -0.208948, -0.140183, 0.170371, 0.0505502, -0.044167, -0.0697924, -0.11468, -0.215026, -0.101998, 0.068333, -0.288726, -0.451081, -0.643991, -0.352195, 0.0754415, 0.202412, 0.254359, -0.125302, -0.0638835, 0.111231, 0.0691564, 0.0369481, 0.0877039, -0.0657031, -0.536984, -0.233129, -0.504363, 0.0327307, -0.0360086, 0.154049, -0.141383, 0.0943023, -0.0554055, 0.0048672, 0.0928575, -0.00421156, -0.164678, -0.590299, -0.0727468, -0.235023, 0.14657, 0.226554, 0.109892, 0.00529705, 0.0878258, 0.135217, 0.204336, 0.0204308, -0.0907935, -0.0149584, -0.11992, -0.228869, 0.240594, 0.0399255, 0.29498, 0.0826416, 0.278276, -0.0414374, -0.066791, -0.0471173, 0.0271302, -0.0343366, -0.0602354, -0.0797072, 0.0432226, 0.129206, 0.35668, 0.456722, 0.268584, 0.317825, 0.35655, -0.0783219, -0.013202, 0.0350851, 0.0561928, 0.0200291, -0.0908494, 0.0972001, 0.177511, 0.0837689, 0.341914, 0.164187, 0.0283995, -0.0741845, -0.144042, -0.0649533, 0.0252456, 0.00379398, -0.141392, 0.00468847, -0.0236545, -0.124146, -0.109983, -0.329452, -0.142155, -0.187364, -0.208528, -0.0370924, -0.0238049, 0.0964206, -0.0310134, 0.0680306, -0.259625, -0.053471, -0.031041, -0.0168049, 0.0503364, -0.203619, -0.0938925, -0.177361, -0.116122, -0.00768943, 0.0430429, -0.0888612, -0.0553328, -0.119102, -0.109638, -0.106888, 0.153955, -0.123599, -0.0520967, 0.0096156, -0.247311, -0.0793354, -0.0108611, -0.0967189, -0.0703401, 0.0111569, -0.0442026, -0.0824196, -0.0263073, -0.0767878, -0.064275, 0.379636, 0.315157, 0.344433, 0.144498, 0.0938549, 0.0394789, 0.020223, -0.0628219, -0.265351, -0.29694, 0.139177, 0.0164009, 0.192828, 0.506441, 0.246359, 0.20998, 0.215123, 0.23985, 0.107399, -0.0911864, -0.233331, -0.144598, 0.0629954, 0.0116526, 0.257356, 0.217764, 0.349836, 0.473649, 0.210409, 0.295961, 0.106053, 0.0069396, 0.0764305, -0.22366, -0.202656, -0.334877, -0.287605, 0.126609, 0.0343399, 0.127349, 0.0796699, -0.124519, -0.195016, -0.0362442, 0.0526563, -0.0676001, -0.159333, -0.259737, -0.261501, -0.302455, -0.231391, -0.0605972, -0.237201, -0.445851, -0.115404, -0.318999, -0.0336719, 0.0706325, 0.089362, -0.178375, -0.00328612, -0.259395, 0.0180787, -0.142272, -0.35711, -0.322388, -0.105007, -0.13855, 0.228935, -0.0343668, 0.0410394, -0.00818364, 0.171483, -0.253106, -0.0570465, -0.273252, -0.0514587, -0.070135, -0.0874555, -0.440695, -0.24907, -0.110754, 0.157835, 0.127542, 0.0506505, 0.056033, 0.119956, 0.147788, 0.120702, 0.243358, 0.300634, -0.208131, -0.254315, -0.0508986, 0.0309857, 0.0834812, 0.0969978, 0.0271103, 0.13135, -0.015075, 0.132954, 0.10975, 0.0751324, 0.23115, 0.232137, 0.128415, 0.0632963, 0.15451, 0.0834029, 0.0912074, 0.0405579, -0.0255333, 0.0476133, 0.0694105, 0.0357707, 0.316109, 0.309206, -0.0156221, 0.0966951, 0.0310419, -0.0176001, -0.0122549, -0.0587871, -0.0821908, 0.0320079, -0.190138, -0.125593, -0.223191, -0.21771, -0.10328, 0.00297119, -0.198842, -0.103727, -0.0476936, 0.0630571, 0.0516995, 0.0155549, -0.260934, -0.0701744, -0.114986, 0.217754, 0.184248, 0.167024, -0.0875255, -0.237672, -0.10708, -0.128471, -0.0891452, -0.0685452, -0.142771, -0.0183361, 0.133608, 0.114124, 0.111606, 0.505243, 0.201619, 0.156614, 0.165734, 0.106978, 0.0419833, 0.0564221, 0.0237093, -0.0528973, -0.0799584, -0.0211509, 0.151814, 0.276685, 0.264284, 0.169048, 0.592946, 0.227169, 0.201534, 0.23984, 0.0877132, -0.0766217, -0.0262207, 0.0576291, 0.131734, 0.143666, 0.321572, 0.216386, 0.392067, 0.487571, 0.593023, -0.00113134, 0.247697, 0.131076, -0.0462713, -0.0198865, -0.00909801, -0.137774, 0.0546944, 0.130414, 0.176137, -0.147803, 0.213691, 0.0826894, 0.00966299, -0.00511495, 0.0412487, -0.0411698, -0.0257208, -0.237059, -0.0768395, 0.156065, -0.0856559, -0.225389, -0.269633, -0.253078, -0.289334, -0.163378, -0.286137, -0.158113, -0.0301295, -0.0887751, -0.175048, -0.0942586, 0.078079, -0.0109177, -0.114693, -0.444998, -0.405471, -0.203083, -0.19453, -0.0741467, 0.0685075, 0.067009, -0.0323439, 0.0909738, -0.181458, -0.238266, -0.0833974, -0.282293, -0.420393, -0.162372, -0.280017, -0.175478, -0.0215275, 0.0574242, 0.0991267, 0.0420779, 0.0717915, -0.138233, -0.159333, -0.356127, -0.222306, -0.419904, -0.417822, -0.119321, -0.0131543, -0.137986, -0.0186418, -0.0765216, 0.159452, 0.00875704, -0.0718219, 0.0911646, -0.141782, -0.33177, -0.0446761, -0.181662, -0.117012, 0.00931794, -0.0272944, -0.0640998, 0.0445277, 0.0384044, 0.177309, 0.116683, 0.0748277, 0.149233, 0.0772222, -0.117146, 0.0278269, 0.148924, 0.0736543, 0.116571, 0.0808177, 0.0613899, -0.0457633, -0.043612, -0.0361704, 0.107331, 0.117836, 0.116485, 0.0781721, 0.210902, -0.0165618, 0.176689, 0.0665242, 0.0841118}, {-0.0224733, -0.0924331, -0.00122087, -0.166305, -0.0382241, -0.163689, -0.0918012, -0.053023, 0.016225, 0.084878, -0.0728688, 0.0144821, 0.056999, -0.0309074, -0.0591214, -0.105958, -0.219163, -0.2648, 0.0666286, 0.1352, -0.242002, 0.0754908, -0.0569921, -0.14466, 0.0533356, -0.0786357, 0.00493502, -0.173521, -0.109715, -0.25077, -0.473917, -0.617177, -0.511284, -0.440607, -0.230546, -0.264048, -0.218685, -0.0439886, 0.0468752, -0.0428333, -0.0384231, -0.563817, -0.269289, -0.144523, -0.246288, -0.362012, -0.308725, 0.0435474, -0.0950828, 0.00540737, 0.00969981, -0.0615915, -0.163897, -0.193056, -0.419937, -0.329007, -0.0527982, -0.0457677, -0.151806, -0.130107, -0.0354758, -0.109136, 0.177565, -0.168713, -0.0857591, 0.00586798, -0.102112, -0.00280082, -0.0163537, 0.245409, 0.0996332, -0.0357596, -0.0726304, 0.154014, -0.0556016, -0.0214296, -0.00563572, -0.00888503, 0.0458478, 0.276047, 0.0128875, 0.304281, 0.0944562, -0.0904481, 0.217819, 0.214678, 0.0347909, -0.167392, -0.32776, -0.0734128, -0.106328, 0.0127632, -0.103751, 0.623175, 0.272562, 0.304484, 0.0763822, 0.177256, 0.0793386, 0.116126, 0.254443, 0.126255, 0.0258098, -0.0142557, -0.219243, 0.030604, 0.127708, 0.381501, 0.2016, 0.0186305, 0.176518, -0.00747451, -0.195487, 0.038487, 0.131968, 0.0299813, -0.0699728, -0.136022, 0.0521714, 0.125255, 0.219267, 0.308451, 0.209293, 0.340966, -0.103698, 0.328274, 0.0248415, 0.216346, -0.0562544, -0.0811552, -0.0995134, 0.173423, 0.0442737, 0.320731, 0.159068, 0.293968, 0.581805, 0.402445, 0.145264, 0.213886, 0.0012646, -0.0408606, 0.0234193, 0.00251398, -0.0623502, 0.0880219, 0.322984, 0.575258, 0.316534, 0.5736, 0.232347, 0.412507, 0.328815, 0.100454, 0.111244, 0.105274, -0.0241969, -0.189196, 0.147163, 0.0592607, 0.166057, 0.21575, 0.277348, 0.354428, 0.0657144, 0.0225699, 0.0864642, -0.0268155, 0.0443225, -0.0246798, -0.044666, -0.0804237, 0.0150699, 0.0159589, -0.0726286, -0.0501215, -0.0866589, 0.034168, -0.0695745, -0.0496297, 0.00968239, -0.0033548, -0.0400366, 0.00365121, -0.0245458, 0.0391612, -0.215169, -0.131458, 0.065984, 0.0681004, -0.112305, -0.00270949, 0.0123841, 0.0105588, 0.0547555, 0.0238802, -0.103416, -0.0651172, -0.110196, 0.0537256, 0.0882637, 0.161466, 0.11233, -0.218118, -0.0218509, 0.01317, -0.0795719, 0.0427084, -0.0713732, -0.0432324, 0.126929, -0.0119587, 0.272196, 0.00294913, -0.05976, 0.251213, -0.0419268, 0.134657, 0.112492, -0.0234542, -0.0515609, 0.0710097, 0.200562, -0.00275174, 0.0717774, 0.10615, 0.237583, 0.184554, -0.100305, 0.122445, 0.170598, 0.324753, 0.0893423, 0.0241252, -0.0431536, -0.0552644, 0.402461, 0.192773, 0.0871019, 0.111201, 0.110892, 0.23182, 0.0477945, 0.0533568, 0.288095, -0.0795128, -0.00744744, 0.000355891, -0.146056, 0.050389, -0.0440915, -0.111846, 0.155667, 0.169001, 0.120925, -0.125616, 0.000267702, 0.18945, -0.122371, 0.0879113, -0.062671, -0.0483215, -0.13184, 0.0613752, -0.0671498, -0.0664226, 0.194339, 0.134996, -0.374507, 0.079564, 0.0396825, -0.0396657, 0.0349942, 0.0290778, 0.0179929, -0.00757417, -0.098155, -0.0915998, -0.126259, 0.23098, 0.13507, -0.0875182, -0.00248771, -0.0248502, 0.0128729, -0.00551233, -0.0361678, 0.0554063, -0.0749243, -0.209391, 0.260735, -0.0213124, -0.069119, 0.124061, -0.0147918, -0.0553778, -0.0312043, -0.0225626, 0.0864652, 0.0646597, -0.00320781, -0.0433336, -0.0427578, -0.043041, 0.0759515, 0.205136, -0.0571375, 0.122646, 0.0286252, -0.0096924, -0.0679323, -0.0313538, 0.0393774, -0.0034272, -0.00230249, 0.202426, 0.208263, 0.112453, -0.0154534, 0.222264, -0.0204586, 0.088648, 0.0591513, 0.0583166, 0.0449357, -0.0527764, -0.0015212, -0.0825942, 0.121096, 0.0736185, -0.0690279, -0.0169041, 0.0648506, 0.0151053, 0.114452, 0.0975564, 0.0392349, 0.055147, 0.0615891, -0.0108481, 0.0407795, 0.0518775, -0.00587113, -0.00829413, 5.32755e-06, -0.0656679, -0.0631638, 0.0876385, -0.0612628, -0.0577626, -0.0447977, 0.0867474, 0.0192678, -0.0698166, 0.00387623, -0.10917, -0.11978, -0.180355, 0.0920169, 0.104905, 0.000454233, 0.0256531, 0.0412695, 0.0208902, 0.0646503, -0.0863975, -0.123523, -0.317322, -0.370791, -0.0376587, -0.0929312, -0.0526508, 0.0403268, -0.0372113, 0.0352346, -0.0402259, 0.0844122, -0.0495845, -0.119127, -0.234862, -0.314372, -0.256553, 0.137751, 0.367665, 0.314473, 0.375259, 0.265462, 0.156503, -0.0921479, 0.0074068, 0.0166029, 0.330591, 0.0648306, 0.357486, 0.101468, 0.0690493, 0.213624, 0.104329, 0.265163, 0.0551656, 0.0242767, -0.0542159, 0.0609087, 0.0341622, -0.0548148, 0.169414, 0.478507, 0.282181, 0.0856389, 0.114055, -0.153071, -0.0562532, 0.11959, 0.291831, -0.109285, 0.0869652, -0.0141407, 0.122184, 0.17472, 0.355135, -0.238817, 0.0730758, 0.248484, 0.0565421, -0.176152, -0.0359341, 0.065646, -0.131099, 0.0314909, 0.0689197, -0.138304, 0.146789, -0.15275, 0.138969, 0.0939616, 0.443621, -0.176917, 0.378503, 0.114991, -0.0384809, 0.0661408, -0.0871742, 0.0602931, -0.138681, 0.0831335, 0.0554962, 0.139462, 0.121151, 0.250174, 0.314165, 0.587689, 0.46094, 0.068696, 0.0999933, 0.0220876, -0.0567288, -0.0984707, 0.00260915, 0.0784324, 0.131028, 0.170748, -0.353608, -0.138531, 0.35731, 0.304746, 0.217018, -0.207118, 0.0178938, -0.0734398, -0.105239, 0.0299026, -0.103282, -0.0431552, -0.102583, 0.0782133, -0.242919, 0.00854983, 0.169908, 0.290473, -0.0897167, -0.0642836, 0.0167204, -0.0147254, -0.0657517, -0.0397047, 0.0184119, -0.0881945, -0.124115, -0.376776, 0.0715985, -0.160796, -0.0102809, 0.0432777, 0.0464929, -0.0942857, -0.00854155, -0.0505757, 0.131225, -0.0671013, 0.0838087, -0.317909, -0.423828, -0.156519, 0.274533, 0.0221216, -0.0929823, 0.0703291, -0.0610037, 0.0592435, -0.0302491, -0.0295696, -0.0716893, 0.00753308, -0.0921807, -0.0582195, 0.0800147, 0.083728, 0.0156023, -0.0745418, 0.0447348, 0.0476782, 0.0929955, -0.0964239, -0.00292464, 0.0157575, -0.188181, -0.00968938, -0.123266, -0.126558, -0.0645969, -0.0354231, -0.0228727, -0.0990533, -0.0327116, -0.179843, 0.00827285, 0.249134, 0.192987, -0.0513758, 0.176295, 0.0472206, -0.146463, -0.0968975, -0.0216867, -0.0076499, 0.0879773, -0.0573127, -0.0445227, 0.300363, 0.535157, 0.182107, 0.439384, 0.329511, 0.280625, 0.0323407, -0.118473, -0.283073, -0.0783143, -0.0780548, -0.108, 0.160695, 0.550416, 0.348222, 0.169266, 0.102301, 0.195799, 0.241496, -0.0454373, 0.0419271, -0.287523, -0.00154603, 0.0443526, 0.0755619, -0.178093, 0.0913685, 0.120444, 0.320499, 0.219382, 0.207952, 0.122538, 0.00952945, 0.171444, -0.00940608, -0.178484, 0.0673737, 0.144235, -0.028479, -0.21008, 0.0507738, -0.0144081, -0.0381148, -0.142532, -0.0483033, 0.026023, -0.110457, 0.168374, 0.164781, 0.133035, 0.0650914, -0.396195, -0.309883, -0.228401, -0.322948, -0.034587, -0.237268, -0.0487263, 0.0548151, 0.0345049, -0.0461751, -0.229447, 0.0506946, -0.0903063, 0.0527753, -0.484862, -0.326545, -0.236774, -0.0970363, -0.230048, 0.0134707, -0.144923, -0.188802, -0.11347, -0.118964, 0.092412, -0.105227, -0.058319, -0.272498, -0.349694, -0.398174, 0.0084413, -0.135027, 0.290088, 0.160175, 0.00635493, 0.0898538, 0.056732, 0.0723667, -0.0365168, -0.212139, -0.129568, -0.245497, -0.124245, 0.0210237, 0.166487, 0.470633, -0.0109548, 0.0986183, -0.214851, -0.152929, -0.00848585, 0.056786, -0.113408, 0.0681516, -0.30484, -0.0254875, 0.223875, 0.181427, 0.443627, 0.307174, 0.0373427, -0.103298, 0.0497408, 0.0848636, 0.0483318, -0.170949, -0.123803, -0.054239, -0.222704, 0.184195, 0.0417615, -0.0482153, 0.176295, 0.0475983, 0.0693477, -0.0485024, 0.0750435, -0.0493094, -0.00394666, -0.0128323, 0.0600515, 0.08251, -0.0987998, 0.0857765, -0.0939114, 0.0722516, -0.0645111, 0.00218463, 0.0299246, 0.036022, 0.0740261, -0.0151487, -0.0773012, -0.0772105, -0.0131437, 0.0244023, -0.0481046, -0.0910107, 0.043848, -0.0383346, 0.0179859, 0.0423935, -0.0429763, 0.017474, -0.0818771, 0.00504948, 0.159725, 0.0162603, -0.153248, 0.158367, 0.0605786, -0.0696176, 0.0235007, -0.077361, 0.0851134, -0.0928322, -0.0735506, 0.221815, 0.346163, 0.165256, -0.05003, -0.18498, 0.154159, -0.0844133, -0.0555164, -0.113672, -0.13153, -0.0438518, -0.0444984, -0.0376965, 0.0743787, 0.163617, -0.246015, -0.218581, -0.0820393, 0.0854266, -0.125598, 0.112291, -0.178158, -0.0621959, -0.180336, -0.07969, 0.0940004, -0.15022, -0.1367, -0.0507206, -0.233123, -0.135736, -0.341909, -0.253426, -0.0287323, -0.257398, -0.0470149, 0.00737323, 0.0658037, 0.0942479, -0.155077, -0.0850128, -0.100862, -0.0884536, -0.124261, -0.165426, -0.0136654, 0.0794549, -0.0336778, -0.0849898, 0.0554611, -0.0259069, 0.120639, -0.0437183, -0.239069, -0.151976, -0.102731, -0.311558, 0.106315, -0.285603, 0.105693, -0.21963, -0.137173, -0.129501, 0.075244, 0.0567019, -0.0715546, -0.21147, -0.00805331, -0.274152, -0.195658, -0.00527125, -0.0666916, -0.241272, -0.250431, -0.12939, -0.000329108, -0.0925882, 0.0407449, -0.0950396, -0.132004, -0.185095, -0.115254, -0.10881, 0.0107262, -0.299631, -0.241607, -0.0197291, -0.0766754, 0.075134, -0.0470019, -0.0511215, -0.0784251, 0.00659221, -0.227279, -0.0912575, -0.0152257, 0.100757, -0.0388689, 0.0802345, 0.0457813, -0.104868, -0.0254507, 0.0706244, 0.0895014, 0.0182374, 0.0174094, -0.134801, 0.0426879, -0.139787, 0.202368, -0.143219, -0.254822, -0.0229839, -0.0113874, -0.0456491, -0.0939782, 0.0624777, 0.00694318, -0.0709366, -0.0452568, -0.297157, -0.0646298, -0.284946, 0.0477056, -0.130492, -0.0355765, 0.042293, 0.0487395, 0.0706805, 0.0116024, 0.0590262, -0.0156781, -0.0615359, -0.0818067, 0.0349397, -0.0255161, -0.0175842, -0.0519769, -0.0155486, 0.0260353, -0.000905768, -0.0739738, 0.0842124, 0.0429468, 0.0129641, -0.00583125, -0.0299307, 0.0212713, -0.119515, 0.0373737, 0.08693, 0.00641305, -0.0823649, 0.00608976, 0.100993, 0.0210966, 0.00704419, -0.00278537, 0.290611, 0.524749, 0.292191, 0.286606, 0.0766553, -0.0436933, 0.0887128, -0.0217764, -0.020286, -0.0880253, 0.108117, -0.0430876, 0.167684, 0.372536, 0.0787605, 0.347945, 0.254402, 0.226117, 0.291827, -0.0584952, 0.151752, -0.188197, -0.160724, 0.0501529, -0.0158345, 0.337742, 0.376556, 0.205686, 0.301277, 0.108171, 0.0252346, 0.0678329, -0.0209627, -0.122456, -0.160809, -0.0526199, -0.0261644, 0.247597, 0.391262, 0.266756, 0.289754, 0.311826, -0.0201413, -0.0889023, 0.0726383, -0.0597754, -0.101716, -0.169318, -0.0758368, 0.0164481, -0.0239013, 0.0950742, 0.0403487, 0.368824, 0.0302139, 0.0829593, 0.0526446, -0.0262077, 0.0200277, -0.110763, -0.229709, 0.0691425, 0.0869318, 0.0396106, 0.0916459, 0.117313, 0.471253, 0.115042, -0.351756, 0.101359, 0.155923, 0.0761959, -0.0654607, -0.278922, -0.0553526, 0.0966876, -0.00703493, -0.0120066, 0.0474633, 0.0796667, -0.1888, -0.020374, -0.23766, 0.168512, -0.0187117, 0.310213, 0.219739, -0.033452, -0.079643, -0.0937853, 0.0831347, -0.0444378, -0.387074, -0.315598, -0.24445, -0.15441, -0.197778, -0.0355778, 0.0783449, 0.291499, -0.0144306, -0.121094, 0.0217637, -0.158727, -0.0069446, -0.39732, -0.361321, -0.210851, -0.319709, -0.410608, -0.203482, -0.0196731, -0.0765351, -0.0994515, -0.0690083, -0.0119357, -0.0739777, -0.0977386, -0.229217, -0.309376, -0.3857, -0.454202, -0.482213, -0.402928, -0.359438, -0.0797297, -0.0349355, 0.015865, -0.0531718, 0.0850313, -0.16852, -0.110227, -0.349183, -0.212272, -0.295238, -0.360007, -0.325326, -0.427167, -0.0645515, 0.0327135, -0.118064, 0.00526968, -0.125969, -0.0386798, -0.0562586, -0.0332645, -0.0119249, -0.0483099, -0.0314335, -0.0165574, -0.145221, -0.0845987, -0.0728178, -0.0340249, -0.197578, 0.00636377, 0.0518072, 0.260514, 0.17955, -0.00291503, 0.0394048, 0.157648, 0.0752485, 0.127396, -0.131443, -0.099144, -0.0383529, 0.00436137, 0.133372, 0.143543, 0.0459842, 0.17802, 0.122658, -0.0168063, 0.0297194, -0.00357065, -0.0673075, 0.210232, -0.0926892, -0.0694508, -0.0155471, -0.0446146, 0.358933, 0.216944, 0.435165, 0.459949, 0.218004, 0.00839691, -0.0720173, 0.0852598, -0.141683, 0.0181535, -0.0556591, 0.0624918, 0.311922, 0.152064, 0.552716, 0.294764, 0.282032, 0.0339785, -0.249709, -0.0337732, 0.0858951, -0.260133, 0.12702, -0.119022, 0.169475, -0.176764, -0.17478, 0.274934, 0.429296, 0.148726, -0.300043, -0.416243, -0.129252, 0.0513193, 0.0144216, 0.325706, 0.0415764, -0.247561, -0.187099, 0.220744, 0.481611, 0.26207, 0.041918, -0.142258, 0.00880073, -0.126211, -0.197827, -0.262882, -0.0225452, -0.0562596, 0.294244, -0.193886, 0.0816201, 0.0939194, 0.185102, 0.242259, 0.0581684, 0.0141714, 0.105244, -0.435414, -0.163098, -0.143948, 0.0695475, -0.0121731, 0.180612, -0.120536, 0.00469183, -0.181562, 0.0986247, 0.226125, 0.0504398, 0.320099, 0.0915083, 0.236653, 0.0938576, -0.0934077, 0.0264213, 0.168754, 0.111521, -0.211352, -0.111983, 0.185733, 0.114776, 0.116704, -0.049828, 0.0491892, 0.139977, -0.034212, 0.0668485, 0.00855764, 0.145265, -0.209392, -0.173991, -0.123301, -0.0642748, -0.0788354, 0.124834, 0.0227332, -0.10959, 0.109005, 0.0646107, -0.126307, -0.230951, -0.135846, -0.318436, -0.10313, -0.123197, -0.0387339, -0.0116257, -0.121638, -0.207133, 0.0674753, 0.0616241, -0.0941174, -0.12675, 0.0503462, -0.108185, -0.362282, -0.139816, -0.345256, -0.097681, 0.0959337, 0.12821, -0.151326, 0.0445728, -0.114577, -0.0976125, -0.0259868, -0.0691895, -0.0771716, 0.0598652, 0.00462946, -0.0121766, -0.0604633, -0.021966, -0.102543, -0.136207, -0.190387, -0.0113788, -0.0290429, -0.0259923, 0.024006, -0.0705861, -0.0380514, 0.0650092, 0.0259119, -0.14198, 0.172319, -0.14188, -0.04676, -0.0896044, -0.0924347, -0.018673, -0.0809875, 0.0759273, -0.127851, -0.315086, -0.183771, -0.170844, -0.129755, 0.126415, -0.134911, 0.102671, -0.0697016, 0.0512785, 0.0763852, -0.157944, -0.150883, -0.204121, -0.0731797, -0.0445841, -0.227241, 0.10899, 0.312817, 0.0142514, 0.0820493, -0.08895, 0.0258283, 0.0748574, -0.014628, -0.0772906, -0.113152, -0.264257, -0.0842181, 0.0871752, 0.5023, -0.00679246, -0.0532452, -0.0919719, -0.272222, 0.0124345, 0.00473893, -0.156001, -0.136631, -0.150713, 0.191416, 0.0581577, 0.347921, 0.466277, -0.109324, 0.200241, -0.107919, -0.191796, -0.0664856, -0.0853078, -0.132498, -0.108662, -0.065077, 0.210427, 0.0782013, 0.121568, 0.659048, 0.342088, -0.0544142, -0.138819, 0.112034, -0.100863, -0.0551464, -0.142722, -0.0405645, -0.0326544, -0.222029, -0.0621816, 0.261942, 0.765934, 0.289454, -0.184782, -0.196354, 0.11334, 0.215855, 0.0130191, -0.01587, 0.0687403, 0.0229329, 0.0645247, -0.159485, 0.120889, 0.446294, 0.415347, -0.00919127, -0.249773, -0.0170448, -0.132048, 0.103551, -0.0101757, 0.17564, 0.0372033, 0.0480717, -0.0340724, 0.0389303, 0.270278, 0.368081, 0.203455, -0.0269377, -0.0430842, -0.155699, 0.111353, -0.0186746, 0.00796217, -0.124143, -0.00826959, 0.256787, -0.0186731, 0.22673, 0.414069, 0.306252, 0.135424, 0.42028, 0.0307841, 0.0569403, -0.0876011, -0.0533307, -0.0615019, -0.0649896, 0.0668297, 0.197724, 0.248563, 0.417601, 0.402115, 0.275366, 0.0418938, -0.00706952, -0.0490051, -0.0989653, 0.0372665, -0.151758, -0.154859, -0.0585228, 0.114565, -0.0802365, 0.0941304, -0.171063, 0.0541764, -0.0641559, -0.0200564, -0.167677}, {-0.0860998, 0.0578294, 0.103061, 0.0200945, -0.0846006, 0.143186, 0.0240203, 0.113314, 0.0198792, 0.0649914, -0.0865551, -0.0576876, -0.0877796, -0.0645141, 0.0896704, 0.270401, -0.00229687, 0.450588, 0.132726, -0.0632188, 0.155637, 0.185659, 0.238439, 0.114762, 0.0425918, -0.0416337, 0.0418796, 0.169651, 0.0509488, 0.118299, 0.165583, -0.0551428, -0.0601463, -0.0942437, 0.0741771, -0.140183, 0.0432819, 0.191703, -0.0015739, -0.00823645, 0.0562104, -0.00764328, 0.0159145, -0.0156283, -0.00707252, -0.0614613, -0.0952298, -0.113121, -0.0830134, 0.0236492, 0.187483, -0.0748653, 0.182733, 0.224024, 0.0607084, 0.0996545, -0.151656, -0.269316, -0.125529, -0.148549, -0.172931, 0.0543371, 0.111492, 0.0439724, 0.046751, 0.231758, 0.0503757, -0.115706, -0.101453, -0.245419, -0.235186, -0.218805, -0.234289, 0.21649, 0.18597, 0.151567, 0.284241, -0.0313975, 0.00246135, -0.0148716, 0.0234641, 0.110668, -0.024364, -0.0453803, 0.00954015, -0.165688, -0.0865128, 0.14412, -0.0298114, -0.0803941, -0.00880134, 0.00523055, 0.387001, 0.214873, 0.166357, 0.123566, -0.0860977, -0.0851605, -0.407462, 0.0318716, -0.138116, 0.0359868, 0.0617265, 0.0965659, -0.0255392, 0.131343, 0.170322, 0.357945, 0.379221, 0.168644, -0.0726878, -0.0607688, -0.0379528, 0.191252, -0.0721162, 0.213064, 0.0745182, 0.0163759, 0.107386, 0.0402237, 0.185708, 0.1149, -0.0155121, -0.128963, -0.109499, 0.0783972, 0.115445, 0.0534881, 0.0730478, 0.101465, 0.012251, 0.054464, -0.198538, -0.203487, -0.218892, -0.118989, -0.200908, -0.143295, -0.12955, -0.0406705, 0.417021, 0.0975906, 0.00815213, 0.011368, -0.140124, 0.0488057, -0.137516, -0.0690041, 0.0997355, 0.0780032, -0.0612064, 0.0404102, -0.136008, 0.236222, -0.0366325, 0.0407246, -0.0971652, -0.0530917, -0.0588792, 0.104439, -0.255104, -0.178073, 0.100502, 0.069423, 0.184323, 0.0169879, -0.0371972, 0.0866082, 0.00747412, -0.0121747, -0.0357339, -0.089376, 0.102435, 0.0926798, 0.0152474, -0.0898993, -0.0667404, -0.0985675, -0.0809823, -0.0445429, 0.0857215, 0.0423102, -0.00930866, 0.0559026, 0.05053, 0.0224877, 0.0101774, -0.00396476, -0.0292592, -0.0592382, 0.00349404, 0.0387798, -0.0520151, 0.009042, -0.0325072, 0.0864429, -0.000410449, 0.0859762, -0.207338, 0.17862, 0.104385, -0.289266, 0.0613467, -0.339105, 0.0485688, -0.0714547, 0.0339031, 0.0784783, -0.0419186, 0.0528468, -0.0645429, -0.186615, -0.355706, -0.167315, -0.0656979, -0.159403, 0.0806347, -0.030247, 0.0868848, -0.0181469, -0.0499772, -0.0403744, 0.0274988, 0.0957264, -0.0863047, 0.0496778, -0.222871, -0.341215, -0.10904, -0.054651, 0.0295846, 0.0982299, 0.244719, 0.0267773, 0.127331, 0.00756185, -0.0550242, -0.308358, -0.525568, 0.0673308, -0.0834813, -0.57855, -0.262416, -0.190922, 0.0134854, 0.208887, -0.00162049, 0.0448168, -0.0214973, 0.0806773, 0.0338851, 0.0365229, -0.244692, -0.267735, -0.34412, -0.161361, -0.335112, 0.142239, 0.17152, -0.0521651, 0.0411335, -0.0224604, 0.00668225, 0.119578, 0.0175056, 0.0501163, -0.105598, -0.186266, -0.104853, -0.00460357, -0.130669, 0.168199, 0.0903306, 0.00963069, -0.0362393, 0.0212672, -0.115569, 0.0617188, -0.0284363, -0.248626, -0.181067, -0.375955, -0.0526692, -0.0418745, 0.150453, 0.0525839, 0.0828562, 0.0184789, 0.0397588, -0.208031, -0.285547, -0.394548, -0.3824, -0.224991, -0.148436, -0.00855435, 0.105629, -0.0088472, -0.0936731, 0.0450854, 0.0602544, 0.150567, -0.106733, -0.17984, -0.239886, -0.351639, -0.118755, -0.293633, 0.193358, 0.149849, 0.114989, 0.0827849, -0.0279179, -0.0873921, 0.0484376, -0.013513, -0.0668041, 0.18128, -0.040928, -0.145434, -0.192328, 0.0416499, -0.15536, -0.0162797, 0.0550428, -0.0509114, -0.0139223, 0.0447714, 0.147722, -0.00947584, 0.0332025, 0.0344083, -0.0305005, 0.0679147, 0.0719777, -0.104568, -0.0752928, -0.00152402, -0.0664317, -0.045906, -0.0904961, 0.055004, 0.147563, 0.0373571, 0.115467, 0.0082834, -0.0357406, 0.0204661, 0.0663071, 0.0193488, -0.0701184, 0.0817981, 0.0115295, -0.0684905, 0.296678, 0.205575, 0.0606334, 0.0179735, -0.0557202, -0.255697, -0.225553, -0.122357, 0.0335464, -0.0476849, -0.00219597, 0.0474984, 0.212218, 0.000921571, 0.131792, -0.178565, -0.0165578, 0.0621983, -0.0818467, -0.119925, -0.184952, -0.0205707, 0.00884033, -0.0954214, 0.170633, -0.0454112, -0.0944871, -0.0389246, -0.222652, -0.328427, -0.141599, -0.0672506, -0.0466988, -0.107254, 0.0107526, -0.201801, 0.018175, 0.218675, -0.144278, -0.187847, -0.300832, -0.288389, -0.287955, -0.194622, -0.131366, -0.000315004, -0.199477, 0.0925252, 0.0105068, -0.0201233, 0.0880927, 0.0614592, -0.437809, -0.178715, -0.242969, -0.389396, -0.125739, 0.0575439, 0.0982919, -0.131657, 0.245449, -0.0356953, 0.0823503, 0.151084, -0.180712, -0.17801, -0.0803531, -0.196031, -0.199433, -0.123384, -0.200766, 0.240157, 0.096166, 0.137203, 0.112547, 0.0187093, -0.00811463, 0.159458, 0.243757, 0.198145, -0.0942873, -0.173426, 0.102887, -0.189218, 0.0925292, 0.0598791, 0.141348, 0.0155072, 0.0524643, 0.10772, 0.0215125, 0.0493799, 0.252742, -0.156153, -0.0657466, -0.0363636, -0.235928, 0.00182354, -0.223367, -0.111046, 0.0366656, 0.0600258, 0.00405752, 0.0825549, -0.183876, -0.0855547, 0.00142393, -0.0809805, -0.129168, 0.0262256, -0.0245658, -0.064557, 0.0383841, -0.0375761, 0.0238797, 0.214454, -0.0806761, -0.0694859, -0.136499, 0.0445677, 0.132758, -0.14153, 0.022517, 0.0363421, 0.243069, 0.196772, -0.0649681, 0.0623602, 0.0340465, 0.0880077, 0.0265123, -0.068695, 0.0287259, -0.145648, -0.0530915, -0.0436732, 0.1001, 0.0830671, 0.104351, 0.060154, -0.0602306, 0.0712895, 0.0258733, 0.132795, 0.0760077, 0.124686, 0.112466, 0.355204, 0.00990919, 0.0908954, 0.0277794, 0.0923118, -0.0246696, 0.0711251, -0.0606178, -0.0843807, 0.0687132, 0.00795059, 0.0650585, 0.0482715, -0.0169027, 0.0152857, 0.0619344, 0.0439905, -0.0586413, 0.0457642, -0.028658, -0.0139244, 0.075306, 0.0136583, -0.248412, -0.0460241, 0.0536487, 0.0496983, 0.173705, 0.0397003, -0.052079, -0.027885, 0.0848985, -0.00177597, -0.0186004, 0.23802, 0.0704201, -0.401772, 0.000158493, 0.101989, 0.0443024, 0.107009, 0.137116, 0.270717, 0.0937298, -0.0923094, -0.027925, 0.0357281, -0.131402, -0.353964, -0.0353132, -0.112859, -0.158547, -0.0956527, -0.0633097, -0.0343686, -0.022963, -0.0150965, -0.0300602, 0.0509497, -0.173296, 0.116191, 0.066534, 0.0481519, 0.260716, 0.161312, 0.110666, -0.166576, -0.0737997, 0.0445115, 0.166404, 0.0248973, 0.116754, -0.0211882, 0.134923, 0.470216, 0.563673, 0.434656, 0.378556, 0.0391873, -0.275617, -0.376131, -0.0557729, -0.0598507, 0.144045, 0.0454579, 0.151285, 0.325229, 0.295908, 0.264188, 0.117137, 0.0422159, 0.0231401, -0.28982, -0.625247, -0.256364, -0.171069, -0.0718738, -0.0484883, 0.0218278, 0.218696, -0.203146, -0.18678, 0.17255, -0.097856, 0.0403893, -0.0345641, -0.13077, 0.097637, 0.215232, -0.0380517, 0.0374089, 0.30168, 0.0741484, -0.0995712, -0.10672, 0.0420097, 0.0688117, 0.0796981, 0.0392125, 0.119849, 0.307521, 0.181246, 0.052038, 0.169471, 0.0696028, -0.0614513, -0.0441999, 0.00476902, 0.0475606, 0.333481, 0.0945484, -0.208929, 0.209229, 0.472168, 0.0798677, 0.0915774, 0.00592095, 0.0841156, 0.133474, 0.270607, 0.160074, 0.0579757, 0.0193855, -0.105091, 0.171741, 0.066694, -0.137278, -0.025575, 0.0436772, -0.0636977, 0.102206, 0.331762, 0.321972, 0.284797, 0.0472678, 0.197324, 0.0778742, 0.111394, 0.0190058, -0.100284, -0.269003, 0.0227913, -0.000185065, 0.0150645, 0.12587, 0.124089, 0.0638686, 0.148896, -0.00989241, 0.0958926, -0.0525561, 0.217473, 0.0747009, 0.093801, 0.0807324, 0.0555971, -0.0851447, -0.0287895, 0.0283463, 0.0499787, -0.0511994, 0.059253, 0.059927, -0.0153158, 0.0582881, 0.0248935, 0.0214043, 0.0330511, 0.0933604, 0.0135239, 0.00983023, 0.0462114, -0.114114, -0.0532293, 0.0681808, -0.0227752, -0.0808375, -0.151502, 0.0657646, -0.0396193, -0.0925711, -0.0979014, 0.0195296, 0.0848935, -0.034265, -0.127976, 0.0161568, 0.055182, 0.100407, -0.0113324, -0.00967831, -0.0293711, 0.0219316, -0.0611793, -0.0272158, -0.0588876, -0.190016, -0.0390335, 0.243347, 0.273621, 0.068919, 0.231232, 0.349297, 0.165801, -0.242215, -0.106525, -0.0312101, 0.0594721, -0.0446132, 0.0417897, 0.303377, 0.306711, 0.230731, 0.246331, 0.156392, -0.0351772, 0.0242703, -0.0146937, 0.0507679, -0.0844586, 0.0719942, 0.0904676, 0.187863, 0.304173, 0.128733, 0.379654, 0.0866806, -0.036609, -0.0781679, -0.0431719, -0.0652679, -0.131946, -0.133496, 0.0362636, 0.12055, 0.0481663, 0.623821, 0.407274, 0.347391, 0.180113, 0.258096, 0.180981, -0.045562, 0.0115081, 0.0163169, -0.123644, 0.023001, 0.0101511, 0.190201, 0.281179, 0.422084, 0.0465078, 0.146618, 0.275253, 0.341506, 0.144613, 0.193781, 0.131074, -0.0390168, 0.0503586, -0.0429429, -0.299307, 0.0445008, -0.15053, -0.0333585, -0.00137332, 0.263923, 0.386352, -0.0357875, -0.26473, 0.0261543, 0.0826564, 0.0414524, 0.169049, 0.0563163, 0.0899729, -0.0965815, -0.0771585, -0.124538, 0.128336, 0.15529, 0.14666, 0.322715, -0.0634997, 0.0829317, 0.0937255, -0.0145741, 0.181653, 0.26894, -0.0215606, -0.0742919, -0.133256, 0.212409, 0.0649794, -0.0686509, 0.0652902, 0.0563049, 0.0396821, 0.0370577, -0.0336228, 0.134244, 0.168536, 0.143134, 0.0450595, -0.0970356, -0.189886, 0.0856754, -0.128511, 0.0750136, 0.209072, 0.0112648, 0.0843009, 0.0229652, 0.0133146, 0.0322958, 0.0414946, -0.0415404, 0.119419, -0.0777235, 0.162225, 0.119444, -0.0278821, -0.0409893, -0.0784644, -0.0938456, 0.01735, -0.018064, -0.040915, -0.0147957, 0.0497412, -0.0936026, 0.0252913, 0.0497301, 0.0326116, 0.0344767, -0.0553441, 0.0776497, -0.00284493, 0.0359772, 0.053116, 0.0191895, 0.0809713, 0.272765, 0.199524, -0.188841, 0.0847505, 0.141076, 0.0436986, -0.0132032, -0.0817496, -0.0784993, -0.0515825, -0.0622334, -0.133475, 0.2409, 0.292063, -0.104395, 0.0705387, 0.0250746, 0.215283, 0.32117, 0.270876, 0.0766837, -0.0188103, 0.0270112, -0.0863636, 0.23626, 0.0263971, 0.0201993, 0.0114678, 0.180879, 0.110094, 0.228808, 0.311837, 0.182344, 0.287587, 0.0763017, 0.256935, -0.175872, -0.090477, -0.0860401, -0.099334, 0.0412912, -0.0082881, 0.133697, 0.00419266, 0.0925618, 0.133203, -0.0833384, 0.0105392, 0.0391139, -0.193052, -0.359002, -0.308824, -0.326133, -0.0188655, 0.105671, 0.0816778, 0.0611883, 0.229119, 0.187466, 0.365869, 0.152138, 0.170288, 0.15302, -0.38649, 0.0225417, -0.0652834, 0.0224305, 0.223509, 0.16713, 0.253439, 0.267959, 0.0140415, 0.144788, -0.0821862, 0.0978553, 0.0797718, -0.0812127, -0.0545753, 0.0370881, 0.0882872, 0.17588, 0.0403623, 0.225224, 0.313977, 0.329253, -0.00185179, 0.0219581, -0.148001, -0.474604, -0.0753304, -0.123051, -0.131962, -0.0639619, -0.0187759, -0.128594, 0.0505222, 0.00757881, -0.0175889, -0.14412, -0.0426985, -0.176365, -0.131987, -0.0595627, -0.454615, -0.196946, -0.351035, -0.148713, -0.223269, -0.0424565, 0.19158, -0.249245, 0.125236, -0.0575701, -0.21923, -0.0111852, -0.174562, -0.239638, -0.160593, 0.118952, -0.255846, -0.121692, -0.0720679, 0.0559413, -0.22069, 0.0159247, -0.00804015, 0.174603, -0.0243088, -0.0220106, -0.202004, -0.0770738, 0.0828457, -0.147224, -0.175421, 0.0777082, -0.251403, -0.119933, -0.115544, -0.0318401, -0.0352736, 0.0202474, 0.0211092, -0.120694, 0.1162, 0.131919, 0.0404715, 0.179006, 0.041768, 0.236529, 0.479092, 0.103641, 0.100343, 0.0784142, 0.246219, 0.188361, 0.0326993, 0.138981, 0.257806, 0.283233, 0.282084, 0.175572, 0.181576, 0.24924, 0.175498, 0.0776223, 0.165919, 0.20566, 0.123728, -0.0605954, -0.0720984, -0.0399912, -0.0621918, -0.0475071, 0.0425609, 0.252966, 0.21895, 0.25583, 0.151195, 0.109379, 0.0740498, -0.105589, -0.0638534, -0.249169, -0.195482, 0.0244298, 0.0248195, -0.132495, 0.288305, 0.0638121, 0.203496, 0.184726, -0.00855852, 0.0351604, -0.0760004, -0.0866405, -0.0368289, 0.0441002, -0.0718556, -0.200106, -0.117839, -0.0141781, 0.0848892, -0.0692418, 0.0752349, 0.189448, -0.140254, 0.0917178, -0.214717, -0.322866, -0.177498, -0.082998, -0.279872, -0.411454, -0.225572, 0.143066, -0.0481198, 0.287626, 0.1329, -0.229001, 0.0173756, -0.213964, -0.577443, -0.202677, -0.621648, -0.314676, -0.168826, -0.0732889, -0.246366, 0.00429854, 0.132915, 0.276248, 0.355979, 0.0937432, -0.349381, -0.40359, -0.222242, -0.22209, -0.341013, 0.102902, 0.154905, -0.119164, 0.0813589, 0.287541, 0.243414, 0.0668962, -0.162826, -0.444441, -0.311025, -0.355127, -0.284281, -0.0667625, 0.219835, 0.142524, 0.339665, 0.13422, 0.140638, 0.125703, -0.0389647, -0.219342, -0.398267, -0.25994, -0.242274, -0.282085, -0.0177183, -0.117505, -0.00253676, 0.162833, 0.129259, 0.141029, 0.182109, -0.0349666, -0.208913, -0.539903, -0.284874, -0.459632, -0.503025, -0.317389, -0.0969649, 0.0734538, 0.0120661, 0.15326, 0.104005, 0.114586, -0.0589054, -0.068703, -0.304995, -0.41819, -0.30534, -0.328137, -0.373453, -0.404641, 0.00738707, -0.13779, -0.0187248, 0.173668, 0.203739, 0.292261, 0.140081, 0.114118, -0.0397772, -0.141739, -0.0613619, -0.0863425, -0.216204, -0.1539, 0.191478, 0.0850623, 0.203125, 0.108615, 0.28203, 0.313132, -0.0114235, -0.0460709, -0.0456957, -0.0617128, -0.122447, 0.170333, 0.192331, 0.125863, 0.0549514, 0.200432, 0.308703, 0.212764, 0.185302, 0.309759, 0.295116, 0.0670043, 0.189131, 0.255766, 0.363291, 0.185754, 0.224922, 0.192864, 0.264785, 0.327657, 0.242965, 0.121355, 0.0675877, -0.0298363, -0.277722, -0.19205, -0.234349, 0.153329, 0.0246915, 0.21232, 0.213326, 0.173931, 0.113874, 0.161265, -0.150396, 0.134236, -0.0133482, -0.28196, -0.77122, -0.226839, -0.230645, 0.00902363, -0.074927, 0.115922, 0.321987, 0.285127, 0.142529, -0.165907, -0.101117, -0.167322, -0.292225, -0.453942, -0.495696, -0.402245, -0.10065, -0.141078, -0.20089, 0.219022, 0.208588, -0.00702945, -0.319256, -0.452723, -0.441509, -0.473466, -0.664276, -0.524671, -0.807805, -0.335959, -0.283496, 0.00591094, 0.248456, 0.102091, -0.174423, -0.306753, -0.0526638, -0.395793, -0.374006, -0.461812, -0.52392, -0.480403, -0.190402, -0.246671, -0.0964948, 0.244296, 0.194709, -0.107696, -0.0071083, -0.238625, -0.187202, -0.200435, -0.236023, -0.269083, -0.148407, -0.0681579, 0.0851152, 0.159191, 0.350449, 0.0734822, 0.172451, -0.0646015, -0.138374, -0.263347, -0.619728, -0.22523, -0.0401019, -0.0332358, 0.265048, 0.130796, 0.150677, 0.295315, 0.212764, 0.217328, 0.105198, 0.098326, -0.139023, -0.844835, -0.385177, -0.512949, -0.00760373, 0.0744278, 0.171174, 0.187116, 0.279788, 0.317701, 0.096785, 0.0236123, -0.276558, -0.295765, -0.48337, -0.403034, -0.277673, -0.0105063, 0.25384, 0.194667, -0.0147572, 0.300432, 0.227387, 0.0113279, 0.00654458, -0.251799, -0.171995, -0.599563, -0.448775, -0.340998, -0.146462, 0.15205, 0.297895, 0.186182, 0.28854, 0.304504, 0.229561, -0.0839903, 0.189423, -0.0414397, -0.18211, -0.434432, -0.210847, -0.267335, 0.198149, 0.245599, 0.152923, 0.319923, 0.207847, 0.128738, 0.188813, 0.152903, 0.211709, -0.0411875, -0.0158818, -0.091184, 0.0344337, 0.0619291, 0.173594, 0.331606}, {-0.110231, -0.058166, -0.0246095, 0.0847248, 0.000226215, 0.0309878, -0.253591, -0.00346268, -0.11473, -0.0515135, 0.0166242, -0.0623933, -0.0144336, -0.00249814, -0.0369374, -0.143281, 0.077316, -0.108957, -0.327709, -0.243525, -0.397126, -0.375104, -0.168803, -0.247805, 0.0652749, 0.0606832, -0.120684, -0.19054, 0.325472, 0.304157, 0.2699, -0.141582, -0.315554, -0.284797, -0.300077, -0.0481785, 0.10554, -0.167279, -0.03997, 0.0277727, 0.134933, 0.373714, 0.211144, 0.463941, 0.0821899, -0.128611, -0.0494739, -0.108296, -0.218272, -0.0980538, -0.152627, -0.0334887, 0.185785, 0.0692784, 0.0632888, 0.306706, 0.198643, -0.0371314, 0.107217, -0.0455264, -0.16401, -0.194662, -0.2058, 0.172032, -0.00266452, 0.134957, -0.066722, 0.124656, -0.12089, -0.0132965, -0.204748, -0.192583, -0.116885, 0.0442177, 0.205535, -0.211847, 0.199047, 0.0704561, 0.151766, 0.164093, -0.149821, -0.215984, -0.290465, -0.299753, -0.332957, 0.0398545, 0.0468287, -0.167095, 0.0473576, 0.0265318, 0.0850324, 0.0679457, -0.0241161, -0.182377, -0.274981, -0.324949, -0.442296, -0.449446, -0.133423, 0.135536, 0.251755, -0.0529152, 0.106682, -0.0220841, -0.040128, 0.0782154, -0.0663921, 0.0281954, -0.519918, -0.250961, -0.200472, 0.124739, 0.196709, 0.194667, 0.306961, 0.0646167, 0.00931753, -0.190567, -0.0100161, -0.398585, 0.022038, -0.231103, -0.0847165, 0.131348, 0.0214985, 0.343913, 0.348616, 0.11861, -0.0962208, -0.0207621, -0.0135401, -0.00189859, -0.00952124, 0.21678, 0.336047, 0.146895, 0.137663, 0.209049, 0.396149, 0.0665577, 0.0844803, -0.0566293, -0.00801997, 0.108354, 0.217139, 0.309442, 0.0983993, 0.283541, 0.441623, 0.383062, 0.399766, 0.244864, 0.185659, -0.179074, -0.089621, 0.0795787, 0.0431022, 0.0259725, -0.0183403, 0.29003, 0.51787, 0.310412, 0.151997, 0.120597, 0.219646, 0.0602622, 0.114649, -0.122642, 0.068149, -0.096791, -0.0499781, 0.0854649, 0.0609135, 0.129271, 0.028095, -0.0329618, -0.0734861, -0.0634691, 0.0637496, 0.0845214, 0.0623627, -0.0873691, 0.0449343, 0.0268447, 0.0499695, 0.0189938, -0.0459544, -0.0398135, -0.108231, -0.0216181, -0.0177345, -0.0930605, -0.0408123, -0.0620553, -0.0982662, -0.0179312, -0.0354373, -0.105775, -0.105401, -0.134713, -0.281546, -0.0678228, -0.197041, 0.19399, 0.00516779, -0.12352, 0.0567236, -0.0771036, -0.0537614, -0.0258924, 0.0751639, -0.189231, -0.10612, -0.191544, -0.133554, -0.0661834, 0.107438, -0.156674, 0.0894238, 0.0668284, -0.0281796, 0.0515542, -0.0790159, -0.0560068, -0.0730611, -0.206544, -0.434441, -0.172244, -0.0136661, -0.208534, 0.163756, -0.161771, -0.0275075, -0.0112088, -0.0860352, -0.108842, -0.129733, -0.0633207, -0.182847, -0.0999821, -0.0369887, 0.235472, 0.137839, 0.014085, 0.0537876, -0.109507, 0.0624982, -0.0380419, -0.0155991, -0.0254021, -0.094163, -0.189153, -0.305319, 0.06709, 0.218999, 0.283673, -0.0672408, 0.10197, 0.102022, 0.0921728, 0.101802, -0.0848752, 0.13251, 0.0743357, -0.1821, -0.365657, -0.0521489, 0.0647026, 0.0685754, 0.120826, 0.156112, -0.0492369, 0.0484361, 0.109391, -0.0192104, 0.0087688, -0.0568502, -0.0567417, -0.0817552, -0.0311521, 0.0768961, 0.33223, 0.379244, 0.0991574, -0.101087, 0.0185815, 0.0790412, 0.0158824, -0.103063, -0.25362, -0.163087, -0.21089, 0.0800173, 0.198341, 0.224685, 0.30595, -0.000144388, -0.0377754, 0.0953305, 0.0152698, 0.0283718, 0.00262186, 0.254342, -0.186935, -0.0268474, -0.0317002, -0.0672759, 0.138353, -0.206226, -0.117871, -0.0734602, 0.0940504, -0.0225347, 0.00225406, 0.0449413, 0.134966, -0.00300768, 0.0989122, 0.14573, -0.146965, 0.0096028, -0.117811, 0.00436831, 0.0668398, 0.00181419, 0.0290525, -0.0985408, 0.00711922, 0.104629, 0.0312987, 0.148324, 0.112125, 0.139843, -0.0486905, -0.0262587, 0.0222665, 0.0316367, 0.0485023, 0.0760349, 0.0901339, 0.0400607, 0.0166896, -0.0398759, -0.0297066, 0.0543799, 0.00383666, 0.018908, 0.0479805, 0.0905023, -0.0600003, -0.0700048, 0.0627658, -0.093381, 0.0579175, 0.010352, 0.160797, 0.196075, 0.0995832, 0.0233722, 0.0598503, -0.00314265, 0.0661097, 0.0443108, -0.0764712, -0.0948125, -0.0315949, -0.0729968, 0.0677334, 0.401411, 0.154427, -0.0118464, 0.082351, 0.140621, 0.106069, -0.158854, 0.0422474, -0.018747, -0.0792397, -0.0400275, 0.18369, -0.0600508, -0.00757795, 0.150198, 0.0380792, -0.150701, -0.1015, 0.0119812, -0.186109, 0.217892, -0.0336287, -0.0851354, 0.0708068, 0.0217349, 0.00543151, -0.238096, -0.103333, 0.166353, 0.00118321, 0.122202, -0.0885628, 0.0538982, -0.0852493, 0.00328418, -0.0900169, 0.0325186, 0.162348, -0.471413, -0.223892, -0.189586, -0.0496744, 0.121368, 0.105059, 0.168773, 0.12135, 0.119297, 0.0885741, 0.075915, 0.099541, -0.171663, -0.117898, -0.393077, -0.432759, -0.0669714, 0.289173, 0.293393, 0.187525, 0.300206, 0.255734, 0.0637245, -0.0910829, -0.000360284, -0.180886, -0.0500542, -0.399042, -0.377026, 0.182579, 0.136213, 0.314779, 0.555756, 0.23861, 0.109475, 0.0375355, 0.0621732, -0.0264966, 0.0701099, -0.300058, -0.196139, -0.295536, 0.0331836, 0.0339536, 0.0985257, 0.190632, 0.227072, -0.178068, 0.0136136, -0.0156695, 0.0139367, -0.0945168, -0.0259007, 0.172429, 0.171919, 0.0145076, -0.131594, 0.153102, -0.328588, 0.0477513, -0.199631, -0.0770189, -0.0074414, -0.155805, -0.119095, 0.271361, 0.287105, -0.0166178, -0.292188, 0.0576719, 0.102927, -0.241618, -0.369257, -0.106469, 0.0598207, 0.0766695, 0.191806, -0.0355737, 0.253408, 0.345459, -0.0143429, -0.295702, -0.436883, -0.125511, -0.308803, 0.0297126, -0.0247307, 0.0501611, -0.0683668, 0.0456642, 0.21348, -0.133336, -0.0355635, -0.209057, -0.316376, -0.464474, -0.250853, -0.0569427, 0.107572, -0.0330427, -0.0832292, -0.0229827, 0.0600777, -0.0623217, -0.0302898, 0.0464364, 0.0224918, 0.030419, 0.00561236, -0.0792506, 0.0786868, 0.0555637, -0.0479785, -0.0855604, -0.0552099, -0.0720804, -0.0448381, -0.107295, -0.0158103, -0.024716, -0.10708, 0.0549539, -0.00640691, -0.098346, -0.0141465, 0.0880013, -0.013645, -0.0105181, -0.121495, -0.129129, -0.417559, -0.460559, -0.437173, -0.354456, 0.0891507, 0.170555, 0.186059, -0.0195755, 0.00384605, -0.0629188, -0.0303643, -0.242029, -0.219625, -0.349223, -0.623971, -0.304686, -0.123608, 0.0434211, 0.132731, 0.391398, 0.312301, -0.0668895, -0.0918756, 0.00300482, 0.0073452, -0.249184, -0.0694157, -0.192096, -0.160038, 0.0788713, -0.0091976, 0.0764525, 0.0556613, 0.385107, 0.515495, 0.0088227, 0.105112, 0.012613, 0.0806373, 0.0800527, 0.0201997, 0.296077, 0.0621368, -0.259671, -0.225124, 0.0666451, 0.161348, 0.126421, -0.0670345, 0.267521, 0.004771, 0.373469, 0.284176, 0.309358, 0.308358, 0.00349119, 0.0363936, -0.0236176, -0.201525, 0.140296, -0.0982317, -0.0375113, 0.223096, -0.0868581, 0.248999, 0.37164, 0.513592, 0.121081, 0.0204934, -0.0470705, -0.0900548, -0.0662731, 0.110876, -0.0996939, -0.0418404, 0.136539, -0.144268, 0.327994, 0.0924618, 0.162243, 0.0366207, -0.145281, 0.0231027, 0.0733599, -0.0941575, 0.321856, -0.0749862, -0.0744019, -0.0885943, 0.0393031, 0.155794, -0.0428074, 0.188518, -0.0984192, 0.205524, 0.26158, 0.0643699, 0.404607, 0.00635867, -0.0772118, -0.0517015, -0.139402, -0.174343, -0.093234, -0.209436, -0.0837766, 0.0465297, 0.148688, 0.259957, -0.0427422, 0.216621, 0.253239, 0.147986, 0.0771361, 0.00971389, 0.0821895, -0.10553, 0.199697, -0.0730068, 0.112639, 0.299339, 0.368627, 0.485142, 0.435607, 0.177175, 0.0995407, 0.0445258, -0.0824981, 0.157142, -0.0875903, -0.00719934, -0.155349, 0.12489, 0.294218, 0.065542, -0.0836114, 0.415874, 0.00946433, -0.0714552, -0.0539451, 0.0607323, -0.0447893, 0.0974045, -0.0225203, -0.0901835, -0.0723594, 0.070698, -0.0417988, 0.00186892, -0.0785503, -0.0958498, -0.07258, 0.0712905, 0.0775738, -0.0086909, 0.0730186, -0.104796, -0.0446421, 0.0254519, 0.229564, 0.152041, 0.0323561, -0.0684714, 0.0217913, -0.0692705, -0.086659, -0.0623716, 0.0610462, 0.105968, -0.100956, -0.0919137, 0.11282, 0.202033, -0.0432816, 0.244889, 0.254089, -0.0017963, -0.0628048, -0.00808759, 0.00129673, -0.140808, -0.102445, -0.0631884, -0.389449, 0.166963, 0.0362426, 0.112959, 0.166291, 0.03232, 0.228164, 0.145817, 0.0919212, -0.0396, -0.115662, 0.114561, 0.205078, -0.209426, 0.0185062, 0.24624, 0.0952083, 0.235379, 0.194399, 0.319253, 0.165042, -0.0426654, 0.0672769, 0.0945624, -0.0944018, 0.218814, 0.0799396, 0.00829958, 0.216404, -0.0801048, -0.128014, 0.0486292, 0.164882, -0.0738192, 0.0236731, -0.0595317, 0.0522255, 0.17015, 0.139568, -0.116842, 0.0744044, 0.0857124, -0.27125, -0.333101, -0.12248, 0.141204, 0.022936, -0.0953206, -0.0563657, -0.0671875, -0.113421, -0.106081, -0.202191, 0.0475425, -0.047682, -0.373381, -0.377673, -0.167392, 0.137757, -0.130397, -0.0474032, 0.121374, -0.00528678, 0.00146283, -0.0451426, 0.453189, 0.116025, -0.145174, -0.345893, -0.32306, -0.0769471, 0.119592, -0.0337247, 0.018355, 0.0232713, -0.0933398, 0.0835199, 0.104679, 0.076251, -0.00359985, -0.465648, -0.159609, -0.355106, -0.0184807, -0.160906, 0.0762013, -0.015793, 0.0231951, 0.0457532, -0.0986956, -0.01168, 0.0509553, 0.0491563, -0.264497, -0.214675, -0.250871, 0.0233887, 0.0993078, -0.00125895, -0.04649, 0.0759786, -0.0221005, -0.0543583, -0.040267, -0.0497286, -0.308701, -0.325294, -0.0111254, 0.0678278, 0.246434, 0.1354, -0.105953, -0.0484916, 0.0101271, -0.0615829, 0.00947083, -0.022861, -0.112744, -0.16695, -0.0893259, -0.113554, -0.155294, 0.0938119, 0.0638268, 0.135649, 0.0190573, -0.0210143, -0.0796615, -0.0439605, -0.0256635, 0.0153128, 0.0407825, 0.019985, 0.0544583, 0.0988293, -0.0789147, -0.044212, 0.014234, -0.0331634, 0.01994, 0.0553283, 0.0363619, -0.054999, 0.143122, 0.451478, 0.402902, 0.169503, -0.062202, 0.014205, 0.0404712, -0.0843094, 0.0502082, 0.00356572, -0.0323461, -0.120139, -0.222177, 0.282168, 0.217892, 0.411936, 0.242319, 0.120661, -0.0948592, -0.0237398, -0.04, 0.075126, -0.00684386, -0.104875, 0.0100912, 0.149519, -0.0876838, 0.128813, -0.0190259, 0.277127, 0.122172, -0.0859988, -0.00964501, -0.386634, -0.00809465, 0.0658588, -0.0760987, -0.156927, -0.119742, -0.198176, -0.0910263, 0.173395, 0.00340086, 0.0144419, -0.0240913, -0.121576, -0.00722314, 0.161154, 0.0302329, -0.27954, -0.025538, -0.0292416, -0.156849, 0.172159, -0.00521385, 0.041752, 0.083937, 0.0933934, -0.205896, 0.172922, 0.0244758, -0.115915, -0.17428, -0.379842, -0.0426616, -0.050484, -0.0480561, 0.0994807, 0.0186704, -0.0174506, 0.0250614, -0.295082, -0.154169, -0.114188, -0.000417598, 0.0329638, 0.00457824, 0.108698, 0.070435, 0.184861, -0.0336052, 0.225645, -0.105043, -0.220382, -0.219997, -0.192208, 0.0163084, -0.25166, -0.0900173, -0.0276362, 0.197379, 0.134054, 0.319927, -0.071301, 0.159358, -0.284144, -0.378819, -0.588863, -0.437624, 0.00452026, -0.104712, -0.272218, -0.107709, 0.174972, 0.354272, 0.321119, -0.255071, -0.181353, -0.228696, -0.317797, -0.272364, 0.0307762, -0.192401, -0.0465898, 0.0359233, 0.114955, 0.273721, 0.410014, 0.186092, -0.150271, -0.0992219, -0.226866, -0.123303, -0.215314, 0.0546799, 0.0886602, 0.0602501, 0.0441162, 0.0702056, 0.00861271, 0.218872, -0.108257, 0.0327091, -0.167359, -0.200805, -0.16722, -0.0611625, 0.154302, 0.0808309, -0.0421033, 0.200983, -0.111736, 0.0418515, -0.249279, -0.0891854, -0.277929, -0.159113, -0.2682, -0.261631, -0.250102, 0.00445095, -0.0259459, 0.0747577, 0.0681983, -0.0460673, -0.0574571, 0.139265, 0.243074, 0.187138, 0.12739, 0.0511632, 0.00918599, -0.0697192, -0.00127755, -0.0235535, 0.000284842, -0.066782, -0.000964865, 0.146305, -0.0111973, 0.175025, 0.281919, 0.106704, 0.225145, 0.298862, 0.209506, -0.025297, -0.0352552, -0.0663385, 0.0764289, 0.158424, -0.104437, 0.148723, -0.407115, -0.271012, 0.0318978, 0.158692, 0.162493, 0.177065, 0.257827, -0.025088, -0.0620147, 0.00720589, -0.0948462, -0.141116, -0.265663, -0.170487, -0.384881, -0.0331876, -0.250113, -0.107303, -0.189262, 0.373792, 0.169551, -0.0826242, -0.203967, -0.168728, -0.169655, -0.220324, -0.387527, -0.40805, -0.0722223, -0.303076, 0.0637521, -0.0465438, -0.0185638, 0.0569804, 0.0702967, -0.183349, -0.0273441, -0.0667816, -0.0175092, -0.292983, -0.381743, 0.0343142, -0.146956, -0.276318, -0.224709, -0.0679757, 0.0780799, -0.116512, -0.0114197, -0.139597, -0.358438, 0.275863, -0.0893285, -0.479743, 0.252271, -0.186055, -0.152431, 0.0176326, 0.0309486, -0.154281, 0.0699729, -0.185291, 0.0726254, 0.0598415, -0.00232426, 0.00215241, 0.0653233, -0.356134, 0.101398, -0.286061, 0.00986613, 0.232018, 0.10211, 0.106159, 0.0550304, -0.100993, 0.107772, 0.357115, 0.055102, -0.125954, -0.367401, -0.104719, -0.161819, -0.141577, 0.114607, 0.206952, -0.0511616, 0.154907, 0.273569, 0.275559, 0.419481, 0.458338, -0.0298772, 0.152911, -0.00966232, -0.258781, 0.194962, 0.112706, 0.200284, 0.160248, 0.216327, -0.00290099, 0.0913252, 0.372489, 0.343192, 0.374835, 0.160664, 0.445481, 0.308761, -0.0346251, 0.0424381, -0.0265812, -0.0300012, 0.0698418, 0.0984377, 0.0241521, -0.0136249, 0.110102, -0.184374, -0.0399704, 0.161887, 0.0365226, 0.218079, -0.0615673, 0.077652, 0.114592, -0.148958, -0.0261201, -0.150427, -0.485637, -0.329915, -0.158248, -0.313825, -0.299952, -0.173759, -0.287376, 0.0840513, 0.0548231, 0.111073, 0.126655, 0.137963, -0.0299289, 0.0874055, 0.0381863, 0.0877502, 0.0507239, 0.0466572, -0.0203591, 0.127802, 0.0619871, 0.0473431, -0.0281506, 0.13856, 0.132078, 0.161775, 0.039332, 0.0624328, 0.135818, -0.0879728, 0.0764349, -0.0575497, 0.236467, 0.0794018, 0.0640269, 0.04662, 0.174662, -0.0600891, 0.0349293, -0.477672, -0.213545, -0.357743, -0.400273, -0.246147, -0.0571877, 0.205297, 0.222109, 0.199967, 0.0658254, 0.169213, -0.0702537, -0.134313, -0.251895, -0.105872, -0.775885, -0.622325, -0.477728, -0.210059, -0.0703698, 0.280788, 0.100912, -0.00707374, 0.0601445, -0.0201929, 0.204917, 0.0753011, -0.424097, -0.814196, -0.551763, -0.295691, 0.209053, 0.0386004, 0.0323571, 0.0934602, -0.0646222, 0.0484611, -0.184167, 0.121614, -0.216656, -0.65351, -0.844003, -0.514034, -0.021677, -0.020655, 0.195855, 0.0497651, 0.117307, 0.171791, 0.156464, -0.129567, 0.00745148, -0.262648, -0.373755, -0.401564, -0.523502, 0.0856164, 0.179375, 0.0513061, 0.19164, -0.054067, 0.0142242, 0.233357, -0.0455738, 0.33766, 0.163167, -0.372095, -0.228857, -0.335369, 0.253077, 0.0205307, 0.0300499, 0.15244, 0.27311, 0.0682521, 0.28562, 0.0552709, 0.00761028, -0.187573, -0.223987, -0.234068, -0.0379324, 0.0375321, 0.264479, 0.326012, 0.0987641, 0.199472, 0.0424864, 0.0892304, 0.155351, -0.0700213, 0.0943489, -0.195619, 0.0654667, 0.183249, 0.234066, 0.492864, 0.373168, 0.0494854, 0.0131986, 0.128487, 0.127085, 0.161386, 0.278461, -0.0955422, 0.076131, 0.0101152, 0.322971, 0.322503, 0.35775, -0.00596848, -0.0685714, 0.0328922, -0.0386107, -0.0816127, -0.0641838, 0.114002, -0.0577785, -0.327414, 0.169918, -0.10391, -0.0414062, -0.0235644, -0.0453229, -0.148246, -0.0651216, 0.0883689, -0.0342262, 0.0596476, -0.202748, -0.192755, -0.360992, 0.0529995, -0.0757572, 0.015857, -0.0802542, -0.164659, -0.0465954, -0.0908643}};
const float bias_weights[10] = {-0.0114061, -0.085721, -0.0433665, 0.0521415, -0.108397, -0.149676, 0.110237, -0.141807, 0.133699, 0.0273976};
