#include "mbed.h"
#include <sstream>
#include "easy-connect.h"
#include "https_request.h"
#include "ssl_ca_pem.h"

// For your API Token, refer to "API token" in your application setting page
const char API_TOKEN[] = "api-token";
// Your domain name can be seen in the usage explanation with curl.
const char URL[] = "https://{domain}.cybozu.com/k/v1/record.json";

// app_id, application id, can be checked with your application's URL
// e.g. https://{domain}.cybozu.com/k/2/ -> app_id is 2
int app_id = 1;

#if defined(__CC_ARM)
// To avoid "invalid multibyte character sequence" warning
#pragma diag_suppress 870
#endif

#if !defined(TARGET_WIO_3G)
#error Selected target is not supported.
#endif

// on-board resources
Serial pc(USBTX, USBRX, 115200);
DigitalOut GrovePower(PB_10, 1);

#define D20 (PB_4)

// Grove sensors

// buzzer
DigitalOut buzzer(D38);

// button or touch sensor
InterruptIn btn(D20);
int id = 0;

void push()
{
    id++;
}

// JSON simplicity parser
char* j_paser( const char *buf , char *word , char *out )
{
    int i = 0;
    char *p;
    char _word[64] = "\"\0";

    strcat(_word , word );
    strcat(_word , "\"" );

    p = strstr( (char*)buf , _word ) + 2 + strlen(_word);

    while( (p[i] != ',')&&(p[i] != '\n')&&(p[i] != '"') ) {
        out[i] = p[i];
        i++;
    }
    out[i] = '\0';

    return p;
}

// main method. retrieve data from kintone by HTTP GET
int main()
{
    btn.mode(PullUp);
    btn.fall(push); // set interrupt handler

    NetworkInterface* network = NULL;
    network = easy_connect(true);    // If true, prints out connection details.
    if (!network) {
        pc.printf("\n----- Network Error -----\n");
        return -1;
    }

    pc.printf("\n----- Network Connected -----\n");
    wait(2.0);

    while(1) {
        // Set url
        std::stringstream ss_url;
        std::string s_url(URL);

        ss_url << s_url << "?app=" << app_id << "&id=" << id;
        string url = ss_url.str();
        pc.printf("%s\n", url.c_str());

        pc.printf("\n----- HTTPS GET request -----\n");
        HttpsRequest* get_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_GET, url.c_str());
        get_req->set_header("X-Cybozu-API-Token", API_TOKEN);
        HttpResponse* get_res = get_req->send();

        pc.printf("\n----- HTTPS GET response [%d]-----\n", get_res->get_status_code());

        if(get_res->get_status_code() == 200) {
            pc.printf("\n----- HTTPS GET response 200 -----\n");
            const char* body = get_res->get_body_as_string().c_str();

            pc.printf("%s\n", body);

            // Response JSON parse
            char value[256];

            char* p = j_paser(body, "日付", value);
            j_paser(p,"value", value);
            pc.printf("date:%s\n", value);

            p = j_paser(body, "文字列__1行_", value);
            j_paser(p,"value", value);
            pc.printf("%s\n", value);

            buzzer = 1;
            wait(0.1);
            buzzer = 0;
        }

        delete get_req;
        wait(10.0);
    }
}
