#include "mbed.h"
#include "Grove_LCD_RGB_Backlight.h"
#include "Grove_temperature.h"
#include "WS2812.h"
#include "PixelArray.h"
#include "Servo.h"

#include <sstream>
#include "easy-connect.h"
#include "https_request.h"
#include "ssl_ca_pem.h"

#if !defined(TARGET_WIO_3G)
#error Selected target is not supported.
#endif

#define D20 (PB_4)
#define D19 (PB_3)

// on-board resources

Serial pc(USBTX, USBRX, 115200);
DigitalOut GrovePower(PB_10, 1);

#define WS2812_BUF 8
#define NUM_COLORS 8
#define NUM_LEDS_PER_COLOR 8
#define H0 8
#define L0 32
#define H1 17
#define L1 32
 
DigitalOut LEDPower(PE_8, 1);
PixelArray px(WS2812_BUF);
WS2812 ws(PB_1, WS2812_BUF, H0, L0, H1, L1);

// Grove sensors

DigitalOut led1(D38);
AnalogIn ain(A6); // angle or light sensor
InterruptIn btn(D20); // button or touch sensor
Grove_LCD_RGB_Backlight lcd(I2C_SDA, I2C_SCL);
Grove_temperature temp(A4);

uint32_t button = 0;

void push()
{
    button++;
}


const char API_TOKEN[] = "tfa6Ud9FY760SfLLhHl3UBr0NFdVHEFLHvdjTsrW";
const char URL[] = "https://devzfyjsa.cybozu.com/k/v1/record.json";

int app_id = 1;

// JSON simplicity parser
char* j_paser( const char *buf , char *word , char *out )
{
    int i = 0;
    char *p;
    char _word[64] = "\"\0";

    strcat(_word , word );
    strcat(_word , "\"" );

    p = strstr( (char*)buf , _word ) + 2 + strlen(_word);
    
    while( (p[i] != ',')&&(p[i] != '\n')&&(p[i] != '"') )
    {
        out[i] = p[i];
        i++;
    }
    out[i] = '\0';
    
    return p;
}




int main()
{
    char buf[20];
    btn.fall(push); // set interrupt handler

    lcd.clear();
    lcd.setRGB(0xff, 0x00, 0x00);
    lcd.locate(0, 0);
    lcd.print("Hello World!");
    lcd.locate(0, 1);

    // set up the colours we want to draw with
    const int colorbuf[NUM_COLORS] = {0x000000, 0x2f0000,0x2f2f00,0x002f00,0x002f2f,0x00002f,0x2f002f, 0x2f2f2f};
 
    ::ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling

    // for each of the colours (j) write out 10 of them
    // the pixels are written at the colour*10, plus the colour position
    // all modulus 60 so it wraps around
    for (int i = 0; i < WS2812_BUF; i++) {
        px.Set(i, colorbuf[i]);
        px.SetI(i, 0x80);
    }
 
    pc.printf("hello, Mbed world\n");

    /*
    int cnt = 0;
    int idx = 0;

    while (true) {
        pc.printf("count = %4d, button = %d, analog = %2.2f, temp = %2.2f\n", cnt++, button, ain.read(), temp.getTemperature());
        sprintf(buf, "L=%2.2f, T=%2.2f", ain.read(), temp.getTemperature());
        
        lcd.setRGB(0xff, (255*ain.read()), 0x00);
        lcd.locate(0, 1);
        lcd.print(buf);
        
        led1 = !led1;

        ws.write_offsets(px.getBuf(), idx, idx, idx);
        idx++;
        if (idx >= WS2812_BUF) {
            idx = 0;
        }

        wait(0.5);
    }
    */
    NetworkInterface* network = NULL;

    /*
    pc.baud(115200);

    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Network Connect..");
    */

    pc.printf("\r\n----- Start -----\r\n");
    
    network = easy_connect(true);    // If true, prints out connection details.
    if (!network) {
        //lcd.printf("NG");
        pc.printf("\r\n----- Network Error -----\r\n");
        return -1;
    }

    //lcd.printf("OK");
    pc.printf("\r\n----- Network Connected -----\r\n");
    
    wait(2.0);
    
    while(1){
        int id = 10;
        
        /*
        // ID select
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Please select id.");
        while(fire == 0){
            lcd.locate(0,14);
            lcd.printf("id = ");
            if( up == 1) id++;
            if( down == 1) id--;
            lcd.printf("%d     ",id);
            wait(0.2);
        }
        
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("It is polling with the selected id.");
        */
                
        // Set url
        std::stringstream ss_url;
        std::string s_url(URL);
        
        ss_url << s_url << "?app=" << app_id << "&id=" << id;
        
        string url = ss_url.str();
        
        pc.printf("%s\r\n",url.c_str());
        
        while(1){
            pc.printf("\r\n----- HTTPS GET request -----\r\n");
            HttpsRequest* get_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_GET, url.c_str());
            
            get_req->set_header("X-Cybozu-API-Token", API_TOKEN);
            
            HttpResponse* get_res = get_req->send();
            
            pc.printf("\n----- HTTPS GET response [%d]-----\n",get_res->get_status_code());
            
            if(get_res->get_status_code() == 200){
                pc.printf("\n----- HTTPS GET response 200 -----\n");
                const char* body = get_res->get_body_as_string().c_str();
                
                pc.printf("%s\r\n",body);
                
                // Response JSON parse
                char value[256];
                
                char* p = j_paser(body,"日付",value);
                j_paser(p,"value",value);
                printf("date:%s\r\n",value);
                
                /*
                lcd.cls();
                lcd.locate(0,3);
                lcd.printf("Date:%s",value);
                */
                
                p = j_paser(body,"文字列__1行_",value);
                j_paser(p,"value",value);
                printf("%s\r\n",value);
                
                /*
                lcd.locate(0,14);
                lcd.printf("name:%s",value);
                
                // Sound an alert
                spkr.period(1.0/5000.0);
                spkr=0.5;
                wait(1.0);
                spkr=0.0;
                */
                
                delete get_req;
                
                break;
            }
            
            delete get_req;
            
            wait(10.0);
        }
        
        //while(fire == 0);
        wait(1.0);
    }
}
