#include "mbed.h"
#include "Grove_LCD_RGB_Backlight.h"
#include "Grove_temperature.h"
#include "WS2812.h"
#include "PixelArray.h"
#include "Servo.h"

#if !defined(TARGET_WIO_3G)
#error Selected target is not supported.
#endif

#define D20 (PB_4)
#define D19 (PB_3)

// on-board resources
Serial pc(USBTX, USBRX, 115200);
DigitalOut GrovePower(PB_10, 1);

#define WS2812_BUF 150
#define NUM_COLORS 6
#define NUM_LEDS_PER_COLOR 10

#define H0 8
#define L0 32
#define H1 17
#define L1 32
 
DigitalOut LEDPower(PE_8, 1);
PixelArray px(WS2812_BUF);
WS2812 ws(PB_1, 1, H0, L0, H1, L1);
#if 0
// Grove sensors
DigitalOut led1(D38);
AnalogIn ain(A6); // angle or light sensor
InterruptIn btn(D20); // button or touch sensor
Grove_LCD_RGB_Backlight lcd(I2C_SDA, I2C_SCL);
Grove_temperature temp(A4);
#endif
uint32_t button = 0;


void push()
{
    button++;
}

#if 0

// main() runs in its own thread in the OS
int main()
{
    char buf[20];
    btn.fall(push); // set interrupt handler

    lcd.clear();
    lcd.setRGB(0xff, 0x00, 0x00);
    lcd.locate(0, 0);
    lcd.print("Hello World!");
    lcd.locate(0, 1);

#if 0
    ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling
    int array[4] = (0xff, 0, 0, 0);
    ws.write(array);
#endif

    int cnt = 0;
    pc.printf("hello, Mbed world\n");
    
    while (true) {
        pc.printf("count = %4d, button = %d, analog = %2.2f, temp = %2.2f\n", cnt++, button, ain.read(), temp.getTemperature());
        sprintf(buf, "L=%2.2f, T=%2.2f", ain.read(), temp.getTemperature());
        lcd.setRGB(0xff, (255*ain.read()), 0x00);
        lcd.locate(0, 1);
        lcd.print(buf);
        led1 = !led1;
        wait(0.5);
    }
}

#else
int main()
{
    pc.printf("NeoPixel test.\n");
    pc.printf("%2d, %2d, %2d, %2d\n", H0, L0, H1, L1);
 
    ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling
    
    // set up the colours we want to draw with
    int colorbuf[NUM_COLORS] = {0x2f0000,0x2f2f00,0x002f00,0x002f2f,0x00002f,0x2f002f};
 
    // for each of the colours (j) write out 10 of them
    // the pixels are written at the colour*10, plus the colour position
    // all modulus 60 so it wraps around
    for (int i = 0; i < WS2812_BUF; i++) {
        px.Set(i, colorbuf[(i / NUM_LEDS_PER_COLOR) % NUM_COLORS]);
    }
 
    // now all the colours are computed, add a fade effect using intensity scaling
    // compute and write the II value for each pixel
    for (int j=0; j<WS2812_BUF; j++) {
        // px.SetI(pixel position, II value)
        px.SetI(j%WS2812_BUF, 0xf+(0xf*(j%NUM_LEDS_PER_COLOR)));
    }
 
 
    // Now the buffer is written, rotate it
    // by writing it out with an increasing offset
    while (1) {
        for (int z=WS2812_BUF; z >= 0 ; z--) {
            ws.write_offsets(px.getBuf(),z,z,z);
            wait(0.075);
        }
    }
 
}
#endif

