#include "mbed.h"
#include "Grove_LCD_RGB_Backlight.h"
#include "Grove_temperature.h"

#define D20 (PB_4)
#define D19 (PB_3)

DigitalOut GrovePower(PB_10, 1);
DigitalOut led1(D38);
AnalogIn ain(A6);
InterruptIn btn(D20);
Grove_LCD_RGB_Backlight rgbLCD(I2C_SDA, I2C_SCL);
Grove_temperature temp(A4);

uint32_t button = 0;


void push()
{
    button++;
}

// main() runs in its own thread in the OS
int main()
{
    btn.fall(push);

    rgbLCD.clear();
    rgbLCD.setRGB(0xff, 0x00, 0x00);
    rgbLCD.locate(0, 0);
    rgbLCD.print("Hello World!");
    rgbLCD.locate(0, 1);
    rgbLCD.print("This is a test");

    int cnt = 0;
    printf("hello, Mbed world\n");
    while (true) {
        printf("count = %4d, button = %d, analog = %f, temp = %f\n", cnt++, button, ain.read(), temp.getTemperature());
        led1 = !led1;
        wait(0.5);
    }
}
