#include "mbed.h"
#include "Grove_LCD_RGB_Backlight.h"

#define D20 (PB_4)
#define D19 (PB_3)

DigitalOut GrovePower(PB_10, 1);
DigitalOut led1(D38);
AnalogIn ain(A6);
InterruptIn btn(D20);
Grove_LCD_RGB_Backlight rgbLCD(I2C_SDA, I2C_SCL);

uint32_t button = 0;

///

float get_temp()
{
    const int B = 4275;               // B value of the thermistor
    const int R0 = 100000;            // R0 = 100k
    AnalogIn temp(A4);

    float R = 1.0f/temp.read() - 1.0f;
    R = R0*R;

    float temperature = 1.0/(log(R/R0)/B+1/298.15)-273.15; // convert to temperature via datasheet
    return temperature;
}
///


void push()
{
    button++;
}

// main() runs in its own thread in the OS
int main()
{
    btn.fall(push);

    rgbLCD.clear();
    rgbLCD.setRGB(0xff, 0x00, 0x00);
    rgbLCD.locate(0, 0);
    rgbLCD.print("Hello World!");
    rgbLCD.locate(0, 1);
    rgbLCD.print("This is a test");

    int cnt = 0;
    printf("hello, Mbed world\n");
    while (true) {
        printf("count = %4d, button = %d, analog = %f, temp = %f\n", cnt++, button, ain.read(), get_temp());
        led1 = !led1;
        wait(0.5);
    }
}

