#include "mbed.h"
#include <sstream>
#include "easy-connect.h"
#include "https_request.h"
#include "ssl_ca_pem.h"

#if !defined(TARGET_WIO_3G)
#error Selected target is not supported.
#endif

// on-board resources
Serial pc(USBTX, USBRX, 115200);
DigitalOut GrovePower(PB_10, 1);

#define D20 (PB_4)

// Grove sensors

// buzzer
DigitalOut buzzer(D38);
int buzzer_on = 1, buzzer_off = 0;

// button or touch sensor
InterruptIn btn(D20);
uint32_t button = 0;
int id = 0;

void push()
{
    button++;
    id++;
}

// For your API Token, refer to "API token" in your application setting page
const char API_TOKEN[] = "api-token";
// Your domain name can be seen in the usage explanation with curl. 
const char URL[] = "https://{domain}.cybozu.com/k/v1/record.json";

// app_id, application id, can be checked with your application's URL
// e.g. https://{domain}.cybozu.com/k/2/ -> app_id is 2
int app_id = 1;


// JSON simplicity parser
char* j_paser( const char *buf , char *word , char *out )
{
    int i = 0;
    char *p;
    char _word[64] = "\"\0";

    strcat(_word , word );
    strcat(_word , "\"" );

    p = strstr( (char*)buf , _word ) + 2 + strlen(_word);
    
    while( (p[i] != ',')&&(p[i] != '\n')&&(p[i] != '"') )
    {
        out[i] = p[i];
        i++;
    }
    out[i] = '\0';
    
    return p;
}

// main method. retrieve data from Kintone by HTTP GET
int main()
{
    char buf[20];
    btn.fall(push); // set interrupt handler

    pc.printf("Greetings from Ina-city Hackerthon on 25-26 of August\n");
    
    NetworkInterface* network = NULL;

    pc.printf("\r\n----- Start -----\r\n");
    
    network = easy_connect(true);    // If true, prints out connection details.
    if (!network) {
        pc.printf("\r\n----- Network Error -----\r\n");
        return -1;
    }

    pc.printf("\r\n----- Network Connected -----\r\n");
    
    wait(2.0);
    
    while(1){
        
        while(1){
            // Set url
            std::stringstream ss_url;
            std::string s_url(URL);
            
            ss_url << s_url << "?app=" << app_id << "&id=" << id;
            string url = ss_url.str();
            
            pc.printf("%s\r\n",url.c_str());
            
            pc.printf("\r\n----- HTTPS GET request -----\r\n");
            HttpsRequest* get_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_GET, url.c_str());
            
            get_req->set_header("X-Cybozu-API-Token", API_TOKEN);
            
            HttpResponse* get_res = get_req->send();
            
            pc.printf("\n----- HTTPS GET response [%d]-----\n",get_res->get_status_code());
            
            if(get_res->get_status_code() == 200){
                pc.printf("\n----- HTTPS GET response 200 -----\n");
                const char* body = get_res->get_body_as_string().c_str();
                
                pc.printf("%s\r\n",body);
                
                // Response JSON parse
                char value[256];
                
                char* p = j_paser(body,"日付",value);
                j_paser(p,"value",value);
                printf("date:%s\r\n",value);
                
                p = j_paser(body,"文字列__1行_",value);
                j_paser(p,"value",value);
                printf("%s\r\n",value);
                
                int buzz_flag = 1;
                while(buzz_flag){
                    buzzer = buzzer_on;
                    wait(.5);
                    buzzer = buzzer_off;
                    wait(.5);
                    buzz_flag = 0;
                }
                
                delete get_req;
                
                break;
            }
            
            delete get_req;
            
            wait(10.0);
        }
           
        wait(1.0);
    }
}
