/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_ADC_REGISTERS_H__
#define __HW_ADC_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 ADC
 *
 * Analog-to-Digital Converter
 *
 * Registers defined in this header file:
 * - HW_ADC_SC1n - ADC Status and Control Registers 1
 * - HW_ADC_CFG1 - ADC Configuration Register 1
 * - HW_ADC_CFG2 - ADC Configuration Register 2
 * - HW_ADC_Rn - ADC Data Result Register
 * - HW_ADC_CV1 - Compare Value Registers
 * - HW_ADC_CV2 - Compare Value Registers
 * - HW_ADC_SC2 - Status and Control Register 2
 * - HW_ADC_SC3 - Status and Control Register 3
 * - HW_ADC_OFS - ADC Offset Correction Register
 * - HW_ADC_PG - ADC Plus-Side Gain Register
 * - HW_ADC_MG - ADC Minus-Side Gain Register
 * - HW_ADC_CLPD - ADC Plus-Side General Calibration Value Register
 * - HW_ADC_CLPS - ADC Plus-Side General Calibration Value Register
 * - HW_ADC_CLP4 - ADC Plus-Side General Calibration Value Register
 * - HW_ADC_CLP3 - ADC Plus-Side General Calibration Value Register
 * - HW_ADC_CLP2 - ADC Plus-Side General Calibration Value Register
 * - HW_ADC_CLP1 - ADC Plus-Side General Calibration Value Register
 * - HW_ADC_CLP0 - ADC Plus-Side General Calibration Value Register
 * - HW_ADC_CLMD - ADC Minus-Side General Calibration Value Register
 * - HW_ADC_CLMS - ADC Minus-Side General Calibration Value Register
 * - HW_ADC_CLM4 - ADC Minus-Side General Calibration Value Register
 * - HW_ADC_CLM3 - ADC Minus-Side General Calibration Value Register
 * - HW_ADC_CLM2 - ADC Minus-Side General Calibration Value Register
 * - HW_ADC_CLM1 - ADC Minus-Side General Calibration Value Register
 * - HW_ADC_CLM0 - ADC Minus-Side General Calibration Value Register
 *
 * - hw_adc_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_ADC_BASE
#define HW_ADC_INSTANCE_COUNT (2U) //!< Number of instances of the ADC module.
#define HW_ADC0 (0U) //!< Instance number for ADC0.
#define HW_ADC1 (1U) //!< Instance number for ADC1.
#define REGS_ADC0_BASE (0x4003B000U) //!< Base address for ADC0.
#define REGS_ADC1_BASE (0x400BB000U) //!< Base address for ADC1.

//! @brief Table of base addresses for ADC instances.
static const uint32_t __g_regs_ADC_base_addresses[] = {
        REGS_ADC0_BASE,
        REGS_ADC1_BASE,
    };

//! @brief Get the base address of ADC by instance number.
//! @param x ADC instance number, from 0 through 1.
#define REGS_ADC_BASE(x) (__g_regs_ADC_base_addresses[(x)])

//! @brief Get the instance number given a base address.
//! @param b Base address for an instance of ADC.
#define REGS_ADC_INSTANCE(b) ((b) == REGS_ADC0_BASE ? HW_ADC0 : (b) == REGS_ADC1_BASE ? HW_ADC1 : 0)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_SC1n - ADC Status and Control Registers 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_SC1n - ADC Status and Control Registers 1 (RW)
 *
 * Reset value: 0x0000001FU
 *
 * SC1A is used for both software and hardware trigger modes of operation. To
 * allow sequential conversions of the ADC to be triggered by internal peripherals,
 * the ADC can have more than one status and control register: one for each
 * conversion. The SC1B-SC1n registers indicate potentially multiple SC1 registers
 * for use only in hardware trigger mode. See the chip configuration information
 * about the number of SC1n registers specific to this device. The SC1n registers
 * have identical fields, and are used in a "ping-pong" approach to control ADC
 * operation. At any one point in time, only one of the SC1n registers is actively
 * controlling ADC conversions. Updating SC1A while SC1n is actively controlling
 * a conversion is allowed, and vice-versa for any of the SC1n registers specific
 * to this MCU. Writing SC1A while SC1A is actively controlling a conversion
 * aborts the current conversion. In Software Trigger mode, when SC2[ADTRG]=0,
 * writes to SC1A subsequently initiate a new conversion, if SC1[ADCH] contains a
 * value other than all 1s. Writing any of the SC1n registers while that specific
 * SC1n register is actively controlling a conversion aborts the current conversion.
 * None of the SC1B-SC1n registers are used for software trigger operation and
 * therefore writes to the SC1B-SC1n registers do not initiate a new conversion.
 */
typedef union _hw_adc_sc1n
{
    uint32_t U;
    struct _hw_adc_sc1n_bitfields
    {
        uint32_t ADCH : 5;             //!< [4:0] Input channel select
        uint32_t DIFF : 1;             //!< [5] Differential Mode Enable
        uint32_t AIEN : 1;             //!< [6] Interrupt Enable
        uint32_t COCO : 1;             //!< [7] Conversion Complete Flag
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_adc_sc1n_t;
#endif

/*!
 * @name Constants and macros for entire ADC_SC1n register
 */
//@{
#define HW_ADC_SC1n_COUNT (2U)

#define HW_ADC_SC1n_ADDR(x, n)   (REGS_ADC_BASE(x) + 0x0U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_ADC_SC1n(x, n)        (*(__IO hw_adc_sc1n_t *) HW_ADC_SC1n_ADDR(x, n))
#define HW_ADC_SC1n_RD(x, n)     (HW_ADC_SC1n(x, n).U)
#define HW_ADC_SC1n_WR(x, n, v)  (HW_ADC_SC1n(x, n).U = (v))
#define HW_ADC_SC1n_SET(x, n, v) (HW_ADC_SC1n_WR(x, n, HW_ADC_SC1n_RD(x, n) |  (v)))
#define HW_ADC_SC1n_CLR(x, n, v) (HW_ADC_SC1n_WR(x, n, HW_ADC_SC1n_RD(x, n) & ~(v)))
#define HW_ADC_SC1n_TOG(x, n, v) (HW_ADC_SC1n_WR(x, n, HW_ADC_SC1n_RD(x, n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_SC1n bitfields
 */

/*!
 * @name Register ADC_SC1n, field ADCH[4:0] (RW)
 *
 * Selects one of the input channels. The input channel decode depends on the
 * value of DIFF. DAD0-DAD3 are associated with the input pin pairs DADPx and
 * DADMx. Some of the input channel options in the bitfield-setting descriptions might
 * not be available for your device. For the actual ADC channel assignments for
 * your device, see the Chip Configuration details. The successive approximation
 * converter subsystem is turned off when the channel select bits are all set,
 * that is, ADCH = 11111. This feature allows explicit disabling of the ADC and
 * isolation of the input channel from all sources. Terminating continuous
 * conversions this way prevents an additional single conversion from being performed. It
 * is not necessary to set ADCH to all 1s to place the ADC in a low-power state
 * when continuous conversions are not enabled because the module automatically
 * enters a low-power state when a conversion completes.
 *
 * Values:
 * - 00000 - When DIFF=0, DADP0 is selected as input; when DIFF=1, DAD0 is
 *     selected as input.
 * - 00001 - When DIFF=0, DADP1 is selected as input; when DIFF=1, DAD1 is
 *     selected as input.
 * - 00010 - When DIFF=0, DADP2 is selected as input; when DIFF=1, DAD2 is
 *     selected as input.
 * - 00011 - When DIFF=0, DADP3 is selected as input; when DIFF=1, DAD3 is
 *     selected as input.
 * - 00100 - When DIFF=0, AD4 is selected as input; when DIFF=1, it is reserved.
 * - 00101 - When DIFF=0, AD5 is selected as input; when DIFF=1, it is reserved.
 * - 00110 - When DIFF=0, AD6 is selected as input; when DIFF=1, it is reserved.
 * - 00111 - When DIFF=0, AD7 is selected as input; when DIFF=1, it is reserved.
 * - 01000 - When DIFF=0, AD8 is selected as input; when DIFF=1, it is reserved.
 * - 01001 - When DIFF=0, AD9 is selected as input; when DIFF=1, it is reserved.
 * - 01010 - When DIFF=0, AD10 is selected as input; when DIFF=1, it is reserved.
 * - 01011 - When DIFF=0, AD11 is selected as input; when DIFF=1, it is reserved.
 * - 01100 - When DIFF=0, AD12 is selected as input; when DIFF=1, it is reserved.
 * - 01101 - When DIFF=0, AD13 is selected as input; when DIFF=1, it is reserved.
 * - 01110 - When DIFF=0, AD14 is selected as input; when DIFF=1, it is reserved.
 * - 01111 - When DIFF=0, AD15 is selected as input; when DIFF=1, it is reserved.
 * - 10000 - When DIFF=0, AD16 is selected as input; when DIFF=1, it is reserved.
 * - 10001 - When DIFF=0, AD17 is selected as input; when DIFF=1, it is reserved.
 * - 10010 - When DIFF=0, AD18 is selected as input; when DIFF=1, it is reserved.
 * - 10011 - When DIFF=0, AD19 is selected as input; when DIFF=1, it is reserved.
 * - 10100 - When DIFF=0, AD20 is selected as input; when DIFF=1, it is reserved.
 * - 10101 - When DIFF=0, AD21 is selected as input; when DIFF=1, it is reserved.
 * - 10110 - When DIFF=0, AD22 is selected as input; when DIFF=1, it is reserved.
 * - 10111 - When DIFF=0, AD23 is selected as input; when DIFF=1, it is reserved.
 * - 11000 - Reserved.
 * - 11001 - Reserved.
 * - 11010 - When DIFF=0, Temp Sensor (single-ended) is selected as input; when
 *     DIFF=1, Temp Sensor (differential) is selected as input.
 * - 11011 - When DIFF=0, Bandgap (single-ended) is selected as input; when
 *     DIFF=1, Bandgap (differential) is selected as input.
 * - 11100 - Reserved.
 * - 11101 - When DIFF=0,VREFSH is selected as input; when DIFF=1, -VREFSH
 *     (differential) is selected as input. Voltage reference selected is determined
 *     by SC2[REFSEL].
 * - 11110 - When DIFF=0,VREFSL is selected as input; when DIFF=1, it is
 *     reserved. Voltage reference selected is determined by SC2[REFSEL].
 * - 11111 - Module is disabled.
 */
//@{
#define BP_ADC_SC1n_ADCH     (0U)          //!< Bit position for ADC_SC1n_ADCH.
#define BM_ADC_SC1n_ADCH     (0x0000001FU) //!< Bit mask for ADC_SC1n_ADCH.
#define BS_ADC_SC1n_ADCH     (5U)          //!< Bit field size in bits for ADC_SC1n_ADCH.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC1n_ADCH field.
#define BR_ADC_SC1n_ADCH(x, n) (HW_ADC_SC1n(x, n).B.ADCH)
#endif

//! @brief Format value for bitfield ADC_SC1n_ADCH.
#define BF_ADC_SC1n_ADCH(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC1n_ADCH), uint32_t) & BM_ADC_SC1n_ADCH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADCH field to a new value.
#define BW_ADC_SC1n_ADCH(x, n, v) (HW_ADC_SC1n_WR(x, n, (HW_ADC_SC1n_RD(x, n) & ~BM_ADC_SC1n_ADCH) | BF_ADC_SC1n_ADCH(v)))
#endif
//@}

/*!
 * @name Register ADC_SC1n, field DIFF[5] (RW)
 *
 * Configures the ADC to operate in differential mode. When enabled, this mode
 * automatically selects from the differential channels, and changes the
 * conversion algorithm and the number of cycles to complete a conversion.
 *
 * Values:
 * - 0 - Single-ended conversions and input channels are selected.
 * - 1 - Differential conversions and input channels are selected.
 */
//@{
#define BP_ADC_SC1n_DIFF     (5U)          //!< Bit position for ADC_SC1n_DIFF.
#define BM_ADC_SC1n_DIFF     (0x00000020U) //!< Bit mask for ADC_SC1n_DIFF.
#define BS_ADC_SC1n_DIFF     (1U)          //!< Bit field size in bits for ADC_SC1n_DIFF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC1n_DIFF field.
#define BR_ADC_SC1n_DIFF(x, n) (BITBAND_ACCESS32(HW_ADC_SC1n_ADDR(x, n), BP_ADC_SC1n_DIFF))
#endif

//! @brief Format value for bitfield ADC_SC1n_DIFF.
#define BF_ADC_SC1n_DIFF(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC1n_DIFF), uint32_t) & BM_ADC_SC1n_DIFF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DIFF field to a new value.
#define BW_ADC_SC1n_DIFF(x, n, v) (BITBAND_ACCESS32(HW_ADC_SC1n_ADDR(x, n), BP_ADC_SC1n_DIFF) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC1n, field AIEN[6] (RW)
 *
 * Enables conversion complete interrupts. When COCO becomes set while the
 * respective AIEN is high, an interrupt is asserted.
 *
 * Values:
 * - 0 - Conversion complete interrupt is disabled.
 * - 1 - Conversion complete interrupt is enabled.
 */
//@{
#define BP_ADC_SC1n_AIEN     (6U)          //!< Bit position for ADC_SC1n_AIEN.
#define BM_ADC_SC1n_AIEN     (0x00000040U) //!< Bit mask for ADC_SC1n_AIEN.
#define BS_ADC_SC1n_AIEN     (1U)          //!< Bit field size in bits for ADC_SC1n_AIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC1n_AIEN field.
#define BR_ADC_SC1n_AIEN(x, n) (BITBAND_ACCESS32(HW_ADC_SC1n_ADDR(x, n), BP_ADC_SC1n_AIEN))
#endif

//! @brief Format value for bitfield ADC_SC1n_AIEN.
#define BF_ADC_SC1n_AIEN(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC1n_AIEN), uint32_t) & BM_ADC_SC1n_AIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AIEN field to a new value.
#define BW_ADC_SC1n_AIEN(x, n, v) (BITBAND_ACCESS32(HW_ADC_SC1n_ADDR(x, n), BP_ADC_SC1n_AIEN) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC1n, field COCO[7] (RO)
 *
 * This is a read-only field that is set each time a conversion is completed
 * when the compare function is disabled, or SC2[ACFE]=0 and the hardware average
 * function is disabled, or SC3[AVGE]=0. When the compare function is enabled, or
 * SC2[ACFE]=1, COCO is set upon completion of a conversion only if the compare
 * result is true. When the hardware average function is enabled, or SC3[AVGE]=1,
 * COCO is set upon completion of the selected number of conversions (determined
 * by AVGS). COCO in SC1A is also set at the completion of a calibration sequence.
 * COCO is cleared when the respective SC1n register is written or when the
 * respective Rn register is read.
 *
 * Values:
 * - 0 - Conversion is not completed.
 * - 1 - Conversion is completed.
 */
//@{
#define BP_ADC_SC1n_COCO     (7U)          //!< Bit position for ADC_SC1n_COCO.
#define BM_ADC_SC1n_COCO     (0x00000080U) //!< Bit mask for ADC_SC1n_COCO.
#define BS_ADC_SC1n_COCO     (1U)          //!< Bit field size in bits for ADC_SC1n_COCO.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC1n_COCO field.
#define BR_ADC_SC1n_COCO(x, n) (BITBAND_ACCESS32(HW_ADC_SC1n_ADDR(x, n), BP_ADC_SC1n_COCO))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CFG1 - ADC Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CFG1 - ADC Configuration Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The configuration Register 1 (CFG1) selects the mode of operation, clock
 * source, clock divide, and configuration for low power or long sample time.
 */
typedef union _hw_adc_cfg1
{
    uint32_t U;
    struct _hw_adc_cfg1_bitfields
    {
        uint32_t ADICLK : 2;           //!< [1:0] Input Clock Select
        uint32_t MODE : 2;             //!< [3:2] Conversion mode selection
        uint32_t ADLSMP : 1;           //!< [4] Sample Time Configuration
        uint32_t ADIV : 2;             //!< [6:5] Clock Divide Select
        uint32_t ADLPC : 1;            //!< [7] Low-Power Configuration
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_adc_cfg1_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CFG1 register
 */
//@{
#define HW_ADC_CFG1_ADDR(x)      (REGS_ADC_BASE(x) + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CFG1(x)           (*(__IO hw_adc_cfg1_t *) HW_ADC_CFG1_ADDR(x))
#define HW_ADC_CFG1_RD(x)        (HW_ADC_CFG1(x).U)
#define HW_ADC_CFG1_WR(x, v)     (HW_ADC_CFG1(x).U = (v))
#define HW_ADC_CFG1_SET(x, v)    (HW_ADC_CFG1_WR(x, HW_ADC_CFG1_RD(x) |  (v)))
#define HW_ADC_CFG1_CLR(x, v)    (HW_ADC_CFG1_WR(x, HW_ADC_CFG1_RD(x) & ~(v)))
#define HW_ADC_CFG1_TOG(x, v)    (HW_ADC_CFG1_WR(x, HW_ADC_CFG1_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CFG1 bitfields
 */

/*!
 * @name Register ADC_CFG1, field ADICLK[1:0] (RW)
 *
 * Selects the input clock source to generate the internal clock, ADCK. Note
 * that when the ADACK clock source is selected, it is not required to be active
 * prior to conversion start. When it is selected and it is not active prior to a
 * conversion start, when CFG2[ADACKEN]=0, the asynchronous clock is activated at
 * the start of a conversion and deactivated when conversions are terminated. In
 * this case, there is an associated clock startup delay each time the clock
 * source is re-activated.
 *
 * Values:
 * - 00 - Bus clock
 * - 01 - Alternate clock 2 (ALTCLK2)
 * - 10 - Alternate clock (ALTCLK)
 * - 11 - Asynchronous clock (ADACK)
 */
//@{
#define BP_ADC_CFG1_ADICLK   (0U)          //!< Bit position for ADC_CFG1_ADICLK.
#define BM_ADC_CFG1_ADICLK   (0x00000003U) //!< Bit mask for ADC_CFG1_ADICLK.
#define BS_ADC_CFG1_ADICLK   (2U)          //!< Bit field size in bits for ADC_CFG1_ADICLK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG1_ADICLK field.
#define BR_ADC_CFG1_ADICLK(x) (HW_ADC_CFG1(x).B.ADICLK)
#endif

//! @brief Format value for bitfield ADC_CFG1_ADICLK.
#define BF_ADC_CFG1_ADICLK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG1_ADICLK), uint32_t) & BM_ADC_CFG1_ADICLK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADICLK field to a new value.
#define BW_ADC_CFG1_ADICLK(x, v) (HW_ADC_CFG1_WR(x, (HW_ADC_CFG1_RD(x) & ~BM_ADC_CFG1_ADICLK) | BF_ADC_CFG1_ADICLK(v)))
#endif
//@}

/*!
 * @name Register ADC_CFG1, field MODE[3:2] (RW)
 *
 * Selects the ADC resolution mode.
 *
 * Values:
 * - 00 - When DIFF=0:It is single-ended 8-bit conversion; when DIFF=1, it is
 *     differential 9-bit conversion with 2's complement output.
 * - 01 - When DIFF=0:It is single-ended 12-bit conversion ; when DIFF=1, it is
 *     differential 13-bit conversion with 2's complement output.
 * - 10 - When DIFF=0:It is single-ended 10-bit conversion. ; when DIFF=1, it is
 *     differential 11-bit conversion with 2's complement output
 * - 11 - When DIFF=0:It is single-ended 16-bit conversion..; when DIFF=1, it is
 *     differential 16-bit conversion with 2's complement output
 */
//@{
#define BP_ADC_CFG1_MODE     (2U)          //!< Bit position for ADC_CFG1_MODE.
#define BM_ADC_CFG1_MODE     (0x0000000CU) //!< Bit mask for ADC_CFG1_MODE.
#define BS_ADC_CFG1_MODE     (2U)          //!< Bit field size in bits for ADC_CFG1_MODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG1_MODE field.
#define BR_ADC_CFG1_MODE(x)  (HW_ADC_CFG1(x).B.MODE)
#endif

//! @brief Format value for bitfield ADC_CFG1_MODE.
#define BF_ADC_CFG1_MODE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG1_MODE), uint32_t) & BM_ADC_CFG1_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MODE field to a new value.
#define BW_ADC_CFG1_MODE(x, v) (HW_ADC_CFG1_WR(x, (HW_ADC_CFG1_RD(x) & ~BM_ADC_CFG1_MODE) | BF_ADC_CFG1_MODE(v)))
#endif
//@}

/*!
 * @name Register ADC_CFG1, field ADLSMP[4] (RW)
 *
 * Selects between different sample times based on the conversion mode selected.
 * This field adjusts the sample period to allow higher impedance inputs to be
 * accurately sampled or to maximize conversion speed for lower impedance inputs.
 * Longer sample times can also be used to lower overall power consumption if
 * continuous conversions are enabled and high conversion rates are not required.
 * When ADLSMP=1, the long sample time select bits, (ADLSTS[1:0]), can select the
 * extent of the long sample time.
 *
 * Values:
 * - 0 - Short sample time.
 * - 1 - Long sample time.
 */
//@{
#define BP_ADC_CFG1_ADLSMP   (4U)          //!< Bit position for ADC_CFG1_ADLSMP.
#define BM_ADC_CFG1_ADLSMP   (0x00000010U) //!< Bit mask for ADC_CFG1_ADLSMP.
#define BS_ADC_CFG1_ADLSMP   (1U)          //!< Bit field size in bits for ADC_CFG1_ADLSMP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG1_ADLSMP field.
#define BR_ADC_CFG1_ADLSMP(x) (BITBAND_ACCESS32(HW_ADC_CFG1_ADDR(x), BP_ADC_CFG1_ADLSMP))
#endif

//! @brief Format value for bitfield ADC_CFG1_ADLSMP.
#define BF_ADC_CFG1_ADLSMP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG1_ADLSMP), uint32_t) & BM_ADC_CFG1_ADLSMP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADLSMP field to a new value.
#define BW_ADC_CFG1_ADLSMP(x, v) (BITBAND_ACCESS32(HW_ADC_CFG1_ADDR(x), BP_ADC_CFG1_ADLSMP) = (v))
#endif
//@}

/*!
 * @name Register ADC_CFG1, field ADIV[6:5] (RW)
 *
 * Selects the divide ratio used by the ADC to generate the internal clock ADCK.
 *
 * Values:
 * - 00 - The divide ratio is 1 and the clock rate is input clock.
 * - 01 - The divide ratio is 2 and the clock rate is (input clock)/2.
 * - 10 - The divide ratio is 4 and the clock rate is (input clock)/4.
 * - 11 - The divide ratio is 8 and the clock rate is (input clock)/8.
 */
//@{
#define BP_ADC_CFG1_ADIV     (5U)          //!< Bit position for ADC_CFG1_ADIV.
#define BM_ADC_CFG1_ADIV     (0x00000060U) //!< Bit mask for ADC_CFG1_ADIV.
#define BS_ADC_CFG1_ADIV     (2U)          //!< Bit field size in bits for ADC_CFG1_ADIV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG1_ADIV field.
#define BR_ADC_CFG1_ADIV(x)  (HW_ADC_CFG1(x).B.ADIV)
#endif

//! @brief Format value for bitfield ADC_CFG1_ADIV.
#define BF_ADC_CFG1_ADIV(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG1_ADIV), uint32_t) & BM_ADC_CFG1_ADIV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADIV field to a new value.
#define BW_ADC_CFG1_ADIV(x, v) (HW_ADC_CFG1_WR(x, (HW_ADC_CFG1_RD(x) & ~BM_ADC_CFG1_ADIV) | BF_ADC_CFG1_ADIV(v)))
#endif
//@}

/*!
 * @name Register ADC_CFG1, field ADLPC[7] (RW)
 *
 * Controls the power configuration of the successive approximation converter.
 * This optimizes power consumption when higher sample rates are not required.
 *
 * Values:
 * - 0 - Normal power configuration.
 * - 1 - Low-power configuration. The power is reduced at the expense of maximum
 *     clock speed.
 */
//@{
#define BP_ADC_CFG1_ADLPC    (7U)          //!< Bit position for ADC_CFG1_ADLPC.
#define BM_ADC_CFG1_ADLPC    (0x00000080U) //!< Bit mask for ADC_CFG1_ADLPC.
#define BS_ADC_CFG1_ADLPC    (1U)          //!< Bit field size in bits for ADC_CFG1_ADLPC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG1_ADLPC field.
#define BR_ADC_CFG1_ADLPC(x) (BITBAND_ACCESS32(HW_ADC_CFG1_ADDR(x), BP_ADC_CFG1_ADLPC))
#endif

//! @brief Format value for bitfield ADC_CFG1_ADLPC.
#define BF_ADC_CFG1_ADLPC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG1_ADLPC), uint32_t) & BM_ADC_CFG1_ADLPC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADLPC field to a new value.
#define BW_ADC_CFG1_ADLPC(x, v) (BITBAND_ACCESS32(HW_ADC_CFG1_ADDR(x), BP_ADC_CFG1_ADLPC) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CFG2 - ADC Configuration Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CFG2 - ADC Configuration Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * Configuration Register 2 (CFG2) selects the special high-speed configuration
 * for very high speed conversions and selects the long sample time duration
 * during long sample mode.
 */
typedef union _hw_adc_cfg2
{
    uint32_t U;
    struct _hw_adc_cfg2_bitfields
    {
        uint32_t ADLSTS : 2;           //!< [1:0] Long Sample Time Select
        uint32_t ADHSC : 1;            //!< [2] High-Speed Configuration
        uint32_t ADACKEN : 1;          //!< [3] Asynchronous Clock Output Enable
        uint32_t MUXSEL : 1;           //!< [4] ADC Mux Select
        uint32_t RESERVED0 : 27;       //!< [31:5]
    } B;
} hw_adc_cfg2_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CFG2 register
 */
//@{
#define HW_ADC_CFG2_ADDR(x)      (REGS_ADC_BASE(x) + 0xCU)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CFG2(x)           (*(__IO hw_adc_cfg2_t *) HW_ADC_CFG2_ADDR(x))
#define HW_ADC_CFG2_RD(x)        (HW_ADC_CFG2(x).U)
#define HW_ADC_CFG2_WR(x, v)     (HW_ADC_CFG2(x).U = (v))
#define HW_ADC_CFG2_SET(x, v)    (HW_ADC_CFG2_WR(x, HW_ADC_CFG2_RD(x) |  (v)))
#define HW_ADC_CFG2_CLR(x, v)    (HW_ADC_CFG2_WR(x, HW_ADC_CFG2_RD(x) & ~(v)))
#define HW_ADC_CFG2_TOG(x, v)    (HW_ADC_CFG2_WR(x, HW_ADC_CFG2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CFG2 bitfields
 */

/*!
 * @name Register ADC_CFG2, field ADLSTS[1:0] (RW)
 *
 * Selects between the extended sample times when long sample time is selected,
 * that is, when CFG1[ADLSMP]=1. This allows higher impedance inputs to be
 * accurately sampled or to maximize conversion speed for lower impedance inputs.
 * Longer sample times can also be used to lower overall power consumption when
 * continuous conversions are enabled if high conversion rates are not required.
 *
 * Values:
 * - 00 - Default longest sample time; 20 extra ADCK cycles; 24 ADCK cycles
 *     total.
 * - 01 - 12 extra ADCK cycles; 16 ADCK cycles total sample time.
 * - 10 - 6 extra ADCK cycles; 10 ADCK cycles total sample time.
 * - 11 - 2 extra ADCK cycles; 6 ADCK cycles total sample time.
 */
//@{
#define BP_ADC_CFG2_ADLSTS   (0U)          //!< Bit position for ADC_CFG2_ADLSTS.
#define BM_ADC_CFG2_ADLSTS   (0x00000003U) //!< Bit mask for ADC_CFG2_ADLSTS.
#define BS_ADC_CFG2_ADLSTS   (2U)          //!< Bit field size in bits for ADC_CFG2_ADLSTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG2_ADLSTS field.
#define BR_ADC_CFG2_ADLSTS(x) (HW_ADC_CFG2(x).B.ADLSTS)
#endif

//! @brief Format value for bitfield ADC_CFG2_ADLSTS.
#define BF_ADC_CFG2_ADLSTS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG2_ADLSTS), uint32_t) & BM_ADC_CFG2_ADLSTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADLSTS field to a new value.
#define BW_ADC_CFG2_ADLSTS(x, v) (HW_ADC_CFG2_WR(x, (HW_ADC_CFG2_RD(x) & ~BM_ADC_CFG2_ADLSTS) | BF_ADC_CFG2_ADLSTS(v)))
#endif
//@}

/*!
 * @name Register ADC_CFG2, field ADHSC[2] (RW)
 *
 * Configures the ADC for very high-speed operation. The conversion sequence is
 * altered with 2 ADCK cycles added to the conversion time to allow higher speed
 * conversion clocks.
 *
 * Values:
 * - 0 - Normal conversion sequence selected.
 * - 1 - High-speed conversion sequence selected with 2 additional ADCK cycles
 *     to total conversion time.
 */
//@{
#define BP_ADC_CFG2_ADHSC    (2U)          //!< Bit position for ADC_CFG2_ADHSC.
#define BM_ADC_CFG2_ADHSC    (0x00000004U) //!< Bit mask for ADC_CFG2_ADHSC.
#define BS_ADC_CFG2_ADHSC    (1U)          //!< Bit field size in bits for ADC_CFG2_ADHSC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG2_ADHSC field.
#define BR_ADC_CFG2_ADHSC(x) (BITBAND_ACCESS32(HW_ADC_CFG2_ADDR(x), BP_ADC_CFG2_ADHSC))
#endif

//! @brief Format value for bitfield ADC_CFG2_ADHSC.
#define BF_ADC_CFG2_ADHSC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG2_ADHSC), uint32_t) & BM_ADC_CFG2_ADHSC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADHSC field to a new value.
#define BW_ADC_CFG2_ADHSC(x, v) (BITBAND_ACCESS32(HW_ADC_CFG2_ADDR(x), BP_ADC_CFG2_ADHSC) = (v))
#endif
//@}

/*!
 * @name Register ADC_CFG2, field ADACKEN[3] (RW)
 *
 * Enables the asynchronous clock source and the clock source output regardless
 * of the conversion and status of CFG1[ADICLK]. Based on MCU configuration, the
 * asynchronous clock may be used by other modules. See chip configuration
 * information. Setting this field allows the clock to be used even while the ADC is
 * idle or operating from a different clock source. Also, latency of initiating a
 * single or first-continuous conversion with the asynchronous clock selected is
 * reduced because the ADACK clock is already operational.
 *
 * Values:
 * - 0 - Asynchronous clock output disabled; Asynchronous clock is enabled only
 *     if selected by ADICLK and a conversion is active.
 * - 1 - Asynchronous clock and clock output is enabled regardless of the state
 *     of the ADC.
 */
//@{
#define BP_ADC_CFG2_ADACKEN  (3U)          //!< Bit position for ADC_CFG2_ADACKEN.
#define BM_ADC_CFG2_ADACKEN  (0x00000008U) //!< Bit mask for ADC_CFG2_ADACKEN.
#define BS_ADC_CFG2_ADACKEN  (1U)          //!< Bit field size in bits for ADC_CFG2_ADACKEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG2_ADACKEN field.
#define BR_ADC_CFG2_ADACKEN(x) (BITBAND_ACCESS32(HW_ADC_CFG2_ADDR(x), BP_ADC_CFG2_ADACKEN))
#endif

//! @brief Format value for bitfield ADC_CFG2_ADACKEN.
#define BF_ADC_CFG2_ADACKEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG2_ADACKEN), uint32_t) & BM_ADC_CFG2_ADACKEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADACKEN field to a new value.
#define BW_ADC_CFG2_ADACKEN(x, v) (BITBAND_ACCESS32(HW_ADC_CFG2_ADDR(x), BP_ADC_CFG2_ADACKEN) = (v))
#endif
//@}

/*!
 * @name Register ADC_CFG2, field MUXSEL[4] (RW)
 *
 * Changes the ADC mux setting to select between alternate sets of ADC channels.
 *
 * Values:
 * - 0 - ADxxa channels are selected.
 * - 1 - ADxxb channels are selected.
 */
//@{
#define BP_ADC_CFG2_MUXSEL   (4U)          //!< Bit position for ADC_CFG2_MUXSEL.
#define BM_ADC_CFG2_MUXSEL   (0x00000010U) //!< Bit mask for ADC_CFG2_MUXSEL.
#define BS_ADC_CFG2_MUXSEL   (1U)          //!< Bit field size in bits for ADC_CFG2_MUXSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CFG2_MUXSEL field.
#define BR_ADC_CFG2_MUXSEL(x) (BITBAND_ACCESS32(HW_ADC_CFG2_ADDR(x), BP_ADC_CFG2_MUXSEL))
#endif

//! @brief Format value for bitfield ADC_CFG2_MUXSEL.
#define BF_ADC_CFG2_MUXSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CFG2_MUXSEL), uint32_t) & BM_ADC_CFG2_MUXSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MUXSEL field to a new value.
#define BW_ADC_CFG2_MUXSEL(x, v) (BITBAND_ACCESS32(HW_ADC_CFG2_ADDR(x), BP_ADC_CFG2_MUXSEL) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_Rn - ADC Data Result Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_Rn - ADC Data Result Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The data result registers (Rn) contain the result of an ADC conversion of the
 * channel selected by the corresponding status and channel control register
 * (SC1A:SC1n). For every status and channel control register, there is a
 * corresponding data result register. Unused bits in R n are cleared in unsigned
 * right-aligned modes and carry the sign bit (MSB) in sign-extended 2's complement modes.
 * For example, when configured for 10-bit single-ended mode, D[15:10] are
 * cleared. When configured for 11-bit differential mode, D[15:10] carry the sign bit,
 * that is, bit 10 extended through bit 15. The following table describes the
 * behavior of the data result registers in the different modes of operation. Data
 * result register description Conversion mode D15 D14 D13 D12 D11 D10 D9 D8 D7
 * D6 D5 D4 D3 D2 D1 D0 Format 16-bit differential S D D D D D D D D D D D D D D D
 * Signed 2's complement 16-bit single-ended D D D D D D D D D D D D D D D D
 * Unsigned right justified 13-bit differential S S S S D D D D D D D D D D D D
 * Sign-extended 2's complement 12-bit single-ended 0 0 0 0 D D D D D D D D D D D D
 * Unsigned right-justified 11-bit differential S S S S S S D D D D D D D D D D
 * Sign-extended 2's complement 10-bit single-ended 0 0 0 0 0 0 D D D D D D D D D D
 * Unsigned right-justified 9-bit differential S S S S S S S S D D D D D D D D
 * Sign-extended 2's complement 8-bit single-ended 0 0 0 0 0 0 0 0 D D D D D D D D
 * Unsigned right-justified S: Sign bit or sign bit extension; D: Data, which is
 * 2's complement data if indicated
 */
typedef union _hw_adc_rn
{
    uint32_t U;
    struct _hw_adc_rn_bitfields
    {
        uint32_t D : 16;               //!< [15:0] Data result
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_adc_rn_t;
#endif

/*!
 * @name Constants and macros for entire ADC_Rn register
 */
//@{
#define HW_ADC_Rn_COUNT (2U)

#define HW_ADC_Rn_ADDR(x, n)     (REGS_ADC_BASE(x) + 0x10U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_ADC_Rn(x, n)          (*(__I hw_adc_rn_t *) HW_ADC_Rn_ADDR(x, n))
#define HW_ADC_Rn_RD(x, n)       (HW_ADC_Rn(x, n).U)
#endif
//@}

/*
 * Constants & macros for individual ADC_Rn bitfields
 */

/*!
 * @name Register ADC_Rn, field D[15:0] (RO)
 */
//@{
#define BP_ADC_Rn_D          (0U)          //!< Bit position for ADC_Rn_D.
#define BM_ADC_Rn_D          (0x0000FFFFU) //!< Bit mask for ADC_Rn_D.
#define BS_ADC_Rn_D          (16U)         //!< Bit field size in bits for ADC_Rn_D.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_Rn_D field.
#define BR_ADC_Rn_D(x, n)    (HW_ADC_Rn(x, n).B.D)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CV1 - Compare Value Registers
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CV1 - Compare Value Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Compare Value Registers (CV1 and CV2) contain a compare value used to
 * compare the conversion result when the compare function is enabled, that is,
 * SC2[ACFE]=1. This register is formatted in the same way as the Rn registers in
 * different modes of operation for both bit position definition and value format
 * using unsigned or sign-extended 2's complement. Therefore, the compare function
 * uses only the CVn fields that are related to the ADC mode of operation. The
 * compare value 2 register (CV2) is used only when the compare range function is
 * enabled, that is, SC2[ACREN]=1.
 */
typedef union _hw_adc_cv1
{
    uint32_t U;
    struct _hw_adc_cv1_bitfields
    {
        uint32_t CV : 16;              //!< [15:0] Compare Value.
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_adc_cv1_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CV1 register
 */
//@{
#define HW_ADC_CV1_ADDR(x)       (REGS_ADC_BASE(x) + 0x18U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CV1(x)            (*(__IO hw_adc_cv1_t *) HW_ADC_CV1_ADDR(x))
#define HW_ADC_CV1_RD(x)         (HW_ADC_CV1(x).U)
#define HW_ADC_CV1_WR(x, v)      (HW_ADC_CV1(x).U = (v))
#define HW_ADC_CV1_SET(x, v)     (HW_ADC_CV1_WR(x, HW_ADC_CV1_RD(x) |  (v)))
#define HW_ADC_CV1_CLR(x, v)     (HW_ADC_CV1_WR(x, HW_ADC_CV1_RD(x) & ~(v)))
#define HW_ADC_CV1_TOG(x, v)     (HW_ADC_CV1_WR(x, HW_ADC_CV1_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CV1 bitfields
 */

/*!
 * @name Register ADC_CV1, field CV[15:0] (RW)
 */
//@{
#define BP_ADC_CV1_CV        (0U)          //!< Bit position for ADC_CV1_CV.
#define BM_ADC_CV1_CV        (0x0000FFFFU) //!< Bit mask for ADC_CV1_CV.
#define BS_ADC_CV1_CV        (16U)         //!< Bit field size in bits for ADC_CV1_CV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CV1_CV field.
#define BR_ADC_CV1_CV(x)     (HW_ADC_CV1(x).B.CV)
#endif

//! @brief Format value for bitfield ADC_CV1_CV.
#define BF_ADC_CV1_CV(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CV1_CV), uint32_t) & BM_ADC_CV1_CV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CV field to a new value.
#define BW_ADC_CV1_CV(x, v)  (HW_ADC_CV1_WR(x, (HW_ADC_CV1_RD(x) & ~BM_ADC_CV1_CV) | BF_ADC_CV1_CV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CV2 - Compare Value Registers
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CV2 - Compare Value Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Compare Value Registers (CV1 and CV2) contain a compare value used to
 * compare the conversion result when the compare function is enabled, that is,
 * SC2[ACFE]=1. This register is formatted in the same way as the Rn registers in
 * different modes of operation for both bit position definition and value format
 * using unsigned or sign-extended 2's complement. Therefore, the compare function
 * uses only the CVn fields that are related to the ADC mode of operation. The
 * compare value 2 register (CV2) is used only when the compare range function is
 * enabled, that is, SC2[ACREN]=1.
 */
typedef union _hw_adc_cv2
{
    uint32_t U;
    struct _hw_adc_cv2_bitfields
    {
        uint32_t CV : 16;              //!< [15:0] Compare Value.
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_adc_cv2_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CV2 register
 */
//@{
#define HW_ADC_CV2_ADDR(x)       (REGS_ADC_BASE(x) + 0x1CU)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CV2(x)            (*(__IO hw_adc_cv2_t *) HW_ADC_CV2_ADDR(x))
#define HW_ADC_CV2_RD(x)         (HW_ADC_CV2(x).U)
#define HW_ADC_CV2_WR(x, v)      (HW_ADC_CV2(x).U = (v))
#define HW_ADC_CV2_SET(x, v)     (HW_ADC_CV2_WR(x, HW_ADC_CV2_RD(x) |  (v)))
#define HW_ADC_CV2_CLR(x, v)     (HW_ADC_CV2_WR(x, HW_ADC_CV2_RD(x) & ~(v)))
#define HW_ADC_CV2_TOG(x, v)     (HW_ADC_CV2_WR(x, HW_ADC_CV2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CV2 bitfields
 */

/*!
 * @name Register ADC_CV2, field CV[15:0] (RW)
 */
//@{
#define BP_ADC_CV2_CV        (0U)          //!< Bit position for ADC_CV2_CV.
#define BM_ADC_CV2_CV        (0x0000FFFFU) //!< Bit mask for ADC_CV2_CV.
#define BS_ADC_CV2_CV        (16U)         //!< Bit field size in bits for ADC_CV2_CV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CV2_CV field.
#define BR_ADC_CV2_CV(x)     (HW_ADC_CV2(x).B.CV)
#endif

//! @brief Format value for bitfield ADC_CV2_CV.
#define BF_ADC_CV2_CV(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CV2_CV), uint32_t) & BM_ADC_CV2_CV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CV field to a new value.
#define BW_ADC_CV2_CV(x, v)  (HW_ADC_CV2_WR(x, (HW_ADC_CV2_RD(x) & ~BM_ADC_CV2_CV) | BF_ADC_CV2_CV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_SC2 - Status and Control Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_SC2 - Status and Control Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The status and control register 2 (SC2) contains the conversion active,
 * hardware/software trigger select, compare function, and voltage reference select of
 * the ADC module.
 */
typedef union _hw_adc_sc2
{
    uint32_t U;
    struct _hw_adc_sc2_bitfields
    {
        uint32_t REFSEL : 2;           //!< [1:0] Voltage Reference Selection
        uint32_t DMAEN : 1;            //!< [2] DMA Enable
        uint32_t ACREN : 1;            //!< [3] Compare Function Range Enable
        uint32_t ACFGT : 1;            //!< [4] Compare Function Greater Than Enable
        uint32_t ACFE : 1;             //!< [5] Compare Function Enable
        uint32_t ADTRG : 1;            //!< [6] Conversion Trigger Select
        uint32_t ADACT : 1;            //!< [7] Conversion Active
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_adc_sc2_t;
#endif

/*!
 * @name Constants and macros for entire ADC_SC2 register
 */
//@{
#define HW_ADC_SC2_ADDR(x)       (REGS_ADC_BASE(x) + 0x20U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_SC2(x)            (*(__IO hw_adc_sc2_t *) HW_ADC_SC2_ADDR(x))
#define HW_ADC_SC2_RD(x)         (HW_ADC_SC2(x).U)
#define HW_ADC_SC2_WR(x, v)      (HW_ADC_SC2(x).U = (v))
#define HW_ADC_SC2_SET(x, v)     (HW_ADC_SC2_WR(x, HW_ADC_SC2_RD(x) |  (v)))
#define HW_ADC_SC2_CLR(x, v)     (HW_ADC_SC2_WR(x, HW_ADC_SC2_RD(x) & ~(v)))
#define HW_ADC_SC2_TOG(x, v)     (HW_ADC_SC2_WR(x, HW_ADC_SC2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_SC2 bitfields
 */

/*!
 * @name Register ADC_SC2, field REFSEL[1:0] (RW)
 *
 * Selects the voltage reference source used for conversions.
 *
 * Values:
 * - 00 - Default voltage reference pin pair, that is, external pins VREFH and
 *     VREFL
 * - 01 - Alternate reference pair, that is, VALTH and VALTL . This pair may be
 *     additional external pins or internal sources depending on the MCU
 *     configuration. See the chip configuration information for details specific to this
 *     MCU
 * - 10 - Reserved
 * - 11 - Reserved
 */
//@{
#define BP_ADC_SC2_REFSEL    (0U)          //!< Bit position for ADC_SC2_REFSEL.
#define BM_ADC_SC2_REFSEL    (0x00000003U) //!< Bit mask for ADC_SC2_REFSEL.
#define BS_ADC_SC2_REFSEL    (2U)          //!< Bit field size in bits for ADC_SC2_REFSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC2_REFSEL field.
#define BR_ADC_SC2_REFSEL(x) (HW_ADC_SC2(x).B.REFSEL)
#endif

//! @brief Format value for bitfield ADC_SC2_REFSEL.
#define BF_ADC_SC2_REFSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC2_REFSEL), uint32_t) & BM_ADC_SC2_REFSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REFSEL field to a new value.
#define BW_ADC_SC2_REFSEL(x, v) (HW_ADC_SC2_WR(x, (HW_ADC_SC2_RD(x) & ~BM_ADC_SC2_REFSEL) | BF_ADC_SC2_REFSEL(v)))
#endif
//@}

/*!
 * @name Register ADC_SC2, field DMAEN[2] (RW)
 *
 * Values:
 * - 0 - DMA is disabled.
 * - 1 - DMA is enabled and will assert the ADC DMA request during an ADC
 *     conversion complete event noted when any of the SC1n[COCO] flags is asserted.
 */
//@{
#define BP_ADC_SC2_DMAEN     (2U)          //!< Bit position for ADC_SC2_DMAEN.
#define BM_ADC_SC2_DMAEN     (0x00000004U) //!< Bit mask for ADC_SC2_DMAEN.
#define BS_ADC_SC2_DMAEN     (1U)          //!< Bit field size in bits for ADC_SC2_DMAEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC2_DMAEN field.
#define BR_ADC_SC2_DMAEN(x)  (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_DMAEN))
#endif

//! @brief Format value for bitfield ADC_SC2_DMAEN.
#define BF_ADC_SC2_DMAEN(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC2_DMAEN), uint32_t) & BM_ADC_SC2_DMAEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAEN field to a new value.
#define BW_ADC_SC2_DMAEN(x, v) (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_DMAEN) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC2, field ACREN[3] (RW)
 *
 * Configures the compare function to check if the conversion result of the
 * input being monitored is either between or outside the range formed by CV1 and CV2
 * determined by the value of ACFGT. ACFE must be set for ACFGT to have any
 * effect.
 *
 * Values:
 * - 0 - Range function disabled. Only CV1 is compared.
 * - 1 - Range function enabled. Both CV1 and CV2 are compared.
 */
//@{
#define BP_ADC_SC2_ACREN     (3U)          //!< Bit position for ADC_SC2_ACREN.
#define BM_ADC_SC2_ACREN     (0x00000008U) //!< Bit mask for ADC_SC2_ACREN.
#define BS_ADC_SC2_ACREN     (1U)          //!< Bit field size in bits for ADC_SC2_ACREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC2_ACREN field.
#define BR_ADC_SC2_ACREN(x)  (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ACREN))
#endif

//! @brief Format value for bitfield ADC_SC2_ACREN.
#define BF_ADC_SC2_ACREN(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC2_ACREN), uint32_t) & BM_ADC_SC2_ACREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACREN field to a new value.
#define BW_ADC_SC2_ACREN(x, v) (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ACREN) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC2, field ACFGT[4] (RW)
 *
 * Configures the compare function to check the conversion result relative to
 * the CV1 and CV2 based upon the value of ACREN. ACFE must be set for ACFGT to
 * have any effect.
 *
 * Values:
 * - 0 - Configures less than threshold, outside range not inclusive and inside
 *     range not inclusive; functionality based on the values placed in CV1 and
 *     CV2.
 * - 1 - Configures greater than or equal to threshold, outside and inside
 *     ranges inclusive; functionality based on the values placed in CV1 and CV2.
 */
//@{
#define BP_ADC_SC2_ACFGT     (4U)          //!< Bit position for ADC_SC2_ACFGT.
#define BM_ADC_SC2_ACFGT     (0x00000010U) //!< Bit mask for ADC_SC2_ACFGT.
#define BS_ADC_SC2_ACFGT     (1U)          //!< Bit field size in bits for ADC_SC2_ACFGT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC2_ACFGT field.
#define BR_ADC_SC2_ACFGT(x)  (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ACFGT))
#endif

//! @brief Format value for bitfield ADC_SC2_ACFGT.
#define BF_ADC_SC2_ACFGT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC2_ACFGT), uint32_t) & BM_ADC_SC2_ACFGT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACFGT field to a new value.
#define BW_ADC_SC2_ACFGT(x, v) (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ACFGT) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC2, field ACFE[5] (RW)
 *
 * Enables the compare function.
 *
 * Values:
 * - 0 - Compare function disabled.
 * - 1 - Compare function enabled.
 */
//@{
#define BP_ADC_SC2_ACFE      (5U)          //!< Bit position for ADC_SC2_ACFE.
#define BM_ADC_SC2_ACFE      (0x00000020U) //!< Bit mask for ADC_SC2_ACFE.
#define BS_ADC_SC2_ACFE      (1U)          //!< Bit field size in bits for ADC_SC2_ACFE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC2_ACFE field.
#define BR_ADC_SC2_ACFE(x)   (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ACFE))
#endif

//! @brief Format value for bitfield ADC_SC2_ACFE.
#define BF_ADC_SC2_ACFE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC2_ACFE), uint32_t) & BM_ADC_SC2_ACFE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACFE field to a new value.
#define BW_ADC_SC2_ACFE(x, v) (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ACFE) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC2, field ADTRG[6] (RW)
 *
 * Selects the type of trigger used for initiating a conversion. Two types of
 * trigger are selectable: Software trigger: When software trigger is selected, a
 * conversion is initiated following a write to SC1A. Hardware trigger: When
 * hardware trigger is selected, a conversion is initiated following the assertion of
 * the ADHWT input after a pulse of the ADHWTSn input.
 *
 * Values:
 * - 0 - Software trigger selected.
 * - 1 - Hardware trigger selected.
 */
//@{
#define BP_ADC_SC2_ADTRG     (6U)          //!< Bit position for ADC_SC2_ADTRG.
#define BM_ADC_SC2_ADTRG     (0x00000040U) //!< Bit mask for ADC_SC2_ADTRG.
#define BS_ADC_SC2_ADTRG     (1U)          //!< Bit field size in bits for ADC_SC2_ADTRG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC2_ADTRG field.
#define BR_ADC_SC2_ADTRG(x)  (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ADTRG))
#endif

//! @brief Format value for bitfield ADC_SC2_ADTRG.
#define BF_ADC_SC2_ADTRG(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC2_ADTRG), uint32_t) & BM_ADC_SC2_ADTRG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADTRG field to a new value.
#define BW_ADC_SC2_ADTRG(x, v) (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ADTRG) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC2, field ADACT[7] (RO)
 *
 * Indicates that a conversion or hardware averaging is in progress. ADACT is
 * set when a conversion is initiated and cleared when a conversion is completed or
 * aborted.
 *
 * Values:
 * - 0 - Conversion not in progress.
 * - 1 - Conversion in progress.
 */
//@{
#define BP_ADC_SC2_ADACT     (7U)          //!< Bit position for ADC_SC2_ADACT.
#define BM_ADC_SC2_ADACT     (0x00000080U) //!< Bit mask for ADC_SC2_ADACT.
#define BS_ADC_SC2_ADACT     (1U)          //!< Bit field size in bits for ADC_SC2_ADACT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC2_ADACT field.
#define BR_ADC_SC2_ADACT(x)  (BITBAND_ACCESS32(HW_ADC_SC2_ADDR(x), BP_ADC_SC2_ADACT))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_SC3 - Status and Control Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_SC3 - Status and Control Register 3 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Status and Control Register 3 (SC3) controls the calibration, continuous
 * convert, and hardware averaging functions of the ADC module.
 */
typedef union _hw_adc_sc3
{
    uint32_t U;
    struct _hw_adc_sc3_bitfields
    {
        uint32_t AVGS : 2;             //!< [1:0] Hardware Average Select
        uint32_t AVGE : 1;             //!< [2] Hardware Average Enable
        uint32_t ADCO : 1;             //!< [3] Continuous Conversion Enable
        uint32_t RESERVED0 : 2;        //!< [5:4]
        uint32_t CALF : 1;             //!< [6] Calibration Failed Flag
        uint32_t CAL : 1;              //!< [7] Calibration
        uint32_t RESERVED1 : 24;       //!< [31:8]
    } B;
} hw_adc_sc3_t;
#endif

/*!
 * @name Constants and macros for entire ADC_SC3 register
 */
//@{
#define HW_ADC_SC3_ADDR(x)       (REGS_ADC_BASE(x) + 0x24U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_SC3(x)            (*(__IO hw_adc_sc3_t *) HW_ADC_SC3_ADDR(x))
#define HW_ADC_SC3_RD(x)         (HW_ADC_SC3(x).U)
#define HW_ADC_SC3_WR(x, v)      (HW_ADC_SC3(x).U = (v))
#define HW_ADC_SC3_SET(x, v)     (HW_ADC_SC3_WR(x, HW_ADC_SC3_RD(x) |  (v)))
#define HW_ADC_SC3_CLR(x, v)     (HW_ADC_SC3_WR(x, HW_ADC_SC3_RD(x) & ~(v)))
#define HW_ADC_SC3_TOG(x, v)     (HW_ADC_SC3_WR(x, HW_ADC_SC3_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_SC3 bitfields
 */

/*!
 * @name Register ADC_SC3, field AVGS[1:0] (RW)
 *
 * Determines how many ADC conversions will be averaged to create the ADC
 * average result.
 *
 * Values:
 * - 00 - 4 samples averaged.
 * - 01 - 8 samples averaged.
 * - 10 - 16 samples averaged.
 * - 11 - 32 samples averaged.
 */
//@{
#define BP_ADC_SC3_AVGS      (0U)          //!< Bit position for ADC_SC3_AVGS.
#define BM_ADC_SC3_AVGS      (0x00000003U) //!< Bit mask for ADC_SC3_AVGS.
#define BS_ADC_SC3_AVGS      (2U)          //!< Bit field size in bits for ADC_SC3_AVGS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC3_AVGS field.
#define BR_ADC_SC3_AVGS(x)   (HW_ADC_SC3(x).B.AVGS)
#endif

//! @brief Format value for bitfield ADC_SC3_AVGS.
#define BF_ADC_SC3_AVGS(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC3_AVGS), uint32_t) & BM_ADC_SC3_AVGS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVGS field to a new value.
#define BW_ADC_SC3_AVGS(x, v) (HW_ADC_SC3_WR(x, (HW_ADC_SC3_RD(x) & ~BM_ADC_SC3_AVGS) | BF_ADC_SC3_AVGS(v)))
#endif
//@}

/*!
 * @name Register ADC_SC3, field AVGE[2] (RW)
 *
 * Enables the hardware average function of the ADC.
 *
 * Values:
 * - 0 - Hardware average function disabled.
 * - 1 - Hardware average function enabled.
 */
//@{
#define BP_ADC_SC3_AVGE      (2U)          //!< Bit position for ADC_SC3_AVGE.
#define BM_ADC_SC3_AVGE      (0x00000004U) //!< Bit mask for ADC_SC3_AVGE.
#define BS_ADC_SC3_AVGE      (1U)          //!< Bit field size in bits for ADC_SC3_AVGE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC3_AVGE field.
#define BR_ADC_SC3_AVGE(x)   (BITBAND_ACCESS32(HW_ADC_SC3_ADDR(x), BP_ADC_SC3_AVGE))
#endif

//! @brief Format value for bitfield ADC_SC3_AVGE.
#define BF_ADC_SC3_AVGE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC3_AVGE), uint32_t) & BM_ADC_SC3_AVGE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVGE field to a new value.
#define BW_ADC_SC3_AVGE(x, v) (BITBAND_ACCESS32(HW_ADC_SC3_ADDR(x), BP_ADC_SC3_AVGE) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC3, field ADCO[3] (RW)
 *
 * Enables continuous conversions.
 *
 * Values:
 * - 0 - One conversion or one set of conversions if the hardware average
 *     function is enabled, that is, AVGE=1, after initiating a conversion.
 * - 1 - Continuous conversions or sets of conversions if the hardware average
 *     function is enabled, that is, AVGE=1, after initiating a conversion.
 */
//@{
#define BP_ADC_SC3_ADCO      (3U)          //!< Bit position for ADC_SC3_ADCO.
#define BM_ADC_SC3_ADCO      (0x00000008U) //!< Bit mask for ADC_SC3_ADCO.
#define BS_ADC_SC3_ADCO      (1U)          //!< Bit field size in bits for ADC_SC3_ADCO.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC3_ADCO field.
#define BR_ADC_SC3_ADCO(x)   (BITBAND_ACCESS32(HW_ADC_SC3_ADDR(x), BP_ADC_SC3_ADCO))
#endif

//! @brief Format value for bitfield ADC_SC3_ADCO.
#define BF_ADC_SC3_ADCO(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC3_ADCO), uint32_t) & BM_ADC_SC3_ADCO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADCO field to a new value.
#define BW_ADC_SC3_ADCO(x, v) (BITBAND_ACCESS32(HW_ADC_SC3_ADDR(x), BP_ADC_SC3_ADCO) = (v))
#endif
//@}

/*!
 * @name Register ADC_SC3, field CALF[6] (RO)
 *
 * Displays the result of the calibration sequence. The calibration sequence
 * will fail if SC2[ADTRG] = 1, any ADC register is written, or any stop mode is
 * entered before the calibration sequence completes. Writing 1 to CALF clears it.
 *
 * Values:
 * - 0 - Calibration completed normally.
 * - 1 - Calibration failed. ADC accuracy specifications are not guaranteed.
 */
//@{
#define BP_ADC_SC3_CALF      (6U)          //!< Bit position for ADC_SC3_CALF.
#define BM_ADC_SC3_CALF      (0x00000040U) //!< Bit mask for ADC_SC3_CALF.
#define BS_ADC_SC3_CALF      (1U)          //!< Bit field size in bits for ADC_SC3_CALF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC3_CALF field.
#define BR_ADC_SC3_CALF(x)   (BITBAND_ACCESS32(HW_ADC_SC3_ADDR(x), BP_ADC_SC3_CALF))
#endif
//@}

/*!
 * @name Register ADC_SC3, field CAL[7] (RW)
 *
 * Begins the calibration sequence when set. This field stays set while the
 * calibration is in progress and is cleared when the calibration sequence is
 * completed. CALF must be checked to determine the result of the calibration sequence.
 * Once started, the calibration routine cannot be interrupted by writes to the
 * ADC registers or the results will be invalid and CALF will set. Setting CAL
 * will abort any current conversion.
 */
//@{
#define BP_ADC_SC3_CAL       (7U)          //!< Bit position for ADC_SC3_CAL.
#define BM_ADC_SC3_CAL       (0x00000080U) //!< Bit mask for ADC_SC3_CAL.
#define BS_ADC_SC3_CAL       (1U)          //!< Bit field size in bits for ADC_SC3_CAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_SC3_CAL field.
#define BR_ADC_SC3_CAL(x)    (BITBAND_ACCESS32(HW_ADC_SC3_ADDR(x), BP_ADC_SC3_CAL))
#endif

//! @brief Format value for bitfield ADC_SC3_CAL.
#define BF_ADC_SC3_CAL(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_SC3_CAL), uint32_t) & BM_ADC_SC3_CAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CAL field to a new value.
#define BW_ADC_SC3_CAL(x, v) (BITBAND_ACCESS32(HW_ADC_SC3_ADDR(x), BP_ADC_SC3_CAL) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_OFS - ADC Offset Correction Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_OFS - ADC Offset Correction Register (RW)
 *
 * Reset value: 0x00000004U
 *
 * The ADC Offset Correction Register (OFS) contains the user-selected or
 * calibration-generated offset error correction value. This register is a 2's
 * complement, left-justified, 16-bit value . The value in OFS is subtracted from the
 * conversion and the result is transferred into the result registers, Rn. If the
 * result is greater than the maximum or less than the minimum result value, it is
 * forced to the appropriate limit for the current mode of operation.
 */
typedef union _hw_adc_ofs
{
    uint32_t U;
    struct _hw_adc_ofs_bitfields
    {
        uint32_t OFS : 16;             //!< [15:0] Offset Error Correction Value
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_adc_ofs_t;
#endif

/*!
 * @name Constants and macros for entire ADC_OFS register
 */
//@{
#define HW_ADC_OFS_ADDR(x)       (REGS_ADC_BASE(x) + 0x28U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_OFS(x)            (*(__IO hw_adc_ofs_t *) HW_ADC_OFS_ADDR(x))
#define HW_ADC_OFS_RD(x)         (HW_ADC_OFS(x).U)
#define HW_ADC_OFS_WR(x, v)      (HW_ADC_OFS(x).U = (v))
#define HW_ADC_OFS_SET(x, v)     (HW_ADC_OFS_WR(x, HW_ADC_OFS_RD(x) |  (v)))
#define HW_ADC_OFS_CLR(x, v)     (HW_ADC_OFS_WR(x, HW_ADC_OFS_RD(x) & ~(v)))
#define HW_ADC_OFS_TOG(x, v)     (HW_ADC_OFS_WR(x, HW_ADC_OFS_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_OFS bitfields
 */

/*!
 * @name Register ADC_OFS, field OFS[15:0] (RW)
 */
//@{
#define BP_ADC_OFS_OFS       (0U)          //!< Bit position for ADC_OFS_OFS.
#define BM_ADC_OFS_OFS       (0x0000FFFFU) //!< Bit mask for ADC_OFS_OFS.
#define BS_ADC_OFS_OFS       (16U)         //!< Bit field size in bits for ADC_OFS_OFS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_OFS_OFS field.
#define BR_ADC_OFS_OFS(x)    (HW_ADC_OFS(x).B.OFS)
#endif

//! @brief Format value for bitfield ADC_OFS_OFS.
#define BF_ADC_OFS_OFS(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_OFS_OFS), uint32_t) & BM_ADC_OFS_OFS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OFS field to a new value.
#define BW_ADC_OFS_OFS(x, v) (HW_ADC_OFS_WR(x, (HW_ADC_OFS_RD(x) & ~BM_ADC_OFS_OFS) | BF_ADC_OFS_OFS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_PG - ADC Plus-Side Gain Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_PG - ADC Plus-Side Gain Register (RW)
 *
 * Reset value: 0x00008200U
 *
 * The Plus-Side Gain Register (PG) contains the gain error correction for the
 * plus-side input in differential mode or the overall conversion in single-ended
 * mode. PG, a 16-bit real number in binary format, is the gain adjustment
 * factor, with the radix point fixed between ADPG15 and ADPG14. This register must be
 * written by the user with the value described in the calibration procedure.
 * Otherwise, the gain error specifications may not be met.
 */
typedef union _hw_adc_pg
{
    uint32_t U;
    struct _hw_adc_pg_bitfields
    {
        uint32_t PG : 16;              //!< [15:0] Plus-Side Gain
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_adc_pg_t;
#endif

/*!
 * @name Constants and macros for entire ADC_PG register
 */
//@{
#define HW_ADC_PG_ADDR(x)        (REGS_ADC_BASE(x) + 0x2CU)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_PG(x)             (*(__IO hw_adc_pg_t *) HW_ADC_PG_ADDR(x))
#define HW_ADC_PG_RD(x)          (HW_ADC_PG(x).U)
#define HW_ADC_PG_WR(x, v)       (HW_ADC_PG(x).U = (v))
#define HW_ADC_PG_SET(x, v)      (HW_ADC_PG_WR(x, HW_ADC_PG_RD(x) |  (v)))
#define HW_ADC_PG_CLR(x, v)      (HW_ADC_PG_WR(x, HW_ADC_PG_RD(x) & ~(v)))
#define HW_ADC_PG_TOG(x, v)      (HW_ADC_PG_WR(x, HW_ADC_PG_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_PG bitfields
 */

/*!
 * @name Register ADC_PG, field PG[15:0] (RW)
 */
//@{
#define BP_ADC_PG_PG         (0U)          //!< Bit position for ADC_PG_PG.
#define BM_ADC_PG_PG         (0x0000FFFFU) //!< Bit mask for ADC_PG_PG.
#define BS_ADC_PG_PG         (16U)         //!< Bit field size in bits for ADC_PG_PG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_PG_PG field.
#define BR_ADC_PG_PG(x)      (HW_ADC_PG(x).B.PG)
#endif

//! @brief Format value for bitfield ADC_PG_PG.
#define BF_ADC_PG_PG(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_PG_PG), uint32_t) & BM_ADC_PG_PG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PG field to a new value.
#define BW_ADC_PG_PG(x, v)   (HW_ADC_PG_WR(x, (HW_ADC_PG_RD(x) & ~BM_ADC_PG_PG) | BF_ADC_PG_PG(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_MG - ADC Minus-Side Gain Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_MG - ADC Minus-Side Gain Register (RW)
 *
 * Reset value: 0x00008200U
 *
 * The Minus-Side Gain Register (MG) contains the gain error correction for the
 * minus-side input in differential mode. This register is ignored in
 * single-ended mode. MG, a 16-bit real number in binary format, is the gain adjustment
 * factor, with the radix point fixed between ADMG15 and ADMG14. This register must
 * be written by the user with the value described in the calibration procedure.
 * Otherwise, the gain error specifications may not be met.
 */
typedef union _hw_adc_mg
{
    uint32_t U;
    struct _hw_adc_mg_bitfields
    {
        uint32_t MG : 16;              //!< [15:0] Minus-Side Gain
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_adc_mg_t;
#endif

/*!
 * @name Constants and macros for entire ADC_MG register
 */
//@{
#define HW_ADC_MG_ADDR(x)        (REGS_ADC_BASE(x) + 0x30U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_MG(x)             (*(__IO hw_adc_mg_t *) HW_ADC_MG_ADDR(x))
#define HW_ADC_MG_RD(x)          (HW_ADC_MG(x).U)
#define HW_ADC_MG_WR(x, v)       (HW_ADC_MG(x).U = (v))
#define HW_ADC_MG_SET(x, v)      (HW_ADC_MG_WR(x, HW_ADC_MG_RD(x) |  (v)))
#define HW_ADC_MG_CLR(x, v)      (HW_ADC_MG_WR(x, HW_ADC_MG_RD(x) & ~(v)))
#define HW_ADC_MG_TOG(x, v)      (HW_ADC_MG_WR(x, HW_ADC_MG_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_MG bitfields
 */

/*!
 * @name Register ADC_MG, field MG[15:0] (RW)
 */
//@{
#define BP_ADC_MG_MG         (0U)          //!< Bit position for ADC_MG_MG.
#define BM_ADC_MG_MG         (0x0000FFFFU) //!< Bit mask for ADC_MG_MG.
#define BS_ADC_MG_MG         (16U)         //!< Bit field size in bits for ADC_MG_MG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_MG_MG field.
#define BR_ADC_MG_MG(x)      (HW_ADC_MG(x).B.MG)
#endif

//! @brief Format value for bitfield ADC_MG_MG.
#define BF_ADC_MG_MG(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_MG_MG), uint32_t) & BM_ADC_MG_MG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MG field to a new value.
#define BW_ADC_MG_MG(x, v)   (HW_ADC_MG_WR(x, (HW_ADC_MG_RD(x) & ~BM_ADC_MG_MG) | BF_ADC_MG_MG(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLPD - ADC Plus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLPD - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x0000000AU
 *
 * The Plus-Side General Calibration Value Registers (CLPx) contain calibration
 * information that is generated by the calibration function. These registers
 * contain seven calibration values of varying widths: CLP0[5:0], CLP1[6:0],
 * CLP2[7:0], CLP3[8:0], CLP4[9:0], CLPS[5:0], and CLPD[5:0]. CLPx are automatically set
 * when the self-calibration sequence is done, that is, CAL is cleared. If these
 * registers are written by the user after calibration, the linearity error
 * specifications may not be met.
 */
typedef union _hw_adc_clpd
{
    uint32_t U;
    struct _hw_adc_clpd_bitfields
    {
        uint32_t CLPD : 6;             //!< [5:0]
        uint32_t RESERVED0 : 26;       //!< [31:6]
    } B;
} hw_adc_clpd_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLPD register
 */
//@{
#define HW_ADC_CLPD_ADDR(x)      (REGS_ADC_BASE(x) + 0x34U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLPD(x)           (*(__IO hw_adc_clpd_t *) HW_ADC_CLPD_ADDR(x))
#define HW_ADC_CLPD_RD(x)        (HW_ADC_CLPD(x).U)
#define HW_ADC_CLPD_WR(x, v)     (HW_ADC_CLPD(x).U = (v))
#define HW_ADC_CLPD_SET(x, v)    (HW_ADC_CLPD_WR(x, HW_ADC_CLPD_RD(x) |  (v)))
#define HW_ADC_CLPD_CLR(x, v)    (HW_ADC_CLPD_WR(x, HW_ADC_CLPD_RD(x) & ~(v)))
#define HW_ADC_CLPD_TOG(x, v)    (HW_ADC_CLPD_WR(x, HW_ADC_CLPD_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLPD bitfields
 */

/*!
 * @name Register ADC_CLPD, field CLPD[5:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLPD_CLPD     (0U)          //!< Bit position for ADC_CLPD_CLPD.
#define BM_ADC_CLPD_CLPD     (0x0000003FU) //!< Bit mask for ADC_CLPD_CLPD.
#define BS_ADC_CLPD_CLPD     (6U)          //!< Bit field size in bits for ADC_CLPD_CLPD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLPD_CLPD field.
#define BR_ADC_CLPD_CLPD(x)  (HW_ADC_CLPD(x).B.CLPD)
#endif

//! @brief Format value for bitfield ADC_CLPD_CLPD.
#define BF_ADC_CLPD_CLPD(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLPD_CLPD), uint32_t) & BM_ADC_CLPD_CLPD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLPD field to a new value.
#define BW_ADC_CLPD_CLPD(x, v) (HW_ADC_CLPD_WR(x, (HW_ADC_CLPD_RD(x) & ~BM_ADC_CLPD_CLPD) | BF_ADC_CLPD_CLPD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLPS - ADC Plus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLPS - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLPD register description.
 */
typedef union _hw_adc_clps
{
    uint32_t U;
    struct _hw_adc_clps_bitfields
    {
        uint32_t CLPS : 6;             //!< [5:0]
        uint32_t RESERVED0 : 26;       //!< [31:6]
    } B;
} hw_adc_clps_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLPS register
 */
//@{
#define HW_ADC_CLPS_ADDR(x)      (REGS_ADC_BASE(x) + 0x38U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLPS(x)           (*(__IO hw_adc_clps_t *) HW_ADC_CLPS_ADDR(x))
#define HW_ADC_CLPS_RD(x)        (HW_ADC_CLPS(x).U)
#define HW_ADC_CLPS_WR(x, v)     (HW_ADC_CLPS(x).U = (v))
#define HW_ADC_CLPS_SET(x, v)    (HW_ADC_CLPS_WR(x, HW_ADC_CLPS_RD(x) |  (v)))
#define HW_ADC_CLPS_CLR(x, v)    (HW_ADC_CLPS_WR(x, HW_ADC_CLPS_RD(x) & ~(v)))
#define HW_ADC_CLPS_TOG(x, v)    (HW_ADC_CLPS_WR(x, HW_ADC_CLPS_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLPS bitfields
 */

/*!
 * @name Register ADC_CLPS, field CLPS[5:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLPS_CLPS     (0U)          //!< Bit position for ADC_CLPS_CLPS.
#define BM_ADC_CLPS_CLPS     (0x0000003FU) //!< Bit mask for ADC_CLPS_CLPS.
#define BS_ADC_CLPS_CLPS     (6U)          //!< Bit field size in bits for ADC_CLPS_CLPS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLPS_CLPS field.
#define BR_ADC_CLPS_CLPS(x)  (HW_ADC_CLPS(x).B.CLPS)
#endif

//! @brief Format value for bitfield ADC_CLPS_CLPS.
#define BF_ADC_CLPS_CLPS(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLPS_CLPS), uint32_t) & BM_ADC_CLPS_CLPS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLPS field to a new value.
#define BW_ADC_CLPS_CLPS(x, v) (HW_ADC_CLPS_WR(x, (HW_ADC_CLPS_RD(x) & ~BM_ADC_CLPS_CLPS) | BF_ADC_CLPS_CLPS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLP4 - ADC Plus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLP4 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000200U
 *
 * For more information, see CLPD register description.
 */
typedef union _hw_adc_clp4
{
    uint32_t U;
    struct _hw_adc_clp4_bitfields
    {
        uint32_t CLP4 : 10;            //!< [9:0]
        uint32_t RESERVED0 : 22;       //!< [31:10]
    } B;
} hw_adc_clp4_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLP4 register
 */
//@{
#define HW_ADC_CLP4_ADDR(x)      (REGS_ADC_BASE(x) + 0x3CU)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLP4(x)           (*(__IO hw_adc_clp4_t *) HW_ADC_CLP4_ADDR(x))
#define HW_ADC_CLP4_RD(x)        (HW_ADC_CLP4(x).U)
#define HW_ADC_CLP4_WR(x, v)     (HW_ADC_CLP4(x).U = (v))
#define HW_ADC_CLP4_SET(x, v)    (HW_ADC_CLP4_WR(x, HW_ADC_CLP4_RD(x) |  (v)))
#define HW_ADC_CLP4_CLR(x, v)    (HW_ADC_CLP4_WR(x, HW_ADC_CLP4_RD(x) & ~(v)))
#define HW_ADC_CLP4_TOG(x, v)    (HW_ADC_CLP4_WR(x, HW_ADC_CLP4_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLP4 bitfields
 */

/*!
 * @name Register ADC_CLP4, field CLP4[9:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLP4_CLP4     (0U)          //!< Bit position for ADC_CLP4_CLP4.
#define BM_ADC_CLP4_CLP4     (0x000003FFU) //!< Bit mask for ADC_CLP4_CLP4.
#define BS_ADC_CLP4_CLP4     (10U)         //!< Bit field size in bits for ADC_CLP4_CLP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLP4_CLP4 field.
#define BR_ADC_CLP4_CLP4(x)  (HW_ADC_CLP4(x).B.CLP4)
#endif

//! @brief Format value for bitfield ADC_CLP4_CLP4.
#define BF_ADC_CLP4_CLP4(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLP4_CLP4), uint32_t) & BM_ADC_CLP4_CLP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLP4 field to a new value.
#define BW_ADC_CLP4_CLP4(x, v) (HW_ADC_CLP4_WR(x, (HW_ADC_CLP4_RD(x) & ~BM_ADC_CLP4_CLP4) | BF_ADC_CLP4_CLP4(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLP3 - ADC Plus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLP3 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * For more information, see CLPD register description.
 */
typedef union _hw_adc_clp3
{
    uint32_t U;
    struct _hw_adc_clp3_bitfields
    {
        uint32_t CLP3 : 9;             //!< [8:0]
        uint32_t RESERVED0 : 23;       //!< [31:9]
    } B;
} hw_adc_clp3_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLP3 register
 */
//@{
#define HW_ADC_CLP3_ADDR(x)      (REGS_ADC_BASE(x) + 0x40U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLP3(x)           (*(__IO hw_adc_clp3_t *) HW_ADC_CLP3_ADDR(x))
#define HW_ADC_CLP3_RD(x)        (HW_ADC_CLP3(x).U)
#define HW_ADC_CLP3_WR(x, v)     (HW_ADC_CLP3(x).U = (v))
#define HW_ADC_CLP3_SET(x, v)    (HW_ADC_CLP3_WR(x, HW_ADC_CLP3_RD(x) |  (v)))
#define HW_ADC_CLP3_CLR(x, v)    (HW_ADC_CLP3_WR(x, HW_ADC_CLP3_RD(x) & ~(v)))
#define HW_ADC_CLP3_TOG(x, v)    (HW_ADC_CLP3_WR(x, HW_ADC_CLP3_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLP3 bitfields
 */

/*!
 * @name Register ADC_CLP3, field CLP3[8:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLP3_CLP3     (0U)          //!< Bit position for ADC_CLP3_CLP3.
#define BM_ADC_CLP3_CLP3     (0x000001FFU) //!< Bit mask for ADC_CLP3_CLP3.
#define BS_ADC_CLP3_CLP3     (9U)          //!< Bit field size in bits for ADC_CLP3_CLP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLP3_CLP3 field.
#define BR_ADC_CLP3_CLP3(x)  (HW_ADC_CLP3(x).B.CLP3)
#endif

//! @brief Format value for bitfield ADC_CLP3_CLP3.
#define BF_ADC_CLP3_CLP3(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLP3_CLP3), uint32_t) & BM_ADC_CLP3_CLP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLP3 field to a new value.
#define BW_ADC_CLP3_CLP3(x, v) (HW_ADC_CLP3_WR(x, (HW_ADC_CLP3_RD(x) & ~BM_ADC_CLP3_CLP3) | BF_ADC_CLP3_CLP3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLP2 - ADC Plus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLP2 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000080U
 *
 * For more information, see CLPD register description.
 */
typedef union _hw_adc_clp2
{
    uint32_t U;
    struct _hw_adc_clp2_bitfields
    {
        uint32_t CLP2 : 8;             //!< [7:0]
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_adc_clp2_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLP2 register
 */
//@{
#define HW_ADC_CLP2_ADDR(x)      (REGS_ADC_BASE(x) + 0x44U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLP2(x)           (*(__IO hw_adc_clp2_t *) HW_ADC_CLP2_ADDR(x))
#define HW_ADC_CLP2_RD(x)        (HW_ADC_CLP2(x).U)
#define HW_ADC_CLP2_WR(x, v)     (HW_ADC_CLP2(x).U = (v))
#define HW_ADC_CLP2_SET(x, v)    (HW_ADC_CLP2_WR(x, HW_ADC_CLP2_RD(x) |  (v)))
#define HW_ADC_CLP2_CLR(x, v)    (HW_ADC_CLP2_WR(x, HW_ADC_CLP2_RD(x) & ~(v)))
#define HW_ADC_CLP2_TOG(x, v)    (HW_ADC_CLP2_WR(x, HW_ADC_CLP2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLP2 bitfields
 */

/*!
 * @name Register ADC_CLP2, field CLP2[7:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLP2_CLP2     (0U)          //!< Bit position for ADC_CLP2_CLP2.
#define BM_ADC_CLP2_CLP2     (0x000000FFU) //!< Bit mask for ADC_CLP2_CLP2.
#define BS_ADC_CLP2_CLP2     (8U)          //!< Bit field size in bits for ADC_CLP2_CLP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLP2_CLP2 field.
#define BR_ADC_CLP2_CLP2(x)  (HW_ADC_CLP2(x).B.CLP2)
#endif

//! @brief Format value for bitfield ADC_CLP2_CLP2.
#define BF_ADC_CLP2_CLP2(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLP2_CLP2), uint32_t) & BM_ADC_CLP2_CLP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLP2 field to a new value.
#define BW_ADC_CLP2_CLP2(x, v) (HW_ADC_CLP2_WR(x, (HW_ADC_CLP2_RD(x) & ~BM_ADC_CLP2_CLP2) | BF_ADC_CLP2_CLP2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLP1 - ADC Plus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLP1 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000040U
 *
 * For more information, see CLPD register description.
 */
typedef union _hw_adc_clp1
{
    uint32_t U;
    struct _hw_adc_clp1_bitfields
    {
        uint32_t CLP1 : 7;             //!< [6:0]
        uint32_t RESERVED0 : 25;       //!< [31:7]
    } B;
} hw_adc_clp1_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLP1 register
 */
//@{
#define HW_ADC_CLP1_ADDR(x)      (REGS_ADC_BASE(x) + 0x48U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLP1(x)           (*(__IO hw_adc_clp1_t *) HW_ADC_CLP1_ADDR(x))
#define HW_ADC_CLP1_RD(x)        (HW_ADC_CLP1(x).U)
#define HW_ADC_CLP1_WR(x, v)     (HW_ADC_CLP1(x).U = (v))
#define HW_ADC_CLP1_SET(x, v)    (HW_ADC_CLP1_WR(x, HW_ADC_CLP1_RD(x) |  (v)))
#define HW_ADC_CLP1_CLR(x, v)    (HW_ADC_CLP1_WR(x, HW_ADC_CLP1_RD(x) & ~(v)))
#define HW_ADC_CLP1_TOG(x, v)    (HW_ADC_CLP1_WR(x, HW_ADC_CLP1_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLP1 bitfields
 */

/*!
 * @name Register ADC_CLP1, field CLP1[6:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLP1_CLP1     (0U)          //!< Bit position for ADC_CLP1_CLP1.
#define BM_ADC_CLP1_CLP1     (0x0000007FU) //!< Bit mask for ADC_CLP1_CLP1.
#define BS_ADC_CLP1_CLP1     (7U)          //!< Bit field size in bits for ADC_CLP1_CLP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLP1_CLP1 field.
#define BR_ADC_CLP1_CLP1(x)  (HW_ADC_CLP1(x).B.CLP1)
#endif

//! @brief Format value for bitfield ADC_CLP1_CLP1.
#define BF_ADC_CLP1_CLP1(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLP1_CLP1), uint32_t) & BM_ADC_CLP1_CLP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLP1 field to a new value.
#define BW_ADC_CLP1_CLP1(x, v) (HW_ADC_CLP1_WR(x, (HW_ADC_CLP1_RD(x) & ~BM_ADC_CLP1_CLP1) | BF_ADC_CLP1_CLP1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLP0 - ADC Plus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLP0 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLPD register description.
 */
typedef union _hw_adc_clp0
{
    uint32_t U;
    struct _hw_adc_clp0_bitfields
    {
        uint32_t CLP0 : 6;             //!< [5:0]
        uint32_t RESERVED0 : 26;       //!< [31:6]
    } B;
} hw_adc_clp0_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLP0 register
 */
//@{
#define HW_ADC_CLP0_ADDR(x)      (REGS_ADC_BASE(x) + 0x4CU)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLP0(x)           (*(__IO hw_adc_clp0_t *) HW_ADC_CLP0_ADDR(x))
#define HW_ADC_CLP0_RD(x)        (HW_ADC_CLP0(x).U)
#define HW_ADC_CLP0_WR(x, v)     (HW_ADC_CLP0(x).U = (v))
#define HW_ADC_CLP0_SET(x, v)    (HW_ADC_CLP0_WR(x, HW_ADC_CLP0_RD(x) |  (v)))
#define HW_ADC_CLP0_CLR(x, v)    (HW_ADC_CLP0_WR(x, HW_ADC_CLP0_RD(x) & ~(v)))
#define HW_ADC_CLP0_TOG(x, v)    (HW_ADC_CLP0_WR(x, HW_ADC_CLP0_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLP0 bitfields
 */

/*!
 * @name Register ADC_CLP0, field CLP0[5:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLP0_CLP0     (0U)          //!< Bit position for ADC_CLP0_CLP0.
#define BM_ADC_CLP0_CLP0     (0x0000003FU) //!< Bit mask for ADC_CLP0_CLP0.
#define BS_ADC_CLP0_CLP0     (6U)          //!< Bit field size in bits for ADC_CLP0_CLP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLP0_CLP0 field.
#define BR_ADC_CLP0_CLP0(x)  (HW_ADC_CLP0(x).B.CLP0)
#endif

//! @brief Format value for bitfield ADC_CLP0_CLP0.
#define BF_ADC_CLP0_CLP0(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLP0_CLP0), uint32_t) & BM_ADC_CLP0_CLP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLP0 field to a new value.
#define BW_ADC_CLP0_CLP0(x, v) (HW_ADC_CLP0_WR(x, (HW_ADC_CLP0_RD(x) & ~BM_ADC_CLP0_CLP0) | BF_ADC_CLP0_CLP0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLMD - ADC Minus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLMD - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x0000000AU
 *
 * The Minus-Side General Calibration Value (CLMx) registers contain calibration
 * information that is generated by the calibration function. These registers
 * contain seven calibration values of varying widths: CLM0[5:0], CLM1[6:0],
 * CLM2[7:0], CLM3[8:0], CLM4[9:0], CLMS[5:0], and CLMD[5:0]. CLMx are automatically
 * set when the self-calibration sequence is done, that is, CAL is cleared. If
 * these registers are written by the user after calibration, the linearity error
 * specifications may not be met.
 */
typedef union _hw_adc_clmd
{
    uint32_t U;
    struct _hw_adc_clmd_bitfields
    {
        uint32_t CLMD : 6;             //!< [5:0]
        uint32_t RESERVED0 : 26;       //!< [31:6]
    } B;
} hw_adc_clmd_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLMD register
 */
//@{
#define HW_ADC_CLMD_ADDR(x)      (REGS_ADC_BASE(x) + 0x54U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLMD(x)           (*(__IO hw_adc_clmd_t *) HW_ADC_CLMD_ADDR(x))
#define HW_ADC_CLMD_RD(x)        (HW_ADC_CLMD(x).U)
#define HW_ADC_CLMD_WR(x, v)     (HW_ADC_CLMD(x).U = (v))
#define HW_ADC_CLMD_SET(x, v)    (HW_ADC_CLMD_WR(x, HW_ADC_CLMD_RD(x) |  (v)))
#define HW_ADC_CLMD_CLR(x, v)    (HW_ADC_CLMD_WR(x, HW_ADC_CLMD_RD(x) & ~(v)))
#define HW_ADC_CLMD_TOG(x, v)    (HW_ADC_CLMD_WR(x, HW_ADC_CLMD_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLMD bitfields
 */

/*!
 * @name Register ADC_CLMD, field CLMD[5:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLMD_CLMD     (0U)          //!< Bit position for ADC_CLMD_CLMD.
#define BM_ADC_CLMD_CLMD     (0x0000003FU) //!< Bit mask for ADC_CLMD_CLMD.
#define BS_ADC_CLMD_CLMD     (6U)          //!< Bit field size in bits for ADC_CLMD_CLMD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLMD_CLMD field.
#define BR_ADC_CLMD_CLMD(x)  (HW_ADC_CLMD(x).B.CLMD)
#endif

//! @brief Format value for bitfield ADC_CLMD_CLMD.
#define BF_ADC_CLMD_CLMD(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLMD_CLMD), uint32_t) & BM_ADC_CLMD_CLMD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLMD field to a new value.
#define BW_ADC_CLMD_CLMD(x, v) (HW_ADC_CLMD_WR(x, (HW_ADC_CLMD_RD(x) & ~BM_ADC_CLMD_CLMD) | BF_ADC_CLMD_CLMD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLMS - ADC Minus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLMS - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLMD register description.
 */
typedef union _hw_adc_clms
{
    uint32_t U;
    struct _hw_adc_clms_bitfields
    {
        uint32_t CLMS : 6;             //!< [5:0]
        uint32_t RESERVED0 : 26;       //!< [31:6]
    } B;
} hw_adc_clms_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLMS register
 */
//@{
#define HW_ADC_CLMS_ADDR(x)      (REGS_ADC_BASE(x) + 0x58U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLMS(x)           (*(__IO hw_adc_clms_t *) HW_ADC_CLMS_ADDR(x))
#define HW_ADC_CLMS_RD(x)        (HW_ADC_CLMS(x).U)
#define HW_ADC_CLMS_WR(x, v)     (HW_ADC_CLMS(x).U = (v))
#define HW_ADC_CLMS_SET(x, v)    (HW_ADC_CLMS_WR(x, HW_ADC_CLMS_RD(x) |  (v)))
#define HW_ADC_CLMS_CLR(x, v)    (HW_ADC_CLMS_WR(x, HW_ADC_CLMS_RD(x) & ~(v)))
#define HW_ADC_CLMS_TOG(x, v)    (HW_ADC_CLMS_WR(x, HW_ADC_CLMS_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLMS bitfields
 */

/*!
 * @name Register ADC_CLMS, field CLMS[5:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLMS_CLMS     (0U)          //!< Bit position for ADC_CLMS_CLMS.
#define BM_ADC_CLMS_CLMS     (0x0000003FU) //!< Bit mask for ADC_CLMS_CLMS.
#define BS_ADC_CLMS_CLMS     (6U)          //!< Bit field size in bits for ADC_CLMS_CLMS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLMS_CLMS field.
#define BR_ADC_CLMS_CLMS(x)  (HW_ADC_CLMS(x).B.CLMS)
#endif

//! @brief Format value for bitfield ADC_CLMS_CLMS.
#define BF_ADC_CLMS_CLMS(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLMS_CLMS), uint32_t) & BM_ADC_CLMS_CLMS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLMS field to a new value.
#define BW_ADC_CLMS_CLMS(x, v) (HW_ADC_CLMS_WR(x, (HW_ADC_CLMS_RD(x) & ~BM_ADC_CLMS_CLMS) | BF_ADC_CLMS_CLMS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLM4 - ADC Minus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLM4 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000200U
 *
 * For more information, see CLMD register description.
 */
typedef union _hw_adc_clm4
{
    uint32_t U;
    struct _hw_adc_clm4_bitfields
    {
        uint32_t CLM4 : 10;            //!< [9:0]
        uint32_t RESERVED0 : 22;       //!< [31:10]
    } B;
} hw_adc_clm4_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLM4 register
 */
//@{
#define HW_ADC_CLM4_ADDR(x)      (REGS_ADC_BASE(x) + 0x5CU)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLM4(x)           (*(__IO hw_adc_clm4_t *) HW_ADC_CLM4_ADDR(x))
#define HW_ADC_CLM4_RD(x)        (HW_ADC_CLM4(x).U)
#define HW_ADC_CLM4_WR(x, v)     (HW_ADC_CLM4(x).U = (v))
#define HW_ADC_CLM4_SET(x, v)    (HW_ADC_CLM4_WR(x, HW_ADC_CLM4_RD(x) |  (v)))
#define HW_ADC_CLM4_CLR(x, v)    (HW_ADC_CLM4_WR(x, HW_ADC_CLM4_RD(x) & ~(v)))
#define HW_ADC_CLM4_TOG(x, v)    (HW_ADC_CLM4_WR(x, HW_ADC_CLM4_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLM4 bitfields
 */

/*!
 * @name Register ADC_CLM4, field CLM4[9:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLM4_CLM4     (0U)          //!< Bit position for ADC_CLM4_CLM4.
#define BM_ADC_CLM4_CLM4     (0x000003FFU) //!< Bit mask for ADC_CLM4_CLM4.
#define BS_ADC_CLM4_CLM4     (10U)         //!< Bit field size in bits for ADC_CLM4_CLM4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLM4_CLM4 field.
#define BR_ADC_CLM4_CLM4(x)  (HW_ADC_CLM4(x).B.CLM4)
#endif

//! @brief Format value for bitfield ADC_CLM4_CLM4.
#define BF_ADC_CLM4_CLM4(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLM4_CLM4), uint32_t) & BM_ADC_CLM4_CLM4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLM4 field to a new value.
#define BW_ADC_CLM4_CLM4(x, v) (HW_ADC_CLM4_WR(x, (HW_ADC_CLM4_RD(x) & ~BM_ADC_CLM4_CLM4) | BF_ADC_CLM4_CLM4(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLM3 - ADC Minus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLM3 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * For more information, see CLMD register description.
 */
typedef union _hw_adc_clm3
{
    uint32_t U;
    struct _hw_adc_clm3_bitfields
    {
        uint32_t CLM3 : 9;             //!< [8:0]
        uint32_t RESERVED0 : 23;       //!< [31:9]
    } B;
} hw_adc_clm3_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLM3 register
 */
//@{
#define HW_ADC_CLM3_ADDR(x)      (REGS_ADC_BASE(x) + 0x60U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLM3(x)           (*(__IO hw_adc_clm3_t *) HW_ADC_CLM3_ADDR(x))
#define HW_ADC_CLM3_RD(x)        (HW_ADC_CLM3(x).U)
#define HW_ADC_CLM3_WR(x, v)     (HW_ADC_CLM3(x).U = (v))
#define HW_ADC_CLM3_SET(x, v)    (HW_ADC_CLM3_WR(x, HW_ADC_CLM3_RD(x) |  (v)))
#define HW_ADC_CLM3_CLR(x, v)    (HW_ADC_CLM3_WR(x, HW_ADC_CLM3_RD(x) & ~(v)))
#define HW_ADC_CLM3_TOG(x, v)    (HW_ADC_CLM3_WR(x, HW_ADC_CLM3_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLM3 bitfields
 */

/*!
 * @name Register ADC_CLM3, field CLM3[8:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLM3_CLM3     (0U)          //!< Bit position for ADC_CLM3_CLM3.
#define BM_ADC_CLM3_CLM3     (0x000001FFU) //!< Bit mask for ADC_CLM3_CLM3.
#define BS_ADC_CLM3_CLM3     (9U)          //!< Bit field size in bits for ADC_CLM3_CLM3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLM3_CLM3 field.
#define BR_ADC_CLM3_CLM3(x)  (HW_ADC_CLM3(x).B.CLM3)
#endif

//! @brief Format value for bitfield ADC_CLM3_CLM3.
#define BF_ADC_CLM3_CLM3(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLM3_CLM3), uint32_t) & BM_ADC_CLM3_CLM3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLM3 field to a new value.
#define BW_ADC_CLM3_CLM3(x, v) (HW_ADC_CLM3_WR(x, (HW_ADC_CLM3_RD(x) & ~BM_ADC_CLM3_CLM3) | BF_ADC_CLM3_CLM3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLM2 - ADC Minus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLM2 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000080U
 *
 * For more information, see CLMD register description.
 */
typedef union _hw_adc_clm2
{
    uint32_t U;
    struct _hw_adc_clm2_bitfields
    {
        uint32_t CLM2 : 8;             //!< [7:0]
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_adc_clm2_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLM2 register
 */
//@{
#define HW_ADC_CLM2_ADDR(x)      (REGS_ADC_BASE(x) + 0x64U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLM2(x)           (*(__IO hw_adc_clm2_t *) HW_ADC_CLM2_ADDR(x))
#define HW_ADC_CLM2_RD(x)        (HW_ADC_CLM2(x).U)
#define HW_ADC_CLM2_WR(x, v)     (HW_ADC_CLM2(x).U = (v))
#define HW_ADC_CLM2_SET(x, v)    (HW_ADC_CLM2_WR(x, HW_ADC_CLM2_RD(x) |  (v)))
#define HW_ADC_CLM2_CLR(x, v)    (HW_ADC_CLM2_WR(x, HW_ADC_CLM2_RD(x) & ~(v)))
#define HW_ADC_CLM2_TOG(x, v)    (HW_ADC_CLM2_WR(x, HW_ADC_CLM2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLM2 bitfields
 */

/*!
 * @name Register ADC_CLM2, field CLM2[7:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLM2_CLM2     (0U)          //!< Bit position for ADC_CLM2_CLM2.
#define BM_ADC_CLM2_CLM2     (0x000000FFU) //!< Bit mask for ADC_CLM2_CLM2.
#define BS_ADC_CLM2_CLM2     (8U)          //!< Bit field size in bits for ADC_CLM2_CLM2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLM2_CLM2 field.
#define BR_ADC_CLM2_CLM2(x)  (HW_ADC_CLM2(x).B.CLM2)
#endif

//! @brief Format value for bitfield ADC_CLM2_CLM2.
#define BF_ADC_CLM2_CLM2(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLM2_CLM2), uint32_t) & BM_ADC_CLM2_CLM2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLM2 field to a new value.
#define BW_ADC_CLM2_CLM2(x, v) (HW_ADC_CLM2_WR(x, (HW_ADC_CLM2_RD(x) & ~BM_ADC_CLM2_CLM2) | BF_ADC_CLM2_CLM2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLM1 - ADC Minus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLM1 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000040U
 *
 * For more information, see CLMD register description.
 */
typedef union _hw_adc_clm1
{
    uint32_t U;
    struct _hw_adc_clm1_bitfields
    {
        uint32_t CLM1 : 7;             //!< [6:0]
        uint32_t RESERVED0 : 25;       //!< [31:7]
    } B;
} hw_adc_clm1_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLM1 register
 */
//@{
#define HW_ADC_CLM1_ADDR(x)      (REGS_ADC_BASE(x) + 0x68U)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLM1(x)           (*(__IO hw_adc_clm1_t *) HW_ADC_CLM1_ADDR(x))
#define HW_ADC_CLM1_RD(x)        (HW_ADC_CLM1(x).U)
#define HW_ADC_CLM1_WR(x, v)     (HW_ADC_CLM1(x).U = (v))
#define HW_ADC_CLM1_SET(x, v)    (HW_ADC_CLM1_WR(x, HW_ADC_CLM1_RD(x) |  (v)))
#define HW_ADC_CLM1_CLR(x, v)    (HW_ADC_CLM1_WR(x, HW_ADC_CLM1_RD(x) & ~(v)))
#define HW_ADC_CLM1_TOG(x, v)    (HW_ADC_CLM1_WR(x, HW_ADC_CLM1_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLM1 bitfields
 */

/*!
 * @name Register ADC_CLM1, field CLM1[6:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLM1_CLM1     (0U)          //!< Bit position for ADC_CLM1_CLM1.
#define BM_ADC_CLM1_CLM1     (0x0000007FU) //!< Bit mask for ADC_CLM1_CLM1.
#define BS_ADC_CLM1_CLM1     (7U)          //!< Bit field size in bits for ADC_CLM1_CLM1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLM1_CLM1 field.
#define BR_ADC_CLM1_CLM1(x)  (HW_ADC_CLM1(x).B.CLM1)
#endif

//! @brief Format value for bitfield ADC_CLM1_CLM1.
#define BF_ADC_CLM1_CLM1(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLM1_CLM1), uint32_t) & BM_ADC_CLM1_CLM1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLM1 field to a new value.
#define BW_ADC_CLM1_CLM1(x, v) (HW_ADC_CLM1_WR(x, (HW_ADC_CLM1_RD(x) & ~BM_ADC_CLM1_CLM1) | BF_ADC_CLM1_CLM1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ADC_CLM0 - ADC Minus-Side General Calibration Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ADC_CLM0 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLMD register description.
 */
typedef union _hw_adc_clm0
{
    uint32_t U;
    struct _hw_adc_clm0_bitfields
    {
        uint32_t CLM0 : 6;             //!< [5:0]
        uint32_t RESERVED0 : 26;       //!< [31:6]
    } B;
} hw_adc_clm0_t;
#endif

/*!
 * @name Constants and macros for entire ADC_CLM0 register
 */
//@{
#define HW_ADC_CLM0_ADDR(x)      (REGS_ADC_BASE(x) + 0x6CU)

#ifndef __LANGUAGE_ASM__
#define HW_ADC_CLM0(x)           (*(__IO hw_adc_clm0_t *) HW_ADC_CLM0_ADDR(x))
#define HW_ADC_CLM0_RD(x)        (HW_ADC_CLM0(x).U)
#define HW_ADC_CLM0_WR(x, v)     (HW_ADC_CLM0(x).U = (v))
#define HW_ADC_CLM0_SET(x, v)    (HW_ADC_CLM0_WR(x, HW_ADC_CLM0_RD(x) |  (v)))
#define HW_ADC_CLM0_CLR(x, v)    (HW_ADC_CLM0_WR(x, HW_ADC_CLM0_RD(x) & ~(v)))
#define HW_ADC_CLM0_TOG(x, v)    (HW_ADC_CLM0_WR(x, HW_ADC_CLM0_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ADC_CLM0 bitfields
 */

/*!
 * @name Register ADC_CLM0, field CLM0[5:0] (RW)
 *
 * Calibration Value
 */
//@{
#define BP_ADC_CLM0_CLM0     (0U)          //!< Bit position for ADC_CLM0_CLM0.
#define BM_ADC_CLM0_CLM0     (0x0000003FU) //!< Bit mask for ADC_CLM0_CLM0.
#define BS_ADC_CLM0_CLM0     (6U)          //!< Bit field size in bits for ADC_CLM0_CLM0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ADC_CLM0_CLM0 field.
#define BR_ADC_CLM0_CLM0(x)  (HW_ADC_CLM0(x).B.CLM0)
#endif

//! @brief Format value for bitfield ADC_CLM0_CLM0.
#define BF_ADC_CLM0_CLM0(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ADC_CLM0_CLM0), uint32_t) & BM_ADC_CLM0_CLM0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLM0 field to a new value.
#define BW_ADC_CLM0_CLM0(x, v) (HW_ADC_CLM0_WR(x, (HW_ADC_CLM0_RD(x) & ~BM_ADC_CLM0_CLM0) | BF_ADC_CLM0_CLM0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_adc_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All ADC module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_adc
{
    __IO hw_adc_sc1n_t SC1n[2];            //!< [0x0] ADC Status and Control Registers 1
    __IO hw_adc_cfg1_t CFG1;               //!< [0x8] ADC Configuration Register 1
    __IO hw_adc_cfg2_t CFG2;               //!< [0xC] ADC Configuration Register 2
    __I hw_adc_rn_t Rn[2];                 //!< [0x10] ADC Data Result Register
    __IO hw_adc_cv1_t CV1;                 //!< [0x18] Compare Value Registers
    __IO hw_adc_cv2_t CV2;                 //!< [0x1C] Compare Value Registers
    __IO hw_adc_sc2_t SC2;                 //!< [0x20] Status and Control Register 2
    __IO hw_adc_sc3_t SC3;                 //!< [0x24] Status and Control Register 3
    __IO hw_adc_ofs_t OFS;                 //!< [0x28] ADC Offset Correction Register
    __IO hw_adc_pg_t PG;                   //!< [0x2C] ADC Plus-Side Gain Register
    __IO hw_adc_mg_t MG;                   //!< [0x30] ADC Minus-Side Gain Register
    __IO hw_adc_clpd_t CLPD;               //!< [0x34] ADC Plus-Side General Calibration Value Register
    __IO hw_adc_clps_t CLPS;               //!< [0x38] ADC Plus-Side General Calibration Value Register
    __IO hw_adc_clp4_t CLP4;               //!< [0x3C] ADC Plus-Side General Calibration Value Register
    __IO hw_adc_clp3_t CLP3;               //!< [0x40] ADC Plus-Side General Calibration Value Register
    __IO hw_adc_clp2_t CLP2;               //!< [0x44] ADC Plus-Side General Calibration Value Register
    __IO hw_adc_clp1_t CLP1;               //!< [0x48] ADC Plus-Side General Calibration Value Register
    __IO hw_adc_clp0_t CLP0;               //!< [0x4C] ADC Plus-Side General Calibration Value Register
    uint8_t _reserved0[4];
    __IO hw_adc_clmd_t CLMD;               //!< [0x54] ADC Minus-Side General Calibration Value Register
    __IO hw_adc_clms_t CLMS;               //!< [0x58] ADC Minus-Side General Calibration Value Register
    __IO hw_adc_clm4_t CLM4;               //!< [0x5C] ADC Minus-Side General Calibration Value Register
    __IO hw_adc_clm3_t CLM3;               //!< [0x60] ADC Minus-Side General Calibration Value Register
    __IO hw_adc_clm2_t CLM2;               //!< [0x64] ADC Minus-Side General Calibration Value Register
    __IO hw_adc_clm1_t CLM1;               //!< [0x68] ADC Minus-Side General Calibration Value Register
    __IO hw_adc_clm0_t CLM0;               //!< [0x6C] ADC Minus-Side General Calibration Value Register
} hw_adc_t;
#pragma pack()

//! @brief Macro to access all ADC registers.
//! @param x ADC instance number.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_ADC(0)</code>.
#define HW_ADC(x)      (*(hw_adc_t *) REGS_ADC_BASE(x))
#endif

#endif // __HW_ADC_REGISTERS_H__
// v22/130726/0.9
// EOF
