#include "mbed.h"
#include "ADXL345_I2C.h"
#include "ble/BLE.h"
#include "ble/services/UARTService.h"
#include "Serial.h"
#include <math.h>
#include <stdlib.h>
#define MAX 20
#define k 4

#define NEED_CONSOLE_OUTPUT 1 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
#define DEBUG(...) { printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

 ADXL345_I2C accelerometer(p30, p7);
 BLEDevice  ble;
 DigitalOut led1(LED1);
 Serial uart1(USBTX,USBRX);
 UARTService *uartServicePtr;
 
 
 
 
 void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
   
    DEBUG("Connected!\n\r");
    
}

uint8_t b[40]={'a','d','q','w'};
void onDataWritten(const GattWriteCallbackParams *params)
{
    if ((uartServicePtr != NULL) && (params->handle == uartServicePtr->getTXCharacteristicHandle())) {
        uint16_t bytesRead = params->len;
        DEBUG("received %u bytes %s\n\r", bytesRead,params->data);
    }
}

void periodicCallback(void)
{
    led1 = !led1;
}

int threshold =6.8;
int xval[10]={0};
int yval[10]={0};
int zval[10]={0};

using namespace std;
enum category{STANDING,CLIMBING,WALKING};
class data{
    int x,y;
    category cat;
    public:
    void setd(int a,int b,category c){
        x=a;
        y=b;
        cat=c;
    }
    int getx(){return x;}
    int gety(){return y;}
    category getcat(){
        return cat;
    }
};//end of class
int dis(data d1,data d2)
{
    return sqrt(pow(((double)d2.getx()-(double)d1.getx()),2.0)+pow(((double)d2.gety()-(double)d1.gety()),2.0));
}

 int main() 
 {
     uart1.baud(9600);
     int readings[3] = {0, 0, 0};
     char buffer [20];
     
        //inisiliasi
        int steps=0;
        int flag=0;
        int acc=0;
        int totvect   [20] = {0};
        int totave    [20] = {0};
        int totvel    [20] = {0};
        int totdist   [20] = {0};
        
            
        
        //float sum1, sum2, sum3 = 0
        int xaccl[20];
        int yaccl[20];
        int zaccl[20];
       
       // Test Daata
       memset(&buffer, 0, sizeof(buffer));
       int16_t reading_1= 0;
       int16_t reading_2= 0;
       int16_t reading_3= 0;
       int16_t avg_1= 0;
       int16_t avg_2= 0;
       int16_t avg_3= 0;
       snprintf(buffer, 20, "data: %d,%d,%d,%d,%d,%d\n",(int16_t)reading_1,(int16_t)reading_2,(int16_t)reading_3,(int16_t)avg_1,(int16_t)avg_2,(int16_t)avg_3);
       
       int p,q; //input
       int a[MAX]; //store distances
       int b[k]; //to get min distances, used in calc
       int c[k]; //to store freq

       
    led1 = 1;
    uart1.baud(9600);
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    
    DEBUG("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onConnection(connectionCallback);
    ble.onDataWritten(onDataWritten);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"BLE UART", sizeof("BLE UART") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(1000); /* 1000ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    UARTService uartService(ble);
    uartServicePtr = &uartService;
    
     uart1.printf("Starting ADXL345 test...\n");
     wait(0.1);
     uart1.printf("Device ID is: 0x%02x\n", accelerometer.getDeviceID());
     wait(0.1);

    
    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);

    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);
    
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);

    //Measurement mode.
    accelerometer.setPowerControl(0x08);
    
       
      
     while (1) 
     {
         ble.waitForEvent();
         wait(0.1);
         accelerometer.getOutput(readings);
         /*uart1.printf("\n%i, %i, %i\n", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
         memset(&buffer, 0, sizeof(buffer));
         snprintf(buffer, 20, "data: %d,%d,%d\n\n", (int16_t)readings[0],(int16_t)readings[1],(int16_t)readings[0]);
         ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), (uint8_t*)buffer, sizeof(buffer), false);*/
         
         
         //float x,y,z
        for (int i=0; i<10; i++)
        {
            xaccl[i]=(readings[0]);
            wait(0.1);
            yaccl[i]=(readings[1]);
            wait(0.1);
            zaccl[i]=(readings[2]);
            wait(0.1);
            
            
            //formula
            totvect[i] = sqrt(pow((double)xaccl[i],2.0)+pow((double)yaccl[i],2.0)+pow((double)zaccl[i],2.0));
            wait(0.3);
            totave[i] = ((double)totvect[i]+(double)totvect[i-1])/2.0 ;
            wait(0.3);
            acc=acc+totave[i];
            wait(0.3);
            totvel[i]=(1*((double)totave[i]-(double)totave[i-1]/2.0)+totvel[i-1]);
            wait(0.3);
            totdist[i]=(1*((double)totvel[i]-(double)totvel[i-1]/2.0)+totdist[i-1]);         
         
         
         //cal steps
         if (totave[i] > threshold && flag==0)
         {
             steps = steps+1;
             flag=1;
         }
         else if (totave[i] > threshold && flag == 1)
         {
          // do nothing   
         }
         if (totave[i] < threshold && flag == 1)
             {flag=0;}
             uart1.printf("\nsteps:%i", (int16_t)steps);
             memset(&buffer, 0, sizeof(buffer));
             snprintf(buffer, 20, "\n%d\t", (int16_t)steps);
             ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), (uint8_t*)buffer, sizeof(buffer), false);
             
            uart1.printf("\tacc:%i", (int16_t)totave[i]);
            memset(&buffer, 0, sizeof(buffer));
            snprintf(buffer, 20, "\t%d", (int16_t)totave[i]);
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), (uint8_t*)buffer, sizeof(buffer), false);
        
            uart1.printf("\tvel:%i", (int16_t)totvel[i]);
            memset(&buffer, 0, sizeof(buffer));
            snprintf(buffer, 20, "\t%d", (int16_t)totvel[i]);
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), (uint8_t*)buffer, sizeof(buffer), false);

            uart1.printf("\tdist:%i", (int16_t)totdist[i]);
            memset(&buffer, 0, sizeof(buffer));
            snprintf(buffer, 20, "\t%d\n", (int16_t)totdist[i]);
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), (uint8_t*)buffer, sizeof(buffer), false);
  
      
        }
       
       do{
        wait(0.1);
        
        for(int i=0;i<k;i++)
        { //initiLIZATION
            b[i]=-1;
            c[i]=0;
        } 
        int min=1000;
        p = (readings[0]);
        q = (readings[1]);
        //uart1.scanf("%ld,%ld",&p,&q);
        if((p < 0) | (q < 0))
            exit(0);
        data n; //data point to classify
        n.setd(p,q,STANDING);
        data d[MAX]; //training set
        
        d[0].setd(1,1,STANDING);
        d[1].setd(1,2,STANDING);
        d[2].setd(1,3,STANDING);
        d[3].setd(1,4,STANDING);
        d[4].setd(1,5,STANDING);
        d[5].setd(1,6,STANDING);
        d[6].setd(1,7,STANDING);
        d[7].setd(2,1,STANDING);
        d[8].setd(2,2,STANDING);
        d[9].setd(2,3,WALKING);
        d[10].setd(2,4,WALKING);
        d[11].setd(2,5,WALKING);
        d[12].setd(2,6,WALKING);
        d[13].setd(2,7,WALKING);
        d[14].setd(5,1,CLIMBING);
        d[15].setd(5,2,CLIMBING);
        d[16].setd(5,3,CLIMBING);
        d[17].setd(5,4,CLIMBING);
        d[18].setd(5,5,CLIMBING);
        d[19].setd(5,6,CLIMBING);
        for(int i=0;i<20;i++){
            a[i]=dis(n,d[i]);
            //uart1.printf("\t\t %d\n", a[i]);
        }
        //k-nearest neighbours calculation i.e smallest k distances
        for(int j=0;j<k;j++)
        {
            min=1000;
            for(int i=0;i<20;i++)
            {
                if(i!=b[0]&&i!=b[1]&&i!=b[2])
                { 
                    if((a[i]<=min))
                    {
                        min=a[i];
                        b[j]=i;
                    }
                }
            } 
            
            //uart1.printf("%d\n",min);
        }
        //counting frequency of a class in each neighbour   
        for(int i=0;i<k;i++)
        {
            switch (d[b[i]].getcat())
            { 
            case STANDING:
                c[0]++;
                break;
            case WALKING:
                c[2]++;
                break;
            case CLIMBING:
                c[1]++;
                break;
            }
        } //counting max frequency
        int max=-1,j;
        for(int i=0;i<k;i++)
        {    
            if(c[i]>max){
                max=c[i];
                j=i;
            }
        }
       
            wait(0.1);
            printf("Prediction is:");
            switch (j)
            {    
            case 0:
                uart1.printf("STANDING\n");
                break;
            case 1:
                uart1.printf("CLIMBING\n");
                break;
            case 2:
                uart1.printf("WALKING\n");
                break;
            }
         
        
    }while(true); 
        
    }
 
 }
 
