#include "mbed.h"
#include <iostream>
#include "conio.h"
#include "Serial.h"
Serial uart1(USBTX,USBRX);

int main()
{
    uart1.baud(9600);
    wait(0.1);
    iint i,j,l;
    int tsc=12;
    char gen[12]={'F','M','F','F','F','M','F','M','M','F','M','F'};
    float h[12]={1.6f,2.0f,1.9f,1.88f,1.7f,1.85f,1.6f,1.7f,2.2f,1.8f,1.95f,1.9f};
    char op[12][10]={"short","tall","medium","medium","short","medium","short","short","tall","medium","medium","medium"};
 
    uart1.printf("\n Initial Set:");
    uart1.printf("\nGender\tHeight\tOutput");
    for(i=0;i<12;i++)
    {
        uart1.printf("%d, %d, %d \n",gen[i], h[i], op[i]);
    }
 
    float nh;
    char ng;
    uart1.printf("\n Enter tuple to be processed (Height,Gender) :");
    cin>>nh>>ng;
 
    int t;
    uart1.printf("\n Enter threshold:");
    cin>>t;
 
    float d[12][2],k;
 
    //calculating distance to each value in training set
    for(i=0;i<12;i++)
    {
        d[i][0]=i;
        k=h[i]-nh;
        if(k<0)
        {
            d[i][1]=-k;
        }
        else
        {
            d[i][1]=k;
        }
    }
 
    //Sorting
    for(i=0;i<11;i++)
    {
        for(j=0;j<11;j++)
        {
            if(d[j][1]>d[j+1][1])
            {
                k=d[j][1];
                d[j][1]=d[j+1][1];
                d[j+1][1]=k;
 
                l=d[j][0];
                d[j][0]=d[j+1][0];
                d[j+1][0]=l;
            }
        }
    }
 
    int nos=0;  //no of shorts
    int nom=0;  //no of mediums
    int not=0;  //no of talls
 
    uart1.printf("\nGender\tHeight\tOutput\n");
    for(i=0;i<t;i++)
    {
        l=d[i][0];
        uart1.printf("%d, %d, %d\n",gen[l],h[l],op[l]);
        if(strcmp(op[l],"short")==0)
        {
            nos++;
        }
        if(strcmp(op[l],"medium")==0)
        {
            nom++;
        }
        if(strcmp(op[l],"tall")==0)
        {
            not++;
        }
    }
 
    uart1.printf("\n No of shorts:")<<nos;
    uart1.printf("\n No of medium:")<<nom;
    uart1.printf("\n No of tall:")<<not;
 
    if(nos>nom&&nos>not)
    {
        uart1.printf("\n New Tuple is classified as Short");
    }
 
    if(nom>nos&&nom>not)
    {
        uart1.printf("\n New Tuple is classified as Medium");
    }
 
    if(not>nom&&not>nos)
    {
        uart1.printf("\n New Tuple is classified as Tall");
    }
    
    getch();
}
 
 