#include "mbed.h"
#include "dataset.h"
#include "funcionesKNN.h"
#include <string>
Serial pc(USBTX, USBRX);
#define FI 100 // filas de la base de datos
#define CO 4   // numero de caracteristicas

// variables 
/*char* clasesSt[3]; // strings con las clases
char* nomAtr[CO]; // strings con los nombres de atributos
double atributos[FI][CO]; // atributos
int clasesNo[FI]; // clases
*/
double dato[CO]; // dato a clasificar
long actual = 0, previo = 0;

//-----------------------------------------------------------------------
// Extrae caracteres dados los identificadores y los convierte a double
//-----------------------------------------------------------------------
void extraeDatos(string str, double dato[], char dlm[]){
  
  string auxstr = "";
  int posdlm[5], tamstr = 0;
  int i= 0, j = 0;
  
  // buscar caracteres de identificacion
  posdlm[0] = str.indexOf(dlm[0]); // (
  posdlm[1] = str.indexOf(dlm[1]); // ,
  posdlm[2] = str.indexOf(dlm[1], posdlm[1] + 1); // ,
  posdlm[3] = str.indexOf(dlm[1], posdlm[2] + 1); // ,
  posdlm[4] = str.indexOf(dlm[2]); // )
    
  for(j=0; j<CO; j++){
    // extraer datos numericos
    for(i=posdlm[j]+1; i<posdlm[j+1]; i++){
      auxstr = auxstr + str[i];  
    }

    //convertir a double
    int y = auxstr.length();
    char buf[y+1];
    auxstr.toCharArray(buf, y+1);
    dato[j] = atof(buf);
    
    //Serial.println(dato[j],3);
    auxstr=""; // reset del auxiliar
    }      
}

//-----------------------------------------------------------------------
// Impresion de confirmacion
//-----------------------------------------------------------------------
void imprime(double dato[], int clase){
  
  pc.printf("-----------------------------------------------\n");
  pc.printf("%i",(int16_t)nomAtr[0]); pc.printf(": "); pc.printf("%i",(int16_t)dato[0],3); pc.printf(" cms\n");
  pc.printf("%i",(int16_t)nomAtr[1]); pc.printf(": "); pc.printf("%i",(int16_t)dato[1],3); pc.printf(" cms\n");
  pc.printf("%i",(int16_t)nomAtr[2]); pc.printf(": "); pc.printf("%i",(int16_t)dato[2],3); pc.printf(" cms\n");
  pc.printf("%i",(int16_t)nomAtr[3]); pc.printf(": "); pc.printf("%i",(int16_t)dato[3],3); pc.printf(" cms\b");
  pc.printf(" >> Clase: "); pc.printf("%i\n",(int16_t)clasesSt[clase]);
}

//-----------------------------------------------------------------------
// Configuracion del microcontrolador
//-----------------------------------------------------------------------
int main() 
{
  pc.baud(9600);
  //Serial.begin(9600);
  wait(0.1);
  pc.printf("===============================================\n");
  pc.printf("===            KKN Classification           ===\n");
  pc.printf("===============================================\n");
  wait(0.05);
  
  //-----------------------------------------------------------------------
// Programa principal
//-----------------------------------------------------------------------
    while(1) 
    {
  
        // recibir los datos a clasificar
        if(Serial.available())
        {
       
            // recibir una cadena hasta que se tenga el '\n'
            string str = Serial.readStringUntil('\n');  
            extraeDatos(str, dato, "{,}");
    
            // tic
            previo = millis();    
          
            // encontrar la clase, con 5 vecinos cercanos
            int cl = clasificaKNN((double**)atributos, clasesNo, dato, 11, FI, CO);
            pc.printf("%i\n",(int16_t)cl);

            // tac
            actual = millis();
  
            // imprimir
            imprime(dato, cl);
            pc.printf("Tiempo: "); pc.printf("%i\n",(int16_t)actual-previo); pc.printf(" mS\n");
        }
    }
}


