#ifndef SHIFTBRITE_H
#define SHIFTBRITE_H

#include "mbed.h"

#define RED(color) (((color) >> 16) & 0xFF) << 2
#define GREEN(color) (((color) >> 8) & 0xFF) << 2
#define BLUE(color) ((color) & 0xFF) << 2

class ShiftBrite
{
    public:
        ShiftBrite(PinName spi1, PinName spi2, PinName spi3, PinName latch);
        void writeCommand(int command);
        void setColorRGB(int red, int green, int blue);
        void setColor(int color);
        void fadeColor(int color1, int color2, float time);
        void writeInit(int red_level, int green_level, int blue_level);
        
    protected:
        SPI spi;
        DigitalOut latch;
 };        

#endif
