#include "ShiftBrite.h"

ShiftBrite::ShiftBrite(PinName spi1, PinName spi2, PinName spi3, PinName latch_) : spi(spi1, spi2, spi3), latch(latch_)
{
    spi.format(16, 0);
    spi.frequency(500000);
    latch = 0;
}

void ShiftBrite::writeCommand(int command)
{
    spi.write(command >> 16);
    spi.write(command & 0x0000ffff);
    latch = 1;
    wait(0.00001);
    latch = 0;
}

void ShiftBrite::writeInit(int red_level, int green_level, int blue_level)
{
    unsigned int Init_Command = 0x40000000;
    Init_Command = 0x40000000|(blue_level<<20)|(red_level<<10)|green_level;
    spi.write(Init_Command >> 16 & 0xFFFF);
    spi.write(Init_Command & 0xFFFF);
    wait(.000015);
    latch=1;
    wait(.000015);
    latch=0;
}

void ShiftBrite::setColorRGB(int red, int green, int blue)
{
    int command = (blue << 20) | (red << 10) | green;
    writeCommand(command);
}

void ShiftBrite::setColor(int color)
{
    setColorRGB(RED(color), GREEN(color), BLUE(color));
}

void ShiftBrite::fadeColor(int color1, int color2, float time)
{
    int red1 = RED(color1);
    int green1 = GREEN(color1);
    int blue1 = BLUE(color1);
    int red2 = RED(color2);
    int green2 = GREEN(color2);
    int blue2 = BLUE(color2);
    
    float rstep = (red2 - red1) / 256.0;
    float gstep = (green2 - green1) / 256.0;
    float bstep = (blue2 - blue1) / 256.0;
    float steptime = time / 256.0;
    
    for (int i = 0; i < 256; i++)
    {
        setColorRGB(red1 + (int)(rstep * i), green1 + (int)(gstep * i), blue1 + (int)(bstep * i));
        wait(steptime);
    }
    setColorRGB(red2, green2, blue2);
}
