// Allen Wild
// ECE 4180, Spring 2015
// Lab 1 solution

#include "mbed.h"

//#define PART1
//#define PART2
//#define PART3
//#define EXCRED1
//#define EXCRED2 // not implemented here
//#define EXCRED3
//#define EXCRED4 // not implemented here
#define EXCRED5

DigitalIn  button1(p21);
DigitalIn  button2(p24);

#ifdef PART1 //{{{
DigitalOut led(p26);

int main()
{
    while(1)
    {
        led = !button2;
        wait_ms(50);
    }
}
#endif //}}}

#ifdef PART2 //{{{
PwmOut led(p26);

int main()
{
    float val = 0.5;

    while (1)
    {
        if (button1)
        {
            val += 0.01;
            if (val > 1)
                val = 1;
        }
        if (button2)
        {
            val -= 0.01;
            if (val < 0)
                val = 0;
        }
        led = val;
        wait_ms(20);
    }
}
#endif //}}}

#ifdef PART3 //{{{
#include "MCP23S17.h"
SPI spi(p11, p12, p13);
MCP23S17 chip(spi, p14, 0x40);

int main()
{
    chip.direction(PORT_A, 0xFF); // input
    chip.direction(PORT_B, 0x00); // output
    chip.configurePullUps(PORT_A, 0x01);

    while (1)
    {
        char port_val = chip.read(PORT_A);
        chip.write(PORT_B, ~port_val & 0x01);
        wait_ms(50);
    }
}
#endif //}}}

#ifdef EXCRED1 //{{{
// Watchdog Timer

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led(p26);

void wdt_kick()
{
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}

void wdt_setup(float s)
{
    // from cookbook page
    LPC_WDT->WDCLKSEL = 0x1;
    uint32_t clk = SystemCoreClock / 16;
    LPC_WDT->WDTC = s * (float)clk;
    LPC_WDT->WDMOD = 0x3;
    wdt_kick();
}

int main()
{
    led1 = 0;
    if ((LPC_WDT->WDMOD >> 2) & 1)
        led2 = 1;
    else
        led2 = 0;

    wdt_setup(3.0);
    
    while (1)
    {
        led = !button2;
        wait_ms(50);
        if (!button1)
        {
            led1 = 1;
            while (1); // get stuck if button1 pressed
        }
        wdt_kick();
    }
}
#endif //}}}

#ifdef EXCRED3 //{{{

SPI spi(p5, p6, p7);
DigitalOut latch(p9);
DigitalOut nenable(p8);

void shiftbrite_write(int color)
{
    int red = (color >> 16) & 0xFF;
    int green = (color >> 8) & 0xFF;
    int blue = color & 0xFF;
    int command = (blue << 20) | (red << 10) | green;
    spi.write(command >> 16);
    spi.write(command & 0x0000ffff);
    latch = 1;
    wait(0.00001);
    latch = 0;
}

#define N_COLORS 6
const int colors[N_COLORS] = {0xff0000, 0xffff00, 0x00ff00, 0x00ffff, 0x0000ff, 0xff00ff};

int main()
{
    // set up ShiftBrite
    spi.format(16, 0);
    spi.frequency(500000);
    latch = 0;
    nenable = 0;
    shiftbrite_write(colors[0]);

    int i = 1;
    while (1)
    {
        if (!button2) // change color when button pressed
        {
            shiftbrite_write(colors[i]);
            if (++i >= N_COLORS)
                i = 0;
            while (!button2); // wait until button releases
        }
        if (!button1)
        {
            nenable = !nenable; // toggle enable pin
            while (!button1);
        }
        wait_ms(50);
    }
}

#endif //}}}

#ifdef EXCRED5 //{{{
#include "MCP23S17.h"

SPI spi(p11, p12, p13);
MCP23S17 chip1(spi, p14, 0x40);
MCP23S17 chip2(spi, p14, 0x42);

int main()
{
    chip1.direction(PORT_A, 0xFF); // input
    chip1.direction(PORT_B, 0x00); // output
    chip1.configurePullUps(PORT_A, 0x01);
    chip2.direction(PORT_A, 0xFF);
    chip2.direction(PORT_B, 0x00);

    while (1)
    {
        char port_val = chip1.read(PORT_A);
        chip1.write(PORT_B, ~port_val & 0x01);
        chip2.write(PORT_B, ~port_val & 0x01);
        wait_ms(50);
    }
}

#endif //}}}
