#include "mbed.h"
#include "USBHost.h"
#include "Utils.h"

Serial pc(USBTX, USBRX);
Serial rob(p13, p14);
DigitalIn modeSw(p19);

// because of wiring on the breadboard, these pins are connected to 5V or
// ground (for the robot and BlueSMiRF connections) so configure them as inputs
// to avoid shorting anything out
DigitalIn di11(p11);
DigitalIn di12(p12);
DigitalIn di15(p15);
DigitalIn di16(p16);

extern DigitalOut led1, led2, led3, led4;

Ticker failsafeTick;
time_t lastReportTime;

void failsafe()
{
    time_t t = time(NULL);
    if (t > lastReportTime+1)
    {
        rob.puts("stop\r");
        led3 = 1;
    }
}

void RunWiimote();
void RunAndroid();

int main()
{
    modeSw.mode(PullDown);
    rob.baud(19200);
    set_time(9001);
    failsafeTick.attach(&failsafe, 0.1);
    
    printf("Vroom Vroom!\n");
    if (modeSw)
        RunWiimote();
    else
        RunAndroid();
}
