#include "mbed.h"

extern Serial rob;
extern DigitalOut led1, led2, led3, led4;

Serial bt(p9, p10);  // tx, rx
DigitalIn d11(p11),d12(p12),d15(p15),d16(p16);
DigitalOut out(p18);
extern AnalogIn ir;

char c;
int dir;
char garbage;
float y;
char stringIn[128];
int valout;
int maxVel = 50;
int maxVelb = -maxVel;
int i=0;

extern time_t lastReportTime;

int RunAndroid()
{
    bt.baud(19200);  
    while(1)
    {
        if(bt.readable())
        {
            i = 0;
            while((c=bt.getc()) != '\0')
                stringIn[i++] = c;

            stringIn[i]=0;
            if(stringIn[0] == 'X')
                sscanf(stringIn,"%s %d %f",&garbage, &dir,&y);  

            if (abs(y) >= 500) 
                valout = -floor((2*(abs(y)-500)/1000)*maxVel);
            else
                valout = maxVel- floor((2*abs(y)/1000)*maxVel);
                
            bool wall = ir.read() > (2.0 / 3.3);
                led4 = wall;

            if (wall && dir == 1)
                rob.printf("stop\r");
            else if(dir == 1)
            {
                if (y <= 0)
                    rob.printf("mogo 1:%d 2:%d\r",maxVel, valout);

                else if (y>0)
                    rob.printf("mogo 1:%d 2:%d\r",valout,maxVel);

            }
            else if(dir == -1)
            {
                valout = -valout;

                if (y <= 0)
                    rob.printf("mogo 1:%d 2:%d\r",-maxVel, valout);

                else if (y>0)
                    rob.printf("mogo 1:%d 2:%d\r",valout,-maxVel);

            }  
            else
                rob.printf("stop\r");

            lastReportTime = time(NULL);
            led3 = 0;
        }
    }
}
