/*
 * Allen Wild
 * Joseph Guinta
 *
 * ECE 4180 Lab 1
 */

#include "mbed.h"
#include "rtos.h"
#include "MCP23S17.h"
#include "ShiftBrite.h"

#define PB0_PIN p20
#define LED_PIN p29
#define PWM_PIN p21
#define EX_CS_PIN p18

void updateSBColor(void const *args);

DigitalIn pb1(PB0_PIN);
DigitalOut led(LED_PIN);
PwmOut pwm(PWM_PIN);

SPI ex_spi(p11, p12, p13);
MCP23S17 ex(ex_spi, EX_CS_PIN, 0x40);

// flags set when reading/writing the SPI extender,
// helpful for knowing what's happening in the logic analyzer
DigitalOut ex_read(p24);
DigitalOut ex_write(p23);

ShiftBrite sb(p5, p6, p7, p8);
const int sbcolors[] = {0xff0000, 0xffff00, 0x00ff00, 0x00ffff, 0x0000ff, 0xff00ff};
int sbci = 0;

// brightness of PWM output
float bright = 0.0f;
bool pb1p = false;

int main()
{
    // set extender as inputs, configure internal pullups
    ex.direction(PORT_A, 0xFF);
    ex.configurePullUps(PORT_A, 0x90);
    // port B as outputs (for LED)
    ex.direction(PORT_B, 0x00);
    
    ex_read = 0;
    ex_write = 0;

    sb.writeInit(32, 0, 0);
    sb.fadeColor(0, 0xff0000, 0.5);
    
    // set PWM to 100Hz
    pwm.period_ms(10);

    // oh no, I'm multithreading this
    // god help us all...
    Thread sbThread(updateSBColor);

    while (true)
    {
        // read button and turn on LED if pressed
        pb1p = !pb1;
        led = pb1p;
        if (pb1p)
            sbThread.signal_set(0x1);
        while (!pb1);

        // use pushbuttons on extender to control PWM brightness
        // invert because active-low switches
        ex_read = 1;
        char edata = ~(ex.read(PORT_A));
        ex_read = 0;

        // if either button pressed, turn on ex LED
        if (edata & 0x90)
        {
            ex_write = 1; // note: debugging signal only
            ex.write(PORT_B, 1);
            ex_write = 0;
        }
        else
        {
            ex_write = 1;
            ex.write(PORT_B, 0);
            ex_write = 0;
        }

        // if button 1 and below max brightness, increment by 1%
        if ((edata&0x80) && bright < 1.0)
            bright += 0.01;
        // likewise for button 2 to decrement
        if ((edata&0x10) && bright > 0)
            bright -= 0.01;
        pwm = bright;

        Thread::wait(10);
    }
}

// SB color fading happens in a different thread
void updateSBColor(void const *args)
{
    while (true)
    {
        //Thread::wait(100);
        Thread::signal_wait(0x1);
        sb.fadeColor(sbcolors[(sbci != 0) ? sbci-1 : 5], sbcolors[sbci], 0.5);
        if (++sbci > 5)
            sbci = 0;
    }
}