    AREA    binary_clock, CODE, READONLY
    EXPORT  my_leds
    
; Define some constants to make things more readable.
ALLLEDS     EQU 0xB40000   ; Bit mask for all 4 LEDs.
LEDBASEADDR EQU 0x2009C020
LEDSETOFF   EQU 0x18
LEDCLROFF   EQU 0x1C

my_leds
    ; First clear all of the LEDs.
    LDR     R1, =LEDBASEADDR
    LDR     R2, =ALLLEDS
    STR     R2, [R1, #LEDCLROFF]

    ; Make sure we only use the 4 LSBs.
    AND     R0, R0, #0xF
    ; Reverse bits to make LED order more intuitive.
    RBIT    R0, R0
    LSR     R0, R0, #28
    
    ; Store the 4th bit in R2.
    UBFX    R2, R0, #0x3, #0x1
    ; Clear bit 4 of the input.
    BIC     R0, R0, #0x8
    ; If R2 is set, place a bit in bit 5.
    BFI     R0, R2, #0x4, #0x1
    
    ; Shift input right once to store and delete LSB.
    LSRS    R0, R0, #1
    
    ; Now bit 1 is stored in C and R0 contains bits 2, 3, and 4 starting at the LSB position.
    ; Shift R0 left to put bits 2, 3, and 4 in the correct position.
    LSL     R0, R0, #20
    
    ; Conditionally insert bit 1 into R0.
    ORRCS   R0, R0, #0x040000   ; LED1
    
    ; Now use our full mask to set correct LEDs.
    STR     R0, [R1, #LEDSETOFF]
    
    ; Return
    BX      LR
    ALIGN
    END
    