
#include "mbed.h"

class LEDController{
public:
    
    /*
     * Identifies what note was passed in and passes this information along to chooseLEDForNote.
     * @param key The integer representation of the note
     * @param type This integer determines whether the event coming in is an "on" or "off" event
     */
    void identifyKeyForLed(int key, int type);

private:    
    /*
     * Finds an available LED to light up or turn off depending on the type param.
     * @param key[] This is the notes information such as the numerical key value and RGB values.
     * @param type This integer determines whether the event coming in is an "on" or "off" event.
     * @param signature Determines whether the note is sharp or not
     */
    void chooseLedForKey(int colors[3], int type, int signature, int key);
    
    /*
     * Sets the chosen LED to the proper color of the note passed in.
     * @param key[] This is the notes information such as the numerical key value and RGB values.
     * @param type This integer determines whether the event coming in is an "on" or "off" event.
     * @param signature Determines whether the note is sharp or not
     * @param led Determines which LED to light up
     */
    void setLedToKey(int colors[3], int type, int signature, int led, int key);
    
    
};    