#include "mbed.h"
#include "LEDController.h"

//Pins that output values to the brick LED
DigitalOut brickled1(p5);
DigitalOut brickled2(p6);
DigitalOut brickled3(p7);
DigitalOut brickled4(p8);

//Pins that output values to the tri-color LEDS for cLED1
DigitalOut myled1_1(p9);
DigitalOut myled1_2(p10);
DigitalOut myled1_3(p11);

//Pins that output values to the tri-color LEDS for LED2
DigitalOut myled2_1(p12);
DigitalOut myled2_2(p13);
DigitalOut myled2_3(p14);

//Pins that output values to the tri-color LEDS for LED3
DigitalOut myled3_1(p15);
DigitalOut myled3_2(p16);
DigitalOut myled3_3(p17);

//Pins that output values to the tri-color LEDS for LED4
DigitalOut myled4_1(p18);
DigitalOut myled4_2(p19);
DigitalOut myled4_3(p20);

void identifyKeyForLed(int key, int type);
void chooseLedForKey(int colors[3], int type, int signature, int key);
void setLedToKey(int colors[3], int type, int signature, int led, int key);

//These are the color assignments for the keys. In order, C, C#, D, D#, E,F, F#, G, G#, A, A#, B
int colors[12][3] = {{1,0,1},{1,0,1},{1,0,0},{1,0,0},{0,1,0},{0,0,1},{0,0,1},{1,1,0},{1,1,0},{0,1,1},{0,1,1},{1,1,1}};

//This holds the current key of the LED. If no key is in the LED then the value for that slot is -1.
int ledKeys[4] = {-1,-1,-1,-1};

const int SHARP = 1;
const int NOT_SHARP = 0;

const int cLED1 = 1;
const int cLED2 = 2;
const int cLED3 = 3;
const int cLED4 = 4;

const int cSharp = 1;
const int dSharp = 3;
const int fSharp = 6;
const int gSharp = 8;
const int aSharp = 10;

//Identifies the key.
void LEDController::identifyKeyForLed(int key, int type){
   
   //Performs modulus to determine key. This also determines color and signature.
   int determineColorSignature = key%12;

   //If modulus operation is any of these values then it means the key is sharp. 
   if(determineColorSignature == cSharp || determineColorSignature == dSharp || determineColorSignature == fSharp 
      || determineColorSignature == gSharp || determineColorSignature == aSharp){
        chooseLedForKey(colors[determineColorSignature], type, SHARP, key);
    }else{
        chooseLedForKey(colors[determineColorSignature], type, NOT_SHARP, key);
    }     
} 

//Chooses which LED needs to perform an action. Either turning on a light to the specific note
//color or turning off the LED when the key is no longer active.
void LEDController::chooseLedForKey(int colors[3], int type, int signature, int key){
    
    //Determines if the LED is not set and therefore can be used. 
    if(type == -1){
        if(ledKeys[0] == key){
          setLedToKey(colors, type, signature, 1, key);
        }else if(ledKeys[1] == key){
          setLedToKey(colors, type, signature, 2, key);
        }else if(ledKeys[2] == key){
          setLedToKey(colors, type, signature, 3, key);
        }else if(ledKeys[3] == key){
          setLedToKey(colors, type, signature, 4, key);
        }        
    } else {
        if(ledKeys[0] == -1){
            setLedToKey(colors, type, signature, 1, key);
        }else if(ledKeys[1] == -1){
            setLedToKey(colors, type, signature, 2, key);
        }else if(ledKeys[2] == -1){
            setLedToKey(colors, type, signature, 3, key);
        }else if(ledKeys[3] == -1){
            setLedToKey(colors, type, signature, 4, key);
        }
    }
}

//This sets the LED to the key or clears the previously set LED of that specific key if the type is off.
void LEDController::setLedToKey(int colors[3], int type, int signature, int led, int key){
 if(led == cLED1){
        if(type == 1){
            ledKeys[0] = key;
            myled1_1 = colors[0];
            myled1_2 = colors[1];
            myled1_3 = colors[2];
            if(signature == SHARP){
                brickled1 = 1;
             }
         }else{
            ledKeys[0] = -1;
            myled1_1 = 0;
            myled1_2 = 0;
            myled1_3 = 0;
            brickled1 = 0;
         }
    }else if(led == cLED2){
        if(type == 1){
            ledKeys[1] = key;
            myled2_1 = colors[0];
            myled2_2 = colors[1];
            myled2_3 = colors[2];
            if(signature == SHARP){
                brickled2 = 1;
             }
     }else{
            ledKeys[1] = -1;
            myled2_1 = 0;
            myled2_2 = 0;
            myled2_3 = 0;
            brickled2 = 0;
     }
    }else if(led == cLED3){
        if(type == 1){
            ledKeys[2] = key;
            myled3_1 = colors[0];
            myled3_2 = colors[1];
            myled3_3 = colors[2];
            if(signature == SHARP){
                brickled3 = 1;
             }
     }else{
            ledKeys[2] = -1;
            myled3_1 = 0;
            myled3_2 = 0;
            myled3_3 = 0;
            brickled3 = 0;
     }
    }else if(led == cLED4){
        if(type == 1){
            ledKeys[3] = key;
            myled4_1 = colors[0];;
            myled4_2 = colors[1];
            myled4_3 = colors[2];
            if(signature == SHARP){
                brickled4 = 1;
             }
     }else{
            ledKeys[3] = -1;
            myled4_1 = 0;
            myled4_2 = 0;
            myled4_3 = 0;
            brickled4 = 0;
     }
    }
        
}        
