
/**
 * The processor used for teh implementation of Karplus strong.
 *
 * @author Austin Suszek
 */

#ifndef AS_KARPLUS_STRONG_H
#define AS_KARPLUS_STRONG_H

#include <math.h>
#include <stdlib.h>
#include <time.h>

#include "../Constants.h"

class KarplusStrong {
public:
    
    /**
     * Constructor
     */
    KarplusStrong();
    
    /**
     * Signal the start of a new note.
     *
     * @param key The integer representation of the note
     * @param velocity The float representation of the velocity (NOT int!)
     */
    void midiNoteOn(int key, float velocity);
    
    /**
     * Create the initial buffer sample for the specific index.
     *
     * @param bufferIndex The index to process
     * @return The new sample to save in the buffer
     */
    float fillBuffer(const int bufferIndex);
    
    /**
     * Process the existing buffer for the specific index.
     *
     * @param inputSample The sample to process from the buffer
     * @return The modified sample to save in the buffer
     */
    float processBuffer(const float inputSample);
    
private:

    static void initializeNoiseSeed();
    static float getRand() {
        return float(rand()) / float(RAND_MAX);   
    };
    static float getRandSample() {
        return 1.0 - 2.0 * getRand();  
    };
    
    float lastOutput;
    float filterCoefficient;
    float nextFilterCoefficient;
    
    static const float pluckDampingVariationMin;
    static const float pluckDampingVariationDifference;
    float pluckDampingCoefficient;
    
    float lowpassFilter(const float output, const float input, const float smoothingFactor);

};

#endif