/**
 * The interface for all audio input and output.
 * This class acts as a container for individual voices.
 * It takes in MIDI events and handles processing and output.
 *
 * @author Austin Suszek
 */

#ifndef AS_AUDIO_ENGINE_H
#define AS_AUDIO_ENGINE_H

#include "../Constants.h"
#include "../mbed.h"
#include "Synthesizer.h"

class AudioEngine {
public:

    /**
     * Constructor
     */
    AudioEngine();
    
    /**
     * Signal the beginning of a note being pressed.
     *
     * @param key The integer representation of the note
     * @param velocity (optional) The note velocity in the range of 0-127
     */
    void midiNoteOn(const int key, const int velocity = 0x7F);
    
    /**
     * Signal the end of a note being pressed.
     *
     * @param key The integer representation of the note
     */
    void midiNoteOff(const int key);
    
    /**
     * Switch to a new synth instrument.
     *
     * @param direction 1 for next, -1 for previous.
     * @return The new index being played.
     */
    int nextSynth(int direction);
    
private:
    
    Ticker samplePeriod;
    
    float outputSample;
    void outputAudio();
    
    Synthesizer synthesizers[C::MAX_POLYPHONY];
    
};

#endif