//
// mbed-os rev.171(mbed2, very old, deprecated BUT useful)  (r020904,sige)
// 1--CAN-th2mot-mbed2-01_01  
//    packs the position(0-36000) command to the data_segment and 
//    dispatches the std_data_frame to the HT02(=GI8008) motor thru CAN1.
//    returns the received data_seg from the motor.
//    (the actual HT02 motor would send back the response data frame?)
//
//  th2mot(double th, unsigned int id)    (th=theta_in, id=CANid_in) 
//
// data segment specific to the HT02 motor
// [0]=host_addr(0xff=this_MCU, 0x01=motor_#01),
// [1]=func_code(01=pos.cmd), [2]=[4]=reserved(?)
// [3]=acce=*256[rpm/s],    [5]=target velo.[rpm] (of motor axis wo the gear, maybe)
// [6]=pos.lower byte,      [7]=pos.higher byte (of output axis, maybe)[0-36000]

#include "mbed.h"
#include "CAN.h"

// Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX);

CAN can1(p30, p29);     // (RX,TX)pins in this order
CAN can2( p9, p10);

char c_sent=0, c_read=0;   // counters of sent and read
char dseg[8]={0xFF, 0x01, 0x00, 0x64, 0x00, 0x80, 0x00, 0x00};  //data_segment
char dseg[9]={0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
//  byte manipu using the union Hoge, char MUST be unsigned.
union Hoge{ unsigned char c[2]; uint16_t ii; };

void th2mot(double th, unsigned int id)
{
    Hoge hoge;
    pc.printf("+(th2mot).. \n\r");
    //  truncates th*100. to uint16_t, which is then packed to dseg[6][7].
    //  e.g. th=12.345[deg], then hoge.ii=1234 (=0x04d2) and dseg[6]=0xd2, dseg[7]=0x04
    //  follows the little endian
    hoge.ii=(uint16_t)(th*100.);         dseg[6]=hoge.c[0]; dseg[7]=hoge.c[1];

    if( can1.write(CANMessage(1, dseg, 8, CANData, CANStandard)) ) {
        c_sent++;   led1 = !led1;
        pc.printf(" ++sent thru can1. c_sent=%d dseg[6][7]=0x%02X%02X \n\r", c_sent, dseg[6],dseg[7]);  }
    else
        pc.printf(" ++failed can1.write sent=%d dseg[6][7]=0x%02X%02X \n\r", c_sent, dseg[6],dseg[7]);
}   //  endof th2mot


int main()
{
    double th; unsigned int id;
    CANMessage msg;      // remote msg? what determines the size(msg)?
    can1.frequency(1000000);    can2.frequency(1000000);  // CANbus=1Mbps
    th=12.3456;  id=1;
    //  9600(default) 115200(not max?)  921600(on STM32F446, benkatz)
     pc.baud(921600);
     
     while(1){
       pc.printf("+++(main of th2mot)...  +feed theta(double)[deg][0.-360.]");
       pc.scanf("%lf", &th);

       th2mot(th, id);
       wait(0.2);             // dummy wait 0.2[s]
       if(can1.read(msg)) {   // org=can2
          c_read++; led2 = !led2;
          pc.printf(" ++can2 c_read=%d, d[0..7]_read=(0x", c_read);
          for(int i=0; i<8; i++) pc.printf("%02X ", msg.data[i]);
          pc.printf(") \n\r");
       }   //  endof can1.read
       else
          pc.printf(" ++failed can1.read...  c_sent=%d\n\r", c_sent);
     }     //  endof while(1)-loop
     
}          //  endof main

