#include "mbed.h"

BusOut data(D8,D9,D10,D11,D12,D13,D14,D15);
BusOut control(D0,D1);
//D0 for wr~ and D1 for A0 (Latch A or B)
int K1max,K2max,K1min,K2min;
float Vref=5.0;  //reference voltage from LDO
int i,v1,v2,v3,v4;   // v1 is low voltage for latchB, v2 is low voltage for latchA, 
//v3 is high voltage for latchA , v4 is high voltage for latchB 
int t1,t2,t3,t4;    //variables that store time

int  min(int i,int j)
{
if (i>=j)
    return j;
else
    return i;
}
int  max(int i,int j)
{
if (i<=j)
    return j;
else
    return i;
}


int time1(int v3 , int v4)
{  
    t1= (min(v3,v4))/(50);
    return(t1);
}


int time2(int v3 , int v4)
{   
    t2= (max(v3,v4)-min(v3,v4))/(50);
    return(t2);
}


int time3(int v3 , int v4, int v1, int v2)
{   
    t3= (min(v3,v4)-max(v1,v2))/(50);
    return(t3);
}


int time4(int v1 , int v2)
{  
    t4= (max(v1,v2)-min(v1,v2))/(50);
    return(t4);
}


int K1maxim( int v3, int v4)
{   
    K1max = (min(v3,v4)*256)/(400*Vref); // 400=slope, 5.0= vref
    return(K1max);
}


int K2maxim( int v3, int v4)
{  
    K2max = (max(v3,v4)*256)/(400*Vref); // 400=slope, 5.0= vref
    return(K2max);
}


int K1minim( int v1, int v2)
{   
    K1min = (max(v1,v2)*256)/(400*Vref); // 400=slope, 5.0= vref
    return(K1min);
}


int K2minim( int v1, int v2)
{   
    K2min = (min(v1,v2)*256)/(400*Vref); // 400=slope, 5.0= vref
    return(K2min);
}


int main()

{
    
for(i=0;i<min(K1max,K2max);i++)
{
    
   control = 0;
    data=i;
    wait(t1/2);
    
    
    
    control =1;
    data=i;
    wait(t1/2);
    
    
}
for(i=min(K1max,K2max);i<=max(K1max,K2max);i++)
{
    if(K2max>=K1max)
    {control = 1;// wr~=0 and AO=1
    data=i;
    wait(t2);}
    else
    {control = 0;// wr~=0 and AO=1
    data=i;
    wait(t2);}
 }
 control = 3;
 }