#include "lwip/opt.h"
#include "lwip/stats.h"
#include "lwip/sys.h"
#include "lwip/pbuf.h"
#include "lwip/udp.h"
#include "lwip/tcp.h"
#include "lwip/dns.h"
#include "lwip/dhcp.h"
#include "lwip/init.h"
#include "lwip/netif.h"
#include "netif/etharp.h"
#include "netif/loopif.h"
#include "device.h"

//#include "stdint.h"
#include "mbed.h"
#include "CoOS.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
struct netif lpc17xx_netif;

/*---------------------------------- Define  ---------------------------------*/
#define STK_SIZE        128                /*!< Stack size.                    */
#define INIT_TASK_PRIO    11                  /*!< Priority of "init_task" task.    */
#define A_TASK_PRIO        10                  /*!< Priority of "A" task.            */
#define B_TASK_PRIO        10                  /*!< Priority of "B" task.            */
#define CLK_TASK_PRIO    10                  /*!< Priority of "clock" task.        */

/*---------------------------------- Variable Define -------------------------*/
OS_STK    init_task_stk[STK_SIZE];        /*!< The stack of "init_task" task.    */
OS_STK    a_task_stk[STK_SIZE];            /*!< The stack of "a" task.            */
OS_STK    b_task_stk[STK_SIZE];            /*!< The stack of "b" task.            */
OS_STK    clk_task_stk[STK_SIZE];            /*!< The stack of "clcok" task.        */

OS_MutexID    mut_LED;                    /*!< Mutex id related to LED.        */

OS_FlagID    a_flg;
OS_FlagID    b_flg;
U8            errInfo[32];                /*!< Save error code.                */

const char *page[] = {
    "HTTP/1.1 200 OK\n"
    "Server:mbed embedded\n"
    "Content-Type: text/html\n"
    "Content-Length: 190\n"
    "\n\n"
    "<html>\r\n"
    "  <header>\r\n"
    "    <title>Whats up?</title>\r\n"
    "  </header>\r\n"
    "  <body>\r\n"
    "    <h1>Hello World!!11elf</h1>\r\n"
    "    <p>Have a greate day.</p>\r\n"
    "    <a href=\"/1.html\">turn  </a>\r\n"
    "  </body>\r\n"
    "</html>\r\n"
    "\n\n"
    ,
    "HTTP/1.1 200 OK\r\n"
    "Server:mbed embedded\r\n"
    "Content-Type: text/html\r\n"
    "Content-Length: 178\r\n"
    "\r\n"
    "<html>\r\n"
    "  <header>\r\n"
    "    <title>LED Power</title>\r\n"
    "  </header>\r\n"
    "  <body>\r\n"
    "    <h1>Lets rotate!!11elf</h1>\r\n"
    "    <p>Bam!!!!!!!!!!.</p>\r\n"
    "    <a href=\"/\">back</a>\r\n"
    "  </body>\r\n"
    "</html>\r\n"
    "\r\n"
};


err_t recv_callback(void *arg, struct tcp_pcb *pcb, struct pbuf *p, err_t err) {
    int i,x;
    char *data;

    /* Check if status is ok and data is arrived. */
    if (err == ERR_OK && p != NULL) {
        /* Inform TCP that we have taken the data. */
        tcp_recved(pcb, p->tot_len);
        data = static_cast<char *>(p->payload);

        /* If the data is a GET request we can handle it. */
        if (strncmp(data, "GET ", 4) == 0) {
            for (i = 0; i < 40; i++) {
                if (((char *)data + 4)[i] == ' ' ||
                        ((char *)data + 4)[i] == '\r' ||
                        ((char *)data + 4)[i] == '\n') {
                    ((char *)data + 4)[i] = 0;
                }
            }

            /* Check the URL */
            /* We only know two URLs /1.html and default */
            /* store the URL information in our global x variable to change twinkle behaviour. */
            x = (strncmp((char *)(data + 4), "/1.html", 7) == 0)? 1: 0;
            /* Clean up the Memory */
            pbuf_free(p);

            /* Send the right page as answere. */
            if (tcp_write(pcb, (void *)page[x], strlen(page[x]), 1) != ERR_OK) {
                //error("Could not write", 0);
            }
        } else {
            /* No data arrived */
            /* That means the client closes the connection and sent us a packet with FIN flag set to 1. */
            /* We have to cleanup and destroy out TCPConnection. */
            pbuf_free(p);
        }
    }

    /* Don't panic! Everything is fine. */
    return ERR_OK;
}

/* Accept an incomming call on the registered port */
err_t accept_callback(void *arg, struct tcp_pcb *npcb, err_t err) {
    LWIP_UNUSED_ARG(arg);
    /* Subscribe a receive callback function */
    tcp_recv(npcb, &recv_callback);

    /* Don't panic! Everything is fine. */
    return ERR_OK;
}

void taskB (void *pdata) {
    for (;;) {
        led1 = !led1;
        CoTickDelay(200);
    }
}

void taskA (void *pdata) {
    printf("starting task\n");
    unsigned char x = 0;
    struct ip_addr ipaddr, netmask, gw;
    char *hostname = "Dichi";
    struct netif   *netif = &lpc17xx_netif;
    //Ticker tickFast, tickSlow, tickARP, eth_tick, dns_tick, dhcp_coarse, dhcp_fine;

    //lpc17xx_netif = (netif *)mem_malloc(sizeof(struct netif));

    IP4_ADDR(&gw, 0,0,0,0);
    IP4_ADDR(&ipaddr, 0,0,0,0);
    IP4_ADDR(&netmask, 255,255,255,255);
    lwip_init();

    netif->hwaddr_len = ETHARP_HWADDR_LEN;
    device_address((char *)netif->hwaddr);

    netif = netif_add(netif, &ipaddr, &netmask, &gw, NULL, device_init, ip_input);
    netif->hostname = hostname;
    netif_set_default(netif);
    netif->hostname = hostname;
    netif_set_up(netif);
    dhcp_start(netif);

    struct tcp_pcb *pcb = tcp_new();
    if (tcp_bind(pcb, IP_ADDR_ANY, 80) == ERR_OK) {
	        pcb = tcp_listen(pcb);
	        tcp_accept(pcb, &accept_callback);
    }

    printf("entering while loop\n");
    for (;;) {
        CoTickDelay(10);
        device_poll();
        if ( ++x % 100 == 0) {
            etharp_tmr();
            tcp_fasttmr();
            tcp_slowtmr();
            dns_tmr();
            dhcp_coarse_tmr();
            dhcp_fine_tmr();
            x=0;
        }   
    }
}



int main() {
    //SystemInit();
    CoInitOS();
    CoCreateTask(taskA,0,A_TASK_PRIO,&a_task_stk[STK_SIZE-1],STK_SIZE);
    CoCreateTask(taskB,0,B_TASK_PRIO,&b_task_stk[STK_SIZE-1],STK_SIZE);
    CoStartOS();
    while (1);
}

