#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "PlatformMutex.h"



uLCD_4DGL myLCD(p28, p27, p30);
Mutex lcd_mutex;
RawSerial  pc(USBTX, USBRX);
Serial  bluemod(p13,p14);

PwmOut red(p24);
PwmOut green(p22);
PwmOut blue(p21);

SDFileSystem sd(p5, p6, p7, p8, "sd");

AnalogOut Speaker(p18);
wave_player waver(&Speaker);
bool  PLAY = true;
bool  *PlayStopPtr = &PLAY;

// Thread 1
// print counter into first line and wait for 1 s
void thread1(void const *args)
{
    int i;
    while(true) {       // thread loop
        lcd_mutex.lock();
        myLCD.locate(0,0);
        myLCD.printf("Weeeee Woooo");
        lcd_mutex.unlock();
        i++;
        Thread::wait(1000);
    }
}

// Thread 2
// print counter into third line and wait for 0,5s
void thread2(void const *args)
{
    int k;
    while(true) {       // thread loop
        lcd_mutex.lock();
        myLCD.locate(0,20);
        myLCD.printf("Pull Over.");
        lcd_mutex.unlock();
        k++;
        Thread::wait(500); // wait 0.5s
    }
}


void thread4(void const *args) {
    while(true) {
        FILE *wave_file;
        wave_file=fopen("/sd/Siren.wav","r");
        waver.play(wave_file,PlayStopPtr);
        fclose(wave_file);
        Thread::wait(1000);    // wait 1.0s
    }
}
 
int main() {
    
    myLCD.cls();
    
    Thread t1(thread1);
    Thread t2(thread2);
  //  Thread t3(thread3);
    Thread t4(thread4);
    
    Timer t;
    t.start();
    while (true) {
        lcd_mutex.lock();
        myLCD.locate(0,9);
        myLCD.printf("The time taken was %0.2f seconds\n", t.read());
            char bred=0;
    char bgreen=0;
    char bblue=0;
    red = green = blue = 0;
    while(1) {
        if (bluemod.getc()=='!') {
            if (bluemod.getc()=='C') { //color data packet
                bred = bluemod.getc(); // RGB color values
                bgreen = bluemod.getc();
                bblue = bluemod.getc();
                if (bluemod.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) { //checksum OK?
                    red = bred/255.0; //send new color to RGB LED PWM outputs
                    green = bgreen/255.0;
                    blue = bblue/255.0;
                }
            }
        }
    }
        
        
        lcd_mutex.unlock();
        Thread::wait(500);
    }
}
