#include "mbed.h"
#include "XNucleo53L0A1.h"
#include <stdio.h>
#include "rtos.h"
#include "LSM9DS1.h"

#define VL53L0_I2C_SDA   p28
#define VL53L0_I2C_SCL   p27


DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);
DigitalOut shdn(p26);

static XNucleo53L0A1 *board=NULL;


int main() 
{
    float tempC;
    int status;
    uint32_t distance;
    uint32_t last_distance;
    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    /* creates the 53L0A1 expansion board singleton obj */
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
    shdn = 0; //must reset sensor for an mbed reset to work
    wait(0.1);
    shdn = 1;
    wait(0.1);
    LSM9DS1 lol(p9, p10, 0xD6, 0x3C);
    lol.begin();
    if (!lol.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    lol.calibrate();
    /* init the 53L0A1 board with default values */
    status = board->init_board();

    while (status) 
    {
        pc.printf("Failed to init board! \r\n");
        status = board->init_board();
    }
    //loop taking and printing distance
    while (1) 
    {

        if (board->sensor_centre->get_distance(&distance) == VL53L0X_ERROR_NONE) 
        {
            if(distance != last_distance)
            {
                pc.printf("D=%ld mm\r\n", distance);
            }
            board->sensor_centre->get_distance(&last_distance);
        } 
        lol.readTemp();
        lol.readMag();
        lol.readGyro();
        
        //pc.printf("%d %d %d %d %d %d %d %d %d\n\r", lol.calcGyro(lol.gx), lol.calcGyro(lol.gy), lol.calcGyro(lol.gz), lol.ax, lol.ay, lol.az, lol.mx, lol.my, lol.mz);
        //pc.printf("%d %d %d\n\r", lol.calcGyro(lol.gx), lol.calcGyro(lol.gy), lol.calcGyro(lol.gz));
        pc.printf("gyro: %d %d %d\n\r", lol.gx, lol.gy, lol.gz);
        pc.printf("accel: %d %d %d\n\r", lol.ax, lol.ay, lol.az);
        pc.printf("mag: %d %d %d\n\n\r", lol.mx, lol.my, lol.mz);
        myled = 1;
        wait(2);
        myled = 0;
        wait(2);
//        tempC = myTMP36;
//        pc.printf("Float operator overloading avoids .read(): T=%5.2F C \n\r", tempC);
//        pc.printf("A Printf arg needs a float type convert: T=%5.2F C \n\r", float(myTMP36));
//        pc.printf("Or Use .read() instead: T=%5.2F C \n\r\n\r", myTMP36.read());
//        wait(.5);
        
    }
    
}
