
#pragma once
#define xstr(s) str(s)
#define str(s) #s
 
// State machine states
#define STATE_INIT 0
#define STATE_STARTING_GPS 1
#define STATE_WAITING_FIX 2
#define STATE_COLLECTING_TELEMETRY 3
#define STATE_SENDING_TELEMETRY 4
#define STATE_SLEEPING 5
 
// Times of working
#define SLEEP_CHECK_TIME 5
#define SLEEP_TIME_S  1500
#define FIX_CHECK_TIME_S 5
#define PARSER_TIMEOUT_S 10
#define WATCHDOG_INTERVAL_S 30
 
#define FIX_MAX_TRIES 25
 
#define COMD_EXE_TRIES 10
 
// Pinouts
#define PIN_SDA     PB_9
#define PIN_SCL     PB_8
#define PIN_ONEWIRE PC_14
#define PIN_SIM_TX  PA_9
#define PIN_SIM_RX  PA_10
#define PIN_TX      PA_2
#define PIN_RX      PA_3
 
// Debug options
#define DEBUG_SIM 1
#define DEBUG_PC 1
#define ENABLE_WATCHDOG 1
 
/***********************************************************/
/* FOR TEST */
/***********************************************************/
// NBIoT settings
//#define MTS_COAP_SERVER_IP          195.34.49.22
//#define MTS_COAP_SERVER_PORT        6683
//#define MTS_COAP_TOKEN                HJne7HnjcPMy8pjZ2GfI
 
//#define MTS_TELEMETRY_URL_STRING    "coap://" xstr(MTS_COAP_SERVER_IP) ":" xstr(MTS_COAP_SERVER_PORT) "/api/v1/" xstr(MTS_COAP_TOKEN) "/telemetry\""
 
/***********************************************************/
// NBIoT settings
 #define MTS_COAP_SERVER_IP          193.227.232.26
 #define MTS_COAP_SERVER_PORT        5683
  
 #define MTS_TELEMETRY_URL_STRING    "coap://" xstr(MTS_COAP_SERVER_IP) ":" xstr(MTS_COAP_SERVER_PORT) "/api/v1/MIEMHSE-TEST\""
// #define MTS_TELEMETRY_URL_STRING    "coap://193.227.232.26:5683/api/v1/MIEMHSE-TEST"
 
 
 
            
