/**********************************************************************
Texas State University Senior Project - HexiHeart
Team Zeta: Alex Song, Jasmine Rounsaville, Issam Hichami, Neil Baker
Version: HexiHeart_1st 11/12/17
This version has basic menu layout and screen timeout feature.  The menu
are just placeholders (for the most part) and will be either adjusted or
replaced with graphic images.

***********************************************************************/

#include "mbed.h"
#include "Hexi_KW40Z.h"         // Button and BLE fuctions
#include "FXOS8700.h"           // 3D Accelorometer & Mag
#include "FXAS21002.h"          // 3-Axis Gyroscope
#include "Hexi_OLED_SSD1351.h"  // OLED fuctions
#include "OLED_types.h"         // Text attributs
#include "string.h"
#include "OpenSans_Font.h"


/* We need to confirm whether it's better to include and
configure every module for lowest power, or whether it's
better to save memory by not doing that
*/

// Definitions
#define LED_ON          0
#define LED_OFF         1
#define SCRN_TIME       60.0


void StartHaptic(void);
void StartHaptic(int x);
void StopHaptic(void const *n);
void error_screen(void);
void update_display(void);


// *****************  Global variables  ***********************
char text_1[20];            // Text buffer - Do we need more?
char display_buff[30];      //Buffer for conversion to char to display
bool OLED_ON = 1;
uint8_t Screen_Num = 0;      // Initialize to main screen
uint8_t variableExample = 0;


// ***************** Define pins *****************************
DigitalOut chips(PTB12);

FXAS21002 gyro(PTC11,PTC10); // Gyroscope
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); // SSD1351 OLED Driver (MOSI,SCLK,POWER,CS,RST,DC)
FXOS8700 accel(PTC11, PTC10); // Accelorometer
FXOS8700 mag(PTC11, PTC10);   // Mag (same chip as Accel)


DigitalOut RED_Led(LED1);
DigitalOut GRN_Led(LED2);
DigitalOut BLU_Led(LED3);
DigitalOut haptic(PTB9);

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */
KW40Z kw40z_device(PTE24, PTE25);

/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

//***************** Tickers and Timers *****************
Ticker Screen_Timer;// use ticker to turn off OLED

void timout_timer() // turn off display mode
{
    oled.FillScreen(COLOR_BLACK); // Clear screen.. is there a better command for this?
    OLED_ON = 0;  // set flag to off
    Screen_Timer.detach();
}//end routine

void ButtonUp(void)
{
    Screen_Timer.attach(&timout_timer,(SCRN_TIME));//Is this sufficient to reset/restart ticker timer for OLED?
    if (OLED_ON == 0) {
        OLED_ON = 1; // Scree was off, set to On
        update_display();
    } else {
        switch(Screen_Num) {
            case 0: {// We're in Main Screen
                StartHaptic();
                update_display();
                break;
            }
            case 1: {// Second Screen
                
                update_display();
                StartHaptic();
          
            }
            default: {
                break;
            }
        }
    }

}

void ButtonDown(void)
{
    Screen_Timer.attach(&timout_timer,(SCRN_TIME));//Is this sufficient to reset/restart ticker timer for OLED?
    if (OLED_ON == 0) {
        OLED_ON = 1; // Screen was off, set to On
        update_display();
    } else {

        switch(Screen_Num) {
            case 0: {// We're in Main Screen
                StartHaptic();                
                update_display();
                break;
            }
            case 1: {// Second Screen
                StartHaptic();
                break;
            }
            default: {
                break;
            }
        }
    }
}

void ButtonRight(void)
{
    Screen_Timer.attach(&timout_timer,(SCRN_TIME));//Is this sufficient to reset/restart ticker timer for OLED?
    if (OLED_ON == 0) {
        OLED_ON = 1; // Screen was off, set to On
        update_display();
    } else {
        switch(Screen_Num) 
        {
            case 0: {// We're in Main Screen
                StartHaptic();
                variableExample++;
                update_display();
                break;
            }
            default:{
                break;
            }
        }
    }
}
void ButtonLeft(void)
{
    Screen_Timer.attach(&timout_timer,(SCRN_TIME));//Is this sufficient to reset/restart ticker timer for OLED?
    if (OLED_ON == 0) {
        OLED_ON = 1; // Screen was off, set to On
        update_display();
    } else {
        switch(Screen_Num) {
            case 0: {// We're in Main Screen
                StartHaptic(); 
                variableExample--;       
                update_display();
                break;
            }
            case 1:{
                Screen_Num = 0;
                update_display();
                break;   
            }
        }
    }
}


int main()
{
    oled.FillScreen(COLOR_BLACK); // Clear screen
// *****************  Local variables  ***********************
//   float accel_data[3]; float accel_rms=0.0;

// **************  configure sensor modules  ******************
    accel.accel_config();
    mag.mag_config();
//    gyro.gyro_config();
//    maxim = 1;
    chips = 1;

    RED_Led = LED_OFF;
    GRN_Led = LED_OFF;
    BLU_Led = LED_OFF;
// ***** Register callbacks/interupts to application functions *********
    kw40z_device.attach_buttonUp(&ButtonUp);
    kw40z_device.attach_buttonDown(&ButtonDown);
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);

// **** Get OLED Class Default Text Properties ****************
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);

// *********Set text color and screen alignment  **************
    textProperties.fontColor = COLOR_WHITE;
    textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
    oled.SetTextProperties(&textProperties);

// **************  Display spash screen  **********************
    textProperties.fontColor = COLOR_RED;
    oled.SetTextProperties(&textProperties);
    oled.Label((uint8_t *)"Example",20,5); // Display red "Heart" at x,y

    textProperties.fontColor = COLOR_WHITE;
    oled.SetTextProperties(&textProperties);
    wait(3);  // wait 3 seconds
    update_display(); // Displays current screen (screen 0)
    Screen_Timer.attach(&timout_timer,(SCRN_TIME));//start ticker timer for turning off LCD
//  ******************* Main Loop *************************
    while (true) {

        Thread::wait(500); // wait half a sec in each loop
    }
}
//  ************** end of main()

void update_display(void)
{
    oled_text_properties_t textProperties = {0};  // Need these to change font color
    oled.GetTextProperties(&textProperties);      // Need these to change font color
    switch(Screen_Num) {
        case 0: {// Main Screen
            oled.FillScreen(COLOR_BLACK); // Clear screen
            oled.Label((uint8_t *)"Test Screen",15,10); // Display "" at x,y
            oled.Label((uint8_t *)"*",85,15); // "*" at x,y
            oled.Label((uint8_t *)"*",85,60); // "*" at x,y
            oled.Label((uint8_t *)"-1",10,80); // Display "Back" at x,y
            oled.Label((uint8_t *)"+1",60,80);  //Display "enter" at x,y
            sprintf(display_buff, "%u", variableExample);
            oled.Label((uint8_t *)display_buff,15,40);  //Display "enter" at x,y
            break;
        }
        case 1: {// Panic Alert option
            oled.FillScreen(COLOR_BLACK); // Clear screen
            oled.Label((uint8_t *)"Second Screen",20,5); // Display at x,y
            oled.Label((uint8_t *)"Back",10,80); // Display "Back" at x,y
        }
    }
        

}

/*****************************************************************************
Name: StartHaptic
Purpose: Cause the HexiHeart device to vibrate for a predetermined amount of
         time
Inputs: None
Returns: None
******************************************************************************/
void StartHaptic(void)
{
    hapticTimer.start(30);  // was originaly 50
    haptic = 1;
}

/*****************************************************************************
Name: StartHaptic
Purpose: Cause the HexiHeart device to vibrate for x amount of time
Inputs: An int representing the duration of the vibration
Returns: None
******************************************************************************/

void StartHaptic(int x)
{
    hapticTimer.start(x);
    haptic = 1;
}

void StopHaptic(void const *n)
{
    haptic = 0;
    hapticTimer.stop();
}



    
