/* Servo controller mini-project. Three button control for HS422 servo, left 10*, right 10*, reset to center. 
Austin Sloop, 1/7/16
*/

#include "mbed.h"

DigitalIn right(p5);        //Right button, CW
DigitalIn left(p9);         //Left button, CCW
DigitalIn reset(p7);        //Middle button, reset to 0

PwmOut servo(p21);          //Servo Control
DigitalOut L(LED1);         //Debug LED
DigitalOut R(LED3);         //Debugging Purposes
DigitalOut C(LED2);         //Debug LED

int i=1500;               //value of servo position
int main(){
servo.period(0.020);
    while(1){       
        if (right==1){
            wait(0.05);
            if (right==0){
                i=i+100; 
                R=1;
                wait(.1);
                R=0;   
            }
        }
        if (left==1) {
            wait(0.05);
            if (left==0){
                i=i-100;
                L=1;
                wait(.1);
                L=0;
            }
        }
        if (reset==1) {
            wait(0.05);
            if (reset==0){
                i=1500;
                C=1;
                wait(.1);
                C=0;
            }
        }
        if (i>2400) {i=2400;}            //Prevention of over-extention of servo
        if (i<600) {i=600;}
        servo.pulsewidth_us(i);       
    } 
}