//data comm functions
//serial communication protocol

#ifndef DATACOMM_H
#define DATACOMM_H

#define PREAMBLE 0x7E
#define POSTAMBLE 0x7F
#define MAX 100

#include "mbed.h"
#include "platform.h"
#include "gpio_api.h"

class DataComm {

    public:
        //initialize signal input/output pins
        void setClockOut(PinName pin);
        void setClockIn(PinName pin);
        void setSerialOut(PinName pin);
        void setSerialIn(PinName pin);
        //listen for incoming preamble        
        void listen();
        //set clock speed
        void setClock(int clock);
        //send preamble
        void initiate_connection();
        void send_data(char data[], int size);
        char* receive_data();
        //send postamble
        void close_connection();
    
    
    
    protected:
        //gpio input/output pins
        gpio_t clock_out;
        gpio_t clock_in;        
        gpio_t serial_out;
        gpio_t serial_in;
        //clock speed and skew
        int clock_time;
        int skew_time;
        //timer for handling clock and skew
        Timer t;     
};

#endif