#include "mbed.h"
#include "DebouncedIn.h"
#include <Pulse1.h>
#include "TextLCD.h"
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
DigitalOut led(LED1);
DigitalOut led2(LED2);
DebouncedIn button1(PTC12); //incrementar
DebouncedIn button2(PTC13);//decrementar
DebouncedIn button3(PTC16);//salir
// todos los valores estan en microsegundos
int header =13560; //tiempo de cabecera pulso abajo
const int head_H = 10836; //+20% medida con osciloscopio en microsegundos
const int head_L = 3624;//-20%  medida con osciloscopio
int i=0;
int j=0;
int cont=0,k=0,h=0,c=0,hexa=0,pot=0,otra=0;
int hexadeci[8];
//double pot=0;
const int T_alto=1700;//ponga su tiempo de la prueba
const int T_bajo=600;//ponga su tiempo de la prueba
const int num_bits = 32;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
int binar1[32];
  int flag1=0,flag2=0;
  
  
  
int main(){
while(1){
ini1: header=13560;


      led2=1;
      led=1;
      header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
      if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
      else goto ini1;
      
seguir:
     
       //leo los datos de la trama y se meten a un arreglo
      wait_us(5000);
      led2=0;
      for(i=0;i<(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
      dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
      num[i]=dato;
      wait_us(300);   
      }
      wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla 
      pc.printf(",%d",header);
      for(i=0;i<(num_bits-1);++i){  
      pc.printf(",%d",num[i]);
      }
      wait(0.1);  //espero e imprimo en binario 
      pc.printf("\n\n");
      for(i=0;i<(num_bits-1);++i){  
      if(num[i] > ((T_alto+T_bajo)/2))
      {
          pc.printf("1");
          binar1[i]=1;
          }                    //guardo la cadena en binario 
      else {
          pc.printf("0");
          binar1[i]=0;
      }
      }
      
      cont=0;
      
for(k=0;k<=28;k=k+4)//recorre cada byte y entra al for que recorre los bits de cada byte
{
    pot=3; 
    for(c=0;c<4;++c)
        {
        //otra=pow(2.0,pot);   ////conversion de binario a hexadecimal recorre de a cada bit hasta tener un byte y lo convierte en hexadecimal
        hexa=hexa+binar1[(c+k)]*pow(2.0,pot);  //Binar1 *2^pot calcula el peso del bit actual Y lo va acumulando en hexa Al final hexa, tiene la suma de los pesos de los bit y eso da el valor hexadecimal
        --pot;// decrementa pot(2^3,2^2,2^1,2^0)
        }         
        
        
    hexadeci[cont]=hexa;// guarda los 8 bytes
    hexa=0;// vuelve a poner hexa en 0 para mirar el otro byte siguiente
    ++cont;// aumento el contador
}
for (i=0;i<30;++i)
{otra=otra+num[i];
    }
otra=otra/31;

j=0;   //banderas
flag1=0;
   while(flag1==0)
        {  
        flag2=j;//se utiliza para dejar de ver datos y volver a hundir un boton del control para ver otros datos
        if(button3.falling()) 
         {
             flag1=1;  //se sale del while y hay que volver a hundir un boton en el control para iniciar
         }
        if(button1.falling()) //bajar
         {
             j++;
             if(j>34){j=34;} //limite inferior. llega hasta 31 contando el hexadecimal,distancia entre bits,t.bits y  un espacio es hasta 34
         }
         if(button2.falling()) //subir
         {
             j--;
             if(j<0){j=0;}//limite superior
         }
            if(flag2!=j){lcd.cls();}//limpio para hacer el scroll
            
 switch(j)// el scrol se hizo mediante varios casos para esto se utiliza un switch
    {
        case 0://en el caso 0 se muestra el hexadecimal guardado en la cadena hexadeci
        for(i=0;i<8;++i)// me muestra el valor de cada byte en hexadecimal moviendo hacia la derecha en el LCD
        {
            lcd.locate(i,0);
            lcd.printf("%X",hexadeci[i]);
        }
            lcd.locate(0,1);
            lcd.printf("Header = %d us", header);//imprimo header
        
        break;
        
        case 1:
        lcd.locate(0,0);
        lcd.printf("Header = %d us", header);
        lcd.locate(0,1);
        lcd.printf("N.bits =31"); 
        break;
        
        case 2:
        lcd.locate(0,0);
        lcd.printf("N.bits =31"); 
        lcd.locate(0,1);
        lcd.printf("Prom.bits = %d us",otra); 

        break;
         
        
        case 3:
        lcd.locate(0,0);
        lcd.printf("Prom.bits = %d us",otra);
        lcd.locate(0,1);
        lcd.printf("t.bits");
        break;
        
        case 4:
        lcd.locate(0,0);
        lcd.printf("t.bits");
        lcd.locate(0,1);
        lcd.printf("%d uS",num[0]);
        break;
        
        default:// resto de casos
        cont=j-5;// cont esta en 5  entonces cont=0 me muestra el primer numero de la cadena num que seria num[0] y
        lcd.locate(0,0);
        lcd.printf("%d uS",num[cont]);
        lcd.locate(0,1);
        lcd.printf("%d uS",num[cont+1]);// abajo me muestra el siguiente, ya si sigue con los otros caso hasta j=34
        break;
        
        } 
        
 }
 }
 }