#include <mbed.h>
#include <mpr121.h>
#include "uLCD_4DGL.h"
#include "rtos.h"


//DigitalOut led1(LED1);
//DigitalOut led2(LED2);
//DigitalOut led3(LED3);
//DigitalOut led4(LED4);
AnalogIn   ain1(p15);
AnalogIn   ain2(p16);
AnalogIn   ain3(p17);
AnalogIn   ain4(p18);
AnalogIn   ain5(p19);
AnalogIn   ain6(p20);

DigitalOut led0(LED1);

DigitalOut led1(p21);
DigitalOut led2(p22);
DigitalOut led3(p23);
DigitalOut led4(p24);
DigitalOut led5(p25);
DigitalOut led6(p26);

int cupPresence1;
int cupPresence2;
int cupPresence3;
int cupPresence4;
int cupPresence5;
int cupPresence6;

int cupPreviousState1;
int cupPreviousState2;
int cupPreviousState3;
int cupPreviousState4;
int cupPreviousState5;
int cupPreviousState6;


int player1Points = 0;
int player2Points = 0;

int player1MassArray[] = {0, 0, 0};
int player2MassArray[] = {0, 0, 0};
int player1Mass = 0;
int player2Mass = 0;

float player1BAC = 0;
float player2BAC = 0;

float a1 = 0;
float a2 = 0;
float r = 0.73;

Mutex lcd_mutex;


uLCD_4DGL uLCD(p28,p27,p29); // serial tx, serial rx, reset pin;

Serial pc(USBTX, USBRX); // tx, rx

InterruptIn keypadInterrupt(p14); // Create the interrupt receiver object on pin 26


I2C i2c(p9, p10); // Setup the i2c bus on pins 9 and 10

Mpr121 mpr121(&i2c, Mpr121::ADD_VSS); // constructor(i2c object, i2c address of the mpr121)

float ledThreshold = 0.25;

int keyPressed;

// Key hit/release interrupt routine
void fallInterrupt() {
  int value=mpr121.read(0x00);
  value +=mpr121.read(0x01)<<8;
 
  switch (value)
    {
         case 1: keyPressed = 0; 
         break;
         case 2: keyPressed = 1;
         break;
         case 4: keyPressed = 2;
         break;
         case 8: keyPressed = 3;
         break;
         case 16: keyPressed = 4;
         break;
         case 32: keyPressed = 5;
         break;
         case 64: keyPressed = 6;
         break;
         case 128: keyPressed = 7;
         break;
         case 256: keyPressed = 8;
         break;
         case 512: keyPressed = 9;
         break;
         case 1024: keyPressed = 10;
         break;
         case 2048: keyPressed = 11;
         break;
         default: keyPressed = 12;   // no key pressed
         break;  
    }
    
 
}

void checkLed1(void const *args) 
{
    while (true) 
    {
        if(ain1.read() < ledThreshold)
        {
           cupPresence1 = 1;
           led1 = 1;
            cupPreviousState1 = 1;
        }
        else
        {
           if(cupPreviousState1 == 1){
           a1 = a1 + 4;
           }
           cupPresence1 = 0;
           led1 = 0;
           cupPreviousState1 = 0;
        }
        Thread::wait(250);
    }
}
void checkLed2(void const *args) 
{
    while (true) 
    {
        if(ain2.read() < ledThreshold)
        {
           cupPresence2 = 1;
           led2 = 1;
           cupPreviousState2 = 1;
        }
        else
        {
            if(cupPreviousState2 == 1){
           a1 = a1 + 4;
           }
           cupPresence2 = 0;
           led2 = 0;
            cupPreviousState2 = 0;
        }
        Thread::wait(250);
    }
}
void checkLed3(void const *args) 
{
    while (true) 
    {
        if(ain3.read() < ledThreshold - 0.22)
        {
           cupPresence3 = 1;
           led3 = 1;
            cupPreviousState3 = 1;
        }
        else
        {
            if(cupPreviousState3 == 1){
           a1 = a1 + 4;
           }
           cupPresence3 = 0;
           led3 = 0;
            cupPreviousState3 = 0;
        }
        Thread::wait(250);
    }
}
void checkLed4(void const *args) 
{
    while (true) 
    {
        if(ain4.read() < ledThreshold)
        {
           cupPresence4 = 1;
           led4 = 1;
            cupPreviousState4 = 1;
        }
        else
        {
            if(cupPreviousState4 == 1){
           a2 = a2 + 4;
           }
           cupPresence4 = 0;
           led4 = 0;
           cupPreviousState4 = 0;
        }
        Thread::wait(250);
    }
}
void checkLed5(void const *args) 
{
    while (true) 
    {
        if(ain5.read() < ledThreshold + 0.05)
        {
           cupPresence5 = 1;
           led5 = 1;
           cupPreviousState5 = 1;
        }
        else
        {
           if(cupPreviousState5 == 1){
           a2 = a2 + 4;
           }
           cupPresence5 = 0;
           led5 = 0;
           cupPreviousState5 = 0;
        }
        Thread::wait(250);
    }
}
void checkLed6(void const *args) 
{
    while (true) 
    {
        if(ain6.read() < ledThreshold + 0.09)
        {
           cupPresence6 = 1;
           led6 = 1;
           cupPreviousState6 = 1;
        }
        else
        {
           if(cupPreviousState6 == 1){
           a2 = a2 + 4;
           }
           cupPresence6 = 0;
           led6 = 0;
            cupPreviousState6 = 0;
        }
        Thread::wait(250);
    }
}

void resetScore()
{

while(cupPresence4 != 1 || cupPresence5 != 1 || cupPresence6 != 1 || cupPresence1 != 1 || cupPresence2 != 1 || cupPresence3 != 1){
 uLCD.locate(0,7);
 uLCD.printf(" in while loop");
}
}
  
 void declareWinner(int winner){
  player1Points = 0; 
  player2Points = 0; 
  lcd_mutex.lock();
  uLCD.cls();
  uLCD.locate(0,1);
  uLCD.printf("Player %i Wins!", winner);
  lcd_mutex.lock();
  wait(10);
  }
 
void checkBAC(void const *args) 
{
    while (true) 
    {
     player1BAC = ((0.06*a1*5.14)/(player1Mass*r));
     player2BAC = ((0.06*a2*5.14)/(player2Mass*r));
        
      Thread::wait(250);  
}
} 
 
  
    
void checkScore(void const *args) 
{
    while (true) 
    {
        if(cupPresence4 == 0 && cupPresence5 == 0 && cupPresence6 == 0)
        {
           player1Points++;
           //resetScore();
         
          if(player1Points == 3){
            //declareWinner(1);
            }
              wait(5);
        }
        else if(cupPresence1 == 0 && cupPresence2 == 0 && cupPresence3 == 0)
        {
           player2Points++;
           //resetScore();
           if(player2Points == 3){
            //declareWinner(2);
            }
            wait(5);
        }
        
    
      Thread::wait(250);  
}
}


void inputMass(){
    uLCD.locate(0,1);
   // uLCD.set_font_size(5,5);
   // uLCD.color(BLACK);
   // uLCD.background_color(LGREY);
    uLCD.printf("Player 1 Weight");
    wait(1);
for (int i=0; i<3; i++) {
    player1MassArray[i] = keyPressed;
    uLCD.locate(i,3);
    uLCD.printf("%i",player1MassArray[i]);
    wait(1);
}
    uLCD.locate(0,4);
    //uLCD.set_font_size(5,5);
   // uLCD.color(BLACK);
    //uLCD.background_color(LGREY);
    uLCD.printf("Player 2 Weight");
    wait(1);
for (int i=0; i<3; i++) {
    player2MassArray[i] = keyPressed;
    uLCD.locate(i,6);
    uLCD.printf("%i",player2MassArray[i]);
    wait(1);
}
for (int i=0; i < 3; i++)
{
  player1Mass = player1Mass*10 + player1MassArray[i];
}
for (int i=0; i < 3; i++)
{
  player2Mass = player2Mass*10 + player2MassArray[i];
}
}

int main() {
  keypadInterrupt.fall(&fallInterrupt);
  keypadInterrupt.mode(PullUp);
  inputMass();
  Thread thread1(checkLed1);
  Thread thread2(checkLed2);
  Thread thread3(checkLed3);
  Thread thread4(checkLed4);
  Thread thread5(checkLed5);
  Thread thread6(checkLed6);
  Thread thread7(checkScore);
  Thread thread8(checkBAC);


 // pc.printf("Hello World!\n");
 // uLCD.printf("\nHello uLCD World\n"); //Default Green on black text
 // uLCD.printf("\n  Starting Demo...");
  uLCD.filled_rectangle(0, 0 , 128, 64, BLUE);
  uLCD.filled_rectangle(0, 64 , 128, 128, RED);
  while (1) 
  {
  
  //uLCD.color(BLACK);
 // uLCD.background_color(LGREY);
  uLCD.textbackground_color(BLUE);
  //uLCD.set_font_size(20,20);
    uLCD.text_width(2); //4X size text
    uLCD.text_height(2);
  uLCD.color(WHITE);
  uLCD.locate(0,0);
  uLCD.printf("Score: %i",player1Points);
  uLCD.locate(0,2);
  uLCD.printf("   BAC:\n   %1.2f",player1BAC);
  
  uLCD.textbackground_color(RED);
  //uLCD.set_font_size(20,20);FONT_8X8 
    uLCD.text_width(2); //4X size text
    uLCD.text_height(2);
  uLCD.locate(0,4);
  uLCD.color(WHITE);
  uLCD.printf("Score: %i",player2Points);
  uLCD.locate(0,6);
  uLCD.printf("   BAC:\n   %1.2f",player2BAC);
  }
}