#include "mbed.h"
#include <MoistureSensor.h>
#include "RangeFinder.h"
#include <Motor_relay.h>
#include "Servo.h"
#include <C12832.h>

int dry = 0.61;
int wet = 0.37;
moisture_sensor grove(p17);
RangeFinder rf(p18, 10, 5800.0, 100000);
DigitalOut led(LED1);
MOTOR_RELAY motor_relay1(p22);
MOTOR_RELAY motor_relay2(p21);
Servo valve1(p23);
Servo valve2(p24);
C12832 mylcd(p5,p7,p6,p8,p11);
#define on  1
#define off 0
int main (void)
{

    float moisturevalue = 0.0f;
    float moisturepercentage = 0.0f;
    led = 1;
    float d;
    while (true) {

        moisturevalue = grove.read();
        moisturepercentage=(((moisturevalue- 0.37)/(0.61-0.37))*100);
        debug("Moisture reading is %2.2f percent dry\n\r",moisturepercentage);
        mylcd.locate(0,0);
        mylcd.printf("Moist: %.2f",moisturepercentage);

        wait(1.0f);

        d = rf.read_m();
        if (d == -1.0)  {
            printf("Timeout Error.\n\r");
        } else if (d > 5.0) {
            // Seeed's sensor has a maximum range of 4m, it returns
            // something like 7m if the ultrasound pulse isn't reflected.
            printf("No object within detection range.\n");
        } else  {
            printf("Distance = %f m.\n", d);
            mylcd.locate(0,10);
            mylcd.printf("Distance = %f m.\n", d);
        }
        wait(0.5);
        led = !led;


        if(moisturepercentage>80) {
            mylcd.locate(0,10);
            mylcd.printf("outletvalve:open pump:on");
            motor_relay1.SetMotor(1);
            valve1.position(0);
        }
        if(moisturepercentage<20) {
            mylcd.locate(0,10);
            mylcd.printf("outletvalve:close pump:off");
            motor_relay1.SetMotor(0);
            valve1.position(90);
        }
        if(20<moisturepercentage<80) {
            mylcd.locate(0,10);
            mylcd.printf("Moisture:ok pump:off");
            motor_relay1.SetMotor(0);
        }
        if (d>0.07 ) {
            mylcd.locate(0,20);
            mylcd.printf("inletvalve:open pump:on");
            motor_relay2.SetMotor(1);
            valve2.position(90);
        }
        if(d<0.02) {
            mylcd.locate(0,20);
            mylcd.printf("inletvalve:closed pump:off");
            motor_relay2.SetMotor(0);
            valve2.position(0);
        }
        if (0.02<d<0.07) {
            mylcd.locate(0,20);
            mylcd.printf("water level:ok pump:off");
            motor_relay2.SetMotor(0);
        }
    }
    return 0;
}


