#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"
#include "math.h"
#define PI 3.14159265
LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    int p = 0;
     BSP_LCD_SetFont(&Font20);
  
    //lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Special Thanks", CENTER_MODE);
    //lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"To", CENTER_MODE);
    //lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"Ejaz Jamil Sir", CENTER_MODE);
    //wait(2);
  
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
  
    if (status != TS_OK)
    {
      lcd.Clear(LCD_COLOR_RED);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"DRIVER FAIL", CENTER_MODE);
    }
    else
    {
      lcd.Clear(LCD_COLOR_GREEN);
      lcd.SetBackColor(LCD_COLOR_GREEN);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"DRIVER OK", CENTER_MODE);
    }
    
    //wait(2);
     
     
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    BSP_LCD_SetFont(&Font24);
    lcd.DisplayStringAt(0, 10, (uint8_t *)"obaak App", CENTER_MODE);
    
    BSP_LCD_SetFont(&Font20);
    lcd.DisplayStringAt(0, 44, (uint8_t *)"Select Menu", CENTER_MODE);
    
    BSP_LCD_SetFont(&Font16);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(75, 83, 80, 30);
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, 90, (uint8_t *)"sin(x)", CENTER_MODE);
    
    BSP_LCD_SetFont(&Font16);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(75, 120, 80, 30);
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, 127, (uint8_t *)"cos(x)", CENTER_MODE);
    /*
    BSP_LCD_SetFont(&Font16);
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.FillRect(30, 160, 170, 30);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, 167, (uint8_t *)"sin(x) & cos(x)", CENTER_MODE);
    */
    BSP_LCD_SetFont(&Font16);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(75, 160, 80, 30);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, 167, (uint8_t *)"ECG", CENTER_MODE);
    
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DrawLine(10, 250, 30, 250);
    lcd.DrawLine(30, 250, 30, 270);
    lcd.DrawLine(30, 252, 15, 261);
    lcd.DrawLine(15, 261, 30, 270);
    lcd.DrawLine(30, 250, 35, 250);
    lcd.DrawLine(35, 250, 35, 270);
    lcd.DrawCircle(43, 255, 5);
    lcd.DrawLine(37, 261, 47, 270);
    
    lcd.DrawLine(50, 250, 70, 250);
    lcd.DrawLine(70, 250, 70, 270);
    //lcd.DrawLine(30, 252, 15, 261);
    //lcd.DrawLine(15, 261, 30, 270);
    lcd.DrawLine(70, 250, 75, 250);
    lcd.DrawLine(75, 250, 75, 270);
    //lcd.DrawPixel(64, 259, LCD_COLOR_RED);
    lcd.DrawPixel(69, 263, LCD_COLOR_BLACK);
    lcd.DrawPixel(68, 262, LCD_COLOR_BLACK);
    lcd.DrawPixel(67, 261, LCD_COLOR_BLACK);
    lcd.DrawPixel(66, 260, LCD_COLOR_BLACK);
    lcd.DrawPixel(65, 260, LCD_COLOR_BLACK);
    lcd.DrawPixel(64, 260, LCD_COLOR_BLACK);
    lcd.DrawPixel(63, 261, LCD_COLOR_BLACK);
    lcd.DrawPixel(62, 262, LCD_COLOR_BLACK);
    lcd.DrawPixel(61, 263, LCD_COLOR_BLACK);
    lcd.DrawLine(61, 263, 61, 267);
    lcd.DrawPixel(60, 263, LCD_COLOR_BLACK);
    lcd.DrawPixel(59, 262, LCD_COLOR_BLACK);
    lcd.DrawPixel(58, 261, LCD_COLOR_BLACK);
    lcd.DrawPixel(57, 260, LCD_COLOR_BLACK);
    lcd.DrawPixel(56, 260, LCD_COLOR_BLACK);
    lcd.DrawPixel(55, 260, LCD_COLOR_BLACK);
    lcd.DrawPixel(54, 261, LCD_COLOR_BLACK);
    lcd.DrawPixel(53, 262, LCD_COLOR_BLACK);
    lcd.DrawPixel(52, 263, LCD_COLOR_BLACK);
        lcd.DrawLine(52, 263, 52, 268);
        lcd.DrawCircle(54, 267, 2);
        
        lcd.DrawLine(75, 250, 85, 250);
    lcd.DrawPixel(84, 251, LCD_COLOR_BLACK);
    lcd.DrawPixel(83, 252, LCD_COLOR_BLACK);
    lcd.DrawPixel(82, 253, LCD_COLOR_BLACK);
    lcd.DrawPixel(81, 254, LCD_COLOR_BLACK);
    lcd.DrawPixel(80, 255, LCD_COLOR_BLACK);
    lcd.DrawPixel(79.5, 256, LCD_COLOR_BLACK);
    lcd.DrawPixel(79, 257, LCD_COLOR_BLACK);
    lcd.DrawPixel(78.5, 258, LCD_COLOR_BLACK);
    lcd.DrawPixel(78, 259, LCD_COLOR_BLACK);
    lcd.DrawPixel(77.5, 260, LCD_COLOR_BLACK);
    lcd.DrawPixel(77.5, 261, LCD_COLOR_BLACK);
    lcd.DrawPixel(78, 262, LCD_COLOR_BLACK);
    lcd.DrawPixel(78.5, 263, LCD_COLOR_BLACK);
    lcd.DrawPixel(79, 264, LCD_COLOR_BLACK);
    lcd.DrawPixel(79.5, 265, LCD_COLOR_BLACK);
    lcd.DrawPixel(80, 266, LCD_COLOR_BLACK);
    lcd.DrawPixel(81, 267, LCD_COLOR_BLACK);
    lcd.DrawPixel(82, 268, LCD_COLOR_BLACK);
    lcd.DrawPixel(83, 269, LCD_COLOR_BLACK);
    lcd.DrawPixel(84, 270, LCD_COLOR_BLACK);
    lcd.DrawCircle(86, 268, 2);
    
    while(1)
    {
      
      ts.GetState(&TS_State);      
      if (TS_State.TouchDetected)
      {
        x = TS_State.X;
        y = TS_State.Y;
        if(x>74 && x<156){
            if(y>82 && y<114){
                //sin
                p = 1;break;
            }
            else if(y>119 && y<151){
                //cos
                p = 2;break;
            }
            else if(y>159 && y<191){
                //ecg
                p = 4;break;
            }    
        }/*else if(x>29 && x<201 && y>159 && y<191){
            //sin & cos
                p = 3;break;
        }*/
        //sprintf((char*)text, "x=%d y=%d    ", x, y);
        //lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
      }
    }
    lcd.SetBackColor(LCD_COLOR_WHITE);
    if(p==1){
        while(1){
            lcd.Clear(LCD_COLOR_WHITE);
            
            lcd.SetTextColor(LCD_COLOR_BLUE);
lcd.DrawLine(10, 50, 10, 200);
//lcd.DrawLine(20, 0, 20, 320);
//lcd.DrawLine(30, 0, 30, 320);
lcd.DrawLine(10, 125, 235, 125);
//lcd.DrawLine(0, 20, 240, 20);
//lcd.DrawLine(0, 30, 240, 30);
BSP_LCD_SetFont(&Font8);
lcd.DisplayStringAt(0, 50, (uint8_t *)"+1", LEFT_MODE);
lcd.DisplayStringAt(0, 123, (uint8_t *)" 0", LEFT_MODE);
lcd.DisplayStringAt(0, 198, (uint8_t *)"-1", LEFT_MODE);

double val, out;
int b = 0;
for(double y = 0; y<225; y=y+0.625){
    val = PI / 180.0;
    val = val * b;
    out = sin(-val)*75.0;
    double temp = out*1.33*(-1);
    out+=125;
    double c = cos(val)*75.0;
    c+=125;
    double ttt = y + 10.0;  
    lcd.DrawPixel(ttt, out, LCD_COLOR_RED);
    //lcd.DrawPixel(ttt, c, LCD_COLOR_RED);
    b++;
    BSP_LCD_SetFont(&Font12);
    uint8_t text[30];
        sprintf((char*)text, "x:%d(deg)  sin(x):%.2lf", b, temp/100);
        lcd.DisplayStringAt(0, 280, (uint8_t *)&text, LEFT_MODE);
    //x++;
    wait(0.1);
    b++;
}
 wait(2);           
            
            
            
            
        }
    }else if(p==2){
while(1){
            lcd.Clear(LCD_COLOR_WHITE);
            
            lcd.SetTextColor(LCD_COLOR_BLUE);
lcd.DrawLine(10, 50, 10, 200);
//lcd.DrawLine(20, 0, 20, 320);
//lcd.DrawLine(30, 0, 30, 320);
lcd.DrawLine(10, 125, 235, 125);
//lcd.DrawLine(0, 20, 240, 20);
//lcd.DrawLine(0, 30, 240, 30);
BSP_LCD_SetFont(&Font8);
lcd.DisplayStringAt(0, 50, (uint8_t *)"+1", LEFT_MODE);
lcd.DisplayStringAt(0, 123, (uint8_t *)" 0", LEFT_MODE);
lcd.DisplayStringAt(0, 198, (uint8_t *)"-1", LEFT_MODE);

double val, out;
int b = 0;
for(double y = 0; y<450; y=y+0.3125){
    val = PI / 180.0;
    val = val * b;
    out = cos(val)*75.0*(-1);
    double temp = out*1.33*(-1);
    out+=125;
    double c = cos(val)*75.0;
    c+=125;
    double ttt = y + 10.0;  
    lcd.DrawPixel(ttt, out, LCD_COLOR_RED);
    //lcd.DrawPixel(ttt, c, LCD_COLOR_RED);
    b++;
    BSP_LCD_SetFont(&Font12);
    uint8_t text[30];
        sprintf((char*)text, "x:%d(deg)  cos(x):%.2lf", b, temp/100);
        lcd.DisplayStringAt(0, 280, (uint8_t *)&text, LEFT_MODE);
    //x++;
    wait(0.1);
    b++;
}
 wait(2);           
            
            
            
            
        }
    }else if(p==3){
        while(1){
            
        }
    }else if(p==4){
// ECG Demo
lcd.SetTextColor(LCD_COLOR_RED);
while(1){
    lcd.Clear(LCD_COLOR_WHITE);  
    
    /*
    lcd.DrawLine(10, 160, 20, 160);lcd.DrawLine(10, 161, 20, 161);wait(0.1);
    lcd.DrawLine(20, 160, 45, 85);lcd.DrawLine(21, 160, 46, 85);wait(0.1);
    lcd.DrawLine(45, 85, 70, 235);lcd.DrawLine(46, 85, 71, 235);wait(0.1);
    lcd.DrawLine(70, 235, 95, 140);lcd.DrawLine(71, 235, 96, 140);wait(0.1);
    lcd.DrawLine(95, 140, 100, 170);lcd.DrawLine(96, 140, 101, 170);wait(0.1);
    lcd.DrawLine(100, 170, 105, 160);lcd.DrawLine(101, 170, 106, 160);wait(0.1);
    lcd.DrawLine( 105, 160, 115, 160);lcd.DrawLine( 106, 160, 116, 160);wait(0.1);
    
    lcd.DrawLine(10+105, 160, 20+105, 160);lcd.DrawLine(11+105, 161, 21+105, 161);wait(0.1);
    lcd.DrawLine(20+105, 160, 45+105, 85);lcd.DrawLine(21+105, 161, 46+105, 86);wait(0.1);
    lcd.DrawLine(45+105, 85, 70+105, 235);lcd.DrawLine(46+105, 86, 71+105, 236);wait(0.1);
    lcd.DrawLine(70+105, 235, 95+105, 140);lcd.DrawLine(71+105, 236, 96+105, 141);wait(0.1);
    lcd.DrawLine(95+105, 140, 100+105, 170);lcd.DrawLine(96, 141, 101, 171);wait(0.1);
    lcd.DrawLine(100+105, 170, 105+105, 160);lcd.DrawLine(101, 171, 106, 161);wait(0.1);
    lcd.DrawLine( 105+105, 160, 115+105, 160);lcd.DrawLine( 106, 161, 116, 161);wait(0.1);
    */
    
    lcd.DrawLine(10, 160, 20, 160);wait(0.1);
    lcd.DrawLine(20, 160, 45, 85);wait(0.1);
    lcd.DrawLine(45, 85, 70, 235);wait(0.1);
    lcd.DrawLine(70, 235, 95, 140);wait(0.1);
    lcd.DrawLine(95, 140, 100, 170);wait(0.1);
    lcd.DrawLine(100, 170, 105, 160);wait(0.1);
    lcd.DrawLine( 105, 160, 115, 160);wait(0.1);
    
    lcd.DrawLine(10+105, 160, 20+105, 160);wait(0.1);
    lcd.DrawLine(20+105, 160, 45+105, 85);wait(0.1);
    lcd.DrawLine(45+105, 85, 70+105, 235);wait(0.1);
    lcd.DrawLine(70+105, 235, 95+105, 140);wait(0.1);
    lcd.DrawLine(95+105, 140, 100+105, 170);wait(0.1);
    lcd.DrawLine(100+105, 170, 105+105, 160);wait(0.1);
    lcd.DrawLine( 105+105, 160, 115+105, 160);wait(0.1);
    
    wait(0.5);
     
}
    }
}
