#ifndef ACCELEROMETER_H
#define ACCELEROMETER_H

#include "mbed.h"

class Accel  {
public:
    /** create a accelerometer Object
     *
     * @param xpin analogin pin to connect to for x axis
     * @param ypin analogin pin to connect to for y axis
     * @param zpin analogin pin to connect to for z axis**/
     
 Accel(PinName xpin, PinName ypin, PinName zpin);
 float readx();
    /** read analog value from pin y axis
    * @param Percent voltage/ref voltage- full range (0.0 - 1.0)
     */
    float ready();
    /** read analog value from pin z axis
     *
     * @param Percent voltage/ref voltage- full range (0.0 - 1.0)
     */
    float readz();
    /** read analog value from all pins xy&z
     *
     * @param Percent voltage/ref voltage- full range (0.0 - 1.0)
     */
     float readall();
     
private :
    AnalogIn _zpin;
    AnalogIn _ypin;
    AnalogIn _xpin;
    
 };
 #endif        
      
   