/** 06_frdm_serial
 * Serial demo program for the FRDM-KL25Z board
 * Select UART0 for communication via OpenSDA's USB-UART converter
 * Default spedd and format are: 9600 bps, 8-bit, no parity, 1 stop bit 
 */

#include "mbed.h"

Serial pc(USBTX,USBRX);     //UART0 via OpenSDA



int ** sobel(int **c,int h,int w)
{   
    int **image = (int**)malloc(sizeof(int*)*(h-2));
    for( int i=0;i<h;i++)
    {
        image[i]=(int*)malloc(sizeof(int)*(w-2));
    }

    int x[3][3]={{1,0,-1},{2,0,-2},{1,0,-1}};
    int y[3][3]={{1,2,1},{0,0,0},{-1,-2,-1}};

    for (int i=1;i<h-1;++i){
        for (int j=1; j<w-1; ++j){
            for(int k=0;k<3;++k){
                for(int l=0;l<3;++l){
                    image[i-1][j-1] += x[k][l]*c[i-1+k][j-1+l];
                }
                image[i-1][j-1]=abs(image[i-1][j-1])/8;
            }
        }
    }
    return image;
}

int main()
{
int width = 64; int height = 64;
int **image = (int**)malloc(sizeof(int*)*height);
    for( int i=0;i<height;i++)
    {
        image[i]=(int*)malloc(sizeof(int)*width);
    }

/*Write headers*/
int i;
for(i=0;i<4096;i++){
    image[i/64][i%64]= pc.getc();
    }

int **c1= sobel(c,height,width);
          
}
    