#include "mbed.h"
#define MODSERIAL_DEFAULT_RX_BUFFER_SIZE 1024
#define MODSERIAL_DEFAULT_TX_BUFFER_SIZE 64
#include "MODSERIAL.h"
#pragma once

class Y201 : MODSERIAL {

private:

    // serial commands to drive camera
    static const char resetSeq         [4];
    static const int  resetSeqLen          = 4;
    static const char resetSeqAck      [4];
    static const int  resetSeqAckLen       = 4;
    static const char takePicSeq       [5];
    static const int  takePicSeqLen        = 5;
    static const char takePicSeqAck    [5];
    static const int  takePicSeqAckLen     = 5;
    static const char set160x120       [9];
    static const char set320x240       [9];
    static const char set640x480       [9];
    static const int  setSizeLen           = 9;
    static const char setSizeAck       [5];
    static const int  setSizeAckLen        = 5;
    static const char readFileSize     [5];
    static const int  readFileSizeLen      = 5;
    static const char readFileSizeAck  [7];
    static const int  readFileSizeAckLen   = 7;
    static const char readFileHead     [8];
    static const int  readFileHeadLen      = 8;
    static const char readFileAck      [5];
    static const int  readFileAckLen       = 5;
    /*
    static const char changeBaudRateSeq  [5];
    static const int  changeBaudRateSeqLen = 5;
    static const char changeBaudRateAck  [5];
    static const int  changeBaudRateAckLen = 5;
    */
    static const char enterPowerSavingSeq[7];
    static const int  enterPowerSavingLen  = 7;
    static const char enterPowerSavingAck[5];
    static const int  enterPowerSavingAckLen = 5;
    static const char exitPowerSavingSeq [7];
    static const int  exitPowerSavingLen     = 7;
    static const char exitPowerSavingAck[5];
    static const int  exitPowerSavingAckLen  = 5;
    
public:
    
    enum Y201ImageSize {
       e160x120,
       e320x240,
       e640x480
    };
    
    /*
    enum Y201BaudRate {
       e9600,
       e19200,
       e38400,
       e57600,
       e115200
    };
    */

    Y201(PinName tx, PinName rx, const char *name = NULL);

    bool setImageSize(Y201ImageSize size);
    bool takePicture();
    bool readImageSize(int *fileSize);
    bool readImage(int startAddress, int readLen, uint8_t *readBuffer);
    //bool changeBaudRate(Y201BaudRate baudRate);
    bool enterPowerSaving();
    bool exitPowerSaving();
    void trash();
    
    bool waitForInt(int bytes, int *fileSize);
    bool waitFor(const char *seq, const int seqLen);
    void putSeq(const char *seq, int seqLen);
    bool reset();

};
