// stuff to use DBG debug output
#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "main.cpp"
#endif

// relevant headers
#include "mbed.h"
#include "VodafoneUSBModem.h"

#define TEST_NUMBER "0000"
#define MAX_SMS_LEN 256

int main() {
   // setup debug macro
   DBG_INIT();
   DBG_SET_SPEED(115200);
   DBG_SET_NEWLINE("\r\n");
   
   // construct modem object
   VodafoneUSBModem modem;
    
   // locals
   size_t smCount = 0;
   char numBuffer[32], msgBuffer[256];
    
   // send a wake-up SMS
   DBG("Sending test SMS to %s",TEST_NUMBER);
   if(modem.sendSM(TEST_NUMBER,"Hello!")!=0) {
      DBG("Error sending test SMS!");
   }
    
   // loop forever printing received SMSs
   while(1) {
        
      // get SM count
      if(modem.getSMCount(&smCount)!=0) {
         DBG("Error receiving SMS count!");
         continue;
      }
       
      // if SMS in mailbox
      if(smCount>0) {
        
         // get SMS and sender
         if(modem.getSM(numBuffer,msgBuffer,MAX_SMS_LEN)!=0) {
            DBG("Error retrieving SMS from mailbox!");
            continue;
         }
           
         // print SMS and sender
         DBG("SMS: \"%s\", From: \"%s\"",msgBuffer,numBuffer);
           
      }
        
      // wait 1 second
      Thread::wait(1000);
   }
}
