// stuff to use DBG debug output
#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "main.cpp"
#endif

#include "mbed.h"
#include "VodafoneUSBModem.h"
#include "HTTPClient.h"
#include "socket.h"

// connect to socket at ipAddress and port
bool connectToSocket(char *ipAddress, int port, int *sockfd) {
  *sockfd = -1;
  
  // create the socket
  if((*sockfd=socket(AF_INET,SOCK_STREAM,0))<0) {
     INFO("Error opening socket");
     return false;
  }
         
  // create the socket address
  sockaddr_in serverAddress;
  std::memset(&serverAddress, 0, sizeof(struct sockaddr_in));
  serverAddress.sin_addr.s_addr = inet_addr(ipAddress);
  serverAddress.sin_family = AF_INET;
  serverAddress.sin_port = htons(port);

  // do socket connect
  if(connect(*sockfd, (const struct sockaddr *)&serverAddress, sizeof(serverAddress))<0) {
     close(*sockfd);
     INFO("Could not connect");
     return false;
  }
  return true;
}

int main() {
   // setup debug macro
   DBG_INIT();
   DBG_SET_SPEED(115200);
   DBG_SET_NEWLINE("\r\n");
   INFO("Begin");
   
   // construct modem object
   VodafoneUSBModem modem;
   
   // construc http client object
   HTTPClient http;
   
   // locals
   char str[512];
   str[0] = 0x00;
   int ret = 1;

   // connect to the mobile network (get an IP)
   ret = modem.connect("internet","web","web");
   if(ret!=0) {
      DBG("Error connecting to the Vodafone network.");
      return;
   }
   
   int sockfd = 0;
   if(connectToSocket("109.74.199.96",80,&sockfd)) {
      INFO("Connected to socket OK");
      close(sockfd);
   }
    
   // do an HTTP GET
   INFO("Trying to fetch page...");
   ret = http.get("http://m2mthings.com/test.txt", str, 128,3000);
   if(ret==0) {
      INFO("Page fetched successfully - read %d characters", strlen(str));
      INFO("Result: \"%s\"", str);
   } else {
      INFO("Error - ret = %d - HTTP return code = %d", ret, http.getHTTPResponseCode());
   }
    
   // do an HTTP POST
   HTTPMap map;
   HTTPText text(str, 512);
   map.put("Hello", "World");
   map.put("test", "1234");
   INFO("Trying to post data...");
   ret = http.post("http://httpbin.org/post", map, &text);
   if(ret==0) {
      INFO("Executed POST successfully - read %d characters", strlen(str));
      INFO("Result: %s\n", str);
   } else {
      INFO("Error - ret = %d - HTTP return code = %d", ret, http.getHTTPResponseCode());
   }
    
   // disconnect from the mobile network
   modem.disconnect();  

   // flash led 1 forever
   DigitalOut l1(LED1);
   while(1) { 
      l1 = !l1;
      Thread::wait(1000);
   } 
}
