#include "mbed.h"
#include "rtos.h"
#include "Y201.h"

const int Y201::resetSeq       [4] = {0x56,0x00,0x26,0x00};
const int Y201::resetSeqAck    [4] = {0x76,0x00,0x26,0x00};
const int Y201::takePicSeq     [5] = {0x56,0x00,0x36,0x01,0x00};
const int Y201::takePicSeqAck  [5] = {0x76,0x00,0x36,0x00,0x00};
const int Y201::set160x120     [9] = {0x56,0x00,0x31,0x05,0x04,0x01,0x00,0x19,0x22};
const int Y201::set320x240     [9] = {0x56,0x00,0x31,0x05,0x04,0x01,0x00,0x19,0x11};
const int Y201::set640x480     [9] = {0x56,0x00,0x31,0x05,0x04,0x01,0x00,0x19,0x00};
const int Y201::setSizeAck     [5] = {0x76,0x00,0x31,0x00,0x00};
const int Y201::readFileSize   [5] = {0x56,0x00,0x34,0x01,0x00};
const int Y201::readFileSizeAck[7] = {0x76,0x00,0x34,0x00,0x04,0x00,0x00};
const int Y201::readFileHead   [8] = {0x56,0x00,0x32,0x0C,0x00,0x0A,0x00,0x00};
const int Y201::readFileAck    [5] = {0x76,0x00,0x32,0x00,0x00};

DigitalOut led1(LED1);

extern "C" void HardFault_Handler() {
  error("Hard Fault!\n");
}


Serial pc(USBTX, USBRX);


void test(void const*) {
  LocalFileSystem fs("fs");
  FILE *fp = fopen("/fs/picture.jpg","w");
  pc.baud(115200);
  pc.printf("RESET V^V^V^V^V^V^V^V^V^V^V RESET\r\n");
  
  // open camera
  Y201 camera(p28,p27);
  
  // set image size
  if(camera.setImageSize(Y201::e640x480)) {
    printf("Set image size\r\n");
  } else {
    printf("Error setting image size!\r\n");
  }
  
  // reset camera
  if(camera.reset()) {
    printf("Camera reset successfull\r\n");
  } else {
    printf("Error resetting camera\r\n");
  }
  
  // take a picture  
  if(camera.takePicture()) {
    printf("Took picture!\r\n");
  } else {
    printf("Take picture failed!\r\n");
  }
  
  // read file size
  int fileSize = 0;
  if(camera.readImageSize(&fileSize)) {
    printf("Filesize: %d\r\n",fileSize);
  } else {
    printf("Error getting file size\r\n");
  }
  
  NVIC_SetPriority(UART2_IRQn, 0);

  // IMAGE UPLOAD
   
  int bytesRead = 0;
  int chunkSize = 512;

  uint8_t *readBuffer = (uint8_t*)malloc(chunkSize*sizeof(uint8_t));
  while(bytesRead<fileSize) {  
    // read the image
    size_t w;
    if(w=camera.readImage(bytesRead,chunkSize,readBuffer)) {
        
    } else {
        printf("Error in file read\r\n");
        //Dump packet
        for(int i = 0; i < chunkSize; i++)
        {
          if(!(i % 16))
          {
            printf("\n");
          }
          printf("%02x ", readBuffer[i]);
        }
    }
    bytesRead += chunkSize;
    //Thread::wait(1000);
    printf("%d..\n",bytesRead);
    if(bytesRead<fileSize) {
        size_t w = fwrite(readBuffer,chunkSize,1,fp);
    } else {
        size_t w = fwrite(readBuffer,(chunkSize-(bytesRead-fileSize)),1,fp);
    }
    
    camera.trash();
    
  }
  
  printf("\r\n");
  fclose(fp);
  printf("loop exit\r\n");
  printf("filesize: %d\r\n",fileSize);  
}

void tick() {
  led1 = !led1;
}

int main() {
 // Ticker t;
 // t.attach(tick, 1);

  Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
  //Thread testTask(test);
  while(1){ Thread::wait(1000); }

  return 0;
}
