#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "main.cpp"
#endif


#define DEBUG_CYASSL 1

#include "mbed.h"
#include "rtos.h"
#include "ssl.h"
#include "VodafoneUSBModem.h"
#include "socket.h"


#define APN_PAYG

#ifdef APN_GDSP
   #define APN "ppinternetd.gdsp" 
   #define APN_USERNAME ""
   #define APN_PASSWORD ""
#endif

#ifdef APN_CONTRACT
   #define APN "internet" 
   #define APN_USERNAME "web"
   #define APN_PASSWORD "web"
#endif

#ifdef APN_PAYG
   #define APN "smart" 
   #define APN_USERNAME "web"
   #define APN_PASSWORD "web"
#endif

static INLINE unsigned int my_psk_client_cb(CYASSL* ssl, const char* hint,
        char* identity, unsigned int id_max_len, unsigned char* key,
        unsigned int key_max_len)
{
    (void)ssl;
    (void)hint;
    (void)key_max_len;

    /* identity is OpenSSL testing default for openssl s_client, keep same */
    strncpy(identity, "Client_identity", id_max_len);


    /* test key in hex is 0x1a2b3c4d , in decimal 439,041,101 , we're using
       unsigned binary */
    key[0] = 26;
    key[1] = 43;
    key[2] = 60;
    key[3] = 77;

    return 4;   /* length of key in octets or 0 for error */
}


static INLINE unsigned int my_psk_server_cb(CYASSL* ssl, const char* identity,
        unsigned char* key, unsigned int key_max_len)
{
    (void)ssl;
    (void)key_max_len;

    /* identity is OpenSSL testing default for openssl s_client, keep same */
    if (strncmp(identity, "Client_identity", 15) != 0)
        return 0;

    /* test key in hex is 0x1a2b3c4d , in decimal 439,041,101 , we're using
       unsigned binary */
    key[0] = 26;
    key[1] = 43;
    key[2] = 60;
    key[3] = 77;

    return 4;   /* length of key in octets or 0 for error */
}

bool connectToSocket(char *ipAddress, int port, int *sockfd) {
  *sockfd = -1;
  // create the socket
  if((*sockfd=socket(AF_INET,SOCK_STREAM,0))<0) {
     DBG("Error opening socket");
     return false;
  }
         
  // create the socket address
  sockaddr_in serverAddress;
  std::memset(&serverAddress, 0, sizeof(struct sockaddr_in));
  serverAddress.sin_addr.s_addr = inet_addr(ipAddress);
  serverAddress.sin_family = AF_INET;
  serverAddress.sin_port = htons(port);

  // do socket connect
  //LOG("Connecting socket to %s:%d", inet_ntoa(serverAddress.sin_addr), ntohs(serverAddress.sin_port));
  if(connect(*sockfd, (const struct sockaddr *)&serverAddress, sizeof(serverAddress))<0) {
     ::close(*sockfd);
     DBG("Could not connect");
     return false;
  }
  return true;
}


DigitalOut myled(LED1);


//const unsigned char *serverCert = "-----BEGIN CERTIFICATE-----\r\nMIIDCjCCAnOgAwIBAgIJAM/U0HS+lzWAMA0GCSqGSIb3DQEBBQUAMGIxCzAJBgNV\r\nBAYTAlVLMRAwDgYDVQQIEwdFbmdsYW5kMRAwDgYDVQQHEwdOZXdidXJ5MRAwDgYD\r\nVQQKEwdBc2hsZXlzMQwwCgYDVQQLFANSJkQxDzANBgNVBAMTBkFzaGxleTAeFw0x\r\nMzA0MjYxNTIyNTFaFw0xNDA0MjYxNTIyNTFaMGIxCzAJBgNVBAYTAlVLMRAwDgYD\r\nVQQIEwdFbmdsYW5kMRAwDgYDVQQHEwdOZXdidXJ5MRAwDgYDVQQKEwdBc2hsZXlz\r\nMQwwCgYDVQQLFANSJkQxDzANBgNVBAMTBkFzaGxleTCBnzANBgkqhkiG9w0BAQEF\r\nAAOBjQAwgYkCgYEAwbLJUkH8ESIzW+6/k+ZNwt4fSvm0SsnVrmPgJMaoIghIx+EY\r\nxwjGUl5mdNIaOFyj9It1n+BT1uXIBewMTUdXXMDTHU60i+1Q0NtU2uWHoEj9Jf4T\r\nLyG5Jyuellu8zS4A+D5nTUdhxyZDz27BzHZ3XTod8670Zq2kYwjruE/2u+kCAwEA\r\nAaOBxzCBxDAdBgNVHQ4EFgQUff4ginSFEsol4OxS6MQlCfmtLYowgZQGA1UdIwSB\r\njDCBiYAUff4ginSFEsol4OxS6MQlCfmtLYqhZqRkMGIxCzAJBgNVBAYTAlVLMRAw\r\nDgYDVQQIEwdFbmdsYW5kMRAwDgYDVQQHEwdOZXdidXJ5MRAwDgYDVQQKEwdBc2hs\r\nZXlzMQwwCgYDVQQLFANSJkQxDzANBgNVBAMTBkFzaGxleYIJAM/U0HS+lzWAMAwG\r\nA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADgYEArAQgHKW2FcszoxoQxp//waWV\r\n8d8zA2P2TB6QungJeo7GBys/q5JlyZ+XrpNfcGE52qwwHo68JqD4BhOGd3botyhg\r\nHX2+LXavi/cisqwgmmIKN/WtTKBv6MLNxW79WPhmvbkLIRUdTxaUBlKTFYDmNP02\r\n8o7kKH44sPrPaGOeidU=\r\n-----END CERTIFICATE-----";

int main() {
   DBG_INIT();
   DBG_SET_SPEED(115200);
   DBG_SET_NEWLINE("\r\n");
   
   // init modem
   VodafoneUSBModem modem;
    
   // set SSL method to SSL v3 (TLS v1.2)
   //CyaSSLv23_client_method();
     
   CyaSSL_Init();// Initialize CyaSSL
   if(CyaSSL_Debugging_ON()==0) {
      DBG("CyaSSL debugging enabled");
   } else {
      DBG("CyaSSL debugging not compiled in");
   }
   
   
   // setup certificates for server authentication
   CYASSL_CTX* ctx = CyaSSL_CTX_new(CyaSSLv23_client_method());
   if(ctx == NULL){
      DBG("CyaSSL_CTX_new error.\n");
      exit(EXIT_FAILURE);
   }
   DBG("Setup SSL context");
   

   // use pre-shared keys
   CyaSSL_CTX_set_psk_client_callback(ctx,my_psk_client_cb);
   /*
   if(CyaSSL_CTX_load_verify_buffer(ctx, serverCert, strlen((const char*)serverCert),SSL_FILETYPE_PEM)==0) {
   DBG("loaded server cert OK");
   }*/
   
   // connnect modem to cellular network
   DBG("connecting to mobile network");
   if(modem.connect(APN,APN_USERNAME,APN_PASSWORD)!=0) {
      DBG("Error connecting to mobile network");
   }
   DBG("Connected to mobile network");
   
   
   // connect to SSL enabled webserver
   int sockfd = NULL;
   if(!connectToSocket("176.56.234.81", 11111, &sockfd)) {
      DBG("Error connecting to socket");
   }
   DBG("Connected to non-SSL socket");
   
   // hook into SSL
   // Create CYASSL object
   CYASSL* ssl;
   ssl = CyaSSL_new(ctx);
   if(ssl == NULL) {
      DBG("CyaSSL_new error.");
      exit(EXIT_FAILURE);
   }
   DBG("CyaSSL_new OK");
   
   // attach to socket
   DBG("Attaching CyaSSL to socket");
   CyaSSL_set_fd(ssl, sockfd);
   DBG("Attached CyaSSL to socket");
   
   DBG("Issuing CyaSSL_connect");
   if(CyaSSL_connect(ssl)!=SSL_SUCCESS) {
      DBG("CyaSSL_connect failed");
   }
   DBG("CyaSSL_connect OK");
   
   CyaSSL_write(ssl,"hello",5);
   
   // clean up
   CyaSSL_CTX_free(ctx);
   CyaSSL_Cleanup();  
}
    