#ifndef BSD_SOCKET_H_
#define BSD_SOCKET_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "lwip/sockets.h"

#include "lwip/inet.h"

#include "lwip/netdb.h"

//Sockets

inline int accept(int s, struct sockaddr *addr, socklen_t *addrlen)
{
  return lwip_accept(s, addr, addrlen);
}

inline int bind(int s, const struct sockaddr *name, socklen_t namelen)
{
  return lwip_bind(s, name, namelen);
}

inline int shutdown(int s, int how)
{
  return lwip_shutdown(s, how);
}

inline int getsockname (int s, struct sockaddr *name, socklen_t *namelen)
{
  return lwip_getsockname(s, name, namelen);
}

inline int getpeername (int s, struct sockaddr *name, socklen_t *namelen)
{
  return lwip_getpeername(s, name, namelen);
}

inline int getsockopt (int s, int level, int optname, void *optval, socklen_t *optlen)
{
  return lwip_getsockopt(s, level, optname, optval, optlen);
}

inline int setsockopt (int s, int level, int optname, const void *optval, socklen_t optlen)
{
  return lwip_setsockopt(s, level, optname, optval, optlen);
}

inline int connect(int s, const struct sockaddr *name, socklen_t namelen)
{
  return lwip_connect(s, name, namelen);
}

inline int listen(int s, int backlog)
{
  return lwip_listen(s, backlog);
}

inline int recv(int s, void *mem, size_t len, int flags)
{
  return lwip_recv(s, mem, len, flags);
}

inline int recvfrom(int s, void *mem, size_t len, int flags,
      struct sockaddr *from, socklen_t *fromlen)
{
  return lwip_recvfrom(s, mem, len, flags, from, fromlen);
}

inline int send(int s, const void *dataptr, size_t size, int flags)
{
  return lwip_send(s, dataptr, size, flags);
}

inline int sendto(int s, const void *dataptr, size_t size, int flags,
    const struct sockaddr *to, socklen_t tolen)
{
  return lwip_sendto(s, dataptr, size, flags, to, tolen);
}

inline int socket(int domain, int type, int protocol)
{
  return lwip_socket(domain, type, protocol);
}

inline int select(int maxfdp1, fd_set *readset, fd_set *writeset, fd_set *exceptset,
                struct timeval *timeout)
{
  return lwip_select(maxfdp1, readset, writeset, exceptset, timeout);
}

inline int ioctlsocket(int s, long cmd, void *argp)
{
  return lwip_ioctl(s, cmd, argp);
}

inline int read(int s, void *mem, size_t len)
{
  return lwip_read(s, mem, len);
}

inline int write(int s, const void *dataptr, size_t size)
{
  return lwip_write(s, dataptr, size);
}

inline int close(int s)
{
  return lwip_close(s);
}

//DNS
/*
inline struct hostent *gethostbyname(const char *name)
{
  return lwip_gethostbyname(name);
}

inline int gethostbyname_r(const char *name, struct hostent *ret, char *buf, size_t buflen, struct hostent **result, int *h_errnop)
{
  return lwip_gethostbyname_r(name, ret, buf, buflen, result, h_errnop);
}*/

inline void freeaddrinfo(struct addrinfo *ai)
{
  return lwip_freeaddrinfo(ai);
}

inline int getaddrinfo(const char *nodename, const char *servname, const struct addrinfo *hints, struct addrinfo **res)
{
  return lwip_getaddrinfo(nodename, servname, hints, res);
}

#ifdef __cplusplus
}
#endif

#endif
