#include "mbed.h"
#include "CANInterface.h"

Serial pc(USBTX, USBRX);

#define CAN_RD p30
#define CAN_TD p29

#define ENGINE_COOLANT_TEMP 0x05
#define ENGINE_RPM          0x0C
#define VEHICLE_SPEED       0x0D
#define MAF_SENSOR          0x10
#define THROTTLE            0x11
#define O2_VOLTAGE          0x14

int main() {
    pc.baud(115200);
    pc.printf("Begin.\r\n");
    uint8_t outBuf[2];
    int outLen;
    
    CANInterface *can = new CANInterface(CAN_RD,CAN_TD);
    while(1) {
       // RPM
       can->makeRequest(ENGINE_RPM,(uint8_t*)&outBuf,&outLen);
       int rpm = ((outBuf[0]*256) + outBuf[1])/4;
       pc.printf("RPM: %d\r\n",rpm);
       
       // coolant temperature
       can->makeRequest(ENGINE_COOLANT_TEMP,(uint8_t*)&outBuf,&outLen);
       int coolantTemp = (int)outBuf[0]-40;
       pc.printf("Coolant temperature: %d\r\n",coolantTemp);
       
       // vehicle speed
       can->makeRequest(VEHICLE_SPEED,(uint8_t*)&outBuf,&outLen);
       pc.printf("Vehicle speed: %d\r\n",(int)outBuf[0]);
       
       // maf sensor
       can->makeRequest(MAF_SENSOR,(uint8_t*)&outBuf,&outLen);
       int mafSensor = ((outBuf[0]*256) + outBuf[1])/100;
       pc.printf("MAF sensor: %d\r\n",mafSensor);
       
       // O2 voltage
       can->makeRequest(THROTTLE,(uint8_t*)&outBuf,&outLen);
       int o2Voltage = outBuf[0]*0.005;
       pc.printf("O2 voltage: %d\r\n",o2Voltage);
       
       // throttle
       can->makeRequest(O2_VOLTAGE,(uint8_t*)&outBuf,&outLen);
       int throttlePos = (outBuf[0]*100)/255;
       pc.printf("Throttle pos: %d\r\n",throttlePos);
       
       wait(0.5);
    }
}